/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.modules;

import com.google.gson.stream.JsonReader;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.javascript.nodejs.reference.NodeFileModulePsiReferenceBase;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.refactoring.rename.BindablePsiReference;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptNodeReference
extends NodeFileModulePsiReferenceBase
implements BindablePsiReference {
    public static final ParameterizedCachedValueProvider<String, PsiFile> TS_NODE_PACKAGE_JSON_INFO_PROVIDER = new ParameterizedCachedValueProvider<String, PsiFile>(){

        @Nullable
        public CachedValueProvider.Result<String> compute(PsiFile param) {
            VirtualFile virtualFile = param.getVirtualFile();
            return CachedValueProvider.Result.create((Object)TypeScriptNodeReference.getMainFileValue(virtualFile), (Object[])new Object[]{param});
        }
    };
    public static final Key<ParameterizedCachedValue<String, PsiFile>> TS_NODE_PACKAGE_JSON_INFO_KEY = Key.create((String)"typescript.node.modules.cache.value");
    private static final Function<CompletionModuleInfo, CompletionModuleInfo> MAP_COMPLETION_MODULE = info -> new CompletionModuleInfo(info.getName(), info.getVirtualFile(), info.getType()){

        @Override
        @Nullable
        public String getPresentablePath(@Nullable VirtualFile requester) {
            VirtualFile file = this.getVirtualFile();
            assert (file != null);
            return file.getName();
        }
    };

    public TypeScriptNodeReference(@NotNull PsiElement literalExpression, @NotNull String requiredModuleName) {
        if (literalExpression == null) {
            TypeScriptNodeReference.$$$reportNull$$$0(0);
        }
        if (requiredModuleName == null) {
            TypeScriptNodeReference.$$$reportNull$$$0(1);
        }
        super(literalExpression, requiredModuleName);
    }

    @Override
    @Nullable
    protected ResolvedModuleInfo doResolveModule() {
        VirtualFile requester = this.getContainingFile();
        if (requester != null) {
            String requiredModuleName = this.getRequiredModuleName();
            return TypeScriptNodeReference.resolveModuleInfoFromNodeModulesDir(this.getElement().getProject(), requester, requiredModuleName);
        }
        return null;
    }

    public static ResolvedModuleInfo resolveModuleInfoFromNodeModulesDir(Project project, @NotNull VirtualFile requester, @NotNull String requiredModuleName) {
        if (requester == null) {
            TypeScriptNodeReference.$$$reportNull$$$0(2);
        }
        if (requiredModuleName == null) {
            TypeScriptNodeReference.$$$reportNull$$$0(3);
        }
        return NodeModuleSearchUtil.resolveModuleFromNodeModulesDir(requester, requiredModuleName, new TypeScriptNodeModuleDirectorySearchProcessor(project));
    }

    @Override
    @NotNull
    protected CompletionModuleInfo[] getModuleInfos(VirtualFile requester) {
        HashMap modules = ContainerUtil.newHashMap();
        Project project = this.getElement().getProject();
        Condition condition = info -> {
            VirtualFile file = info.getVirtualFile();
            if (file != null) {
                VirtualFile packageJson = null;
                for (VirtualFile virtualFile : file.getChildren()) {
                    if (TypeScriptUtil.isDefinitionFile(virtualFile)) {
                        return true;
                    }
                    if (!"package.json".equals(virtualFile.getName())) continue;
                    packageJson = virtualFile;
                }
                if (packageJson != null) {
                    return null != TypeScriptNodeReference.findInPackageJsonMainFile(project, packageJson);
                }
            }
            return false;
        };
        Collection<CompletionModuleInfo> collection = NodeModuleSearchUtil.collectVisibleNodeModules(modules, project, requester, null);
        List infos = ContainerUtil.filter(collection, (Condition)condition);
        CompletionModuleInfo[] completionModuleInfoArray = (CompletionModuleInfo[])ContainerUtil.map2Array((Collection)infos, (Object[])new CompletionModuleInfo[infos.size()], MAP_COMPLETION_MODULE);
        if (completionModuleInfoArray == null) {
            TypeScriptNodeReference.$$$reportNull$$$0(4);
        }
        return completionModuleInfoArray;
    }

    private static String findInPackageJsonMainFile(Project project, VirtualFile packageJson) {
        PsiManager instance = PsiManager.getInstance((Project)project);
        PsiFile file = instance.findFile(packageJson);
        if (file != null) {
            return (String)CachedValuesManager.getManager((Project)project).getParameterizedCachedValue((UserDataHolder)file, TS_NODE_PACKAGE_JSON_INFO_KEY, TS_NODE_PACKAGE_JSON_INFO_PROVIDER, false, (Object)file);
        }
        return TypeScriptNodeReference.getMainFileValue(packageJson);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String getMainFileValue(VirtualFile packageJson) {
        String string;
        JsonReader jsonReader;
        block9: {
            String string2;
            block8: {
                jsonReader = null;
                try {
                    String text = VfsUtilCore.loadText((VirtualFile)packageJson);
                    StringReader reader = new StringReader(text);
                    jsonReader = new JsonReader((Reader)reader);
                    String typings = JsonUtil.getChildAsString((JsonReader)jsonReader, (String)"typings", (String)"types");
                    if (typings != null) {
                        string2 = typings;
                        if (jsonReader == null) return string2;
                        break block8;
                    }
                    string = null;
                    if (jsonReader == null) return string;
                    break block9;
                }
                catch (Exception e) {
                    String string3 = null;
                    return string3;
                }
            }
            TypeScriptNodeReference.closeJsonReader(jsonReader);
            return string2;
        }
        TypeScriptNodeReference.closeJsonReader(jsonReader);
        return string;
        finally {
            if (jsonReader != null) {
                TypeScriptNodeReference.closeJsonReader(jsonReader);
            }
        }
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            TypeScriptNodeReference.$$$reportNull$$$0(5);
        }
        return null;
    }

    private static void closeJsonReader(JsonReader jsonReader) {
        try {
            jsonReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredModuleName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requester";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/modules/TypeScriptNodeReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/modules/TypeScriptNodeReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleInfoFromNodeModulesDir";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TypeScriptNodeModuleDirectorySearchProcessor
    extends NodeModuleDirectorySearchProcessor {
        private final Project myProject;

        public TypeScriptNodeModuleDirectorySearchProcessor(Project project) {
            this.myProject = project;
        }

        @Override
        protected String[] getExtensions() {
            return TypeScriptUtil.TYPESCRIPT_EXTENSIONS;
        }

        @Override
        protected String findPathInPackageJson(@NotNull VirtualFile packageJson) {
            if (packageJson == null) {
                TypeScriptNodeModuleDirectorySearchProcessor.$$$reportNull$$$0(0);
            }
            return TypeScriptNodeReference.findInPackageJsonMainFile(this.myProject, packageJson);
        }

        @Override
        @Nullable
        public ResolvedModuleInfo loadDirectory(@Nullable VirtualFile moduleSourceRoot, @NotNull VirtualFile dir, @NotNull ModuleType type, boolean respectPackageJson) {
            ResolvedModuleInfo info;
            String main;
            VirtualFile packageJson;
            if (dir == null) {
                TypeScriptNodeModuleDirectorySearchProcessor.$$$reportNull$$$0(1);
            }
            if (type == null) {
                TypeScriptNodeModuleDirectorySearchProcessor.$$$reportNull$$$0(2);
            }
            if (moduleSourceRoot == null) {
                moduleSourceRoot = dir;
            }
            if (respectPackageJson && (packageJson = dir.findChild("package.json")) != null && (main = this.findPathInPackageJson(packageJson)) != null && (info = this.doResolveModule(moduleSourceRoot, type, dir, main = StringUtil.trimEnd((String)main, (char)'/'), true, false)) != null) {
                return info;
            }
            return this.doResolveModule(moduleSourceRoot, type, dir, "index", false, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageJson";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/typescript/modules/TypeScriptNodeReference$TypeScriptNodeModuleDirectorySearchProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findPathInPackageJson";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadDirectory";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

