/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathBuilder;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.typescript.psi.TypeScriptAddImportExecutor;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptAddAugmentationImportFix
extends LocalQuickFixOnPsiElement
implements HighPriorityAction {
    @NotNull
    private final String myName;

    public TypeScriptAddAugmentationImportFix(@NotNull PsiElement context, @NotNull String name) {
        if (context == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(0);
        }
        if (name == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(1);
        }
        super(context);
        this.myName = name;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = TypeScriptAddAugmentationImportFix.getFixText(this.myName);
        if (string == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String getFixText(String name) {
        String string = "Import augmentation " + name;
        if (string == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiFile externalModule;
        if (project == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(5);
        }
        if (file == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(6);
        }
        if (startElement == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(7);
        }
        if (endElement == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(8);
        }
        if ((externalModule = TypeScriptAddAugmentationImportFix.getAugmentationModule(startElement)) == null) {
            return;
        }
        PsiFile placePsiFile = startElement.getContainingFile();
        if (placePsiFile == null) {
            return;
        }
        String externalModuleName = TypeScriptAddAugmentationImportFix.getQuotedModuleName(project, startElement, placePsiFile, externalModule);
        if (externalModuleName == null) {
            return;
        }
        TypeScriptAddImportExecutor executor = new TypeScriptAddImportExecutor(externalModule.getName(), null, startElement);
        executor.createImportOrUseExisting(null, (PsiElement)externalModule, externalModuleName, ES6ImportPsiUtil.ImportExportType.BARE);
    }

    @Nullable
    private static String getQuotedModuleName(@NotNull Project project, @NotNull PsiElement context, @NotNull PsiFile placePsiFile, @NotNull PsiFile augmentationModule) {
        VirtualFile moduleDirectory;
        VirtualFile directoryToCalcModuleName;
        VirtualFile dstFile;
        Pair<VirtualFile, VirtualFile> libraryDirectory;
        if (project == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(9);
        }
        if (context == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(10);
        }
        if (placePsiFile == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(11);
        }
        if (augmentationModule == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(12);
        }
        if ((libraryDirectory = ES6CreateImportUtil.findParentLibraryDirectory(project, dstFile = augmentationModule.getVirtualFile(), TypeScriptAutoImportUtil.NODE_MODULES)) != null && (directoryToCalcModuleName = JSImportPathBuilder.getDirectoryToCalcModuleNameInNodeModules(placePsiFile, moduleDirectory = (VirtualFile)libraryDirectory.first)) != null) {
            String path = VfsUtil.getPath((VirtualFile)directoryToCalcModuleName, (VirtualFile)dstFile, (char)'/');
            JSModuleNameInfo info = new JSModuleNameInfo(path, dstFile, dstFile, context);
            return info.getPath();
        }
        VirtualFile placeFile = placePsiFile.getVirtualFile();
        TypeScriptConfig config2 = TypeScriptConfigService.Provider.parseConfigFile(project, placeFile);
        JSModuleNameInfo moduleInfo = ES6CreateImportUtil.getExactExternalFileModuleName((PsiElement)placePsiFile, dstFile, config2);
        return moduleInfo == null ? null : moduleInfo.getPath();
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(13);
        }
        if (file == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(14);
        }
        if (startElement == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(15);
        }
        if (endElement == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(16);
        }
        return TypeScriptAddAugmentationImportFix.getImportedModuleName(startElement) != null;
    }

    public static String getImportedModuleName(@NotNull PsiElement startElement) {
        PsiFile module;
        if (startElement == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(17);
        }
        if ((module = TypeScriptAddAugmentationImportFix.getAugmentationModule(startElement)) == null) {
            return null;
        }
        String externalModuleName = TypeScriptAddAugmentationImportFix.getQuotedModuleName(startElement.getProject(), startElement, startElement.getContainingFile(), module);
        if (externalModuleName == null) {
            return null;
        }
        PsiElement placeModule = ES6CreateImportUtil.getScopeToAdd(startElement, true);
        if (placeModule == null || module.getContainingFile().equals(placeModule)) {
            return null;
        }
        if (ES6ImportPsiUtil.findExistingES6Import(placeModule, (PsiElement)module, externalModuleName, false) != null) {
            return null;
        }
        return externalModuleName;
    }

    @Nullable
    public static PsiFile getAugmentationModule(@NotNull PsiElement startElement) {
        if (startElement == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(18);
        }
        if (!(startElement instanceof JSReferenceExpression)) {
            return null;
        }
        Collection<PsiElement> elements = JSResolveResult.toElements(((JSReferenceExpression)startElement).multiResolve(false));
        if (elements.size() != 1) {
            return null;
        }
        PsiElement item = (PsiElement)ContainerUtil.getFirstItem(elements);
        PsiElement module = ES6PsiUtil.findExternalModule(item);
        if (!(module instanceof TypeScriptModule) || !((TypeScriptModule)module).isAugmentation()) {
            return null;
        }
        return module.getContainingFile();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/intentions/TypeScriptAddAugmentationImportFix";
                break;
            }
            case 5: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placePsiFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "augmentationModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/intentions/TypeScriptAddAugmentationImportFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getQuotedModuleName";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getImportedModuleName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAugmentationModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

