/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.formatter.blocks;

import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSBlockContext;
import com.intellij.lang.javascript.formatter.blocks.JSBlock;
import com.intellij.lang.javascript.formatter.blocks.SubBlockVisitor;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.lang.javascript.types.TypeScriptClassElementType;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypedJSSubBlockVisitor
extends SubBlockVisitor {
    public TypedJSSubBlockVisitor(@Nullable JSBlock block, @Nullable ASTNodeBasedAlignmentFactory alignmentFactory, @NotNull JSBlockContext jsBlockContext) {
        if (jsBlockContext == null) {
            TypedJSSubBlockVisitor.$$$reportNull$$$0(0);
        }
        super(block, alignmentFactory, jsBlockContext);
    }

    @Override
    @Nullable
    protected Indent getIndent(ASTNode node, ASTNode child, @Nullable Indent sharedSmartIndent) {
        IElementType parentNodeElementType;
        IElementType nodeElementType = node.getElementType();
        IElementType childElementType = child.getElementType();
        ASTNode parentNode = node.getTreeParent();
        IElementType iElementType = parentNodeElementType = parentNode != null ? parentNode.getElementType() : null;
        if (parentNodeElementType instanceof TypeScriptClassElementType && JSElementTypes.FUNCTION_DECLARATIONS.contains(nodeElementType) && JSElementTypes.REFERENCE_EXPRESSION == childElementType) {
            return Indent.getNoneIndent();
        }
        if (TypeScriptElementTypes.TYPE_MEMBERS.contains(nodeElementType)) {
            PsiElement identifier;
            PsiElement psi = node.getPsi();
            PsiElement psiElement = identifier = psi instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)psi).getNameIdentifier() : null;
            if (child == identifier || JSTokenTypes.COMMENTS.contains(childElementType)) {
                return Indent.getNoneIndent();
            }
        }
        if (nodeElementType == JSStubElementTypes.CALL_SIGNATURE && childElementType == JSTokenTypes.NEW_KEYWORD || JSElementTypes.PARAMETER_LISTS.contains(childElementType)) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == TypeScriptElementTypes.INDEX_SIGNATURE && childElementType == JSTokenTypes.LBRACKET) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType instanceof TypeScriptClassElementType && childElementType == TypeScriptElementTypes.INDEX_SIGNATURE) {
            return Indent.getNormalIndent();
        }
        if (nodeElementType == TypeScriptElementTypes.IMPLICIT_MODULE && (childElementType == TypeScriptElementTypes.IMPLICIT_MODULE || childElementType == JSStubElementTypes.TYPESCRIPT_MODULE)) {
            return Indent.getNoneIndent();
        }
        if (childElementType == TypeScriptElementTypes.UNION_OR_INTERSECTION_TYPE) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == TypeScriptElementTypes.UNION_OR_INTERSECTION_TYPE && (childElementType == JSTokenTypes.OR || childElementType == JSTokenTypes.AND || FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)child) == null)) {
            return Indent.getSmartIndent((Indent.Type)Indent.Type.CONTINUATION);
        }
        return super.getIndent(node, child, sharedSmartIndent);
    }

    @Override
    @Nullable
    protected Wrap getWrap(ASTNode node, ASTNode child) {
        IElementType parentElementType;
        IElementType nodeElementType = node != null ? node.getElementType() : null;
        IElementType iElementType = parentElementType = node != null && node.getTreeParent() != null ? node.getTreeParent().getElementType() : null;
        if (TypeScriptElementTypes.UNION_OR_INTERSECTION_TYPE == nodeElementType && parentElementType == JSStubElementTypes.TYPESCRIPT_TYPE_ALIAS && (child.getElementType() == JSTokenTypes.OR || child.getElementType() == JSTokenTypes.AND || FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)child) == null)) {
            return this.getCurrentWrap(this.myJSCodeStyleSettings.UNION_TYPES_WRAP);
        }
        return super.getWrap(node, child);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsBlockContext", "com/intellij/lang/typescript/formatter/blocks/TypedJSSubBlockVisitor", "<init>"));
    }
}

