/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptInsertTypeGuardFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myName;

    public TypeScriptInsertTypeGuardFix(@Nullable PsiElement element, String typeName) {
        super(element);
        this.myName = typeName;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        String shortestTypeName;
        if (project == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(0);
        }
        if (file == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(1);
        }
        if (startElement == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(2);
        }
        if (endElement == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(3);
        }
        if (TypeScriptUtil.hasAmbientExternalModuleInQName(this.myName) && TypeScriptUtil.hasAmbientExternalModuleInQName(shortestTypeName = TypeScriptUtil.getShortestTypeNameInContext(this.myName, startElement))) {
            return false;
        }
        JSVariable variable = TypeScriptInsertTypeGuardFix.getResolvedVariable(startElement);
        if (variable == null) {
            return false;
        }
        if (variable.getType() instanceof JSPrimitiveType && this.isTypeOfMember(this.myName)) {
            return false;
        }
        String name = variable.getName();
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        JSStatement parent = (JSStatement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)startElement, (Class[])new Class[]{JSStatement.class});
        return parent instanceof JSExpressionStatement || parent instanceof JSVarStatement;
    }

    private static JSVariable getResolvedVariable(PsiElement startElement) {
        PsiElement resolve;
        if (startElement instanceof JSVariable) {
            return (JSVariable)startElement;
        }
        if (startElement instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)startElement).resolve()) instanceof JSVariable) {
            return (JSVariable)resolve;
        }
        return null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(4);
        }
        if (file == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(5);
        }
        if (startElement == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(6);
        }
        if (endElement == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            return;
        }
        JSStatement parent = (JSStatement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)startElement, (Class[])new Class[]{JSStatement.class});
        if (parent == null) {
            return;
        }
        JSVariable variable = TypeScriptInsertTypeGuardFix.getResolvedVariable(startElement);
        if (variable == null) {
            return;
        }
        String shortenedType = TypeScriptUtil.getShortestTypeNameInContext(this.myName, startElement);
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        boolean isTypeOf = this.isTypeOfMember(shortenedType);
        String typeOperation = isTypeOf ? "if (typeof %s === %s) {$SELECTION$}" : "if (%s instanceof %s) {$SELECTION$}";
        Template template = templateManager.createTemplate("", "", String.format(typeOperation, variable.getName(), isTypeOf ? TypeScriptInsertTypeGuardFix.wrapWithQuotes(shortenedType) : shortenedType));
        template.setToReformat(true);
        template.setToShortenLongNames(false);
        int offset = parent.getTextRange().getStartOffset();
        editor.getSelectionModel().setSelection(offset, offset + parent.getTextLength());
        editor.getCaretModel().moveToOffset(offset);
        templateManager.startTemplate(editor, parent.getText(), template);
    }

    public boolean isTypeOfMember(String typeofWrapType) {
        return ArrayUtil.contains((String)typeofWrapType, (String[])JSCommonTypeNames.TYPEOF_VALUES);
    }

    @NotNull
    private static String wrapWithQuotes(String shortenedType) {
        String string = '\"' + shortenedType + '\"';
        if (string == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"typescript.insert.type.guard.fix", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/TypeScriptInsertTypeGuardFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/TypeScriptInsertTypeGuardFix";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithQuotes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

