/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSChangeVisibilityHandler {
    public static final TokenSet MODIFIERS_AFTER_ACCESS_KEYWORD = TokenSet.andNot((TokenSet)JSTokenTypes.MODIFIERS, (TokenSet)TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.OVERRIDE_KEYWORD}));
    private final JSAttributeList myAttributeList;
    private final JSAttributeList.AccessType myAccessType;
    private final boolean myExplicitly;

    public JSChangeVisibilityHandler(@NotNull JSAttributeList attributeList, @Nullable JSAttributeList.AccessType accessType, boolean explicitly) {
        if (attributeList == null) {
            JSChangeVisibilityHandler.$$$reportNull$$$0(0);
        }
        this.myAttributeList = attributeList;
        this.myAccessType = accessType;
        this.myExplicitly = explicitly;
    }

    public void apply() {
        JSAttributeList.AccessType type = this.myAttributeList.getExplicitAccessType();
        if (type == this.myAccessType) {
            return;
        }
        PsiElement newAccessType = this.buildNewAccessType();
        PsiElement accessTypeElement = this.myAttributeList.findAccessTypeElement();
        if (accessTypeElement != null) {
            if (newAccessType != null) {
                accessTypeElement.replace(newAccessType);
            } else {
                accessTypeElement.delete();
            }
            return;
        }
        if (newAccessType == null) {
            return;
        }
        ASTNode anchor = this.myAttributeList.getNode().findChildByType(MODIFIERS_AFTER_ACCESS_KEYWORD);
        ASTNode myAttributeListNode = this.myAttributeList.getNode();
        if (anchor == null && (anchor = myAttributeListNode.getLastChildNode()) != null) {
            JSChangeUtil.doDoAddAfter((PsiElement)this.myAttributeList, newAccessType, anchor.getPsi());
            return;
        }
        JSChangeUtil.doDoAddBefore((PsiElement)this.myAttributeList, newAccessType, anchor == null ? null : anchor.getPsi());
    }

    @Nullable
    private PsiElement buildNewAccessType() {
        JSLanguageDialect dialect = DialectDetector.getLanguageDialect((PsiElement)this.myAttributeList);
        String text = this.getAccessTypeText(dialect);
        if (!StringUtil.isEmpty((String)text)) {
            ASTNode newAttributeList = JSChangeUtil.createJSTreeFromText(this.myAttributeList.getProject(), text + " ", dialect);
            if (newAttributeList == null) {
                return null;
            }
            PsiElement newPsi = newAttributeList.getPsi();
            if (newPsi instanceof JSAttributeList) {
                return ((JSAttributeList)newPsi).findAccessTypeElement();
            }
        }
        return null;
    }

    @Nullable
    private String getAccessTypeText(@Nullable JSLanguageDialect dialect) {
        if (this.myAccessType == null) {
            return null;
        }
        if (!this.myExplicitly && this.myAccessType == JSAttributeList.AccessType.PUBLIC) {
            boolean isTypeScript;
            boolean bl = isTypeScript = dialect != null && dialect.getOptionHolder().isTypeScript;
            if (isTypeScript) {
                TypeScriptCodeStyleSettings settings = TypeScriptCodeStyleSettings.getTypeScriptSettings(this.myAttributeList.getProject());
                if (!settings.USE_PUBLIC_MODIFIER) {
                    return null;
                }
            }
        }
        return JSVisibilityUtil.getVisibilityKeyword(this.myAccessType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeList", "com/intellij/lang/javascript/validation/fixes/JSChangeVisibilityHandler", "<init>"));
    }
}

