/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.ide.DataManager;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.introduceParameter.JSIntroduceParameterHandler;
import com.intellij.lang.javascript.refactoring.introduceParameter.JSIntroduceParameterSettings;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.lang.javascript.validation.fixes.JSParameterInserter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class CreateJSParameterIntentionAction
extends FixAndIntentionAction {
    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getName() {
        String string = JSBundle.message((String)"javascript.fix.create.parameter", (Object[])new Object[0]);
        if (string == null) {
            CreateJSParameterIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"javascript.create.variable.intention.family", (Object[])new Object[0]);
        if (string == null) {
            CreateJSParameterIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected void applyFix(Project project, PsiElement psiElement, PsiFile file, Editor editor) {
        final JSReferenceExpression node = (JSReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, JSReferenceExpression.class);
        if (node == null) {
            return;
        }
        JSFunction scope = (JSFunction)PsiTreeUtil.getNonStrictParentOfType((PsiElement)node, (Class[])new Class[]{JSFunction.class});
        if (scope == null) {
            return;
        }
        JSParameterInserter parameterInserter = JSParameterInserter.build(scope);
        if (parameterInserter == null) {
            return;
        }
        boolean b = ReferencesSearch.search((PsiElement)scope).forEach(psiReference -> JSResolveUtil.isSelfReference(psiReference.getElement()));
        JSLanguageDialect languageDialect = JSUtils.getDialect(file);
        String type = null;
        if (languageDialect == JavaScriptSupportLoader.ECMA_SCRIPT_L4) {
            type = BaseCreateFix.guessTypeForExpression((JSExpression)node, file, false);
        }
        if (!b) {
            TextRange textRange = node.getTextRange();
            editor.getSelectionModel().setSelection(textRange.getStartOffset(), textRange.getEndOffset());
            final String finalType = type;
            new JSIntroduceParameterHandler(){

                @Override
                protected JSIntroduceParameterSettings getSettings(Project project, Editor editor, Pair<JSExpression, TextRange> expressionDescriptor, JSExpression[] occurrences, PsiElement scope) {
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        return new JSIntroduceParameterSettings.Base(expressionDescriptor){

                            @Override
                            public boolean addOptionalParameter() {
                                return parameterInserter.mustBeOptional();
                            }

                            @Override
                            public String getInitialValue() {
                                return JSTypeUtils.defaultValueOfType(finalType);
                            }

                            @Override
                            public boolean isReplaceAllOccurrences() {
                                return true;
                            }

                            @Override
                            public String getVariableName() {
                                return node.getReferencedName();
                            }

                            @Override
                            public String getVariableType() {
                                return finalType;
                            }
                        };
                    }
                    return (JSIntroduceParameterSettings)super.getSettings(project, editor, expressionDescriptor, occurrences, scope);
                }
            }.invoke(project, editor, file, DataManager.getInstance().getDataContext());
            return;
        }
        String typeDecoration = "";
        if (languageDialect == JavaScriptSupportLoader.ECMA_SCRIPT_L4 && type != null) {
            typeDecoration = typeDecoration + ":" + type;
        }
        boolean mustBeOptional = parameterInserter.mustBeOptional();
        String introduced = node.getReferencedName() + typeDecoration;
        if (mustBeOptional) {
            introduced = introduced + "=" + JSTypeUtils.defaultValueOfType(type);
        }
        String finalIntroduced = introduced;
        WriteAction.run(() -> {
            JSParameter parameter = parameterInserter.doInsert(finalIntroduced, mustBeOptional, "");
            CodeStyleManager.getInstance((Project)project).reformat(parameter.getParent());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/validation/fixes/CreateJSParameterIntentionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

