/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.JSInsertThisFix;
import com.intellij.lang.javascript.inspections.JSDeclarationsAtScopeStartInspection;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionHandler;
import com.intellij.lang.javascript.refactoring.extractMethod.JSScopeSelectionUI;
import com.intellij.lang.javascript.refactoring.extractMethod.JSSignatureContext;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.lang.javascript.validation.fixes.CreateJSFunctionIntentionActionBase;
import com.intellij.lang.typescript.refactoring.extractMethod.TypeScriptExtractFunctionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateJSFunctionIntentionAction
extends CreateJSFunctionIntentionActionBase {
    private final boolean myIsMethod;
    private final String myFunctionName;
    private boolean myIsProperty;

    public CreateJSFunctionIntentionAction(String name, boolean isMethod) {
        super(name, isMethod ? "javascript.create.method.intention.name" : "javascript.create.function.intention.name");
        this.myFunctionName = name;
        this.myIsMethod = isMethod;
    }

    @Override
    protected void applyFix(Project project, PsiElement psiElement, PsiFile file, Editor editor) {
        this.applyFixWithScopeSelection(project, psiElement, file, editor, ApplicationManager.getApplication().isUnitTestMode() ? (defaultSuggestedScope, scopeList, cb) -> cb.pass((Object)CreateJSFunctionIntentionAction.chooseIntroductionScopeForTest(psiElement, scopeList)) : new JSExtractFunctionHandler.ScopeSelectionPopup(editor));
    }

    public void applyFixWithScopeSelection(final Project project, final PsiElement psiElement, final PsiFile file, final Editor editor, JSScopeSelectionUI scopeSelectionUi) {
        if (psiElement == null) {
            return;
        }
        JSExtractFunctionHandler extractFunctionHandler = DialectDetector.isTypeScript(psiElement) ? new TypeScriptExtractFunctionHandler() : new JSExtractFunctionHandler();
        JSReferenceExpression referenceExpression = (JSReferenceExpression)this.calculateAnchors((PsiElement)psiElement).first;
        if (CreateJSFunctionIntentionAction.getClassFromReferenceExpression(referenceExpression) != null) {
            this.doApplyFix(project, psiElement, file, editor);
            return;
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)referenceExpression);
        List scopes = extractFunctionHandler.findBases(psiElement);
        if (dialect != null && JSClassUtils.isES6ClassImplementation(dialect) && referenceExpression.getQualifier() == null) {
            scopes = ContainerUtil.filter(scopes, scope -> scope.isClassContext() == this.myIsMethod);
        }
        final List finalScopes = scopes;
        final boolean isActionScript = dialect != null && dialect.isECMA4;
        JSSignatureContext context = new JSSignatureContext(){

            @Override
            public boolean isActionScript() {
                return isActionScript;
            }

            @Override
            public boolean isAsync() {
                return false;
            }

            @Override
            public PsiElement getAnchor() {
                return psiElement;
            }

            @Override
            @NotNull
            public List<JSExtractFunctionHandler.IntroductionScope> getIntroductionScopes() {
                List list = finalScopes;
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/CreateJSFunctionIntentionAction$1", "getIntroductionScopes"));
            }
        };
        Pass<JSExtractFunctionHandler.IntroductionScope> callback = new Pass<JSExtractFunctionHandler.IntroductionScope>(){

            public void pass(JSExtractFunctionHandler.IntroductionScope scope) {
                if (scope.isClassContext()) {
                    CreateJSFunctionIntentionAction.this.doApplyFix(project, psiElement, file, editor);
                } else {
                    CreateJSFunctionIntentionAction.this.myIsProperty = scope.getParent() instanceof JSObjectLiteralExpression;
                    boolean placeAtScopeStart = JSDeclarationsAtScopeStartInspection.isEnabledForElement(psiElement);
                    PsiElement anchor = JSUtils.findFunctionAnchor(scope.getParent(), psiElement, placeAtScopeStart);
                    anchor = JSPsiImplUtils.findLeadingCommentOrSelf(anchor);
                    CreateJSFunctionIntentionAction.this.doApplyFix(project, psiElement, file, editor, anchor, scope.getParent());
                }
            }
        };
        extractFunctionHandler.chooseIntroductionScope(context, callback, scopeSelectionUi, this.myFunctionName);
    }

    private static JSExtractFunctionHandler.IntroductionScope chooseIntroductionScopeForTest(@NotNull PsiElement usageElement, @NotNull List<JSScopeSelectionUI.ScopePresentation> presentations) {
        List scopes;
        if (usageElement == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(0);
        }
        if (presentations == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(1);
        }
        if ((scopes = ContainerUtil.map(presentations, presentation -> presentation.getScope())).isEmpty()) {
            throw new RuntimeException("No available scopes");
        }
        if (scopes.size() == 1) {
            return (JSExtractFunctionHandler.IntroductionScope)scopes.get(0);
        }
        JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)usageElement, JSStatement.class, (boolean)false);
        if (statement == null) {
            throw new RuntimeException("Could not find statement from usage");
        }
        PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)statement);
        if (docComment instanceof JSDocComment) {
            String scopePresentation = docComment.getText().substring(3, docComment.getTextLength() - 2).trim();
            for (JSExtractFunctionHandler.IntroductionScope scope : scopes) {
                if (!scopePresentation.equals(scope.toString())) continue;
                return scope;
            }
            throw new RuntimeException("Scope with name " + scopePresentation + " not found");
        }
        return (JSExtractFunctionHandler.IntroductionScope)scopes.get(scopes.size() - 1);
    }

    @Nullable
    private static PsiElement getClassFromReferenceExpression(JSReferenceExpression referenceExpression) {
        if (referenceExpression == null || !JSClassUtils.canHaveClasses((PsiElement)referenceExpression)) {
            return null;
        }
        if (referenceExpression.getQualifier() != null) {
            return CreateJSFunctionIntentionAction.getType(referenceExpression.getQualifier(), referenceExpression.getContainingFile());
        }
        return null;
    }

    @Override
    protected void writeFunctionAndName(Template template, String createdMethodName, PsiFile file, JSClass clazz, JSReferenceExpression referenceExpression) {
        if (this.myIsProperty) {
            createdMethodName = createdMethodName.substring(createdMethodName.lastIndexOf(".") + 1);
            template.addTextSegment(createdMethodName);
            template.addTextSegment(": function ");
            return;
        }
        if (clazz != null) {
            if (createdMethodName.indexOf(46) != -1) {
                createdMethodName = createdMethodName.substring(createdMethodName.lastIndexOf(".") + 1);
            }
            template.addTextSegment(JSClassUtils.createClassFunctionName(createdMethodName, (PsiElement)file));
            return;
        }
        if (DialectDetector.isActionScript((PsiElement)file) || DialectDetector.isTypeScript((PsiElement)file) && referenceExpression.getQualifier() == null || !this.myIsMethod) {
            template.addTextSegment("function ");
            template.addTextSegment(createdMethodName);
            return;
        }
        if (createdMethodName.indexOf(46) == -1) {
            template.addTextSegment(JSChangeUtil.getVariablePrefix((PsiElement)file) + " ");
        }
        template.addTextSegment(createdMethodName);
        template.addTextSegment(" = function ");
    }

    @Override
    protected void addSemicolonSegment(Template template, PsiFile file) {
        if (this.myIsProperty) {
            template.addTextSegment(",");
        } else {
            super.addSemicolonSegment(template, file);
        }
    }

    @Override
    protected void addParameters(Template template, JSReferenceExpression referenceExpression, PsiFile file) {
        PsiElement element = referenceExpression.getParent();
        JSArgumentList list = element instanceof JSCallExpression ? ((JSCallExpression)element).getArgumentList() : null;
        CreateJSFunctionIntentionAction.addParameters(template, list, (PsiElement)referenceExpression, file);
    }

    public static void addParameters(Template template, @Nullable JSArgumentList list, PsiElement context, PsiFile file) {
        JSExpression[] expressions = list != null ? list.getArguments() : JSExpression.EMPTY_ARRAY;
        int paramCount = expressions.length;
        THashSet usedParameterNames = new THashSet();
        for (int i = 0; i < paramCount; ++i) {
            String typeName;
            JSExpression passedParameterValue;
            String var;
            if (i != 0) {
                template.addTextSegment(", ");
            }
            if ((var = (passedParameterValue = expressions[i]) instanceof JSReferenceExpression ? ((JSReferenceExpression)passedParameterValue).getReferenceName() : BasicIntroducedEntityInfoProvider.generateVariableNamesFromExpression(passedParameterValue, context)) == null || var.length() == 0) {
                var = "param" + (i != 0 ? Integer.toString(i + 1) : "");
            } else {
                String baseName = var;
                int j = 2;
                while (usedParameterNames.contains(var)) {
                    var = baseName + j;
                    ++j;
                }
                usedParameterNames.add(var);
            }
            BaseCreateFix.MyExpression expression = new BaseCreateFix.MyExpression(var);
            template.addVariable(var, (Expression)expression, (Expression)expression, true);
            DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)file);
            if (holder == null || !holder.isTypeScript && !holder.isECMA4 || ((typeName = JSResolveUtil.getExpressionType(passedParameterValue, file)) == null || "null".equals(typeName)) && holder.isTypeScript) continue;
            template.addTextSegment(":");
            CreateJSFunctionIntentionAction.addTypeVariable(template, var, context, typeName);
        }
    }

    @Override
    protected void addReturnType(Template template, JSReferenceExpression referenceExpression, PsiFile file) {
        this.guessTypeAndAddTemplateVariable(template, (JSExpression)referenceExpression, file, true);
    }

    @Override
    protected JSReferenceExpression beforeStartTemplateAction(JSReferenceExpression referenceExpression, Editor editor, @Nullable PsiElement anchor, boolean isStaticContext) {
        JSReferenceExpression superRefExpression = super.beforeStartTemplateAction(referenceExpression, editor, anchor, isStaticContext);
        if (superRefExpression == null) {
            return null;
        }
        if (CreateJSFunctionIntentionAction.shouldInsertQualifier(anchor, superRefExpression)) {
            String name;
            JSClass contextClass = JSUtils.getMemberContainingClass(anchor);
            String qualifier = "this";
            if (contextClass != null && isStaticContext && (name = contextClass.getName()) != null) {
                qualifier = name;
            }
            return (JSReferenceExpression)JSInsertThisFix.insertQualifier((JSExpression)superRefExpression, editor, qualifier);
        }
        return superRefExpression;
    }

    private static boolean shouldInsertQualifier(@Nullable PsiElement anchor, JSReferenceExpression superRefExpression) {
        return !DialectDetector.isActionScript((PsiElement)superRefExpression) && superRefExpression.getQualifier() == null && anchor != null && null != JSUtils.getMemberContainingClass(anchor);
    }

    @Override
    protected void addBody(Template template, JSReferenceExpression refExpr, PsiFile file) {
        template.addTextSegment("\n");
        template.addEndVariable();
        template.addTextSegment("\n");
    }

    @Override
    protected void buildTemplate(Template template, JSReferenceExpression referenceExpression, boolean staticContext, PsiFile file, PsiElement anchorParent) {
        super.buildTemplate(template, referenceExpression, staticContext, file, anchorParent);
        if (this.myIsMethod && !JSClassUtils.canHaveClasses((PsiElement)file)) {
            this.addSemicolonSegment(template, file);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "usageElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "presentations";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/validation/fixes/CreateJSFunctionIntentionAction";
        objectArray[2] = "chooseIntroductionScopeForTest";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

