/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flex.ECMAScriptImportOptimizer;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateInheritanceFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String mySupertypeQname;
    private final boolean mySupertypeIsInterface;

    public CreateInheritanceFix(@Nullable PsiElement element, String supertypeQname, boolean supertypeIsInterface) {
        super(element);
        this.mySupertypeQname = supertypeQname;
        this.mySupertypeIsInterface = supertypeIsInterface;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            CreateInheritanceFix.$$$reportNull$$$0(0);
        }
        if (file == null) {
            CreateInheritanceFix.$$$reportNull$$$0(1);
        }
        if (startElement == null) {
            CreateInheritanceFix.$$$reportNull$$$0(2);
        }
        if (endElement == null) {
            CreateInheritanceFix.$$$reportNull$$$0(3);
        }
        JSRefactoringUtil.addToSupersList((JSClass)startElement, this.mySupertypeQname, this.mySupertypeIsInterface);
        if (this.mySupertypeQname.contains(".") && !(startElement instanceof XmlBackedJSClass)) {
            ArrayList<FormatFixer> formatters = new ArrayList<FormatFixer>();
            formatters.add(ImportUtils.insertImportStatements(startElement, Collections.singletonList(this.mySupertypeQname)));
            formatters.addAll(ECMAScriptImportOptimizer.executeNoFormat(startElement.getContainingFile()));
            FormatFixer.fixAll(formatters);
        }
    }

    @NotNull
    public String getText() {
        JSClass clazz = (JSClass)this.getStartElement();
        boolean implement = this.mySupertypeIsInterface && !clazz.isInterface();
        String string = JSBundle.message((String)(implement ? "javascript.fix.create.implements" : "javascript.fix.create.extends"), (Object[])new Object[]{clazz.getName(), this.mySupertypeQname});
        if (string == null) {
            CreateInheritanceFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            CreateInheritanceFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/CreateInheritanceFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/CreateInheritanceFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

