/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.syntaxSelection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.types.JSClassElementType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SmartList;
import com.intellij.util.text.CharArrayUtil;
import java.util.Collections;
import java.util.List;

public class JavaScriptStatementGroupSelectioner
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(PsiElement e) {
        IElementType type;
        ASTNode astNode = e.getNode();
        return astNode != null && ((type = astNode.getElementType()) == JSElementTypes.BLOCK_STATEMENT || type instanceof JSClassElementType);
    }

    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        ASTNode lbrace = e.getNode().findChildByType(JSTokenTypes.LBRACE);
        ASTNode rbrace = e.getNode().findChildByType(JSTokenTypes.RBRACE);
        if (lbrace == null || rbrace == null) {
            return Collections.emptyList();
        }
        int start = CharArrayUtil.shiftForwardUntil((CharSequence)editorText, (int)lbrace.getTextRange().getEndOffset(), (String)"\n");
        start = CharArrayUtil.shiftForward((CharSequence)editorText, (int)start, (String)"\n");
        int end = CharArrayUtil.shiftBackwardUntil((CharSequence)editorText, (int)rbrace.getTextRange().getStartOffset(), (String)"\n");
        if (end > start) {
            return new SmartList((Object)new TextRange(start, end + 1));
        }
        return Collections.emptyList();
    }
}

