/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.syntaxSelection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;

public class JavaScriptLiteralSelectioner
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(PsiElement e) {
        IElementType astNodeType;
        ASTNode astNode = e.getNode();
        return astNode != null && ((astNodeType = astNode.getElementType()) == JSTokenTypes.STRING_LITERAL || astNodeType == JSTokenTypes.SINGLE_QUOTE_STRING_LITERAL || astNodeType == JSElementTypes.ARRAY_LITERAL_EXPRESSION || astNodeType == JSElementTypes.OBJECT_LITERAL_EXPRESSION);
    }

    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        TextRange elem = e.getTextRange();
        if (elem.getLength() > 2 && (!(e.getParent() instanceof JSLiteralExpression) || StringUtil.isQuotedString((String)e.getText()))) {
            return new SmartList((Object)new TextRange(elem.getStartOffset() + 1, elem.getEndOffset() - 1));
        }
        return Collections.emptyList();
    }
}

