/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.structureView.JSStructureItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.TreeTraversal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSStructureViewElementBase
implements StructureViewTreeElement {
    public static final String ANONYMOUS_ELEMENT_PRESENTATION = "<anonymous>";
    protected final PsiElement myElement;
    protected final List<PsiElement> myElements;
    private final NotNullLazyValue<ItemPresentation> myPresentation;
    protected volatile boolean myInherited;

    public JSStructureViewElementBase(@NotNull PsiElement element, @NotNull List<PsiElement> elements) {
        if (element == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(1);
        }
        this.myPresentation = NotNullLazyValue.createValue(() -> this.createPresentation());
        this.myElement = element;
        this.myElements = elements;
    }

    @NotNull
    public StructureViewTreeElement[] getChildren() {
        PsiElement element = this.getValue();
        if (!element.isValid()) {
            if (EMPTY_ARRAY == null) {
                JSStructureViewElementBase.$$$reportNull$$$0(2);
            }
            return EMPTY_ARRAY;
        }
        ArrayList children = ContainerUtil.newArrayList(this.getOwnChildren());
        Collections.sort(children, JSStructureViewElementBase.injectionAwareComparator(element.getProject()));
        StructureViewTreeElement[] structureViewTreeElementArray = children.toArray(new StructureViewTreeElement[children.size()]);
        if (structureViewTreeElementArray == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(3);
        }
        return structureViewTreeElementArray;
    }

    @NotNull
    public abstract List<StructureViewTreeElement> getOwnChildren();

    @NotNull
    public abstract List<StructureViewTreeElement> getInherited();

    @NotNull
    public ItemPresentation getPresentation() {
        ItemPresentation itemPresentation = (ItemPresentation)this.myPresentation.getValue();
        if (itemPresentation == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(4);
        }
        return itemPresentation;
    }

    public PsiElement getValue() {
        return this.myElement;
    }

    List<PsiElement> getAllElements() {
        return this.myElements;
    }

    public void navigate(boolean requestFocus) {
        ((Navigatable)this.myElement).navigate(requestFocus);
    }

    public boolean canNavigate() {
        return ((Navigatable)this.myElement).canNavigate();
    }

    @Nullable
    protected String getNameForVariableOrFunction(@NotNull PsiElement element, int count) {
        if (element == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(5);
        }
        if (element instanceof JSFunction && ((JSFunction)element).isAnonymousFunctionCall()) {
            return null;
        }
        if (element instanceof JSFunctionExpression && ((JSFunctionExpression)element).getName() == null && PsiTreeUtil.getContextOfType((PsiElement)element, JSAssignmentExpression.class, (boolean)true, (Class[])new Class[]{JSFunction.class}) != null) {
            return String.valueOf(count);
        }
        if (JSStructureViewElementBase.skipVariable(element)) {
            return null;
        }
        if (element instanceof JSImplicitElement && ((JSImplicitElement)element).hasMinorImportance()) {
            return null;
        }
        if (element instanceof TypeScriptCallSignature) {
            String name = JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)((TypeScriptCallSignature)element), true);
            return name != null ? name : String.valueOf(count);
        }
        if (element instanceof TypeScriptIndexSignature) {
            return "Index Signature";
        }
        if (element instanceof JSQualifiedNamedElement && ((JSQualifiedNamedElement)element).getName() == null && element.getParent() instanceof ES6ExportDefaultAssignment) {
            return "<default>";
        }
        return element instanceof JSNamedElementBase ? JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)element, true) : null;
    }

    protected boolean fillChildrenElement(@NotNull List<PsiElement> mainElements, @NotNull MultiMap<String, PsiElement> children, @NotNull Function<PsiElement, Collection<? extends PsiElement>> childrenProvider, @NotNull ChildElementProcessor childProcessor, boolean oneElementOnly) {
        if (mainElements == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(6);
        }
        if (children == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(7);
        }
        if (childrenProvider == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(8);
        }
        if (childProcessor == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(9);
        }
        ArrayDeque<PsiElement> queue = new ArrayDeque<PsiElement>();
        for (PsiElement element : mainElements) {
            queue.addAll((Collection)childrenProvider.fun((Object)element));
        }
        while (!queue.isEmpty()) {
            JSExpression[] expressions;
            boolean processed;
            PsiElement element = (PsiElement)queue.poll();
            JSStructureViewElementBase.addImplicitChildren(queue, element);
            if (this.shouldSkipProcess(element)) continue;
            String name = this.getName(element, children.size());
            if (StringUtil.isNotEmpty((String)name) && !(element instanceof JSDestructuringProperty) && (processed = childProcessor.process(element, name))) {
                if (!oneElementOnly || children.isEmpty()) continue;
                return true;
            }
            if (element instanceof JSArrayLiteralExpression && (expressions = ((JSArrayLiteralExpression)element).getExpressions()).length > 1) {
                for (int i = 0; i < expressions.length; ++i) {
                    JSExpression expression = expressions[i];
                    if (expression == null || !this.hasStructureElements((PsiElement)expression)) continue;
                    children.putValue((Object)("[" + String.valueOf(i) + "]"), (Object)expression);
                }
                continue;
            }
            if (JSStructureViewElementBase.isScopeChangingElement(element)) continue;
            queue.addAll((Collection)childrenProvider.fun((Object)element));
        }
        return false;
    }

    @Nullable
    protected String getName(@NotNull PsiElement element, int count) {
        if (element == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(10);
        }
        return this.getNameForVariableOrFunction(element, count);
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @NotNull
    public static Comparator<StructureViewTreeElement> injectionAwareComparator(@NotNull Project project) {
        if (project == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(11);
        }
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)project);
        Map offsets = FactoryMap.create(element -> {
            PsiElement o = JSStructureViewElementBase.getPsiElement(element);
            StubElement stub = o instanceof StubBasedPsiElement ? ((StubBasedPsiElement)o).getStub() : null;
            return stub != null ? -((ObjectStubBase)stub).id - 1 : manager.injectedToHost(o, o.getTextOffset());
        });
        Comparator comparator = (o1, o2) -> {
            Integer off1 = (int)((Integer)offsets.get(o1));
            Integer off2 = (int)((Integer)offsets.get(o2));
            if (off1 < 0 && off2 > 0) {
                return -1;
            }
            if (off1 > 0 && off2 < 0) {
                return 1;
            }
            return Math.abs(off1) - Math.abs(off2);
        };
        if (comparator == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(12);
        }
        return comparator;
    }

    @NotNull
    public static PsiElement getPsiElement(@NotNull StructureViewTreeElement element) {
        if (element == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(13);
        }
        PsiElement psiElement = (PsiElement)element.getValue();
        if (psiElement == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(14);
        }
        return psiElement;
    }

    @NotNull
    public JSStructureItemPresentation createPresentation() {
        JSStructureItemPresentation jSStructureItemPresentation = new JSStructureItemPresentation(this);
        if (jSStructureItemPresentation == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(15);
        }
        return jSStructureItemPresentation;
    }

    @NotNull
    protected static Collection<? extends PsiElement> getPsiOrStubChildren(@NotNull PsiElement element) {
        StubElement stub;
        if (element == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(16);
        }
        Object object = element instanceof StubBasedPsiElement ? ((StubBasedPsiElement)element).getStub() : (stub = element instanceof PsiFileImpl ? ((PsiFileImpl)element).getStub() : null);
        if (stub != null) {
            List list = ContainerUtil.map((Collection)stub.getChildrenStubs(), o -> o.getPsi());
            if (list == null) {
                JSStructureViewElementBase.$$$reportNull$$$0(17);
            }
            return list;
        }
        List<PsiElement> list = Arrays.asList(element.getChildren());
        if (list == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(18);
        }
        return list;
    }

    public static boolean isScopeChangingElement(@Nullable PsiElement element) {
        return element instanceof JSFunction && !(element instanceof JSFunctionExpression) || element instanceof JSCatchBlock;
    }

    public boolean isInherited() {
        return this.myInherited;
    }

    protected void setInherited() {
        this.myInherited = true;
    }

    protected static boolean isVisible(@Nullable PsiElement namedElement, @Nullable PsiElement element) {
        JSAttributeListOwner attributeListOwner;
        JSAttributeList attributeList;
        if (namedElement instanceof JSElementBase) {
            JSAttributeList.AccessType type = ((JSElementBase)namedElement).getAccessType();
            if (type == JSAttributeList.AccessType.PRIVATE) {
                return false;
            }
            if (namedElement instanceof JSFunctionItem) {
                return true;
            }
        }
        if (namedElement instanceof JSAttributeListOwner && (attributeList = (attributeListOwner = (JSAttributeListOwner)namedElement).getAttributeList()) != null) {
            JSAttributeList.AccessType type = attributeList.getAccessType();
            if (type == JSAttributeList.AccessType.PACKAGE_LOCAL) {
                return JSResolveUtil.isAccessibleFromCurrentPackage(namedElement, element);
            }
            return type != JSAttributeList.AccessType.PRIVATE;
        }
        return true;
    }

    protected static boolean skipVariable(PsiElement element) {
        if (!(element instanceof JSVariable)) {
            return false;
        }
        if (element instanceof JSParameter) {
            return true;
        }
        JSFunction fun = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{JSFunction.class});
        if (fun == null) {
            return false;
        }
        JSExpression initializer = ((JSVariable)element).getInitializerOrStub();
        if (initializer instanceof JSThisExpression || initializer instanceof JSAssignmentExpression) {
            return true;
        }
        if (fun instanceof JSFunctionExpression && fun.isAnonymousFunctionCall()) {
            return false;
        }
        if (JSResolveUtil.findParent((PsiElement)fun) instanceof JSClass) {
            return true;
        }
        return !JSSymbolUtil.isMeaningfulLocalVariableInitializer(initializer);
    }

    private static void addImplicitChildren(Queue<PsiElement> queue, PsiElement element) {
        if (element instanceof JSImplicitElementProvider) {
            Collection elements;
            JSElementIndexingData data = ((JSImplicitElementProvider)element).getIndexingData();
            Collection collection = elements = data != null ? data.getImplicitElements() : null;
            if (elements != null) {
                queue.addAll(elements);
            }
        }
    }

    protected boolean hasStructureElements(@Nullable PsiElement element) {
        return false;
    }

    protected boolean shouldSkipProcess(@Nullable PsiElement element) {
        return element instanceof ES6ImportDeclaration;
    }

    protected void addElement(MultiMap<String, PsiElement> children, PsiElement element, String name) {
        JSFunction function = JSPsiImplUtils.getPossibleFunction(element);
        String nameOfFunction = JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)function, true);
        PsiElement structureElement = function != null && StringUtil.equals((CharSequence)name, (CharSequence)nameOfFunction) ? function : element;
        String key = name != null ? name : ANONYMOUS_ELEMENT_PRESENTATION;
        this.addKeyElement(children, structureElement, key);
    }

    protected void addKeyElement(@NotNull MultiMap<String, PsiElement> children, @NotNull PsiElement structureElement, String key) {
        if (children == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(19);
        }
        if (structureElement == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(20);
        }
        if (!children.get((Object)key).contains(structureElement)) {
            children.putValue((Object)key, (Object)structureElement);
        }
    }

    protected void sortChildrenByImplicitElements(@NotNull List<PsiElement> value) {
        if (value == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(21);
        }
        Collections.sort(value, (e1, e2) -> {
            if (e1 instanceof JSImplicitElement && !(e2 instanceof JSImplicitElement)) {
                return 1;
            }
            if (e2 instanceof JSImplicitElement && !(e1 instanceof JSImplicitElement)) {
                return -1;
            }
            return 0;
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSStructureViewElementBase element = (JSStructureViewElementBase)o;
        if (this.myInherited != element.myInherited) {
            return false;
        }
        return this.myElements.equals(element.myElements);
    }

    @NotNull
    public List<StructureViewTreeElement> getInheritedForClass(@NotNull JSClass parentClass, @NotNull Function<PsiElement, JSStructureViewElementBase> wrapper) {
        if (parentClass == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(22);
        }
        if (wrapper == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(23);
        }
        Project project = parentClass.getProject();
        List list = ((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from(o -> JBIterable.of((Object[])o.getSuperClasses())).withRoots((Iterable)JBIterable.of((Object[])parentClass.getSuperClasses()))).unique()).traverse(TreeTraversal.PLAIN_BFS).map(wrapper).flatten(o -> JBIterable.from(o.getOwnChildren()).sorted(JSStructureViewElementBase.injectionAwareComparator(project))).filter(o -> {
            if (parentClass == null) {
                JSStructureViewElementBase.$$$reportNull$$$0(25);
            }
            return o instanceof JSStructureViewElementBase && JSStructureViewElementBase.isVisible(((JSStructureViewElementBase)o).getValue(), (PsiElement)parentClass);
        }).map(o -> {
            ((JSStructureViewElementBase)o).setInherited();
            return o;
        }).toList();
        if (list == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(24);
        }
        return list;
    }

    public int hashCode() {
        int result = this.myElements.hashCode();
        result = 31 * result + (this.myInherited ? 1 : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/structureView/JSStructureViewElementBase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainElements";
                break;
            }
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childProcessor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structureElement";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/structureView/JSStructureViewElementBase";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "injectionAwareComparator";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElement";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createPresentation";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiOrStubChildren";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getInheritedForClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 24: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNameForVariableOrFunction";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fillChildrenElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "injectionAwareComparator";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPsiOrStubChildren";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addKeyElement";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "sortChildrenByImplicitElements";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getInheritedForClass";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getInheritedForClass$7";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ChildElementProcessor {
        public boolean process(@NotNull PsiElement var1, @NotNull String var2);
    }
}

