/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.inline;

import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import gnu.trove.THashSet;
import java.util.Set;

class InjectionQuoteHandler {
    private final boolean inDoubleQuotedContext;
    private final boolean inQuotedContext;
    private final Set<RangeMarker> literalExpressionsToFix;

    public InjectionQuoteHandler(PsiElement context) {
        PsiElement injectionPlace = context.getContainingFile().getContext();
        if (injectionPlace != null) {
            String injectionText = injectionPlace.getText();
            this.inDoubleQuotedContext = StringUtil.startsWith((CharSequence)injectionText, (CharSequence)"\"");
            this.inQuotedContext = StringUtil.startsWith((CharSequence)injectionText, (CharSequence)"'");
            this.literalExpressionsToFix = this.inDoubleQuotedContext || this.inQuotedContext ? new THashSet() : null;
        } else {
            this.inQuotedContext = false;
            this.inDoubleQuotedContext = false;
            this.literalExpressionsToFix = null;
        }
    }

    Document fixQuotes(PsiElement element) {
        DocumentImpl document = new DocumentImpl(element.getText());
        this.fixQuotes(element, -element.getTextRange().getStartOffset(), (Document)document);
        return document;
    }

    void fixQuotes(PsiElement element, final int offset, final Document document) {
        if (this.literalExpressionsToFix != null) {
            element.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

                public void visitJSLiteralExpression(JSLiteralExpression node) {
                    if (InjectionQuoteHandler.this.literalExpressionsToFix != null) {
                        InjectionQuoteHandler.this.literalExpressionsToFix.add(InjectionQuoteHandler.rangeMarker((PsiElement)node, document, offset));
                    }
                    super.visitJSLiteralExpression(node);
                }
            });
            char outerBound = this.inDoubleQuotedContext ? (char)'\"' : '\'';
            String outerBoundReplacement = this.inDoubleQuotedContext ? "&quot;" : "&apos;";
            char newBound = this.inDoubleQuotedContext ? (char)'\'' : '\"';
            for (RangeMarker marker : this.literalExpressionsToFix) {
                int endStart = marker.getEndOffset() - 1;
                int startEnd = marker.getStartOffset() + 1;
                CharSequence sequence = document.getCharsSequence();
                boolean escaped = false;
                char literalStart = sequence.charAt(startEnd - 1);
                boolean changeLiteralBounds = literalStart == outerBound;
                for (int i = startEnd; i < endStart; ++i) {
                    sequence = document.getCharsSequence();
                    char ch = sequence.charAt(i);
                    if (escaped) {
                        if (ch == outerBound) {
                            document.replaceString(i - 1, i + 1, (CharSequence)outerBoundReplacement);
                            i += outerBoundReplacement.length() - 2;
                            endStart += outerBoundReplacement.length() - 2;
                        }
                        escaped = false;
                        continue;
                    }
                    if (ch == '\\' && !escaped) {
                        escaped = true;
                        continue;
                    }
                    if (escaped) continue;
                    if (ch == outerBound) {
                        document.replaceString(i, i + 1, (CharSequence)outerBoundReplacement);
                        i += outerBoundReplacement.length() - 1;
                        endStart += outerBoundReplacement.length() - 1;
                        continue;
                    }
                    if (ch != newBound || !changeLiteralBounds) continue;
                    document.insertString(i, (CharSequence)"\\");
                    ++i;
                    ++endStart;
                }
                if (!changeLiteralBounds) continue;
                document.replaceString(marker.getStartOffset(), startEnd, (CharSequence)Character.toString(newBound));
                document.replaceString(endStart, marker.getEndOffset(), (CharSequence)Character.toString(newBound));
            }
        }
    }

    public boolean hasSomethingToDo() {
        return this.inDoubleQuotedContext || this.inQuotedContext;
    }

    static RangeMarker rangeMarker(PsiElement node, Document document, int funOffset) {
        return document.createRangeMarker(node.getTextRange().shiftRight(funOffset));
    }
}

