/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractSuper;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.refactoring.BaseJSRefactoringHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;

public class JSExtractSuperClassHandler
extends BaseJSRefactoringHandler {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"extract.superclass.title");
    private static final String CANNOT_REFACTOR_REASON = RefactoringBundle.message((String)"error.wrong.caret.position.class");
    private final BiFunction<JSClass, JSElement, RefactoringDialog> myDialogFactory;

    public JSExtractSuperClassHandler(BiFunction<JSClass, JSElement, RefactoringDialog> dialogFactory) {
        super(REFACTORING_NAME, CANNOT_REFACTOR_REASON);
        this.myDialogFactory = dialogFactory;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            JSExtractSuperClassHandler.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            JSExtractSuperClassHandler.$$$reportNull$$$0(1);
        }
        if (elements.length != 1) {
            return;
        }
        PsiElement element = elements[0];
        JSClass aClass = JSExtractSuperClassHandler.getClass(element);
        if (aClass != null) {
            if (aClass.isInterface()) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)((Editor)CommonDataKeys.EDITOR.getData(dataContext)), (String)RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"superclass.cannot.be.extracted.from.an.interface")), (String)REFACTORING_NAME, null);
            } else if (aClass instanceof XmlBackedJSClassImpl) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)((Editor)CommonDataKeys.EDITOR.getData(dataContext)), (String)RefactoringBundle.getCannotRefactorMessage((String)JSBundle.message((String)"superclass.cannot.be.extracted.from.mxml.component", (Object[])new Object[0])), (String)REFACTORING_NAME, null);
            } else {
                JSElement selected = element instanceof JSElement ? (JSElement)element : null;
                RefactoringDialog dialog = this.myDialogFactory.apply(aClass, selected);
                dialog.show();
            }
        } else {
            CommonRefactoringUtil.showErrorHint((Project)project, null, (String)RefactoringBundle.getCannotRefactorMessage((String)CANNOT_REFACTOR_REASON), (String)REFACTORING_NAME, null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/refactoring/extractSuper/JSExtractSuperClassHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

