/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractSuper;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.refactoring.BaseJSRefactoringHandler;
import com.intellij.lang.typescript.refactoring.TypeScriptExtractInterfaceFromTypeHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;

public class JSExtractInterfaceHandler
extends BaseJSRefactoringHandler {
    private static final TypeScriptExtractInterfaceFromTypeHandler interfaceFromTypeHandler = new TypeScriptExtractInterfaceFromTypeHandler();
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"extract.interface.title");
    private static final String CANNOT_REFACTOR_REASON = RefactoringBundle.message((String)"error.wrong.caret.position.class");
    private final BiFunction<JSClass, JSElement, RefactoringDialog> myDialogFactory;

    public JSExtractInterfaceHandler(BiFunction<JSClass, JSElement, RefactoringDialog> factory) {
        super(REFACTORING_NAME, CANNOT_REFACTOR_REASON);
        this.myDialogFactory = factory;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            JSExtractInterfaceHandler.$$$reportNull$$$0(0);
        }
        if (editor != null && interfaceFromTypeHandler.isAvailableOnEditorAndFile(editor, file)) {
            interfaceFromTypeHandler.invoke(project, editor, file, dataContext);
        } else {
            super.invoke(project, editor, file, dataContext);
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            JSExtractInterfaceHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            JSExtractInterfaceHandler.$$$reportNull$$$0(2);
        }
        if (elements.length != 1) {
            return;
        }
        PsiElement element = elements[0];
        JSClass aClass = JSExtractInterfaceHandler.getClass(element);
        if (aClass != null) {
            JSElement selected = element instanceof JSElement ? (JSElement)element : null;
            RefactoringDialog dialog = this.myDialogFactory.apply(aClass, selected);
            dialog.show();
        } else {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)((Editor)CommonDataKeys.EDITOR.getData(dataContext)), (String)RefactoringBundle.getCannotRefactorMessage((String)CANNOT_REFACTOR_REASON), (String)REFACTORING_NAME, null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/refactoring/extractSuper/JSExtractInterfaceHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

