/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.changeSignature;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.ECMAScriptImportOptimizer;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.modules.ES6ImportAction;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.e4x.JSE4XNamespaceReference;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.JSChangeVisibilityUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.changeSignature.ChangeSignatureUsageViewDescriptor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureUtil;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodDescriptor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringConflictsUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSChangeSignatureProcessor
extends BaseRefactoringProcessor {
    public static final Logger LOG = Logger.getInstance((String)JSChangeSignatureProcessor.class.getName());
    @NotNull
    protected final JSFunction myMethod;
    private final JSAttributeList.AccessType myVisibility;
    private final String myMethodName;
    private final String myReturnType;
    protected final JSParameterInfo[] myParameters;
    private final Set<JSFunction> myMethodsToPropagateParameters;
    private final Set<JSElement> myImportedElements;
    private final boolean myChangeVisibility;
    private Condition<JSFunction> myDeclarationsFilter;
    private final int myMethodParamsNumber;

    public JSChangeSignatureProcessor(@NotNull JSFunction method, JSAttributeList.AccessType visibility, String methodName, String returnType, JSParameterInfo[] parameters, Set<JSFunction> methodsToPropagateParameters, Set<JSElement> importedElements) {
        if (method == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(0);
        }
        super(method.getProject());
        this.myDeclarationsFilter = Conditions.alwaysTrue();
        this.myMethod = method;
        this.myMethodParamsNumber = JSChangeSignatureProcessor.getNumberOfParams(method);
        this.myVisibility = visibility;
        this.myMethodName = methodName;
        this.myReturnType = returnType;
        this.myParameters = parameters;
        this.myMethodsToPropagateParameters = methodsToPropagateParameters;
        this.myImportedElements = importedElements;
        JSAttributeList attributeList = method.getAttributeList();
        this.myChangeVisibility = JSChangeSignatureProcessor.supportsVisibilityModifiers(this.getLangForProcessing()) && attributeList != null && this.myVisibility != attributeList.getAccessType();
    }

    public void setDeclarationsFilter(Condition<JSFunction> declarationsFilter) {
        this.myDeclarationsFilter = declarationsFilter;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(1);
        }
        ChangeSignatureUsageViewDescriptor changeSignatureUsageViewDescriptor = new ChangeSignatureUsageViewDescriptor(usages);
        if (changeSignatureUsageViewDescriptor == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(2);
        }
        return changeSignatureUsageViewDescriptor;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        class MyProcessor
        implements Processor<PsiReference> {
            JSElement myRebindTo;

            MyProcessor(JSElement rebindTo) {
                this.myRebindTo = rebindTo;
            }

            public boolean process(PsiReference psiReference) {
                if (psiReference instanceof JSTextReference) {
                    return true;
                }
                PsiElement element = psiReference.getElement();
                if (JSChangeSignatureProcessor.this.myMethod instanceof JSFunctionExpression) {
                    JSExpression rOperand;
                    if (element.getParent() instanceof JSVariable && JSResolveUtil.isSelfReference(element)) {
                        declarations.add(new FunctionExpressionDeclarationUsageInfo(element.getParent(), null));
                        return true;
                    }
                    if (element.getParent() instanceof JSDefinitionExpression && element.getParent().getParent() instanceof JSAssignmentExpression && (rOperand = ((JSAssignmentExpression)element.getParent().getParent()).getROperand()) == JSChangeSignatureProcessor.this.myMethod) {
                        return true;
                    }
                } else if (element.getParent() instanceof JSVariable && JSResolveUtil.isSelfReference(element)) {
                    return true;
                }
                usages.add(new OtherUsageInfo(element, this.myRebindTo, JSChangeSignatureProcessor.this.myParameters, element.getParent() instanceof JSSuperExpression || JSChangeSignatureProcessor.this.shouldPropagate(element), (Integer)minMaxParameters.first, (Integer)minMaxParameters.second));
                return true;
            }
        }
        Object parent;
        JSField field;
        Trinity<Integer, Integer, Boolean> minMaxParameters;
        Collection<OtherUsageInfo> usages;
        Collection<UsageInfo> declarations;
        block19: {
            JSFunction[] couple;
            JSFunction[] jSFunctionArray;
            Object clazz;
            block17: {
                block21: {
                    block20: {
                        block18: {
                            declarations = Collections.synchronizedCollection(new HashSet());
                            usages = Collections.synchronizedCollection(new HashSet());
                            minMaxParameters = ValidateTypesUtil.getMinMaxParameters((JSParameterItem[])this.myMethod.getParameters());
                            field = null;
                            if (!(this.myMethod instanceof JSFunctionExpression)) break block17;
                            parent = this.myMethod.getParent();
                            if (!(parent instanceof JSVariable)) break block18;
                            ReferencesSearch.search((PsiElement)parent, (SearchScope)parent.getUseScope()).forEach((Processor)new MyProcessor((JSElement)((JSVariable)parent)));
                            break block19;
                        }
                        if (!(parent instanceof JSAssignmentExpression)) break block20;
                        JSDefinitionExpression definitionExpression = (JSDefinitionExpression)((JSAssignmentExpression)parent).getLOperand();
                        ReferencesSearch.search((PsiElement)definitionExpression, (SearchScope)definitionExpression.getUseScope()).forEach((Processor)new MyProcessor((JSElement)definitionExpression));
                        break block19;
                    }
                    if (!(parent instanceof JSProperty)) break block21;
                    ReferencesSearch.search((PsiElement)parent, (SearchScope)parent.getUseScope()).forEach((Processor)new MyProcessor((JSElement)((JSProperty)parent)));
                    break block19;
                }
                if (!(parent instanceof ES6ExportDefaultAssignment)) break block19;
                ReferencesSearch.search((PsiElement)this.myMethod, (SearchScope)this.myMethod.getUseScope()).forEach((Processor)new MyProcessor((JSElement)this.myMethod));
                declarations.add(new MethodDeclarationUsageInfo(this.myMethod, null));
                break block19;
            }
            JSFunction complementary = null;
            if (this.myMethod.isGetProperty()) {
                clazz = JSUtils.getMemberContainingClass((PsiElement)this.myMethod);
                complementary = clazz.findFunctionByNameAndKind(this.myMethod.getName(), JSFunction.FunctionKind.SETTER);
                field = clazz.findFieldByName(JSRefactoringUtil.transformAccessorNameToPropertyName(this.myMethod.getName(), this.myProject));
            } else if (this.myMethod.isSetProperty()) {
                clazz = JSUtils.getMemberContainingClass((PsiElement)this.myMethod);
                complementary = clazz.findFunctionByNameAndKind(this.myMethod.getName(), JSFunction.FunctionKind.GETTER);
                field = clazz.findFieldByName(JSRefactoringUtil.transformAccessorNameToPropertyName(this.myMethod.getName(), this.myProject));
            } else if (this.myMethod.isConstructor()) {
                for (JSCallExpression superCall : JSInheritanceUtil.findSuperConstructorCalls(this.myMethod)) {
                    usages.add(new OtherUsageInfo((PsiElement)superCall.getMethodExpression(), (JSElement)this.myMethod, this.myParameters, this.shouldPropagate((PsiElement)superCall), (Integer)minMaxParameters.first, (Integer)minMaxParameters.second));
                }
            }
            if (complementary != null) {
                JSFunction[] jSFunctionArray2 = new JSFunction[2];
                jSFunctionArray2[0] = this.myMethod;
                jSFunctionArray = jSFunctionArray2;
                jSFunctionArray2[1] = complementary;
            } else {
                JSFunction[] jSFunctionArray3 = new JSFunction[1];
                jSFunctionArray = jSFunctionArray3;
                jSFunctionArray3[0] = this.myMethod;
            }
            for (JSFunction method : couple = jSFunctionArray) {
                THashSet inheritors = new THashSet();
                JSInheritanceUtil.iterateMethodsDown(method, new Processor<JSFunction>((Collection)inheritors){
                    final /* synthetic */ Collection val$inheritors;
                    {
                        this.val$inheritors = collection2;
                    }

                    public synchronized boolean process(JSFunction jsFunction) {
                        if (JSChangeSignatureProcessor.this.myDeclarationsFilter.value((Object)jsFunction)) {
                            declarations.add(new MethodDeclarationUsageInfo(jsFunction, null));
                            this.val$inheritors.add(jsFunction);
                        }
                        return true;
                    }
                });
                for (JSFunction inheritor : inheritors) {
                    ReferencesSearch.search((PsiElement)inheritor, (SearchScope)inheritor.getUseScope()).forEach((Processor)new MyProcessor((JSElement)inheritor));
                }
                ReferencesSearch.search((PsiElement)method, (SearchScope)method.getUseScope()).forEach((Processor)new MyProcessor((JSElement)method));
                declarations.add(new MethodDeclarationUsageInfo(method, null));
            }
        }
        if (this.myMethod instanceof JSFunctionExpression) {
            parent = this.myMethod.getParent();
            if (parent instanceof JSVariable || parent instanceof JSAssignmentExpression || parent instanceof JSProperty) {
                declarations.add(new FunctionExpressionDeclarationUsageInfo((PsiElement)parent, null));
            } else {
                declarations.add(new MethodDeclarationUsageInfo(this.myMethod, null));
            }
        } else {
            declarations.add(new MethodDeclarationUsageInfo(this.myMethod, null));
        }
        this.findPropagationUsages(declarations, usages);
        if (field != null) {
            declarations.add(new FieldDeclarationUsageInfo(field));
            ReferencesSearch.search((PsiElement)field, (SearchScope)field.getUseScope()).forEach((Processor)new MyProcessor((JSElement)field));
        }
        for (UsageInfo usageInfo : declarations) {
            if (!(usageInfo instanceof FunctionDeclarationUsageInfoBase)) continue;
            ((FunctionDeclarationUsageInfoBase)usageInfo).searchForParametersUsages();
        }
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>(declarations);
        result.addAll(usages);
        UsageInfo[] usageInfoArray = result.toArray(new UsageInfo[result.size()]);
        if (usageInfoArray == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    protected void findPropagationUsages(Collection<UsageInfo> declarations, Collection<OtherUsageInfo> usages) {
        if (!this.myMethodsToPropagateParameters.isEmpty()) {
            ArrayList<JSParameterInfo> addedParams = new ArrayList<JSParameterInfo>();
            for (JSParameterInfo parameter : this.myParameters) {
                if (parameter.getOldIndex() != -1 || !StringUtil.isNotEmpty((String)parameter.getDefaultValue())) continue;
                addedParams.add(parameter);
            }
            for (JSFunction toPropagate : this.myMethodsToPropagateParameters) {
                List<JSParameterInfo> p = JSMethodDescriptor.getParameters(toPropagate);
                p.addAll(addedParams);
                JSParameterInfo[] newDeclarationParams = p.toArray(new JSParameterInfo[p.size()]);
                Trinity<Integer, Integer, Boolean> propagateMinMaxParameters = ValidateTypesUtil.getMinMaxParameters((JSParameterItem[])toPropagate.getParameters());
                Processor consumer = psiReference -> {
                    if (psiReference instanceof JSTextReference) {
                        return true;
                    }
                    PsiElement element = psiReference.getElement();
                    if (!(element.getParent() instanceof JSCallExpression)) {
                        return true;
                    }
                    usages.add(new OtherUsageInfo(element, null, newDeclarationParams, this.shouldPropagate(element), (Integer)propagateMinMaxParameters.first, (Integer)propagateMinMaxParameters.second));
                    return true;
                };
                if (toPropagate instanceof JSFunctionExpression) {
                    declarations.add(new FunctionExpressionDeclarationUsageInfo(toPropagate.getParent(), newDeclarationParams));
                    ReferencesSearch.search((PsiElement)toPropagate.getParent(), (SearchScope)toPropagate.getParent().getUseScope()).forEach(consumer);
                    continue;
                }
                for (JSFunction top : JSInheritanceUtil.findTopMethods(toPropagate)) {
                    ReferencesSearch.search((PsiElement)top, (SearchScope)top.getUseScope()).forEach(consumer);
                    if (JSChangeSignatureProcessor.getNumberOfParams(top) != JSChangeSignatureProcessor.getNumberOfParams(toPropagate) || !this.myDeclarationsFilter.value((Object)top)) continue;
                    declarations.add(new MethodDeclarationUsageInfo(top, newDeclarationParams));
                }
                if (!toPropagate.isConstructor()) continue;
                for (JSCallExpression callExpression : JSInheritanceUtil.findSuperConstructorCalls(toPropagate)) {
                    usages.add(new OtherUsageInfo((PsiElement)callExpression.getMethodExpression(), null, newDeclarationParams, this.shouldPropagate((PsiElement)callExpression), (Integer)propagateMinMaxParameters.first, (Integer)propagateMinMaxParameters.second));
                }
            }
        }
    }

    protected void performRefactoring(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(4);
        }
        RequiredImportProcessor importProcessor = JSChangeSignatureProcessor.createImportProcessor(this.getLangForProcessing(), this.myImportedElements);
        ArrayList<OtherUsageInfo> secondStepUsages = new ArrayList<OtherUsageInfo>();
        for (UsageInfo usage : usageInfos) {
            if (usage instanceof FunctionDeclarationUsageInfoBase) {
                this.refactorFunctionDeclaration((FunctionDeclarationUsageInfoBase)usage, importProcessor);
                continue;
            }
            if (usage instanceof FieldDeclarationUsageInfo) {
                this.refactorFieldDeclaration(((FieldDeclarationUsageInfo)usage).getElement(), importProcessor);
                continue;
            }
            if (!(usage instanceof OtherUsageInfo)) continue;
            secondStepUsages.add((OtherUsageInfo)usage);
        }
        for (OtherUsageInfo usage : secondStepUsages) {
            this.refactorUsage(usage, importProcessor);
        }
        importProcessor.finish();
    }

    @NotNull
    private static RequiredImportProcessor createImportProcessor(JSLanguageDialect language, Set<JSElement> importedElements) {
        DialectOptionHolder optionHolder = language.getOptionHolder();
        if (optionHolder.isECMA4) {
            ActionScriptImportProcessor actionScriptImportProcessor = new ActionScriptImportProcessor();
            if (actionScriptImportProcessor == null) {
                JSChangeSignatureProcessor.$$$reportNull$$$0(5);
            }
            return actionScriptImportProcessor;
        }
        if (optionHolder.isTypeScript || optionHolder.isECMA6) {
            ES6CompatibleImportProcessor eS6CompatibleImportProcessor = new ES6CompatibleImportProcessor(importedElements);
            if (eS6CompatibleImportProcessor == null) {
                JSChangeSignatureProcessor.$$$reportNull$$$0(6);
            }
            return eS6CompatibleImportProcessor;
        }
        RequiredImportProcessor requiredImportProcessor = RequiredImportProcessor.EMPTY;
        if (requiredImportProcessor == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(7);
        }
        return requiredImportProcessor;
    }

    private void refactorFunctionDeclaration(FunctionDeclarationUsageInfoBase usage, RequiredImportProcessor requiredImportProcessor) {
        JSFunction function = usage.getFunction();
        JSParameterInfo[] paramsOverride = usage.getParamsOverride();
        MultiMap<JSParameter, UsageInfo> paramsUsages = usage.getParamsUsages();
        if (paramsOverride != null) {
            JSChangeSignatureUtil.setParameters(function, paramsUsages, requiredImportProcessor, this.getLangForProcessing(), paramsOverride);
        } else if (function.getKind() != this.myMethod.getKind() || this.myMethodParamsNumber == JSChangeSignatureProcessor.getNumberOfParams(function)) {
            this.refactorMethodDeclaration(function, requiredImportProcessor, paramsUsages);
        }
    }

    private void refactorUsage(OtherUsageInfo u, RequiredImportProcessor importProcessor) {
        PsiElement el = u.getElement();
        if (el == null) {
            LOG.error(String.format("Could not restore element from pointer [%s] in usageInfo [%s]", new Object[]{u.getSmartPointer(), u}));
            return;
        }
        JSElement target = u.getRebindTo();
        if (target != null) {
            JSChangeSignatureProcessor.rebindTarget(el, target);
        }
        if (el.getParent() instanceof JSCallExpression) {
            JSE4XNamespaceReference namespaceRef;
            JSCallExpression callExpression = (JSCallExpression)el.getParent();
            JSExpression methodExpression = callExpression.getMethodExpression();
            boolean superCall = methodExpression instanceof JSReferenceExpression && ((JSReferenceExpression)methodExpression).getQualifier() instanceof JSSuperExpression;
            this.refactorCall(callExpression, u.getParameters(), u.isPropagate() || superCall, u.myMinParams, u.myMaxParams, importProcessor);
            if (this.myChangeVisibility && (namespaceRef = (JSE4XNamespaceReference)PsiTreeUtil.findChildOfType((PsiElement)methodExpression, JSE4XNamespaceReference.class)) != null) {
                namespaceRef.delete();
            }
        }
    }

    private static void rebindTarget(@NotNull PsiElement el, @NotNull JSElement target) {
        PsiElement localResolveResult;
        if (el == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(8);
        }
        if (target == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(9);
        }
        if (el instanceof ES6ImportSpecifier) {
            ((ES6ImportSpecifier)el).bindToElement((PsiElement)target);
        } else if (el instanceof ES6ImportSpecifierAlias) {
            ((ES6ImportSpecifier)el.getParent()).bindToElement((PsiElement)target);
        }
        if (el instanceof JSReferenceExpression && !((localResolveResult = JSChangeSignatureProcessor.resolveInModule((JSReferenceExpression)el)) instanceof ES6ImportedBinding) && !(localResolveResult instanceof ES6ImportSpecifierAlias)) {
            ((JSReferenceExpression)el).bindToElement((PsiElement)target);
        }
    }

    @Nullable
    private static PsiElement resolveInModule(@NotNull JSReferenceExpression referenceExpression) {
        PsiElement es6Module;
        if (referenceExpression == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(10);
        }
        return (es6Module = ES6PsiUtil.findExternalModule((PsiElement)referenceExpression)) != null && referenceExpression.getReferenceName() != null ? JSStubBasedPsiTreeUtil.resolveLocally(referenceExpression.getReferenceName(), es6Module) : null;
    }

    private static boolean hasSpreadElement(@Nullable JSCallExpression callExpression) {
        return callExpression != null && callExpression.getArgumentList() != null && callExpression.getArgumentList().hasSpreadElement();
    }

    private void refactorCall(@NotNull JSCallExpression callExpression, @NotNull JSParameterInfo[] parameters, boolean propagate, int minParams, int maxParams, @NotNull RequiredImportProcessor importProcessor) {
        if (callExpression == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(11);
        }
        if (parameters == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(12);
        }
        if (importProcessor == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(13);
        }
        JSExpression[] oldArguments = callExpression.getArguments();
        if (this.getLangForProcessing().getOptionHolder().isECMA4 && (oldArguments.length < minParams || oldArguments.length > maxParams) || JSChangeSignatureProcessor.hasSpreadElement(callExpression)) {
            return;
        }
        List<JSExpression> newArguments = this.buildCallArguments(callExpression, parameters, propagate, importProcessor);
        JSCallExpression dummyCallExpression = (JSCallExpression)ObjectUtils.assertNotNull((Object)JSChangeUtil.createExpressionPsiWithContext("dummy()", (PsiElement)callExpression, JSCallExpression.class));
        JSArgumentList newArgList = (JSArgumentList)ObjectUtils.assertNotNull((Object)dummyCallExpression.getArgumentList());
        for (JSExpression argument : newArguments) {
            JSChangeSignatureProcessor.addCommaIfNeeded(newArgList);
            newArgList.addBefore((PsiElement)argument, newArgList.getLastChild());
        }
        JSArgumentList list = callExpression.getArgumentList();
        newArgList = list != null ? (JSArgumentList)list.replace((PsiElement)newArgList) : (JSArgumentList)callExpression.addAfter((PsiElement)newArgList, (PsiElement)callExpression.getMethodExpression());
        CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)newArgList);
    }

    @NotNull
    private List<JSExpression> buildCallArguments(@NotNull JSCallExpression callExpression, @NotNull JSParameterInfo[] parameters, boolean propagate, @NotNull RequiredImportProcessor importProcessor) {
        if (callExpression == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(14);
        }
        if (parameters == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(15);
        }
        if (importProcessor == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(16);
        }
        JSExpression[] oldArguments = callExpression.getArguments();
        ArrayList newArguments = ContainerUtil.newArrayList();
        for (int i = 0; i < parameters.length; ++i) {
            JSParameterInfo parameter = parameters[i];
            if (parameter.getOldIndex() == -1) {
                String value;
                if (StringUtil.isEmpty((String)parameter.getDefaultValue())) {
                    for (int j = i; j < parameters.length; ++j) {
                        JSParameterInfo p2 = parameters[j];
                        LOG.assertTrue((StringUtil.isNotEmpty((String)p2.getInitializer()) || p2.isRest()) && StringUtil.isEmpty((String)p2.getDefaultValue()));
                    }
                    continue;
                }
                if (propagate) {
                    value = parameter.getDeclarationText();
                } else {
                    String defaultValue = parameter.getDefaultValue();
                    if (StringUtil.isEmpty((String)defaultValue)) {
                        defaultValue = JSTypeUtils.defaultValueOfType(parameter.getTypeText());
                    } else {
                        importProcessor.computeImportsForExpression(defaultValue, (PsiElement)callExpression);
                    }
                    value = JSChangeSignatureProcessor.getEscaped(defaultValue, (PsiElement)callExpression);
                }
                this.ensureArgumentsCount(newArguments, i, (JSElement)callExpression);
                newArguments.add(JSChangeUtil.createExpressionPsiWithContext(value, (PsiElement)callExpression, JSExpression.class));
                continue;
            }
            if (parameter.isRest() && parameter.getOldIndex() < oldArguments.length) {
                newArguments.addAll(Arrays.asList(oldArguments).subList(parameter.getOldIndex(), oldArguments.length));
                ArrayList arrayList = newArguments;
                if (arrayList == null) {
                    JSChangeSignatureProcessor.$$$reportNull$$$0(17);
                }
                return arrayList;
            }
            if (parameter.getOldIndex() >= oldArguments.length) continue;
            this.ensureArgumentsCount(newArguments, i, (JSElement)callExpression);
            newArguments.add(oldArguments[parameter.getOldIndex()]);
        }
        ArrayList arrayList = newArguments;
        if (arrayList == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    private void ensureArgumentsCount(@NotNull List<JSExpression> result, int count, @NotNull JSElement context) {
        if (result == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(19);
        }
        if (context == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(20);
        }
        while (result.size() < count) {
            String defaultValue = this.myParameters[result.size()].getInitializer();
            String replacement = result.size() < this.myParameters.length && !StringUtil.isEmpty((String)defaultValue) ? defaultValue : "undefined";
            result.add(JSChangeUtil.createExpressionPsiWithContext(replacement, (PsiElement)context, JSExpression.class));
        }
    }

    private static List<String> computeRequiredActionScriptImports(String text, PsiElement context) {
        ArrayList result = ContainerUtil.newArrayList();
        JSChangeSignatureProcessor.processUnresolvedReferences(text, context, (PairConsumer<JSReferenceExpression, ResolveResult[]>)((PairConsumer)(__, resolveResults) -> {
            String qName;
            if (((ResolveResult[])resolveResults).length != 1) {
                return;
            }
            JSResolveResult resolveResult = (JSResolveResult)resolveResults[0];
            if (resolveResult.getElement() == null || resolveResult.getResolveProblemKey() != null && !"javascript.qualified.name.is.not.imported.message".equals(resolveResult.getResolveProblemKey())) {
                return;
            }
            PsiElement resolved = resolveResult.getElement();
            if (JSResolveUtil.isConstructorFunction(resolved)) {
                resolved = resolved.getParent();
            }
            if ((resolved instanceof JSClass || (resolved instanceof JSFunction || resolved instanceof JSVariable) && resolved.getParent() instanceof JSPackageStatement) && (qName = ((JSQualifiedNamedElement)resolved).getQualifiedName()) != null && qName.contains(".") && JSPsiImplUtils.differentPackageName(StringUtil.getPackageName((String)qName), JSResolveUtil.getPackageNameFromPlace(context))) {
                result.add(qName);
            }
        }));
        return result;
    }

    private static void createRequiredES6Imports(@Nullable String newlyAddedText, @NotNull PsiElement context, @NotNull Set<JSElement> importedElements) {
        if (context == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(21);
        }
        if (importedElements == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(22);
        }
        JSChangeSignatureProcessor.processUnresolvedReferences(newlyAddedText, context, (PairConsumer<JSReferenceExpression, ResolveResult[]>)((PairConsumer)(refExpression, resolveResults) -> {
            if (context == null) {
                JSChangeSignatureProcessor.$$$reportNull$$$0(28);
            }
            if (importedElements == null) {
                JSChangeSignatureProcessor.$$$reportNull$$$0(29);
            }
            if (((ResolveResult[])resolveResults).length == 0 || ((ResolveResult[])resolveResults).length == 1 && StringUtil.equals((CharSequence)((JSResolveResult)resolveResults[0]).getResolveProblemKey(), (CharSequence)"javascript.element.need.to.be.imported")) {
                ES6ImportAction importAction = ES6CreateImportUtil.createImportAction(null, context, refExpression.getReferenceName(), null, ES6ImportAction.DEFAULT_FILTER);
                List acceptableCandidates = importAction.getCandidates();
                if (acceptableCandidates.size() == 1) {
                    importAction.executeFor(acceptableCandidates.get(0), null);
                }
                acceptableCandidates = ContainerUtil.filter(acceptableCandidates, importedElements::contains);
                if (acceptableCandidates.size() == 1) {
                    importAction.executeFor((JSElement)acceptableCandidates.get(0), null);
                }
            }
        }));
    }

    private static void processUnresolvedReferences(@Nullable String newlyAddedText, @NotNull PsiElement context, final PairConsumer<JSReferenceExpression, ResolveResult[]> candidateProcessor) {
        if (context == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(23);
        }
        if (StringUtil.isEmpty((String)newlyAddedText)) {
            return;
        }
        ASTNode astNode = JSChangeUtil.createJSTreeFromText(context.getProject(), newlyAddedText, DialectDetector.languageDialectOfElement(context));
        if (astNode == null) {
            return;
        }
        PsiElement element = astNode.getPsi();
        element.getContainingFile().putUserData(JSResolveUtil.contextKey, (Object)context);
        element.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                Object[] resolveResults = node.multiResolve(false);
                if (resolveResults.length > 1 || ContainerUtil.or((Object[])resolveResults, r -> r.isValidResult() || !(r instanceof JSResolveResult))) {
                    return;
                }
                candidateProcessor.consume((Object)node, (Object)resolveResults);
            }
        });
    }

    private static String getEscaped(String value, PsiElement context) {
        if (value.contains("\"")) {
            if (JSChangeSignatureProcessor.needsApos(context)) {
                return value.replace('\"', '\'');
            }
        } else if (value.contains("'") && !JSChangeSignatureProcessor.needsApos(context)) {
            return value.replace('\'', '\"');
        }
        return value;
    }

    private static boolean needsApos(PsiElement context) {
        if (context.getContainingFile().getContext() instanceof XmlAttributeValue) {
            return true;
        }
        JSEmbeddedContent embeddedContent = (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)context, JSEmbeddedContent.class, (boolean)true);
        return embeddedContent != null && !(embeddedContent.getParent() instanceof XmlTag);
    }

    private static void addCommaIfNeeded(JSArgumentList newArgList) {
        if (newArgList.getArguments().length > 0) {
            newArgList.addBefore(JSChangeUtil.createCommaPsiElement(newArgList.getProject()), newArgList.getLastChild());
        }
    }

    private void refactorMethodDeclaration(JSFunction function, RequiredImportProcessor requiredImportProcessor, MultiMap<JSParameter, UsageInfo> paramsUsages) {
        if (this.myMethodName != null && !this.myMethodName.isEmpty()) {
            PsiElement element;
            JSExpression expression;
            JSExpression lOperand;
            PsiElement parent;
            if (function instanceof JSFunctionExpression && (parent = function.getParent()) instanceof JSAssignmentExpression && (lOperand = ((JSAssignmentExpression)parent).getLOperand()) instanceof JSDefinitionExpression && (expression = ((JSDefinitionExpression)lOperand).getExpression()) instanceof JSReferenceExpression && (element = ((JSReferenceExpression)expression).resolve()) instanceof JSVariable) {
                ((JSVariable)element).setName(this.myMethodName);
            }
            function.setName(this.myMethodName);
        }
        if (JSChangeSignatureProcessor.supportsVisibilityModifiers(this.getLangForProcessing())) {
            if (function instanceof JSFunctionExpression && function.getParent() instanceof JSVariable) {
                JSAttributeList attributeList = ((JSVariable)function.getParent()).getAttributeList();
                if (attributeList != null && attributeList.getAccessType() != this.myVisibility) {
                    JSChangeVisibilityUtil.setVisibility((JSAttributeListOwner)((JSVariable)function.getParent()), this.myVisibility);
                }
            } else {
                JSClass clazz = JSUtils.getMemberContainingClass((PsiElement)function);
                JSAttributeList attributeList = function.getAttributeList();
                if (clazz != null && (this.myVisibility == JSAttributeList.AccessType.PACKAGE_LOCAL && function.isConstructor() || clazz.isInterface())) {
                    JSChangeVisibilityUtil.removeAccessModifier((JSAttributeListOwner)function);
                } else if (attributeList != null && attributeList.getAccessType() != this.myVisibility) {
                    JSChangeVisibilityUtil.setVisibility((JSAttributeListOwner)function, this.myVisibility);
                }
            }
        }
        if (this.myMethod.getKind() == function.getKind()) {
            JSRefactoringUtil.setType((JSNamedElement)function, this.myReturnType);
            requiredImportProcessor.computeImportsForType(this.myReturnType, (PsiElement)function);
            JSChangeSignatureUtil.setParameters(function, paramsUsages, requiredImportProcessor, this.getLangForProcessing(), this.myParameters);
        } else if (this.myMethod.isGetProperty() && function.isSetProperty()) {
            JSParameterListElement[] params = function.getParameters();
            String name = params.length > 0 ? params[0].getName() : "value";
            JSChangeSignatureUtil.setParameters(function, paramsUsages, requiredImportProcessor, this.getLangForProcessing(), new JSParameterInfo(name, this.myReturnType, "", "", -1));
        } else if (this.myMethod.isSetProperty() && function.isGetProperty()) {
            requiredImportProcessor.computeImportsForType(this.myParameters[0].getTypeText(), (PsiElement)function);
            JSRefactoringUtil.setType((JSNamedElement)function, this.myParameters[0].getTypeText());
        }
    }

    private void refactorFieldDeclaration(JSField field, RequiredImportProcessor importProcessor) {
        field.setName(JSRefactoringUtil.transformAccessorNameToPropertyName(this.myMethodName, this.myProject));
        String returnType = this.myMethod.isGetProperty() ? this.myReturnType : this.myParameters[0].getTypeText();
        JSRefactoringUtil.setType((JSNamedElement)field, returnType);
        importProcessor.computeImportsForType(returnType, (PsiElement)field);
    }

    @NotNull
    protected String getCommandName() {
        String methodDescription = JSFormatUtil.formatMethod(this.myMethod, 4353, 0, 0, null);
        String string = RefactoringBundle.message((String)"changing.signature.of.0", (Object[])new Object[]{methodDescription});
        if (string == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(24);
        }
        return string;
    }

    private static int getNumberOfParams(JSFunction function) {
        return function.getParameters().length;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(25);
        }
        MultiMap conflicts = new MultiMap();
        for (UsageInfo usageInfo : (UsageInfo[])refUsages.get()) {
            PsiElement element;
            if (usageInfo instanceof FunctionDeclarationUsageInfoBase) {
                JSFunction pattern;
                JSClass clazz;
                JSFunction method = ((FunctionDeclarationUsageInfoBase)usageInfo).getFunction();
                boolean ignored = false;
                JSParameterInfo[] paramsOverride = ((FunctionDeclarationUsageInfoBase)usageInfo).getParamsOverride();
                if (paramsOverride != null || this.myMethod.getKind() == method.getKind()) {
                    if (paramsOverride != null || this.myMethodParamsNumber == JSChangeSignatureProcessor.getNumberOfParams(method)) {
                        JSParameterInfo[] newParameters = paramsOverride != null ? paramsOverride : this.myParameters;
                        JSChangeSignatureProcessor.checkLocalCollisions(method, newParameters, (MultiMap<PsiElement, String>)conflicts);
                    } else {
                        String methodDescription = RefactoringUIUtil.getDescription((PsiElement)method, (boolean)true);
                        conflicts.putValue((Object)method, (Object)JSBundle.message((String)(JSUtils.getMemberContainingClass((PsiElement)this.myMethod).isInterface() ? "change.signature.conflict.incompatible.implementation" : "change.signature.conflict.incompatible.override"), (Object[])new Object[]{methodDescription, RefactoringUIUtil.getDescription((PsiElement)this.myMethod, (boolean)true), StringUtil.capitalize((String)methodDescription)}));
                        ignored = true;
                    }
                } else if (this.myMethod.isGetProperty() && method.isSetProperty()) {
                    JSParameterListElement[] params = method.getParameters();
                    String name = params.length > 0 ? params[0].getName() : "value";
                    JSChangeSignatureProcessor.checkLocalCollisions(method, new JSParameterInfo[]{new JSParameterInfo(name, this.myReturnType, "", "", -1)}, (MultiMap<PsiElement, String>)conflicts);
                }
                if (ignored || paramsOverride != null || Comparing.equal((String)this.myMethodName, (String)method.getName()) || (clazz = JSUtils.getMemberContainingClass((PsiElement)method)) == null || (pattern = ((JSClass)JSChangeUtil.createStatementFromText(this.myProject, "class Dummy{function " + this.myMethodName + "(){}}", this.getLangForProcessing()).getPsi()).findFunctionByName(this.myMethodName)) == null) continue;
                JSRefactoringConflictsUtil.checkMemberExist((JSAttributeListOwner)pattern, clazz, (MultiMap<PsiElement, String>)conflicts);
                continue;
            }
            if (usageInfo instanceof FieldDeclarationUsageInfo) {
                JSField field = ((FieldDeclarationUsageInfo)usageInfo).getElement();
                JSClass clazz = JSUtils.getMemberContainingClass((PsiElement)field);
                String fieldName = JSRefactoringUtil.transformAccessorNameToPropertyName(this.myMethodName, this.myProject);
                JSField pattern = ((JSClass)JSChangeUtil.createStatementFromText(this.myProject, "class Dummy{var " + fieldName + "(){}}", this.getLangForProcessing()).getPsi()).findFieldByName(fieldName);
                if (pattern == null) continue;
                JSRefactoringConflictsUtil.checkMemberExist((JSAttributeListOwner)pattern, clazz, (MultiMap<PsiElement, String>)conflicts);
                continue;
            }
            if (!(usageInfo instanceof OtherUsageInfo) || (element = usageInfo.getElement()) == null || !(element.getParent() instanceof JSCallExpression) || !JSChangeSignatureProcessor.hasSpreadElement((JSCallExpression)element.getParent())) continue;
            conflicts.putValue((Object)element.getParent(), (Object)JSBundle.message((String)"change.signature.call.expression.contains.spreads", (Object[])new Object[0]));
        }
        JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)this.myMethod);
        if (this.myChangeVisibility && containingClass != null) {
            boolean differentPackages;
            String topClassQName = containingClass.getQualifiedName();
            Ref hasSubMethods = new Ref((Object)false);
            boolean bl = differentPackages = !JSInheritanceUtil.iterateMethodsDown(this.myMethod, (Processor<JSFunction>)((Processor)jsFunction -> {
                hasSubMethods.set((Object)true);
                String qName = JSUtils.getMemberContainingClass((PsiElement)jsFunction).getQualifiedName();
                return !JSPsiImplUtils.differentPackageName(topClassQName, qName);
            }));
            if (((Boolean)hasSubMethods.get()).booleanValue() && (this.myVisibility == JSAttributeList.AccessType.PRIVATE || differentPackages && this.myVisibility == JSAttributeList.AccessType.PACKAGE_LOCAL)) {
                String message = JSBundle.message((String)"{0}.visibility.will.break.methods.hierarchy", (Object[])new Object[]{ElementDescriptionUtil.getElementDescription((PsiElement)this.myMethod, (ElementDescriptionLocation)RefactoringDescriptionLocation.WITH_PARENT), JSFormatUtil.formatVisibility(this.myVisibility)});
                conflicts.putValue((Object)this.myMethod, (Object)StringUtil.capitalize((String)message));
            }
            for (UsageInfo usageInfo : (UsageInfo[])refUsages.get()) {
                JSElement rebindTo;
                if (!(usageInfo instanceof OtherUsageInfo) || !((rebindTo = ((OtherUsageInfo)usageInfo).getRebindTo()) instanceof JSAttributeListOwner)) continue;
                JSRefactoringConflictsUtil.checkAccessibility((JSAttributeListOwner)rebindTo, null, this.myVisibility.name(), usageInfo.getElement(), (MultiMap<PsiElement, String>)conflicts, true, JSVisibilityUtil.DEFAULT_OPTIONS);
            }
        }
        return this.showConflicts(conflicts, (UsageInfo[])refUsages.get());
    }

    private static void checkLocalCollisions(JSFunction function, JSParameterInfo[] newParameters, MultiMap<PsiElement, String> conflicts) {
        HashSet deletedOrRenamedParameters = new HashSet();
        Object[] oldParameters = function.getParameterVariables();
        ContainerUtil.addAll((Collection)deletedOrRenamedParameters, (Object[])oldParameters);
        for (JSParameterInfo parameterInfo : newParameters) {
            if (parameterInfo.getOldIndex() == -1) continue;
            Object oldParameter = oldParameters[parameterInfo.getOldIndex()];
            if (!parameterInfo.getName().equals(oldParameter.getName())) continue;
            deletedOrRenamedParameters.remove(oldParameter);
        }
        boolean isDeclaringMethod = !JSInheritanceUtil.hasSuperMethods(function);
        Condition filter = arg_0 -> JSChangeSignatureProcessor.lambda$checkLocalCollisions$4(isDeclaringMethod, (Set)deletedOrRenamedParameters, arg_0);
        for (JSParameterInfo parameterInfo : newParameters) {
            if (parameterInfo.isDestructuringParameter()) continue;
            int oldParameterIndex = parameterInfo.getOldIndex();
            if (oldParameterIndex != -1) {
                Object parameter = oldParameters[oldParameterIndex];
                if (parameterInfo.getName().equals(parameter.getName())) continue;
                JSChangeSignatureProcessor.reportLocalCollisions(function, parameterInfo.getName(), false, conflicts, (Condition<PsiElement>)filter);
                continue;
            }
            JSChangeSignatureProcessor.reportLocalCollisions(function, parameterInfo.getName(), true, conflicts, (Condition<PsiElement>)filter);
        }
    }

    @Nullable
    public static PsiElement getCollidingElement(JSFunction function, final String name, final Condition<PsiElement> filter) {
        final Ref result = new Ref();
        function.processDeclarations((PsiScopeProcessor)new ResolveProcessor(null){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (!(element instanceof JSVariable)) {
                    return true;
                }
                if (!name.equals(((JSVariable)element).getName())) {
                    return true;
                }
                if (!filter.value((Object)element)) {
                    return true;
                }
                result.set((Object)element);
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureProcessor$3";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, ResolveState.initial(), function.getFirstChild(), (PsiElement)function);
        return (PsiElement)result.get();
    }

    private static void reportLocalCollisions(JSFunction function, String name, boolean newParameter, MultiMap<PsiElement, String> conflicts, Condition<PsiElement> filter) {
        PsiElement element = JSChangeSignatureProcessor.getCollidingElement(function, name, filter);
        if (element != null) {
            String message = RefactoringBundle.message((String)(newParameter ? "there.is.already.a.0.in.1.it.will.conflict.with.the.new.parameter" : "there.is.already.a.0.in.the.1.it.will.conflict.with.the.renamed.parameter"), (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)element, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)function, (boolean)true)});
            conflicts.putValue((Object)function, (Object)StringUtil.capitalize((String)message));
        }
    }

    protected boolean shouldPropagate(PsiElement element) {
        return this.myMethodsToPropagateParameters.contains(PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class));
    }

    @NotNull
    private JSLanguageDialect getLangForProcessing() {
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement((PsiElement)this.myMethod);
        JSLanguageDialect jSLanguageDialect = dialect != null ? dialect : JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        if (jSLanguageDialect == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(26);
        }
        return jSLanguageDialect;
    }

    private static boolean supportsVisibilityModifiers(@NotNull JSLanguageDialect dialect) {
        if (dialect == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(27);
        }
        return dialect.getOptionHolder().isTypeScript || dialect.getOptionHolder().isECMA4;
    }

    private static /* synthetic */ boolean lambda$checkLocalCollisions$4(boolean isDeclaringMethod, Set deletedOrRenamedParameters, PsiElement psiElement) {
        return (isDeclaringMethod || !(psiElement instanceof JSParameter)) && !deletedOrRenamedParameters.contains(psiElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 17: 
            case 18: 
            case 24: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 17: 
            case 18: 
            case 24: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 17: 
            case 18: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importProcessor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 20: 
            case 21: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 22: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedElements";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportProcessor";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCallArguments";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getLangForProcessing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 17: 
            case 18: 
            case 24: 
            case 26: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "rebindTarget";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveInModule";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "refactorCall";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "buildCallArguments";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "ensureArgumentsCount";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createRequiredES6Imports";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processUnresolvedReferences";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "supportsVisibilityModifiers";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createRequiredES6Imports$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 17: 
            case 18: 
            case 24: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ES6CompatibleImportProcessor
    implements RequiredImportProcessor {
        @NotNull
        private final Set<JSElement> myImportedElements;

        public ES6CompatibleImportProcessor(@NotNull Set<JSElement> importedElements) {
            if (importedElements == null) {
                ES6CompatibleImportProcessor.$$$reportNull$$$0(0);
            }
            this.myImportedElements = importedElements;
        }

        @Override
        public void computeImportsForExpression(@Nullable String newlyAddedText, @NotNull PsiElement context) {
            if (context == null) {
                ES6CompatibleImportProcessor.$$$reportNull$$$0(1);
            }
            JSChangeSignatureProcessor.createRequiredES6Imports(newlyAddedText, context, this.myImportedElements);
        }

        @Override
        public void computeImportsForType(@Nullable String newlyAddedType, @NotNull PsiElement context) {
            if (context == null) {
                ES6CompatibleImportProcessor.$$$reportNull$$$0(2);
            }
            this.computeImportsForExpression(newlyAddedType, context);
        }

        @Override
        public void finish() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importedElements";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureProcessor$ES6CompatibleImportProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeImportsForExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeImportsForType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ActionScriptImportProcessor
    implements RequiredImportProcessor {
        private final MultiMap<PsiElement, String> imports = new MultiMap();

        private ActionScriptImportProcessor() {
        }

        @Override
        public void computeImportsForExpression(@Nullable String newlyAddedText, @NotNull PsiElement context) {
            if (context == null) {
                ActionScriptImportProcessor.$$$reportNull$$$0(0);
            }
            this.imports.putValues((Object)context, (Collection)JSChangeSignatureProcessor.computeRequiredActionScriptImports(newlyAddedText, context));
        }

        @Override
        public void computeImportsForType(@Nullable String type, @NotNull PsiElement context) {
            if (context == null) {
                ActionScriptImportProcessor.$$$reportNull$$$0(1);
            }
            String currentPackage = JSResolveUtil.getPackageNameFromPlace(context);
            if (type != null && type.contains(".") && JSPsiImplUtils.differentPackageName(StringUtil.getPackageName((String)type), currentPackage)) {
                this.imports.putValue((Object)context, (Object)type);
            }
        }

        @Override
        public void finish() {
            for (Map.Entry entry : this.imports.entrySet()) {
                FormatFixer formatFixer;
                if (((Collection)entry.getValue()).isEmpty() || (formatFixer = ImportUtils.insertImportStatements((PsiElement)entry.getKey(), (Collection)entry.getValue())) == null) continue;
                formatFixer.fixFormat();
            }
            List toOptimizeImports = this.imports.keySet().stream().map(element -> element.getContainingFile()).distinct().collect(Collectors.toList());
            ArrayList<FormatFixer> formatters = new ArrayList<FormatFixer>();
            for (PsiFile file : toOptimizeImports) {
                formatters.addAll(ECMAScriptImportOptimizer.executeNoFormat(file));
            }
            JSRefactoringUtil.format(formatters);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "context";
            objectArray2[1] = "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureProcessor$ActionScriptImportProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeImportsForExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeImportsForType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface RequiredImportProcessor {
        public static final RequiredImportProcessor EMPTY = new RequiredImportProcessor(){

            @Override
            public void computeImportsForExpression(@Nullable String newlyAddedText, @NotNull PsiElement context) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            @Override
            public void computeImportsForType(@Nullable String newlyAddedType, @NotNull PsiElement context) {
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            @Override
            public void finish() {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "context";
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureProcessor$RequiredImportProcessor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "computeImportsForExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "computeImportsForType";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };

        public void computeImportsForExpression(@Nullable String var1, @NotNull PsiElement var2);

        public void computeImportsForType(@Nullable String var1, @NotNull PsiElement var2);

        public void finish();
    }

    protected static class OtherUsageInfo
    extends UsageInfo {
        @Nullable
        private final SmartPsiElementPointer<JSElement> myRebindTo;
        private final JSParameterInfo[] myParameters;
        private final boolean myPropagate;
        private final int myMinParams;
        private final int myMaxParams;

        public OtherUsageInfo(PsiElement element, @Nullable JSElement rebindTo, JSParameterInfo[] parameters, boolean propagate, int minParams, int maxParams) {
            super(element);
            this.myRebindTo = rebindTo == null ? null : SmartPointerManager.getInstance((Project)this.getProject()).createSmartPsiElementPointer((PsiElement)rebindTo);
            this.myParameters = parameters;
            this.myPropagate = propagate;
            this.myMinParams = minParams;
            this.myMaxParams = maxParams;
        }

        @Nullable
        public JSElement getRebindTo() {
            return this.myRebindTo == null ? null : (JSElement)this.myRebindTo.getElement();
        }

        public JSParameterInfo[] getParameters() {
            return this.myParameters;
        }

        public boolean isPropagate() {
            return this.myPropagate;
        }
    }

    private static class FieldDeclarationUsageInfo
    extends UsageInfo {
        public FieldDeclarationUsageInfo(JSField field) {
            super((PsiElement)field);
        }

        public JSField getElement() {
            return (JSField)super.getElement();
        }
    }

    private static class FunctionExpressionDeclarationUsageInfo
    extends FunctionDeclarationUsageInfoBase {
        public FunctionExpressionDeclarationUsageInfo(PsiElement variableOrAssigment, @Nullable JSParameterInfo[] paramsOverride) {
            super(variableOrAssigment, paramsOverride);
        }

        @Override
        @Nullable
        protected JSFunction getFunction() {
            PsiElement element = this.getElement();
            if (element == null) {
                return null;
            }
            return (JSFunction)PsiTreeUtil.getChildOfType((PsiElement)element, JSFunctionExpression.class);
        }
    }

    protected static class MethodDeclarationUsageInfo
    extends FunctionDeclarationUsageInfoBase {
        public MethodDeclarationUsageInfo(JSFunction function, @Nullable JSParameterInfo[] paramsOverride) {
            super((PsiElement)function, paramsOverride);
        }

        public JSFunction getElement() {
            return (JSFunction)super.getElement();
        }

        @Override
        @Nullable
        protected JSFunction getFunction() {
            return this.getElement();
        }
    }

    static abstract class FunctionDeclarationUsageInfoBase
    extends UsageInfo {
        private final JSParameterInfo[] myParamsOverride;
        private final MultiMap<JSParameter, UsageInfo> myParamsUsages = new MultiMap();

        protected FunctionDeclarationUsageInfoBase(PsiElement element, @Nullable JSParameterInfo[] paramsOverride) {
            super(element);
            this.myParamsOverride = paramsOverride;
        }

        @Nullable
        protected abstract JSFunction getFunction();

        public JSParameterInfo[] getParamsOverride() {
            return this.myParamsOverride;
        }

        public MultiMap<JSParameter, UsageInfo> getParamsUsages() {
            return this.myParamsUsages;
        }

        public void searchForParametersUsages() {
            JSFunction function = this.getFunction();
            if (function == null) {
                return;
            }
            JSParameterList parameterList = function.getParameterList();
            if (parameterList == null) {
                return;
            }
            for (JSParameter parameter : parameterList.getParameterVariables()) {
                for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter, (SearchScope)parameter.getUseScope()).findAll()) {
                    if (JSResolveUtil.isSelfReference((PsiElement)parameter, reference.getElement())) continue;
                    this.myParamsUsages.putValue((Object)parameter, (Object)new UsageInfo(reference));
                }
            }
        }
    }
}

