/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.primitives;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStringType
extends JSPrimitiveType {
    public JSStringType(boolean primitive, JSTypeSource source, JSTypeContext staticOrInstance) {
        super(primitive, source, staticOrInstance);
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSStringType.$$$reportNull$$$0(0);
        }
        if (elementType instanceof JSResolvableType) {
            if ("XML".equals(elementType.getTypeText()) || "XMLList".equals(elementType.getTypeText())) {
                return true;
            }
            JSResolvedTypeInfo resolvedType = ((JSResolvableType)elementType).resolveType();
            if (resolvedType != null && resolvedType.isEnumLiteral()) {
                TypeScriptEnumField field = resolvedType.getDeclarationOfType(TypeScriptEnumField.class);
                if (field == null) {
                    return false;
                }
                EnumConstantValue value = field.getConstantValue();
                return value.getStringValue() != null;
            }
        }
        if (elementType instanceof JSStringType) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        String string = this.isPrimitive() && !this.isEcma() && format != JSType.TypeTextFormat.RESOLVED ? "string" : "String";
        if (string == null) {
            JSStringType.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/primitives/JSStringType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/primitives/JSStringType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

