/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.processors.JSCandidateResultProcessor;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SinkResolveProcessor<T extends ResultSink>
extends ResolveProcessor
implements JSCandidateResultProcessor {
    private final boolean myToStopOnAssignment;
    @NotNull
    private final T myResultSink;
    private PsiElement placeTopParent;
    private String myPackageName;
    private boolean myForcedPackage;
    private boolean encounteredFunctionExpression;
    private boolean encounteredXmlLiteral;

    public SinkResolveProcessor(@NotNull T sink) {
        if (sink == null) {
            SinkResolveProcessor.$$$reportNull$$$0(0);
        }
        this(((ResultSink)sink).getName(), ((ResultSink)sink).place, sink);
    }

    public SinkResolveProcessor(String name, T sink) {
        this(name, null, sink);
    }

    public SinkResolveProcessor(String name, boolean toStopOnAssignment, @NotNull T sink) {
        if (sink == null) {
            SinkResolveProcessor.$$$reportNull$$$0(1);
        }
        this(name, null, toStopOnAssignment, sink);
    }

    public SinkResolveProcessor(String name, PsiElement _place, @NotNull T sink) {
        if (sink == null) {
            SinkResolveProcessor.$$$reportNull$$$0(2);
        }
        this(name, _place, false, sink);
    }

    public SinkResolveProcessor(String name, PsiElement _place, boolean stopOnAssignment, @NotNull T sink) {
        if (sink == null) {
            SinkResolveProcessor.$$$reportNull$$$0(3);
        }
        super(name, _place);
        this.myResultSink = sink;
        this.myToStopOnAssignment = stopOnAssignment;
    }

    public PsiElement getResult() {
        return ((ResultSink)this.myResultSink).getResult();
    }

    @Nullable
    public List<PsiElement> getResults() {
        return ((ResultSink)this.myResultSink).getResults();
    }

    public PsiElement getPlaceTopParent() {
        return this.placeTopParent;
    }

    public void setForcedPackageName(String forcedPackageName) {
        this.myPackageName = forcedPackageName;
        this.myForcedPackage = forcedPackageName != null;
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            SinkResolveProcessor.$$$reportNull$$$0(4);
        }
        if (state == null) {
            SinkResolveProcessor.$$$reportNull$$$0(5);
        }
        if (!((ResultSink)this.myResultSink).accepts(element)) {
            return true;
        }
        if (!this.accessibilityProcessingHandler.accepts(element, this)) {
            return true;
        }
        return this.executeAcceptedElement(element, state);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean executeAcceptedElement(@NotNull PsiElement element, @NotNull ResolveState state) {
        PsiElement ownNameIdentifier;
        block31: {
            block30: {
                if (element == null) {
                    SinkResolveProcessor.$$$reportNull$$$0(6);
                }
                if (state == null) {
                    SinkResolveProcessor.$$$reportNull$$$0(7);
                }
                if (this.place != null && element instanceof JSFunction && !(element instanceof JSFunctionExpression)) {
                    JSFunction function = (JSFunction)element;
                    ReadWriteAccessDetector.Access context = this.doSetterProcessing(this.place);
                    if (context == ReadWriteAccessDetector.Access.Write || this.place instanceof JSFunction && ((JSFunction)this.place).isSetProperty()) {
                        JSClass clazz;
                        if (function.isGetProperty() && (this.myName != null || !(this.place.getParent() instanceof JSExpressionStatement) || (clazz = JSUtils.getMemberContainingClass((PsiElement)function)) == null || clazz.findFunctionByNameAndKind(function.getName(), JSFunction.FunctionKind.SETTER) != null)) {
                            this.addPossibleCandidateResult(element, "javascript.property.is.read.only.message");
                            return true;
                        }
                    } else if (context == ReadWriteAccessDetector.Access.Read && function.isSetProperty() && !(this.place instanceof PsiFile) && !(this.place instanceof JSClass)) {
                        this.addPossibleCandidateResult(element, "javascript.property.is.write.only.message");
                        return true;
                    }
                }
                if (this.place != null && element instanceof JSProperty && !this.checkPropertyAccessType(element)) {
                    return true;
                }
                if (!this.isPlaceConstructorCall()) break block30;
                if (element instanceof JSClass && this.myName != null) {
                    PsiElement constructor = this.getConstructor(element);
                    if (constructor == null) {
                        return true;
                    }
                    if (((ResultSink)this.myResultSink).isActionScript()) {
                        element = constructor;
                    }
                    break block31;
                } else if (JSResolveUtil.isConstructorFunction(element) && this.myName == null) {
                    return true;
                }
                break block31;
            }
            if (this.isElementClassConstructor(element) && !(this.place instanceof JSClass)) {
                return true;
            }
        }
        if (this.nearestVarWeAreIn == element) {
            if (!(this.myResultSink instanceof ResolveResultSink)) return true;
            if (!ActionScriptResolveUtil.isSpecialCallResolveCaseEcmaScript(this.place, this.place != null ? this.place.getParent() : null)) {
                return true;
            }
        }
        if (this.placeTopParent == null && this.place != null) {
            this.placeTopParent = JSResolveUtil.getTopReferenceExpression(this.place);
        }
        if (this.placeTopParent instanceof JSReferenceExpression && JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)this.placeTopParent) && this.place != this.placeTopParent && !JSResolveUtil.isInsideArtificialAttrList((JSReferenceExpression)this.placeTopParent)) {
            if (element instanceof JSVariable) return true;
            if (element instanceof JSFunction) {
                return true;
            }
        }
        boolean checkStopOnMatch = false;
        boolean doStopOnMatch = false;
        if (element instanceof JSFunctionExpression && (ownNameIdentifier = ((JSFunctionExpression)element).getOwnNameIdentifier()) == null) {
            return true;
        }
        if (element instanceof JSDefinitionExpression && !this.isProcessingFromIndices()) {
            boolean toProcess = false;
            JSExpression expression = ((JSDefinitionExpression)element).getExpression();
            if (!(this.accessibilityProcessingHandler.isProcessStatics() || !(expression instanceof JSReferenceExpression) || ((JSReferenceExpression)expression).getQualifier() != null || ((ResultSink)this.myResultSink).isActionScript() || !this.myToStopOnAssignment && JSResolveUtil.isEcmaScript5(element) && DialectDetector.dialectOfElement(element) != DialectOptionHolder.OTHER)) {
                toProcess = true;
            }
            if (!toProcess) {
                return true;
            }
            checkStopOnMatch = true;
            doStopOnMatch = this.myToStopOnAssignment;
        }
        if (SinkResolveProcessor.isField(element) && !this.isToProcessMembers()) {
            return true;
        }
        if (element instanceof PsiNamedElement) {
            element = SinkResolveProcessor.getElement(element);
            if (checkStopOnMatch && !doStopOnMatch) {
                this.addPossibleCandidateResult(element, null);
                return true;
            }
            if (this.myPackageName == null) {
                String string = this.myPackageName = this.place != null ? JSResolveUtil.getPackageNameFromPlace(this.place) : "";
            }
            if (this.myForcedPackage) {
                if (JSResolveUtil.isAccessibleFromPackage(element, this.myPackageName)) return ((ResultSink)this.myResultSink).addResult(element, state, this);
            } else if (JSResolveUtil.isAccessibleFromCurrentPackage(element, this.myPackageName, this.place)) return ((ResultSink)this.myResultSink).addResult(element, state, this);
            this.elementIsNotAccessible(element);
            return true;
        }
        if (element instanceof ES6ImportSpecifier && this.isSpecifierAcceptable((ES6ImportExportSpecifier)((ES6ImportSpecifier)element))) {
            return ((ResultSink)this.myResultSink).addResult(element, state, this);
        }
        if (!(element instanceof ES6ExportDefaultAssignment)) return true;
        return ((ResultSink)this.myResultSink).addResult(element, state, this);
    }

    private static boolean isField(@Nullable PsiElement element) {
        return element instanceof JSField && (!DialectDetector.isActionScript(element) || JSUtils.getMemberContainingClass(element) != null);
    }

    @Nullable
    protected PsiElement getConstructor(@NotNull PsiElement element) {
        JSFunction constructor;
        if (element == null) {
            SinkResolveProcessor.$$$reportNull$$$0(8);
        }
        return (constructor = ((JSClass)element).getConstructor()) == null ? element : constructor;
    }

    private boolean checkPropertyAccessType(@NotNull PsiElement element) {
        if (element == null) {
            SinkResolveProcessor.$$$reportNull$$$0(9);
        }
        JSProperty property = (JSProperty)element;
        ReadWriteAccessDetector.Access access = this.doSetterProcessing(this.place);
        if (access == ReadWriteAccessDetector.Access.Write && property.isGetProperty()) {
            ((ResultSink)this.myResultSink).addCandidateResult(element, true, "javascript.property.is.read.only.message");
            return false;
        }
        if (access == ReadWriteAccessDetector.Access.Read && property.isSetProperty()) {
            ((ResultSink)this.myResultSink).addCandidateResult(element, true, "javascript.property.is.write.only.message");
            return false;
        }
        return true;
    }

    protected boolean isElementClassConstructor(@NotNull PsiElement element) {
        if (element == null) {
            SinkResolveProcessor.$$$reportNull$$$0(10);
        }
        return element instanceof JSFunction && ((JSFunction)element).isConstructor() && JSUtils.getMemberContainingClass(element) != null;
    }

    protected boolean isPlaceConstructorCall() {
        return this.place != null && (SinkResolveProcessor.completeConstructorName(this.place) || this.place instanceof JSSuperExpression);
    }

    protected boolean isSpecifierAcceptable(ES6ImportExportSpecifier specifier) {
        return true;
    }

    public void addPossibleCandidateResult(PsiElement element, String s) {
        ((ResultSink)this.myResultSink).addCandidateResult(element, false, s);
    }

    @Override
    public void executeCandidateResult(PsiElement element, String errorMessage) {
        if (((ResultSink)this.myResultSink).accepts(element)) {
            ((ResultSink)this.myResultSink).addCandidateResult(element, false, errorMessage);
        }
    }

    protected void elementIsNotAccessible(PsiElement element) {
        this.addPossibleCandidateResult(element, "javascript.element.is.not.accessible.message");
    }

    @Override
    protected void startingParent(PsiElement associated) {
        ((ResultSink)this.myResultSink).startingParent(associated, this);
        super.startingParent(associated);
    }

    private ReadWriteAccessDetector.Access doSetterProcessing(PsiElement place) {
        if (this.myName == null && place.getParent() instanceof JSExpressionStatement) {
            return ReadWriteAccessDetector.Access.Write;
        }
        return place != null ? JSReadWriteAccessDetector.ourInstance.getExpressionAccess(place) : ReadWriteAccessDetector.Access.Read;
    }

    private static PsiElement getElement(PsiElement element) {
        if (element instanceof XmlTag) {
            return ((XmlTag)element).getAttribute("name").getValueElement().getChildren()[1];
        }
        return element;
    }

    public ResolveResult[] getResultsAsResolveResults() {
        return ((ResolveResultSink)this.myResultSink).getResultsAsResolveResults();
    }

    public void addResult(@NotNull PsiElement element) {
        if (element == null) {
            SinkResolveProcessor.$$$reportNull$$$0(11);
        }
        ((ResultSink)this.myResultSink).addResult(element, ResolveState.initial(), this);
    }

    @NotNull
    public final T getResultSink() {
        T t = this.myResultSink;
        if (t == null) {
            SinkResolveProcessor.$$$reportNull$$$0(12);
        }
        return t;
    }

    @Override
    public boolean skipTopLevelItems() {
        return ((ResultSink)this.myResultSink).skipTopLevelItems();
    }

    public boolean processingEncounteredAnyTypeAccess() {
        return this.encounteredFunctionExpression || this.encounteredXmlLiteral;
    }

    public boolean isEncounteredXmlLiteral() {
        return this.encounteredXmlLiteral;
    }

    public void setEncounteredXmlLiteral(boolean b) {
        this.encounteredXmlLiteral = b;
    }

    @Override
    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            SinkResolveProcessor.$$$reportNull$$$0(13);
        }
        super.handleEvent(event, associated);
        this.handleActionScriptFunctionExpressionEvents(event, associated);
    }

    protected void handleActionScriptFunctionExpressionEvents(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            SinkResolveProcessor.$$$reportNull$$$0(14);
        }
        if (!((ResultSink)this.getResultSink()).isActionScript()) {
            return;
        }
        if (event == PsiScopeProcessor.Event.SET_DECLARATION_HOLDER) {
            if (associated instanceof JSFunctionExpression && !ActionScriptResolveUtil.isAnonymousEventHandler((JSFunctionExpression)associated)) {
                this.encounteredFunctionExpression = true;
            }
        } else if (event == SCOPE_CHANGE && associated instanceof JSFunction && this.place != null && !(JSResolveUtil.findParent((PsiElement)associated) instanceof JSClass) && PsiTreeUtil.isAncestor((PsiElement)((JSFunction)associated), (PsiElement)this.place, (boolean)true)) {
            this.encounteredFunctionExpression = true;
        }
    }

    @Override
    public boolean needTopLevelClassName(String name) {
        return ((ResultSink)this.myResultSink).needTopLevelClassName(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/SinkResolveProcessor";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/SinkResolveProcessor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultSink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "executeAcceptedElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getConstructor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkPropertyAccessType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isElementClassConstructor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addResult";
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "handleEvent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "handleActionScriptFunctionExpressionEvents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

