/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.actionscript.psi.impl.ActionScriptFunctionImpl;
import com.intellij.lang.actionscript.psi.impl.ActionScriptVariableImpl;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.flex.AnnotationBackedDescriptor;
import com.intellij.lang.javascript.flex.JSResolveHelper;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.index.JSImplicitElementsIndex;
import com.intellij.lang.javascript.index.JSIndexContent;
import com.intellij.lang.javascript.index.JSIndexedRootProvider;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JSPackageIndex;
import com.intellij.lang.javascript.index.JSPackageIndexInfo;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSSymbolNamespace;
import com.intellij.lang.javascript.psi.JSSymbolNamespaceImpl;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6ReferenceList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeofType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSGenericSignature;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSIncludeDirective;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackage;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.JSUseNamespaceDirective;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassProvider;
import com.intellij.lang.javascript.psi.ecmal4.impl.ActionScriptConditionalCompileBlockImpl;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSClassBase;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageStatementImpl;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageWrapper;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSFileImpl;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSCollectMembersToImplementProcessor;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSElementResolveScopeProvider;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSImportedElementResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSOverrideHandler;
import com.intellij.lang.javascript.psi.resolve.JSResolveScopeProvider;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSAttributeListStub;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSNameIndex;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedElementIndex;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSReferenceType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSDirectiveCommentUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.CollectionQuery;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.AdditionalIndexableFileSet;
import com.intellij.util.indexing.AdditionalIndexedRootsScope;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.text.StringTokenizer;
import com.intellij.webcore.libraries.ScriptingLibraryUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSResolveUtil {
    private static final Key<CachedValue<TIntObjectHashMap<Object>>> CACHED_DEFS_KEY = Key.create((String)"JS.CachedDefs");
    private static final UserDataCache<CachedValue<TIntObjectHashMap<Object>>, JSElement, Object> ourCachedDefsCache = new RelevantDefsUserDataCache();
    @NonNls
    public static final String PROTOTYPE_FIELD_NAME = "prototype";
    public static final String CONSTRUCTOR_FIELD_NAME = "constructor";
    public static final String USE_STRICT = "use strict";
    public static final String QUOTED_USE_STRICT = "\"use strict\"";
    public static final String SINGLE_QUOTED_USE_STRICT = "'use strict'";
    public static final String USE_BABEL = "use babel";
    private static final Key<GlobalSearchScope> PROJECT_SCOPE_WITH_PREDEFINED_KEY = Key.create((String)"object.default.scope");
    @NonNls
    public static final String OPTIONS_NAME = "options";
    public static final String VECTOR$OBJECT_TYPE_NAME = "Vector$object";
    public static final String EXCLUDE_CLASS_METADATA = "ExcludeClass";
    public static final String FLASH_UTILS_PROXY = "flash.utils.Proxy";
    public static final String BINDABLE_ATTR_NAME = "Bindable";
    public static final JSIndexedRootProvider JS_INDEXED_ROOT_PROVIDER = (JSIndexedRootProvider)((Object)IndexableSetContributor.EP_NAME.findExtension(JSIndexedRootProvider.class));
    private static final Key<ParameterizedCachedValue<Map<String, String>, JSElement>> ourCachedOpenedNsesKey = Key.create((String)"opened.nses");
    private static final UserDataCache<ParameterizedCachedValue<Map<String, String>, JSElement>, JSElement, Object> ourCachedOpenedNsesCache = new UserDataCache<ParameterizedCachedValue<Map<String, String>, JSElement>, JSElement, Object>(){

        protected ParameterizedCachedValue<Map<String, String>, JSElement> compute(JSElement jsElement, Object p) {
            return CachedValuesManager.getManager((Project)jsElement.getProject()).createParameterizedCachedValue((ParameterizedCachedValueProvider)new ParameterizedCachedValueProvider<Map<String, String>, JSElement>(){

                public CachedValueProvider.Result<Map<String, String>> compute(JSElement context) {
                    class MyProcessor
                    extends StructureResolveProcessor {
                        Map<String, String> openedNses;

                        public MyProcessor() {
                            super((String)null);
                            this.putUserData(LOOKING_FOR_USE_NAMESPACES, true);
                        }

                        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                            String nsValue;
                            if (element == null) {
                                MyProcessor.$$$reportNull$$$0(0);
                            }
                            if (state == null) {
                                MyProcessor.$$$reportNull$$$0(1);
                            }
                            if (element instanceof JSPackageStatement) {
                                return false;
                            }
                            if (!(element instanceof JSUseNamespaceDirective)) {
                                return true;
                            }
                            if (this.openedNses == null) {
                                this.openedNses = new THashMap(1);
                            }
                            if ((nsValue = JSPsiImplUtils.calcNamespaceReference(element)) != null) {
                                this.openedNses.put(nsValue, ((JSUseNamespaceDirective)element).getNamespaceToBeUsed());
                            }
                            return true;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "element";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "state";
                                    break;
                                }
                            }
                            objectArray[1] = "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$5$1$1MyProcessor";
                            objectArray[2] = "execute";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    }
                    MyProcessor processor = new MyProcessor();
                    JSResolveUtil.walkOverStructure((PsiElement)context, processor);
                    return new CachedValueProvider.Result(processor.openedNses, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }
            }, false);
        }
    };
    private static final Class[] PACKAGE_ELEMENTS = new Class[]{TypeScriptModule.class, JSVariable.class, JSNamespaceDeclaration.class, JSPackageStatement.class, JSPackage.class, JSFunction.class, JSClass.class};
    private static final Key<ParameterizedCachedValue<PsiElement[], PsiElement>> CHILDREN_TO_PROCESS_KEY = Key.create((String)"js.children.to.process");
    private static final ParameterizedCachedValueProvider<PsiElement[], PsiElement> CHILDREN_TO_PROCESS_PROVIDER = new ParameterizedCachedValueProvider<PsiElement[], PsiElement>(){

        @Nullable
        public CachedValueProvider.Result<PsiElement[]> compute(PsiElement element) {
            PsiElement[] children = element instanceof JSSwitchStatement ? ((JSSwitchStatement)element).getStatements() : element.getChildren();
            return new CachedValueProvider.Result((Object)children, new Object[]{element});
        }
    };
    public static final UserDataCache<CachedValue<GlobalSearchScope>, Module, Void> ourScopeCache = new UserDataCache<CachedValue<GlobalSearchScope>, Module, Void>("scope.excluding.js.libraries"){

        protected CachedValue<GlobalSearchScope> compute(Module module, Void p) {
            return CachedValuesManager.getManager((Project)module.getProject()).createCachedValue(() -> {
                Project project = module.getProject();
                GlobalSearchScope allLibFiles = ScriptingLibraryUtil.getFilesAndDirectoriesScope((Project)project, (Set)JS_INDEXED_ROOT_PROVIDER.getLibraryFiles(project));
                GlobalSearchScope moduleContentScope = module.getModuleContentWithDependenciesScope();
                GlobalSearchScope moduleWithDependenciesAndLibrariesScope = module.getModuleWithDependenciesAndLibrariesScope(true);
                GlobalSearchScope result = moduleContentScope.uniteWith(moduleWithDependenciesAndLibrariesScope).intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)allLibFiles));
                return new CachedValueProvider.Result((Object)result, new Object[]{ProjectRootManager.getInstance((Project)project)});
            }, false);
        }
    };
    public static final Key<PsiElement> contextKey = Key.create((String)"context.key");

    public static void processInjectedFileForTag(@NotNull XmlTag tag, @NotNull JSInjectedFilesVisitor visitor) {
        InjectedLanguageManager manager;
        if (tag == null) {
            JSResolveUtil.$$$reportNull$$$0(0);
        }
        if (visitor == null) {
            JSResolveUtil.$$$reportNull$$$0(1);
        }
        if ((manager = InjectedLanguageManager.getInstance((Project)tag.getProject())) != null) {
            for (XmlTagChild child : tag.getValue().getChildren()) {
                if (!(child instanceof XmlText)) continue;
                manager.enumerate((PsiElement)child, (PsiLanguageInjectionHost.InjectedPsiVisitor)visitor);
            }
        }
    }

    public static String getExpectedPackageNameFromFile(VirtualFile file, Project project) {
        VirtualFile rootForFile;
        if (file == null) {
            return null;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (file instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)file).getDelegate();
        }
        if ((rootForFile = projectFileIndex.getSourceRootForFile(file)) != null) {
            return VfsUtilCore.getRelativePath((VirtualFile)(file.isDirectory() ? file : file.getParent()), (VirtualFile)rootForFile, (char)'.');
        }
        return null;
    }

    public static void processInterfaceMembers(JSClass clazz, JSCollectMembersToImplementProcessor implementedMethodProcessor) {
        clazz.processDeclarations((PsiScopeProcessor)implementedMethodProcessor, ResolveState.initial(), (PsiElement)clazz, (PsiElement)clazz);
    }

    @Deprecated
    public static String getExpressionType(@Nullable JSExpression expression, @Nullable PsiFile containingFile) {
        if (expression == null) {
            return null;
        }
        if (!DialectDetector.isActionScript((PsiElement)expression)) {
            JSType type = JSResolveUtil.getExpressionJSType(expression);
            return type == null ? null : type.getTypeText(JSType.TypeTextFormat.CODE);
        }
        String type = JSResolveUtil.getQualifiedExpressionType(expression, containingFile);
        return JSResolveUtil.getShortenedType(type, (PsiElement)expression);
    }

    public static String getShortenedType(@Nullable String type, @NotNull PsiElement context) {
        if (context == null) {
            JSResolveUtil.$$$reportNull$$$0(2);
        }
        if (type == null) {
            type = "*";
        } else {
            String shortName = JSResolveUtil.getShortTypeName(type, true);
            String expr = JSImportHandlingUtil.resolveTypeName(shortName, context);
            if (expr != null && !expr.equals(shortName) && !JSResolveUtil.shortReferenceIsAmbiguousOrUnequal(shortName, context, type, true)) {
                type = shortName;
            }
        }
        return type;
    }

    @Deprecated
    @Nullable
    @Contract(value="null, _ -> null")
    public static String getQualifiedExpressionType(@Nullable JSExpression expression, PsiFile containingFile) {
        JSType type = JSResolveUtil.getQualifiedExpressionJSType(expression, containingFile);
        return type == null ? null : JSTypeUtils.getPresentableType(type, true);
    }

    @Deprecated
    @Nullable
    @Contract(value="null, _ -> null")
    public static JSType getQualifiedExpressionJSType(@Nullable JSExpression expression, PsiFile containingFile) {
        if (expression != null) {
            JSType jsType = JSTypeEvaluator.forceEvaluateType((PsiElement)expression, expression, containingFile);
            if (JSTypeUtils.isActionScriptVectorType(jsType)) {
                PsiElement resolve;
                if (expression instanceof JSCallExpression) {
                    expression = ((JSCallExpression)expression).getMethodExpression();
                }
                if (expression instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)expression).resolve()) instanceof JSFunction && !((JSFunction)resolve).isConstructor()) {
                    jsType = JSFunctionImpl.getReturnTypeInContext((JSFunction)resolve, (PsiElement)expression);
                }
            }
            return jsType;
        }
        return null;
    }

    @Nullable
    public static JSType getExpressionJSType(@Nullable JSExpression expression) {
        if (expression == null) {
            return null;
        }
        JSTypeEvaluationResult result = JSTypeEvaluator.getExpressionType(expression);
        return result != null ? result.getType() : null;
    }

    @NotNull
    public static String getShortTypeName(String type, boolean withSignature) {
        int i2;
        String str = type;
        int i = str.indexOf(60);
        String signature = null;
        if (i != -1) {
            int index = str.lastIndexOf(46, i);
            if (index == -1) {
                String string = type;
                if (string == null) {
                    JSResolveUtil.$$$reportNull$$$0(3);
                }
                return string;
            }
            signature = str.substring(index);
            str = str.substring(0, index);
        }
        if ((i2 = str.lastIndexOf(46)) != -1) {
            str = str.substring(i2 + 1);
        }
        String string = str + (withSignature && signature != null ? signature : "");
        if (string == null) {
            JSResolveUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static PsiElement getClassReferenceForXmlFromContext(PsiElement parent) {
        PsiElement context;
        PsiElement psiElement = context = parent != null ? parent.getContext() : null;
        if (context instanceof XmlElement && context.getContainingFile() instanceof XmlFile) {
            return XmlBackedJSClassImpl.getContainingComponent((XmlElement)context);
        }
        return parent;
    }

    @Nullable
    public static XmlBackedJSClass getXmlBackedClass(@NotNull JSFile injectedJsFile) {
        PsiElement context;
        if (injectedJsFile == null) {
            JSResolveUtil.$$$reportNull$$$0(5);
        }
        if ((context = injectedJsFile.getContext()) instanceof XmlAttributeValue || context instanceof XmlText) {
            return XmlBackedJSClassImpl.getContainingComponent((XmlElement)context);
        }
        return null;
    }

    public static <T extends JSStubElementImpl> SearchScope findUseScope(T element) {
        PsiElement scope;
        if (!(element instanceof JSAttributeListOwner)) {
            return element.getDefaultUseScope();
        }
        PsiElement scopeElement = scope = PsiTreeUtil.getContextOfType(element, (Class[])new Class[]{JSCatchBlock.class, JSClass.class, JSObjectLiteralExpression.class, JSExecutionScope.class});
        PsiFile file = element.getContainingFile().getOriginalFile();
        if (scope instanceof JSFile) {
            PsiElement xmlFromContext = JSResolveUtil.getClassReferenceForXmlFromContext(scope);
            if (xmlFromContext != scope) {
                scope = xmlFromContext;
                scopeElement = scope.getContainingFile();
            } else if (!((JSFile)scope).getModuleStatus().isStrictlyModule() || ES6ImportHandler.isExportedWithNameOrDefault(element)) {
                scope = null;
            }
        } else if (scope instanceof TypeScriptModule && ES6ImportHandler.isExportedWithNameOrDefault(element)) {
            scope = null;
        }
        if (scope != null) {
            JSAttributeList attributeList;
            if (scope instanceof JSClass && ((attributeList = ((JSAttributeListOwner)element).getAttributeList()) == null || attributeList.getAccessType() != JSAttributeList.AccessType.PRIVATE)) {
                return element.getDefaultUseScope();
            }
            if (scope instanceof JSEmbeddedContent) {
                return new LocalSearchScope((PsiElement)scopeElement.getContainingFile());
            }
            return new LocalSearchScope(scopeElement);
        }
        if (ActionScriptResolveUtil.isFileLocalSymbol(element)) {
            return GlobalSearchScope.fileScope((PsiFile)file);
        }
        return element.getDefaultUseScope();
    }

    public static boolean isResolveStrict(@NotNull JSReferenceExpression expression) {
        if (expression == null) {
            JSResolveUtil.$$$reportNull$$$0(6);
        }
        if (DialectDetector.isTypeScript((PsiElement)expression)) {
            return TypeScriptUtil.resolveIsStrict(expression);
        }
        return true;
    }

    @Nullable
    public static PsiElement findType(String type, @Nullable PsiElement context, boolean ecma) {
        if (type == null || context == null) {
            return null;
        }
        PsiElement typeClass = null;
        if (ecma) {
            if (context.getParent() instanceof JSNewExpression) {
                context = context.getParent();
            }
            SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(type, context, new ResolveResultSink(context, type));
            processor.setLocalResolve(true);
            processor.setTypeContext(true);
            processor.setToProcessHierarchy(false);
            processor.setToProcessMembers(false);
            JSResolveUtil.treeWalkUp(processor, (PsiElement)context.getContainingFile(), null, context);
            typeClass = processor.getResult();
        }
        if (typeClass == null) {
            typeClass = JSDialectSpecificHandlersFactory.forElement(context).getClassResolver().findClassByQName(type, context);
        }
        return typeClass;
    }

    @Deprecated
    public static boolean isAssignableType(@NonNls String expectedType, @NonNls String type, @Nullable PsiElement context) {
        if (context == null) {
            return JSResolveUtil.isAssignableTypeStatus(expectedType, type, null) != AssignableTypeStatus.COMPILE_TIME_FAIL;
        }
        JSTypeSource source = JSTypeSourceFactory.createTypeSource(context, true);
        JSType lOpType = JSTypeUtils.createType(expectedType, source);
        JSType rOpType = JSTypeUtils.createType(type, source);
        return JSResolveUtil.isAssignableJSType(lOpType, rOpType);
    }

    public static boolean isAssignableJSType(@Nullable JSType lOpType, JSType rOpType) {
        return JSResolveUtil.isAssignableJSType(lOpType, rOpType, null);
    }

    public static boolean isAssignableJSType(@Nullable JSType lOpType, JSType rOpType, @Nullable ProcessingContext context) {
        return lOpType == null || lOpType.isDirectlyAssignableType(rOpType, context);
    }

    public static boolean isEcmaScript5(@Nullable PsiElement decl) {
        JSExecutionScope scope = (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)decl, JSExecutionScope.class);
        SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(USE_STRICT, new ResolveResultSink(null, USE_STRICT));
        while (scope != null) {
            if (JSResolveUtil.hasUseStrictPragma(scope, processor)) {
                return true;
            }
            scope = (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)scope, JSExecutionScope.class);
        }
        return false;
    }

    public static boolean hasUseStrictPragma(@Nullable JSExecutionScope scope) {
        return JSResolveUtil.hasUseStrictPragma(scope, new SinkResolveProcessor<ResolveResultSink>(USE_STRICT, new ResolveResultSink(null, USE_STRICT)));
    }

    private static boolean hasUseStrictPragma(@Nullable JSExecutionScope scope, @NotNull SinkResolveProcessor<?> processor) {
        if (processor == null) {
            JSResolveUtil.$$$reportNull$$$0(7);
        }
        JSResolveUtil.processDeclarationsInScope((JSElement)scope, processor, ResolveState.initial(), null, (PsiElement)scope);
        return processor.getResult() != null;
    }

    public static Collection<VirtualFile> sortFiles(Collection<VirtualFile> virtualFiles) {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(virtualFiles);
        Collections.sort(files, (o1, o2) -> (int)(o1.getLength() - o2.getLength()));
        return files;
    }

    public static boolean calculateStaticFromContext(@Nullable PsiElement psiElement) {
        JSAttributeList attributeList;
        PsiElement grandParent;
        JSAttributeListOwner attributeListOwner = (JSAttributeListOwner)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{JSAttributeListOwner.class});
        while (attributeListOwner instanceof JSFunction && JSPsiImplUtils.isArrowFunction((JSFunction)attributeListOwner)) {
            attributeListOwner = (JSAttributeListOwner)PsiTreeUtil.getParentOfType((PsiElement)attributeListOwner, JSAttributeListOwner.class);
        }
        if ((attributeListOwner instanceof JSVariable || attributeListOwner instanceof JSVarStatement) && !((grandParent = JSResolveUtil.findParent((PsiElement)attributeListOwner)) instanceof JSFile) && !(grandParent instanceof JSClass)) {
            attributeListOwner = (JSAttributeListOwner)PsiTreeUtil.getNonStrictParentOfType((PsiElement)grandParent, (Class[])new Class[]{JSAttributeListOwner.class});
        }
        return attributeListOwner != null && (attributeList = attributeListOwner.getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.STATIC);
    }

    public static boolean shortReferenceIsAmbiguousOrUnequal(@NotNull String shortName, PsiElement context, String expectedFqn, Boolean forceInTypeContext) {
        ResolveResult[] results;
        if (shortName == null) {
            JSResolveUtil.$$$reportNull$$$0(8);
        }
        if ((results = JSReferenceExpressionImpl.resolveUnqualified(shortName, context, forceInTypeContext)).length > 1) {
            return true;
        }
        if (results.length == 0) {
            return false;
        }
        PsiElement element = results[0].getElement();
        if (context.getParent() instanceof JSNewExpression && element instanceof JSFunction && element.getParent() instanceof JSClass) {
            element = element.getParent();
        }
        return element instanceof JSQualifiedNamedElement && !expectedFqn.equals(((JSQualifiedNamedElement)element).getQualifiedName());
    }

    @NotNull
    public static Query<JSPsiElementBase> findOverridingFunctionsByNamespaces(JSPsiElementBase elt) {
        String qName = JSResolveUtil.getQNameToStartHierarchySearch(elt);
        if (qName != null) {
            ArrayList result = new ArrayList();
            THashMap results = new THashMap();
            MyNamespaceProcessor namespaceProcessor = new MyNamespaceProcessor((Set)new THashSet(Collections.singletonList(elt)), true, (Map)results, result){
                final /* synthetic */ Map val$results;
                final /* synthetic */ ArrayList val$result;
                {
                    this.val$results = map;
                    this.val$result = arrayList;
                    super(functions, findAll);
                }

                @Override
                protected boolean doProcess(PsiElement elt) {
                    if (elt instanceof JSProperty) {
                        elt = ((JSProperty)elt).getValue();
                    }
                    if (!(elt instanceof JSPsiElementBase)) {
                        return true;
                    }
                    String qName = JSResolveUtil.getQNameToStartHierarchySearch((JSPsiElementBase)elt);
                    if (qName != null) {
                        ArrayList<JSPsiElementBase> list = (ArrayList<JSPsiElementBase>)this.val$results.get(qName);
                        if (list == null) {
                            list = new ArrayList<JSPsiElementBase>(2);
                            this.val$results.put(qName, list);
                        }
                        list.add((JSPsiElementBase)elt);
                    } else {
                        this.val$result.add((JSPsiElementBase)elt);
                    }
                    return true;
                }
            };
            namespaceProcessor.processDescendantsOf(qName, (PsiElement)elt);
            for (List funs : results.values()) {
                result.addAll(funs);
            }
            CollectionQuery collectionQuery = new CollectionQuery(result);
            if (collectionQuery == null) {
                JSResolveUtil.$$$reportNull$$$0(9);
            }
            return collectionQuery;
        }
        CollectionQuery collectionQuery = new CollectionQuery(Collections.emptyList());
        if (collectionQuery == null) {
            JSResolveUtil.$$$reportNull$$$0(10);
        }
        return collectionQuery;
    }

    public static boolean isFromPredefinedFile(@Nullable PsiFile containingFile) {
        if (containingFile == null) {
            return false;
        }
        return JSResolveUtil.isFromPredefinedFile(containingFile.getProject(), containingFile.getOriginalFile().getVirtualFile());
    }

    public static boolean isFromPredefinedFile(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            JSResolveUtil.$$$reportNull$$$0(11);
        }
        return JSLibraryManager.getInstance(project).isPredefinedLibraryFile(file);
    }

    @Deprecated
    public static AssignableTypeStatus isAssignableTypeStatus(@NonNls String _expectedType, @NonNls String _type, @Nullable PsiElement context) {
        boolean nonecma;
        final String expectedType = JSDocumentationUtils.doCapitalizeCommentTypeIfNeeded(JSDocumentationUtils.stripTypeDecorations(_expectedType));
        String type = JSDocumentationUtils.doCapitalizeCommentTypeIfNeeded(JSDocumentationUtils.stripTypeDecorations(_type));
        if (expectedType != null && JSResolveUtil.hasMultipleOccurenceDelimiters(expectedType) || type != null && JSResolveUtil.hasMultipleOccurenceDelimiters(type)) {
            StringTokenizer expectedTypeIterator = new StringTokenizer(expectedType != null ? expectedType : "", "|/");
            while (expectedTypeIterator.hasMoreElements()) {
                String primitiveExpectedType = expectedTypeIterator.nextToken().trim();
                StringTokenizer typeIterator = new StringTokenizer(type != null ? type : "", "|/");
                while (typeIterator.hasMoreElements()) {
                    String primitiveType = typeIterator.nextToken().trim();
                    AssignableTypeStatus state = JSResolveUtil.isAssignableTypeStatus(primitiveExpectedType, primitiveType, context);
                    if (state == AssignableTypeStatus.COMPILE_TIME_FAIL) continue;
                    return state;
                }
            }
            return AssignableTypeStatus.COMPILE_TIME_FAIL;
        }
        if (expectedType == null || expectedType.equals("*") || expectedType.equals("Object")) {
            return AssignableTypeStatus.OK;
        }
        if (expectedType.equals(type)) {
            return AssignableTypeStatus.OK;
        }
        boolean bl = nonecma = context != null && context.getContainingFile().getLanguage() != JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        if (nonecma && "Function".equals(type) && expectedType.startsWith("function")) {
            return AssignableTypeStatus.OK;
        }
        GenericSignature signature = JSResolveUtil.extractGenericSignature(type);
        GenericSignature expectedSignature = JSResolveUtil.extractGenericSignature(expectedType);
        if (expectedSignature != null && signature != null) {
            return JSResolveUtil.isAssignableTypeStatus(expectedSignature.elementType, signature.elementType, context) == AssignableTypeStatus.OK && expectedSignature.genericType.equals(signature.genericType) ? AssignableTypeStatus.OK : AssignableTypeStatus.COMPILE_TIME_FAIL;
        }
        if (expectedSignature != null) {
            if (nonecma && expectedSignature.elementType.equals(type)) {
                return AssignableTypeStatus.OK;
            }
            return "*".equals(type) ? AssignableTypeStatus.OK : AssignableTypeStatus.COMPILE_TIME_FAIL;
        }
        if (signature != null) {
            return JSResolveUtil.isAssignableTypeStatus(expectedType, signature.elementType, context);
        }
        if ("Number".equals(expectedType) && ("int".equals(type) || "uint".equals(type))) {
            return AssignableTypeStatus.OK;
        }
        if ("int".equals(expectedType) && ("Number".equals(type) || "uint".equals(type))) {
            return AssignableTypeStatus.OK;
        }
        if ("uint".equals(expectedType) && ("int".equals(type) || "Number".equals(type))) {
            return AssignableTypeStatus.OK;
        }
        if ("Array".equals(type) && ("IArguments".equals(expectedType) || expectedType.startsWith("Array") || JSTypeEvaluateManager.isArrayType(expectedType))) {
            return AssignableTypeStatus.OK;
        }
        if ("Array".equals(expectedType) && JSTypeEvaluateManager.isArrayType(type)) {
            return AssignableTypeStatus.OK;
        }
        if ("String".equalsIgnoreCase(expectedType) && (nonecma ? "Number".equalsIgnoreCase(type) || "int".equals(type) || "Boolean".equalsIgnoreCase(type) : "XML".equals(type) || "XMLList".equals(type))) {
            return AssignableTypeStatus.OK;
        }
        if ("void".equals(type)) {
            return AssignableTypeStatus.COMPILE_TIME_FAIL;
        }
        if ("Boolean".equalsIgnoreCase(expectedType)) {
            return AssignableTypeStatus.LANG_IMPLICIT_COERCION;
        }
        if (("XML".equals(expectedType) || "XMLList".equals(expectedType)) && "Object".equals(type)) {
            return AssignableTypeStatus.OK;
        }
        if ("*".equals(type)) {
            return AssignableTypeStatus.OK;
        }
        PsiElement typeClass = JSResolveUtil.findType(type, context, !nonecma);
        if (!(typeClass instanceof JSClass)) {
            if (nonecma) {
                boolean result = JSTypeEvaluateManager.iterateTypeHierarchy(context, type, new JSTypeEvaluateManager.NamespaceProcessor(){
                    final Set<String> visited = new THashSet();

                    @Override
                    public boolean process(String serializedType, VirtualFile file) {
                        String qName = JSTypeUtils.getTypeMatchingNamespace(serializedType);
                        if (!this.visited.contains(qName)) {
                            this.visited.add(qName);
                            return !expectedType.equals(qName);
                        }
                        return true;
                    }
                });
                if (!result) {
                    return AssignableTypeStatus.OK;
                }
                return JSResolveUtil.checkTypedef(context, expectedType, type);
            }
            return AssignableTypeStatus.COMPILE_TIME_FAIL;
        }
        boolean result = JSResolveUtil.processHierarchy((JSClass)typeClass, (Processor<JSClass>)((Processor)jsClass -> !jsClass.getQualifiedName().equals(expectedType)), true);
        if (!result) {
            return AssignableTypeStatus.OK;
        }
        return JSResolveUtil.checkTypedef(context, expectedType, type);
    }

    private static AssignableTypeStatus checkTypedef(PsiElement context, String expectedType, String type) {
        JSType typedefType = JSTypeEvaluateManager.expandTypedefs(context, expectedType);
        return typedefType == null ? AssignableTypeStatus.COMPILE_TIME_FAIL : JSResolveUtil.isAssignableTypeStatus(typedefType.getTypeText(), type, context);
    }

    public static boolean hasMultipleOccurenceDelimiters(String expectedType) {
        String commentDelimiters = "|/";
        for (int i = 0; i < "|/".length(); ++i) {
            if (expectedType.indexOf("|/".charAt(i)) == -1) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static GlobalSearchScope getResolveScope(@NotNull PsiElement element) {
        GlobalSearchScope defaultResolveScope;
        if (element == null) {
            JSResolveUtil.$$$reportNull$$$0(12);
        }
        for (JSElementResolveScopeProvider provider : (JSElementResolveScopeProvider[])JSElementResolveScopeProvider.EP_NAME.getExtensions()) {
            GlobalSearchScope scope = provider.getElementResolveScope(element);
            if (scope == null) continue;
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                JSResolveUtil.$$$reportNull$$$0(13);
            }
            return globalSearchScope;
        }
        VirtualFile file = JSResolveScopeProvider.getFileForScopeEvaluation(element);
        Project project = element.getProject();
        if (file != null && (defaultResolveScope = ResolveScopeManager.getInstance((Project)project).getDefaultResolveScope(file)) != null) {
            GlobalSearchScope globalSearchScope = defaultResolveScope;
            if (globalSearchScope == null) {
                JSResolveUtil.$$$reportNull$$$0(14);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = JSResolveUtil.getJavaScriptSymbolsResolveScope(project);
        if (globalSearchScope == null) {
            JSResolveUtil.$$$reportNull$$$0(15);
        }
        return globalSearchScope;
    }

    @Nullable
    public static PsiElement getContext(@NotNull PsiElement element) {
        PsiElement result;
        if (element == null) {
            JSResolveUtil.$$$reportNull$$$0(16);
        }
        if ((result = (PsiElement)element.getUserData(contextKey)) != null && !result.isValid()) {
            result = null;
        }
        return result;
    }

    public static boolean isObjectClass(@NotNull JSClass aClass) {
        if (aClass == null) {
            JSResolveUtil.$$$reportNull$$$0(17);
        }
        return "Object".equals(aClass.getQualifiedName());
    }

    public static boolean processHierarchy(String qName, PsiFile containingFile, Processor<JSClass> processor, boolean visitInterfaces) {
        PsiElement clazz = JSDialectSpecificHandlersFactory.forElement((PsiElement)containingFile).getClassResolver().findClassByQName(qName, (PsiElement)containingFile);
        if (clazz instanceof JSClass) {
            return JSResolveUtil.processHierarchy((JSClass)clazz, processor, visitInterfaces);
        }
        return true;
    }

    public static boolean processHierarchy(@NotNull JSClass clazz, Processor<JSClass> processor, boolean visitInterfaces) {
        if (clazz == null) {
            JSResolveUtil.$$$reportNull$$$0(18);
        }
        return clazz.processDeclarations((PsiScopeProcessor)new VisitAllTypesProcessor(processor, visitInterfaces), ResolveState.initial(), (PsiElement)clazz, (PsiElement)clazz);
    }

    public static void stableResolveOrder(@NotNull ResolveResult[] results) {
        if (results == null) {
            JSResolveUtil.$$$reportNull$$$0(19);
        }
        Arrays.sort(results, (o1, o2) -> {
            PsiElement elt = o1.getElement();
            PsiElement elt2 = o2.getElement();
            if (elt != null && elt2 != null && elt.getContainingFile() == elt2.getContainingFile()) {
                return elt.getTextOffset() - elt2.getTextOffset();
            }
            return 0;
        });
    }

    public static JSNamedElement findFileLocalElement(@NotNull String str, PsiElement context) {
        if (str == null) {
            JSResolveUtil.$$$reportNull$$$0(20);
        }
        SinkResolveProcessor processor = new SinkResolveProcessor(str, new ResolveResultSink(null, str)){
            {
                this.setTypeContext(true);
                this.setToProcessMembers(false);
            }
        };
        boolean b = context.getContainingFile().processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), null, context);
        return (JSNamedElement)processor.getResult();
    }

    @Nullable
    public static String getQualifiedTypeName(@Nullable String _typeName) {
        if (_typeName != null) {
            String typeName;
            GenericSignature signature = JSResolveUtil.extractGenericSignature(_typeName);
            String string = typeName = signature != null ? signature.elementType : _typeName;
            if (VECTOR$OBJECT_TYPE_NAME.equals(typeName)) {
                typeName = "Vector";
            }
            return GenericSignature.build(typeName, signature);
        }
        return null;
    }

    public static boolean isAccessibleFromPackage(@Nullable PsiElement element, @NotNull String forcedPackageName) {
        JSAttributeList attributeList;
        if (forcedPackageName == null) {
            JSResolveUtil.$$$reportNull$$$0(21);
        }
        if (element instanceof TypeScriptCallSignature) {
            element = JSResolveUtil.findParent(element);
        }
        if (element instanceof JSAttributeListOwner && (attributeList = ((JSAttributeListOwner)element).getAttributeList()) != null) {
            JSAttributeList.AccessType accessType = attributeList.getAccessType();
            if (accessType == JSAttributeList.AccessType.PRIVATE && element instanceof JSClass) {
                return false;
            }
            if (!(accessType != JSAttributeList.AccessType.PACKAGE_LOCAL || attributeList.getNamespace() != null || element instanceof JSFunction && ((JSFunction)element).isConstructor() || JSResolveUtil.isQualifiedAS2Symbol(element))) {
                PsiElement parent = JSResolveUtil.findParent(element);
                if (parent instanceof JSClass ? ((JSClass)parent).isInterface() : !(parent instanceof JSFile) && !(parent instanceof JSPackageStatement) && !(parent instanceof TypeScriptModule)) {
                    return true;
                }
                String packageName2 = JSResolveUtil.getPackageName(element);
                if (!forcedPackageName.equals(packageName2)) {
                    return false;
                }
                if (forcedPackageName.isEmpty() && element instanceof JSClass && ActionScriptResolveUtil.isFileLocalSymbol(element)) {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isSelfReference(PsiElement element) {
        return JSResolveUtil.isSelfReference(element.getParent(), element);
    }

    @Nullable
    public static GenericSignature extractGenericSignature(String type) {
        if (type == null) {
            return null;
        }
        int ltPos = type.indexOf(60);
        if (ltPos > 0 && type.charAt(ltPos - 1) == '.') {
            int gtPos = type.lastIndexOf(62);
            String genericType = type.substring(ltPos + 1, gtPos != -1 ? gtPos : type.length()).trim();
            type = type.substring(0, ltPos - 1).trim();
            return new GenericSignature(type, genericType);
        }
        return null;
    }

    public static PsiElement getTopReferenceParent(PsiElement parent) {
        PsiElement currentParent = parent;
        while (currentParent instanceof JSReferenceExpression) {
            currentParent = currentParent.getParent();
        }
        return currentParent;
    }

    public static PsiElement getTopReferenceExpression(@NotNull PsiElement parent) {
        if (parent == null) {
            JSResolveUtil.$$$reportNull$$$0(22);
        }
        PsiElement element = parent;
        PsiElement currentParent = parent.getParent();
        while (currentParent instanceof JSReferenceExpression) {
            element = currentParent;
            currentParent = currentParent.getParent();
        }
        return element;
    }

    public static boolean isSelfReference(PsiElement currentParent, PsiElement elt) {
        return currentParent instanceof JSPackageStatement || currentParent instanceof JSNamespaceDeclaration && ((JSNamespaceDeclaration)currentParent).getNameIdentifier() == elt || currentParent instanceof JSVariable && ((JSVariable)currentParent).getNameIdentifier() == elt || currentParent instanceof JSFunction && JSPsiImplUtils.isFunctionNameReference((JSFunction)currentParent, elt) || currentParent instanceof JSClass;
    }

    public static boolean isSameReference(@NotNull JSReferenceExpression ref, @NotNull PsiElement resolve) {
        if (ref == null) {
            JSResolveUtil.$$$reportNull$$$0(23);
        }
        if (resolve == null) {
            JSResolveUtil.$$$reportNull$$$0(24);
        }
        if (ref.getContainingFile() != resolve.getContainingFile()) {
            return false;
        }
        JSExpression resolveRef = resolve instanceof JSDefinitionExpression ? ((JSDefinitionExpression)resolve).getExpression() : (resolve instanceof JSNamedElement ? ((JSNamedElement)resolve).getNameIdentifier() : resolve);
        return ref == resolveRef;
    }

    @Nullable
    public static PsiElement findParent(@NotNull PsiElement element) {
        if (element == null) {
            JSResolveUtil.$$$reportNull$$$0(25);
        }
        PsiElement parent = element.getContext();
        if (element instanceof JSVariable && (parent = JSDestructuringUtil.getParentSkippingDestructuring((JSElement)((JSVariable)element))) != null) {
            parent = parent.getContext();
        }
        if (parent instanceof TypeScriptObjectType && parent.getContext() instanceof TypeScriptInterface) {
            parent = parent.getContext();
        }
        if (parent instanceof JSBlockStatement) {
            XmlBackedJSClass xmlBackedClass;
            PsiElement grandParent = parent.getParent();
            if (parent instanceof ActionScriptConditionalCompileBlockImpl) {
                parent = grandParent;
            } else if (grandParent instanceof JSClass) {
                parent = grandParent;
            } else if (grandParent instanceof JSFile && (xmlBackedClass = JSResolveUtil.getXmlBackedClass((JSFile)grandParent)) != null) {
                return xmlBackedClass;
            }
        }
        return parent instanceof JSFile ? JSResolveUtil.findParentClass((JSFile)parent) : parent;
    }

    public static PsiElement findParentClass(@NotNull JSFile file) {
        PsiFile containingFile;
        XmlBackedJSClass xmlBackedClass;
        if (file == null) {
            JSResolveUtil.$$$reportNull$$$0(26);
        }
        if ((xmlBackedClass = JSResolveUtil.getXmlBackedClass(file)) != null) {
            return xmlBackedClass;
        }
        PsiElement forcedContext = JSResolveUtil.getContext((PsiElement)file);
        if (forcedContext instanceof JSClass) {
            return forcedContext;
        }
        if (forcedContext instanceof JSFile) {
            return JSResolveUtil.findParentClass((JSFile)forcedContext);
        }
        if (forcedContext instanceof PsiFile && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)forcedContext)) {
            return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)forcedContext);
        }
        if (forcedContext instanceof XmlElement && JavaScriptSupportLoader.isFlexMxmFile(containingFile = forcedContext.getContainingFile())) {
            return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)containingFile);
        }
        if (forcedContext != null) {
            JSClass jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)forcedContext, JSClass.class);
            if (jsClass != null) {
                return jsClass;
            }
            PsiFile containingFile2 = forcedContext.getContainingFile();
            if (containingFile2 instanceof JSFile && containingFile2 != file) {
                return JSResolveUtil.findParentClass((JSFile)containingFile2);
            }
        }
        return file;
    }

    @Contract(value="null -> null")
    public static JSClass getClassOfContext(@Nullable PsiElement node) {
        return JSResolveUtil.getClassOfContext(node, false);
    }

    @Nullable
    public static JSClass getClassOfContext(@Nullable PsiElement node, boolean strict) {
        JSFunction fun;
        if (node == null) {
            return null;
        }
        if (strict && (fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class)) != null && !JSPsiImplUtils.isArrowFunction(fun)) {
            PsiElement parent = JSResolveUtil.findParent((PsiElement)fun);
            return parent instanceof JSClass ? (JSClass)parent : null;
        }
        JSClass jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)node, JSClass.class);
        if (jsClass != null) {
            return jsClass;
        }
        PsiElement context = JSResolveUtil.getClassReferenceForXmlFromContext((PsiElement)node.getContainingFile());
        if (context instanceof JSClass) {
            return (JSClass)context;
        }
        return null;
    }

    @Nullable
    public static JSClass findClassOfQualifier(JSExpression qualifier, PsiFile containingFile) {
        PsiElement qName;
        String s = JSResolveUtil.getQualifiedExpressionType(qualifier, containingFile);
        PsiElement psiElement = qName = s != null ? JSClassResolver.findClassFromNamespace(s, (PsiElement)containingFile) : null;
        if (qName instanceof JSClass) {
            return (JSClass)qName;
        }
        return null;
    }

    @Nullable
    public static Pair<? extends PsiElement, String> getElementThatShouldBeQualified(PsiElement element, String fqn) {
        PsiElement parent;
        JSReferenceExpression reference = (JSReferenceExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{JSReferenceExpression.class});
        if (reference != null && ((parent = reference.getParent()) instanceof JSImportStatement || parent instanceof JSReferenceListMember && reference.getContainingFile().getContext() != null)) {
            return Pair.create((Object)reference, (Object)fqn);
        }
        if (element.getContainingFile() instanceof JSExpressionCodeFragment) {
            return Pair.create((Object)reference, (Object)fqn);
        }
        return null;
    }

    public static boolean isArtificialClassUsedForReferenceList(JSClass clazz) {
        return clazz.getContainingFile().getContext() != null;
    }

    public static Collection<JSQualifiedNamedElement> findElementsByName(String name, Project project, GlobalSearchScope scope) {
        return JSResolveUtil.findElementsByName(name, project, scope, true);
    }

    public static Collection<JSQualifiedNamedElement> findElementsByName(String name, Project project, GlobalSearchScope scope, boolean resultAsNavigatonElements) {
        HashSet<JSQualifiedNamedElement> result = new HashSet<JSQualifiedNamedElement>();
        Collection jsQualifiedNamedElements = StubIndex.getElements(JSNameIndex.KEY, (Object)name, (Project)project, (GlobalSearchScope)scope, JSQualifiedNamedElement.class);
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (JSQualifiedNamedElement e : jsQualifiedNamedElements) {
            VirtualFile fileOrDir = e.getContainingFile().getVirtualFile();
            if (!projectFileIndex.isInLibrarySource(fileOrDir) ? !projectFileIndex.isInSource(fileOrDir) && !projectFileIndex.isInLibraryClasses(fileOrDir) && e.getContainingFile().getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4 : ApplicationManager.getApplication().isUnitTestMode() && !projectFileIndex.isInLibraryClasses(fileOrDir)) continue;
            if (resultAsNavigatonElements) {
                PsiElement navElement = e.getNavigationElement();
                if (navElement instanceof JSQualifiedNamedElement) {
                    result.add((JSQualifiedNamedElement)navElement);
                    continue;
                }
                result.add(e);
                continue;
            }
            result.add(e);
        }
        ArrayList files = new ArrayList(FilenameIndex.getVirtualFilesByName((Project)project, (String)(name + ".mxml"), (GlobalSearchScope)scope));
        for (VirtualFile file : files) {
            PsiFile psiFile;
            if (!file.isValid() || !projectFileIndex.isInSource(file) || !((psiFile = PsiManager.getInstance((Project)project).findFile(file)) instanceof XmlFile)) continue;
            result.add((JSQualifiedNamedElement)XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)psiFile));
        }
        return result;
    }

    @Nullable
    public static JSType getTypeFromSetAccessor(JSFunctionItem fun) {
        JSParameterItem parameter = JSResolveUtil.getParameterFromSetAccessor(fun);
        return parameter != null ? parameter.getType() : null;
    }

    @Nullable
    public static JSParameterItem getParameterFromSetAccessor(@NotNull JSFunctionItem fun) {
        if (fun == null) {
            JSResolveUtil.$$$reportNull$$$0(27);
        }
        if (!fun.isSetProperty()) {
            return null;
        }
        JSParameterItem[] jsParameters = fun.getParameters();
        if (jsParameters.length != 1) {
            return null;
        }
        return jsParameters[0];
    }

    public static boolean processTopPackages(final ResolveProcessor processor, final ResolveState state, final Project project, final GlobalSearchScope scope) {
        if (processor.skipTopLevelItems()) {
            return true;
        }
        return JSPackageIndex.processElementsInScope("", processor.getName(), new JSPackageIndex.PackageElementsProcessor(){

            @Override
            public boolean process(VirtualFile file, String name, JSPackageIndexInfo.Kind kind, boolean isPublic) {
                if (kind != JSPackageIndexInfo.Kind.PACKAGE) {
                    return true;
                }
                return processor.execute((PsiElement)new JSPackageWrapper(name, project, scope), state);
            }
        }, scope, project);
    }

    public static boolean shouldProcessTopLevelGlobalContext(@NotNull PsiElement place, @NotNull PsiScopeProcessor processor) {
        PsiElement placeParent;
        if (place == null) {
            JSResolveUtil.$$$reportNull$$$0(28);
        }
        if (processor == null) {
            JSResolveUtil.$$$reportNull$$$0(29);
        }
        return JSResolveUtil.shouldProcessImports(place, processor) && (!((placeParent = place.getParent()) instanceof JSCallExpression) || place instanceof JSReferenceExpression && ((JSReferenceExpression)place).getQualifier() != null && ((ResolveProcessor)processor).needsAllVariants() || placeParent instanceof JSNewExpression);
    }

    public static boolean shouldProcessImports(@NotNull PsiElement place, @NotNull PsiScopeProcessor processor) {
        if (place == null) {
            JSResolveUtil.$$$reportNull$$$0(30);
        }
        if (processor == null) {
            JSResolveUtil.$$$reportNull$$$0(31);
        }
        if (!(processor instanceof ResolveProcessor) || ((ResolveProcessor)processor).isLocalResolve()) {
            return false;
        }
        return !(place instanceof JSReferenceExpression) || ((JSReferenceExpression)place).getQualifier() == null || ((ResolveProcessor)processor).needsAllVariants();
    }

    public static boolean processTopLevelClasses(ResolveProcessor processor, ResolveState state, Project project, GlobalSearchScope scope, GlobalSymbolsAcceptanceState acceptOnlyClasses, boolean acceptQualifiedElements) {
        boolean result = true;
        String resolvedName = processor.getName();
        if (resolvedName == null) {
            if (processor.skipTopLevelItems()) {
                return true;
            }
            for (String s : StubIndex.getInstance().getAllKeys(JSNameIndex.KEY, project)) {
                if (!processor.needTopLevelClassName(s) || "IArguments".equals(s)) continue;
                for (JSQualifiedNamedElement e : StubIndex.getElements(JSNameIndex.KEY, (Object)s, (Project)project, (GlobalSearchScope)scope, JSQualifiedNamedElement.class)) {
                    if (e instanceof JSAttributeListOwner && ActionScriptResolveUtil.hasExcludeClassMetadata((JSAttributeListOwner)e) || !JSResolveUtil.acceptableSymbol(e, acceptOnlyClasses, acceptQualifiedElements, processor.place)) continue;
                    result &= processor.execute((PsiElement)e, state);
                }
            }
        } else {
            JSQualifiedNamedElement e;
            Iterator iterator = StubIndex.getElements(JSQualifiedElementIndex.KEY, (Object)resolvedName.hashCode(), (Project)project, (GlobalSearchScope)scope, JSQualifiedNamedElement.class).iterator();
            while (iterator.hasNext() && (!StringUtil.equals((CharSequence)(e = (JSQualifiedNamedElement)iterator.next()).getName(), (CharSequence)resolvedName) || !JSResolveUtil.acceptableSymbol(e, acceptOnlyClasses, acceptQualifiedElements, processor.place) || (result = processor.execute((PsiElement)e, state)))) {
            }
        }
        return result;
    }

    public static boolean acceptableSymbol(JSQualifiedNamedElement e, GlobalSymbolsAcceptanceState acceptOnlyClasses, boolean acceptQualifiedElements, PsiElement place) {
        boolean isNotTopLevel;
        if (acceptOnlyClasses == GlobalSymbolsAcceptanceState.ACCEPT_ONLY_CLASSES ? !(e instanceof JSClass) : (acceptOnlyClasses == GlobalSymbolsAcceptanceState.ACCEPT_NO_CLASSES ? e instanceof JSClass : acceptOnlyClasses == GlobalSymbolsAcceptanceState.ACCEPT_NAMESPACE_DECLARATIONS && !(e instanceof JSNamespaceDeclaration) && !(e instanceof JSVariable))) {
            return false;
        }
        String qName = e.getQualifiedName();
        boolean bl = isNotTopLevel = qName != null && qName.indexOf(46) != -1;
        if (!isNotTopLevel && !JSResolveUtil.isAccessibleSymbol(e, place)) {
            return false;
        }
        if (!acceptQualifiedElements && isNotTopLevel) {
            return false;
        }
        return !(e instanceof JSVariable) && !(e instanceof JSFunction) || DialectDetector.isActionScript((PsiElement)e);
    }

    public static boolean walkOverStructure(@NotNull PsiElement context, Processor<PsiNamedElement> processor) {
        PsiElement forcedContext;
        PsiNamedElement parent;
        if (context == null) {
            JSResolveUtil.$$$reportNull$$$0(32);
        }
        if ((parent = (PsiNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{JSPackageStatement.class, JSClass.class, JSFunction.class, PsiFile.class})) instanceof JSClass && (forcedContext = JSResolveUtil.getContext((PsiElement)parent)) instanceof XmlBackedJSClass && !processor.process((Object)((PsiNamedElement)forcedContext))) {
            return false;
        }
        while (parent != null) {
            if (parent instanceof JSFunctionExpression) {
                parent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{JSPackageStatement.class, JSClass.class, JSFunction.class, PsiFile.class});
                continue;
            }
            if (!processor.process((Object)parent)) {
                return false;
            }
            if (parent instanceof PsiFile) {
                PsiElement data = JSResolveUtil.getContext((PsiElement)parent);
                if (!(data instanceof JSElement)) break;
                parent = (PsiNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)data, (Class[])new Class[]{JSPackageStatement.class, JSClass.class, JSFunction.class, PsiFile.class});
                continue;
            }
            parent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{JSPackageStatement.class, JSClass.class, JSFunction.class, PsiFile.class});
        }
        return true;
    }

    public static Map<String, String> calculateOpenNses(PsiElement place) {
        Ref result = new Ref();
        JSResolveUtil.walkOverStructure(place, (Processor<PsiNamedElement>)((Processor)psiNamedElement -> {
            if (psiNamedElement instanceof JSElement) {
                result.set(((ParameterizedCachedValue)ourCachedOpenedNsesCache.get(ourCachedOpenedNsesKey, (UserDataHolder)((JSElement)psiNamedElement), null)).getValue((Object)((JSElement)psiNamedElement)));
            }
            return false;
        }));
        return result.get() != null ? (Map)result.get() : Collections.emptyMap();
    }

    public static boolean processGlobalThings(ResolveProcessor processor, ResolveState state, PsiElement place, PsiElement context) {
        boolean result = true;
        Project project = context.getProject();
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(context);
        PsiElement placeParent = place.getParent();
        if (JSResolveUtil.shouldProcessTopLevelGlobalContext(place, processor) && (!(place instanceof JSReferenceExpression) || placeParent instanceof JSReferenceExpression || processor.needPackages() || processor.getName() == null)) {
            result = JSResolveUtil.processTopPackages(processor, state, project, scope);
        }
        if (result && !processor.needPackages()) {
            boolean refExpr = place instanceof JSReferenceExpression;
            GlobalSymbolsAcceptanceState acceptOnlyClasses = null;
            if (refExpr && JSResolveUtil.isExprInTypeContext((JSReferenceExpression)place)) {
                acceptOnlyClasses = GlobalSymbolsAcceptanceState.ACCEPT_ONLY_CLASSES;
            }
            if (acceptOnlyClasses == GlobalSymbolsAcceptanceState.ACCEPT_ONLY_CLASSES && processor.getName() == null && JSResolveUtil.isInsideArtificialAttrList((JSReferenceExpression)place)) {
                acceptOnlyClasses = null;
            }
            if (acceptOnlyClasses == GlobalSymbolsAcceptanceState.ACCEPT_ONLY_CLASSES && placeParent instanceof JSImportStatement && processor.getName() == null) {
                acceptOnlyClasses = null;
            }
            if (placeParent instanceof JSUseNamespaceDirective) {
                acceptOnlyClasses = GlobalSymbolsAcceptanceState.ACCEPT_NAMESPACE_DECLARATIONS;
            } else if (placeParent instanceof JSAttributeList && JSResolveUtil.isPlaceWhereNsCanBe(placeParent) || placeParent instanceof JSExpressionStatement && JSResolveUtil.isPlaceWhereNsCanBe(placeParent)) {
                PsiElement parent = JSResolveUtil.findParent(placeParent);
                acceptOnlyClasses = parent instanceof JSExpressionCodeFragment ? GlobalSymbolsAcceptanceState.ACCEPT_ONLY_CLASSES : (parent instanceof JSClass ? GlobalSymbolsAcceptanceState.ACCEPT_NAMESPACE_DECLARATIONS : GlobalSymbolsAcceptanceState.ACCEPT_NO_CLASSES);
            }
            result = JSResolveUtil.processTopLevelClasses(processor, state, project, scope, acceptOnlyClasses, true);
        }
        return result;
    }

    public static boolean isInsideArtificialAttrList(JSReferenceExpression place) {
        if (place.getParent() instanceof JSAttributeList) {
            PsiElement next = PsiTreeUtil.nextLeaf((PsiElement)place);
            if (next instanceof PsiErrorElement) {
                next = PsiTreeUtil.nextLeaf((PsiElement)next);
            }
            return next instanceof PsiWhiteSpace && next.textContains('\n');
        }
        return false;
    }

    public static void processParametersForUsedArgument(@NotNull JSExpression mainOccurrence, @NotNull JSArgumentList parent, @NotNull Processor<JSParameterItem> processor) {
        JSParameterItem parameter;
        PsiElement declaration;
        XmlAttribute attr;
        XmlAttributeDescriptor descriptor2;
        PsiElement context;
        if (mainOccurrence == null) {
            JSResolveUtil.$$$reportNull$$$0(33);
        }
        if (parent == null) {
            JSResolveUtil.$$$reportNull$$$0(34);
        }
        if (processor == null) {
            JSResolveUtil.$$$reportNull$$$0(35);
        }
        int _paramIndex = 0;
        for (JSExpression expr : parent.getArguments()) {
            if (expr == mainOccurrence) break;
            ++_paramIndex;
        }
        int paramIndex = _paramIndex;
        PsiElement firstChild = parent.getFirstChild();
        PsiElement originalFirstChild = PsiUtilCore.getOriginalElement((PsiElement)firstChild, firstChild.getClass());
        JSCallExpression originalElement = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)originalFirstChild, JSCallExpression.class);
        if (originalElement == null) {
            return;
        }
        JSExpression methodExpr = originalElement.getMethodExpression();
        if (methodExpr instanceof JSReferenceExpression) {
            ResolveResult[] results;
            for (ResolveResult r : results = ((JSReferenceExpression)methodExpr).multiResolve(false)) {
                JSParameterItem[] params;
                JSFunctionItem matchedFunction;
                PsiElement element = r.getElement();
                if (element == null || !element.isValid() || (matchedFunction = JSPsiImplUtils.calculatePossibleFunction(element)) == null || !(paramIndex < (params = matchedFunction.getParameters()).length ? !processor.process((Object)params[paramIndex]) : params.length > 0 && params[params.length - 1].isRest() && !processor.process((Object)params[params.length - 1]))) continue;
                return;
            }
        } else if (methodExpr instanceof JSParenthesizedExpression && (context = methodExpr.getContainingFile().getContext()) instanceof XmlAttributeValue && (descriptor2 = (attr = (XmlAttribute)context.getParent()).getDescriptor()) instanceof AnnotationBackedDescriptor && (declaration = descriptor2.getDeclaration()) instanceof JSFunction && (parameter = JSResolveUtil.getParameterFromSetAccessor((JSFunctionItem)((JSFunction)declaration))) != null) {
            processor.process((Object)parameter);
        }
    }

    @Nullable
    public static JSParameterItem findParameterForUsedArgument(@NotNull JSExpression mainOccurrence, @NotNull JSArgumentList parent) {
        if (mainOccurrence == null) {
            JSResolveUtil.$$$reportNull$$$0(36);
        }
        if (parent == null) {
            JSResolveUtil.$$$reportNull$$$0(37);
        }
        Ref result = new Ref();
        JSResolveUtil.processParametersForUsedArgument(mainOccurrence, parent, (Processor<JSParameterItem>)((Processor)jsParameter -> {
            result.set(jsParameter);
            return false;
        }));
        return (JSParameterItem)result.get();
    }

    public static boolean isAccessibleSymbol(JSQualifiedNamedElement subject, PsiElement context) {
        if (ActionScriptResolveUtil.isFileLocalSymbol((PsiElement)subject)) {
            return context != null && JSResolveUtil.isFileLocalSymbolAccessible((PsiElement)subject, context);
        }
        return true;
    }

    private static boolean isFileLocalSymbolAccessible(PsiElement subject, PsiElement context) {
        PsiElement fragmentContext;
        PsiFile contextFile = context.getContainingFile().getOriginalFile();
        if (contextFile instanceof PsiCodeFragment && (fragmentContext = JSResolveUtil.getContext((PsiElement)contextFile)) != null) {
            contextFile = fragmentContext.getContainingFile();
        }
        return subject.getContainingFile() == contextFile;
    }

    public static boolean isAccessibleFromCurrentPackage(PsiElement element, PsiElement place) {
        return JSResolveUtil.isAccessibleFromCurrentPackage(element, place != null ? JSResolveUtil.getPackageNameFromPlace(place) : null, place);
    }

    public static boolean isAccessibleFromCurrentPackage(PsiElement element, String packageName2, PsiElement place) {
        if (place != null) {
            JSAttributeList attrList;
            if (packageName2 == null) {
                return false;
            }
            PsiFile containingFile = place.getContainingFile();
            if ((DialectDetector.isTypeScript((PsiElement)containingFile) || DialectDetector.dialectOfFile(containingFile) == DialectOptionHolder.FLOW) && place instanceof JSReferenceExpression && ((JSReferenceExpression)place).getQualifier() == null) {
                return true;
            }
            if (place.getParent() instanceof JSReferenceListMember && containingFile instanceof JSFile && XmlBackedJSClassImpl.isImplementsAttribute((JSFile)containingFile) && element instanceof JSAttributeListOwner && (attrList = ((JSAttributeListOwner)element).getAttributeList()) != null && attrList.getAccessType() != JSAttributeList.AccessType.PUBLIC) {
                return false;
            }
            if (!JSResolveUtil.isAccessibleFromPackage(element, packageName2)) {
                return (JSResolveUtil.getPackageName(element).isEmpty() || packageName2.isEmpty()) && (ActionScriptResolveUtil.isFileLocalSymbol(element) && JSResolveUtil.isFileLocalSymbolAccessible(element, place) || ResolveProcessor.toSkipPackageLocalCheck(place));
            }
        }
        return true;
    }

    private static boolean isQualifiedAS2Symbol(PsiElement element) {
        String qName;
        return element instanceof JSQualifiedNamedElement && (qName = ((JSQualifiedNamedElement)element).getQualifiedName()) != null && !StringUtil.getPackageName((String)qName).isEmpty() && JSResolveUtil.findParent(element) instanceof JSFile;
    }

    public static String getPackageNameFromPlace(@NotNull PsiElement place) {
        String packageName2;
        if (place == null) {
            JSResolveUtil.$$$reportNull$$$0(38);
        }
        JSQualifiedNamedElement namedElement = (JSQualifiedNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)place, (Class[])PACKAGE_ELEMENTS);
        while (namedElement instanceof JSFunction || namedElement instanceof JSVariable || namedElement instanceof JSDefinitionExpression) {
            PsiElement namedElementParent = JSResolveUtil.findParent((PsiElement)namedElement);
            if (namedElementParent instanceof JSQualifiedNamedElement) {
                namedElement = (JSQualifiedNamedElement)namedElementParent;
                continue;
            }
            namedElement = (JSQualifiedNamedElement)PsiTreeUtil.getParentOfType((PsiElement)namedElementParent, JSQualifiedNamedElement.class);
        }
        if (namedElement == null) {
            PsiFile containingFile = place.getContainingFile().getOriginalFile();
            PsiElement context = containingFile.getContext();
            if (context != null) {
                containingFile = context.getContainingFile().getOriginalFile();
            }
            if (JavaScriptSupportLoader.isMxmlOrFxgFile(containingFile)) {
                return JSResolveUtil.getExpectedPackageNameFromFile(containingFile.getVirtualFile(), containingFile.getProject());
            }
        }
        String string = namedElement instanceof JSPackageStatement || namedElement instanceof TypeScriptModule ? namedElement.getQualifiedName() : (packageName2 = namedElement != null ? JSResolveUtil.getPackageName((PsiElement)namedElement) : "");
        if (packageName2 == null) {
            packageName2 = "";
        }
        return packageName2;
    }

    @NotNull
    public static String getPackageName(PsiElement element) {
        PsiElement parent = JSResolveUtil.findParent(element);
        if (parent instanceof JSClass) {
            String string = JSResolveUtil.getPackageName(parent);
            if (string == null) {
                JSResolveUtil.$$$reportNull$$$0(39);
            }
            return string;
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element);
        if (!(dialect == DialectOptionHolder.ECMA_4 || dialect != null && dialect.isTypeScript)) {
            if ("" == null) {
                JSResolveUtil.$$$reportNull$$$0(40);
            }
            return "";
        }
        JSQualifiedName namespace = ((JSQualifiedNamedElement)element).getNamespace();
        String string = namespace != null ? namespace.getQualifiedName() : "";
        if (string == null) {
            JSResolveUtil.$$$reportNull$$$0(41);
        }
        return string;
    }

    private JSResolveUtil() {
    }

    public static void treeWalkUp(JSResolveProcessor processor, PsiElement elt, PsiElement lastParent, PsiElement place) {
        JSResolveUtil.treeWalkUp(processor, elt, lastParent, place, null);
    }

    public static void treeWalkUp(JSResolveProcessor processor, PsiElement elt, PsiElement lastParent, PsiElement place, PsiElement terminatingParent) {
        while (elt != null) {
            PsiElement parentElement = elt.getContext();
            boolean parentIsClass = parentElement instanceof JSClass;
            int initialIndex = -1;
            PsiElement[] children = JSResolveUtil.getChildren(parentElement);
            if (children != null && children.length > 0) {
                initialIndex = 0;
                for (PsiElement el : children) {
                    if (el == elt) break;
                    ++initialIndex;
                }
            }
            int index = initialIndex;
            boolean finish = false;
            Object cur = elt;
            do {
                if ((cur instanceof JSElement || cur instanceof XmlElement) && !cur.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), (PsiElement)(cur == elt ? lastParent : null), place)) {
                    return;
                }
                if (terminatingParent != cur) continue;
                finish = true;
                break;
            } while (!(cur instanceof PsiFile) && !parentIsClass && (!(cur instanceof JSStatement) || !(parentElement instanceof JSIfStatement)) && (cur = index == -1 ? cur.getPrevSibling() : (index == initialIndex + 1 ? null : (index == 0 ? ((index = children.length - 1) > initialIndex ? children[index] : null) : children[--index]))) != null);
            if (elt instanceof PsiFile) {
                if (elt instanceof XmlFile) {
                    JSResolveUtil.processXmlElement(processor, (XmlFile)elt, place);
                    if (parentElement != null) {
                        parentElement = parentElement.getContainingFile();
                    }
                } else if (elt instanceof JSFile) {
                    if (parentElement != null) {
                        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)parentElement, XmlTag.class);
                        if (tag != null) {
                            PsiFile containingFile = parentElement.getContainingFile();
                            while (tag != null) {
                                for (XmlBackedJSClassProvider provider : (XmlBackedJSClassProvider[])Extensions.getExtensions((ExtensionPointName)XmlBackedJSClassProvider.EP_NAME)) {
                                    if (!provider.canCreateClassFromTag(tag)) continue;
                                    XmlBackedJSClass clazz = XmlBackedJSClassFactory.getInstance().getXmlBackedClass(tag);
                                    if (!clazz.processOuterDeclarations((PsiScopeProcessor)processor)) {
                                        return;
                                    }
                                    clazz.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), (PsiElement)clazz, place);
                                    return;
                                }
                                tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)tag, XmlTag.class);
                            }
                            parentElement = containingFile;
                        } else {
                            FileViewProvider provider;
                            PsiElement topResonableParent = PsiTreeUtil.getParentOfType((PsiElement)parentElement, (Class[])new Class[]{PsiFile.class, JSExecutionScope.class});
                            if (topResonableParent instanceof PsiFile && (provider = ((PsiFile)topResonableParent).getViewProvider()) instanceof MultiplePsiFilesPerDocumentFileViewProvider && topResonableParent == provider.getPsi(provider.getBaseLanguage())) {
                                return;
                            }
                        }
                    } else {
                        parentElement = JSResolveUtil.getContext(elt);
                    }
                } else if (parentElement != null) {
                    parentElement = parentElement.getContainingFile();
                }
                if (!(elt instanceof JSExpressionCodeFragment) && parentElement == null) {
                    return;
                }
            }
            if (finish) {
                return;
            }
            lastParent = elt;
            elt = parentElement;
        }
        return;
    }

    private static void processXmlElement(PsiScopeProcessor processor, XmlFile xmlFile, PsiElement place) {
        XmlTag rootTag;
        XmlDocument document = xmlFile.getDocument();
        XmlTag xmlTag = rootTag = document != null ? document.getRootTag() : null;
        if (JavaScriptSupportLoader.isFlexMxmFile((PsiFile)xmlFile)) {
            JSResolveUtil.processAllGlobalsInXmlFile(processor, xmlFile, place);
        } else if (rootTag != null && xmlFile.getFileType() == XmlFileType.INSTANCE) {
            JSResolveUtil.processAllGlobalsInXmlFile(processor, xmlFile, place);
        }
    }

    public static boolean processAllGlobalsInXmlFile(PsiScopeProcessor processor, XmlFile xmlFile, PsiElement place) {
        XmlBackedJSClass clazz = XmlBackedJSClassFactory.getXmlBackedClass(xmlFile);
        return clazz == null || clazz.processDeclarations(processor, ResolveState.initial(), (PsiElement)clazz, place);
    }

    public static void tryProcessXmlFileImplicitElements(@NotNull PsiElement context, @NotNull WalkUpResolveProcessor processor) {
        if (context == null) {
            JSResolveUtil.$$$reportNull$$$0(42);
        }
        if (processor == null) {
            JSResolveUtil.$$$reportNull$$$0(43);
        }
        PsiFile file = context.getContainingFile();
        XmlFile xmlFile = null;
        if (file instanceof XmlFile) {
            xmlFile = (XmlFile)file;
        } else {
            PsiFile outerFile;
            PsiElement fileContext = file.getContext();
            if (fileContext != null && (outerFile = fileContext.getContainingFile()) instanceof XmlFile) {
                xmlFile = (XmlFile)outerFile;
            }
        }
        if (xmlFile == null) {
            return;
        }
        VirtualFile virtualFile = xmlFile.getVirtualFile();
        if (virtualFile != null && JSImplicitElementsIndex.Holder.containFileType(virtualFile.getFileType())) {
            return;
        }
        Map<String, Collection<JSImplicitElementsIndex.JSElementProxy>> elements = JSIndexContent.get((PsiFile)xmlFile).getImplicitElements();
        Collection<JSImplicitElementsIndex.JSElementProxy> proxies = elements.get(processor.getRequiredName());
        if (proxies != null) {
            for (JSImplicitElementsIndex.JSElementProxy proxy : proxies) {
                processor.doQualifiedCheck((JSPsiElementBase)proxy.toOffsetBasedImplicitElement((PsiFile)xmlFile));
            }
        }
    }

    public static boolean tryProcessAllElementsInInjectedContext(@NotNull PsiFile file, final @NotNull Processor<JSPsiElementBase> processor) {
        if (file == null) {
            JSResolveUtil.$$$reportNull$$$0(44);
        }
        if (processor == null) {
            JSResolveUtil.$$$reportNull$$$0(45);
        }
        if (!(file instanceof JSFile) || InjectedLanguageManager.getInstance((Project)file.getProject()).getInjectionHost((PsiElement)file) == null) {
            return true;
        }
        final Ref stopped = Ref.create((Object)false);
        new JSRecursiveWalkingElementVisitor(){

            public void visitJSElement(JSElement node) {
                Collection elements;
                JSElementIndexingData data;
                if (node instanceof JSFunctionExpression) {
                    return;
                }
                if (node instanceof JSPsiElementBase && !processor.process((Object)((JSPsiElementBase)node))) {
                    this.stopWalking();
                }
                if (node instanceof JSImplicitElementProvider && (data = ((JSImplicitElementProvider)node).getIndexingData()) != null && (elements = data.getImplicitElements()) != null) {
                    for (JSImplicitElement implicitElement : elements) {
                        if (processor.process((Object)implicitElement)) continue;
                        this.stopWalking();
                    }
                }
                super.visitJSElement(node);
            }

            public void stopWalking() {
                super.stopWalking();
                stopped.set((Object)true);
            }
        }.visitJSElement((JSElement)((JSFile)file));
        return (Boolean)stopped.get() == false;
    }

    private static PsiElement[] getChildren(PsiElement element) {
        if (!(element instanceof JSFile || element instanceof JSBlockStatement && element.getParent() instanceof JSNamedElement || element instanceof JSSwitchStatement)) {
            return null;
        }
        return (PsiElement[])CachedValuesManager.getManager((Project)element.getProject()).getParameterizedCachedValue((UserDataHolder)element, CHILDREN_TO_PROCESS_KEY, CHILDREN_TO_PROCESS_PROVIDER, false, (Object)element);
    }

    @Nullable
    public static JSExpression getRealRefExprQualifier(JSReferenceExpression expr) {
        if (!(expr instanceof JSReferenceExpressionImpl)) {
            return null;
        }
        JSExpression qualifier = ((JSReferenceExpressionImpl)expr).getResolveQualifier();
        if (qualifier != null) {
            return qualifier;
        }
        if (JSResolveUtil.isExprInTypeContext(expr) && !DialectDetector.isTypeScript((PsiElement)expr)) {
            JSImportedElementResolveResult resolved = JSImportHandlingUtil.resolveTypeNameUsingImports(expr);
            if (resolved == null) {
                return expr.getQualifier();
            }
            return JSResolveUtil.getRealRefExprQualifierFromResult(expr, resolved);
        }
        return qualifier;
    }

    @Nullable
    public static JSExpression getRealRefExprQualifierFromResult(JSReferenceExpression expr, JSImportedElementResolveResult resolved) {
        GenericSignature signature = JSResolveUtil.extractGenericSignature(resolved.qualifiedName);
        String typeWithoutSignature = signature != null ? signature.elementType : resolved.qualifiedName;
        return ((JSReferenceExpression)JSChangeUtil.createExpressionFromText(expr.getProject(), typeWithoutSignature).getPsi()).getQualifier();
    }

    public static String findPackageStatementQualifier(PsiElement context) {
        String s;
        if (context instanceof JSClass && (s = ((JSClass)context).getQualifiedName()) != null) {
            int i = s.lastIndexOf(46);
            if (i != -1) {
                return s.substring(0, i);
            }
            return null;
        }
        JSQualifiedNamedElement packageOrModuleStatement = (JSQualifiedNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{JSPackageStatement.class, TypeScriptModule.class});
        if (packageOrModuleStatement != null) {
            return packageOrModuleStatement.getQualifiedName();
        }
        return null;
    }

    public static boolean isExprInStrictTypeContext(@NotNull JSReferenceExpression expr) {
        if (expr == null) {
            JSResolveUtil.$$$reportNull$$$0(46);
        }
        for (JSResolveHelper helper : (JSResolveHelper[])Extensions.getExtensions(JSResolveHelper.EP_NAME)) {
            if (helper.isStrictTypeContext((PsiElement)expr)) continue;
            return false;
        }
        PsiElement parent = expr.getParent();
        if (parent instanceof JSReferenceListMember) {
            parent = parent.getParent();
        }
        if (parent instanceof JSGenericSignature || parent instanceof JSImportStatement || parent instanceof JSReferenceList && !(parent instanceof ES6ReferenceList) || parent instanceof TypeScriptType && !(parent instanceof TypeScriptTypeofType) || parent instanceof JSExpressionCodeFragment && ((JSExpressionCodeFragment)parent).isTypeContext()) {
            return true;
        }
        if (parent instanceof JSFunction && ((JSFunction)parent).getReturnTypeElement() == expr) {
            return true;
        }
        return parent instanceof JSVariable && ((JSVariable)parent).getTypeElement() == expr;
    }

    public static boolean isExprInTypeContext(JSReferenceExpression expr) {
        PsiElement parent = expr.getParent();
        return JSResolveUtil.isExprInStrictTypeContext(expr) || parent instanceof JSNewExpression || parent instanceof JSBinaryExpression && ((JSBinaryExpression)parent).getROperand() == expr && (((JSBinaryExpression)parent).getOperationSign() == JSTokenTypes.IS_KEYWORD || ((JSBinaryExpression)parent).getOperationSign() == JSTokenTypes.AS_KEYWORD);
    }

    @Nullable
    public static VirtualFile findPredefinedOrLibraryFile(Project project, String fileName) {
        JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
        VirtualFile vf = libraryManager.findPredefinedLibraryFileByName(fileName);
        if (vf != null) {
            return vf;
        }
        return libraryManager.getMatchingFile(fileName);
    }

    @NotNull
    public static GlobalSearchScope getJavaScriptSymbolsResolveScope(@NotNull Project project) {
        GlobalSearchScope allScope;
        if (project == null) {
            JSResolveUtil.$$$reportNull$$$0(47);
        }
        if ((allScope = (GlobalSearchScope)project.getUserData(PROJECT_SCOPE_WITH_PREDEFINED_KEY)) == null) {
            allScope = GlobalSearchScope.allScope((Project)project);
            allScope = new AdditionalIndexedRootsScope(allScope, (IndexableFileSet)new AdditionalIndexableFileSet(project, new IndexableSetContributor[]{JS_INDEXED_ROOT_PROVIDER}));
            project.putUserData(PROJECT_SCOPE_WITH_PREDEFINED_KEY, (Object)allScope);
        }
        GlobalSearchScope globalSearchScope = allScope;
        if (globalSearchScope == null) {
            JSResolveUtil.$$$reportNull$$$0(48);
        }
        return globalSearchScope;
    }

    @NotNull
    public static JSSymbolNamespace buildNamespaceForQualifier(JSExpression qualifier) {
        List<String> nameIds = null;
        if (qualifier == null) {
            nameIds = JSSymbolUtil.buildNameIndexArray(null);
        } else {
            JSNamespaceEvaluationResult ns = JSSymbolUtil.evaluateNamespaceLocally(qualifier);
            if (ns != null && ns.getQualifiedName() != null) {
                JSNamespaceEvaluationResult jSNamespaceEvaluationResult = ns;
                if (jSNamespaceEvaluationResult == null) {
                    JSResolveUtil.$$$reportNull$$$0(49);
                }
                return jSNamespaceEvaluationResult;
            }
            nameIds = Collections.singletonList("");
        }
        JSSymbolNamespaceImpl jSSymbolNamespaceImpl = new JSSymbolNamespaceImpl(JSQualifiedNameImpl.fromComponents(nameIds), JSContext.UNKNOWN, true, true);
        if (jSSymbolNamespaceImpl == null) {
            JSResolveUtil.$$$reportNull$$$0(50);
        }
        return jSSymbolNamespaceImpl;
    }

    public static boolean iterateType(@NotNull JSPsiElementBase node, final @NotNull PsiElement jsClass, String typeName, final JSOverrideHandler handler, boolean onlyFunctions) {
        String namespace;
        boolean processedClassOverrides;
        if (node == null) {
            JSResolveUtil.$$$reportNull$$$0(51);
        }
        if (jsClass == null) {
            JSResolveUtil.$$$reportNull$$$0(52);
        }
        if (typeName == null) {
            return true;
        }
        final String name = node.getName();
        if (name == null) {
            return true;
        }
        if (!(!(jsClass instanceof JSClass) || (processedClassOverrides = JSInheritanceUtil.processOverrides((JSClass)jsClass, handler, name, namespace = JSResolveUtil.getNamespaceValue(((JSAttributeListOwner)node).getAttributeList()), (PsiElement)node, onlyFunctions)) && DialectDetector.isJavaScript(jsClass))) {
            return processedClassOverrides;
        }
        final GlobalSearchScope resolveScope = JSResolveUtil.getResolveScope(jsClass);
        final JSClassResolver resolver = JSDialectSpecificHandlersFactory.forElement(jsClass).getClassResolver();
        List<String> types = node.getJSContext() == JSContext.STATIC ? Collections.emptyList() : Collections.singletonList(typeName);
        return JSTypeEvaluateManager.iterateTypeHierarchy(jsClass, types, true, new JSTypeEvaluateManager.NamespaceProcessor(){
            final Set<String> visited = new THashSet();

            @Override
            public boolean process(String type, VirtualFile file) {
                String qName = JSTypeUtils.getTypeMatchingNamespace(type);
                if (this.visited.contains(qName)) {
                    return true;
                }
                this.visited.add(qName);
                CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
                GlobalSearchScope scope = jsClass instanceof JSFile ? resolveScope : GlobalSearchScope.fileScope((PsiFile)jsClass.getContainingFile());
                String className = qName + "." + name;
                resolver.processElementsByQNameIncludingImplicit(className, scope, (Processor<JSPsiElementBase>)collectProcessor);
                ArrayList results = ContainerUtil.newArrayListWithCapacity((int)collectProcessor.getResults().size());
                for (JSPsiElementBase result : collectProcessor.getResults()) {
                    if (result.getAccessType() == JSAttributeList.AccessType.PRIVATE || result.getJSContext() == JSContext.STATIC) continue;
                    results.add(result);
                }
                return results.isEmpty() || handler.process(results, jsClass, qName);
            }
        });
    }

    public static String getNamespaceValue(JSAttributeList attributeList) {
        if (attributeList == null) {
            return null;
        }
        String namespace_id = attributeList.getNamespace();
        if (namespace_id == null) {
            return null;
        }
        return attributeList.resolveNamespaceValue();
    }

    @Nullable
    public static String getQNameToStartHierarchySearch(JSPsiElementBase node) {
        JSQualifiedName namespace;
        if (node instanceof JSFunction && (namespace = node.getNamespace()) != null && !JSSymbolUtil.isConstructorSymbol(node)) {
            if (namespace.getName().equals(PROTOTYPE_FIELD_NAME)) {
                namespace = namespace.getParent();
            }
            return namespace != null ? namespace.getQualifiedName() : null;
        }
        PsiElement parentNode = JSResolveUtil.findParent((PsiElement)node);
        if (parentNode instanceof JSClass) {
            JSAttributeList attributeList;
            if (DialectDetector.isTypeScript(parentNode)) {
                return ((JSClass)parentNode).getQualifiedName();
            }
            JSAttributeList jSAttributeList = attributeList = node instanceof JSAttributeListOwner ? ((JSAttributeListOwner)node).getAttributeList() : null;
            if (attributeList == null || !attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE) || attributeList.hasModifier(JSAttributeList.ModifierType.STATIC) || attributeList.getAccessType() == JSAttributeList.AccessType.PRIVATE) {
                return null;
            }
            return ((JSClass)parentNode).getQualifiedName();
        }
        if (node instanceof JSFunctionExpression && parentNode.getContainingFile().getLanguage() != JavaScriptSupportLoader.ECMA_SCRIPT_L4) {
            JSNamespaceEvaluationResult ns = JSContextResolver.resolveContext(node.getFirstChild());
            return JSNamespaceEvaluationResult.getQualifiedName(ns);
        }
        if (parentNode instanceof JSFile && parentNode.getContainingFile().getLanguage() != JavaScriptSupportLoader.ECMA_SCRIPT_L4) {
            return node.getName();
        }
        if (node instanceof JSDefinitionExpression) {
            JSExpression expression = ((JSDefinitionExpression)node).getExpression();
            if (expression instanceof JSReferenceExpression) {
                JSExpression expr = JSSymbolUtil.isConstructorSymbol(node) ? expression : ((JSReferenceExpression)expression).getQualifier();
                JSNamespaceEvaluationResult ns = JSSymbolUtil.evaluateNamespaceLocally(expr);
                return ns != null && ns.getQualifiedName() != null ? ns.getQualifiedName().getQualifiedName() : null;
            }
        } else if (node instanceof JSVariable) {
            JSNamespaceEvaluationResult ns = JSContextResolver.resolveContext((PsiElement)node);
            return JSNamespaceEvaluationResult.getQualifiedName(ns);
        }
        return null;
    }

    public static boolean isInPlaceWhereTypeCanBeDuringCompletion(PsiElement expr) {
        PsiElement parent = expr.getParent();
        if (parent instanceof JSArgumentList || parent instanceof JSVariable && ((JSVariable)parent).getInitializer() == expr) {
            if (expr instanceof JSReferenceExpression) {
                JSExpression qualifier = ((JSReferenceExpression)expr).getQualifier();
                return qualifier == null || qualifier instanceof JSReferenceExpression;
            }
            return true;
        }
        if (parent instanceof JSExpressionStatement) {
            if (expr instanceof JSReferenceExpression) {
                return ((JSReferenceExpression)expr).getQualifier() == null;
            }
            return true;
        }
        return false;
    }

    public static boolean isPlaceWhereNsCanBe(PsiElement parent) {
        PsiElement grandParent = parent.getParent();
        return grandParent instanceof JSClass || grandParent instanceof JSPackageStatement || grandParent instanceof JSFile && grandParent.getContext() == null;
    }

    @Nullable
    public static String getTypeFromTagNameInMxml(@Nullable PsiElement psiElement) {
        JSClass clazz = JSResolveUtil.getClassFromTagNameInMxml(psiElement);
        return clazz != null ? clazz.getQualifiedName() : null;
    }

    public static JSClass getClassFromTagNameInMxml(PsiElement psiElement) {
        XmlTag tag;
        XmlTag xmlTag = tag = psiElement != null ? (XmlTag)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{XmlTag.class}) : null;
        if (tag != null && (!tag.getNamespacePrefix().isEmpty() || JavaScriptSupportLoader.isFlexMxmFile(tag.getContainingFile()))) {
            XmlElementDescriptor descriptor2;
            if ("Script".equals(tag.getLocalName())) {
                tag = ((XmlFile)tag.getContainingFile()).getDocument().getRootTag();
            }
            if ((descriptor2 = tag.getDescriptor()) != null) {
                PsiElement decl = descriptor2.getDeclaration();
                if (decl instanceof JSClass) {
                    return (JSClass)decl;
                }
                if (decl instanceof XmlFile) {
                    return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)decl);
                }
            }
        }
        return null;
    }

    public static <T extends PsiPolyVariantReference> ResolveResult[] resolve(PsiFile file, @NotNull T instance, @NotNull ResolveCache.PolyVariantResolver<T> resolver, boolean incompleteCode) {
        if (instance == null) {
            JSResolveUtil.$$$reportNull$$$0(53);
        }
        if (resolver == null) {
            JSResolveUtil.$$$reportNull$$$0(54);
        }
        if (file == null) {
            return ResolveResult.EMPTY_ARRAY;
        }
        return ResolveCache.getInstance((Project)file.getProject()).resolveWithCaching(instance, resolver, false, incompleteCode);
    }

    public static void clearResolveCaches(PsiFile file) {
        ResolveCache.getInstance((Project)file.getProject()).clearCache(true);
    }

    private static boolean isOutOfScopeDefaultExport(@Nullable Object value, @NotNull JSElement _scope, @NotNull PsiElement place) {
        if (_scope == null) {
            JSResolveUtil.$$$reportNull$$$0(55);
        }
        if (place == null) {
            JSResolveUtil.$$$reportNull$$$0(56);
        }
        return value instanceof PsiElement && ((PsiElement)value).getParent() instanceof ES6ExportDefaultAssignment && !PsiTreeUtil.isAncestor((PsiElement)_scope, (PsiElement)place, (boolean)true);
    }

    public static boolean processDeclarationsInScope(JSElement _scope, PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        JSElement scope = (JSElement)CompletionUtilCoreImpl.getOriginalElement((PsiElement)_scope);
        if (scope == null) {
            return true;
        }
        String requiredName = null;
        boolean toProcessImplicits = true;
        if (processor instanceof JSResolveProcessor) {
            requiredName = ((JSResolveProcessor)processor).getName();
        }
        if (processor instanceof ResolveProcessor) {
            ResolveProcessor resolveProcessor = (ResolveProcessor)processor;
            toProcessImplicits = !resolveProcessor.isProcessingFromIndices();
        }
        boolean result = true;
        TIntObjectHashMap defsMap = (TIntObjectHashMap)((CachedValue)ourCachedDefsCache.get(CACHED_DEFS_KEY, (UserDataHolder)scope, null)).getValue();
        if (requiredName == null) {
            TIntObjectIterator iterator = defsMap.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                Object value = iterator.value();
                if (JSResolveUtil.isOutOfScopeDefaultExport(value, _scope, place)) continue;
                result = JSResolveUtil.dispatchResolve(processor, state, place, result, value);
            }
        } else {
            Object defs = defsMap.get(requiredName.hashCode());
            if (defs != null && !JSResolveUtil.isOutOfScopeDefaultExport(defs, _scope, place)) {
                result = JSResolveUtil.dispatchResolve(processor, state, place, result, defs);
            }
        }
        if (result && toProcessImplicits && scope instanceof JSClassBase) {
            processor.handleEvent(ResolveProcessor.INHERITED_CLASSES_STARTED, (Object)scope);
            for (JSClass clazz : ((JSClassBase)scope).getImplicitlyDeclaredInterfaces()) {
                result = clazz.processDeclarations(processor, state, lastParent, place);
            }
            processor.handleEvent(ResolveProcessor.INHERITED_CLASSES_FINISHED, (Object)scope);
        }
        return result;
    }

    private static boolean dispatchResolve(PsiScopeProcessor processor, ResolveState state, PsiElement place, boolean result, Object o) {
        if (o instanceof JSElement[]) {
            for (JSElement s : (JSElement[])o) {
                result &= s.processDeclarations(processor, state, null, place);
            }
        } else {
            JSElement s = (JSElement)o;
            result &= s.processDeclarations(processor, state, null, place);
        }
        return result;
    }

    @NotNull
    public static Collection<JSElement> findNamedElementsInScope(@NotNull String name, @NotNull JSElement scope) {
        if (name == null) {
            JSResolveUtil.$$$reportNull$$$0(57);
        }
        if (scope == null) {
            JSResolveUtil.$$$reportNull$$$0(58);
        }
        if (scope.isValid()) {
            JSElement originalElement = (JSElement)CompletionUtilCoreImpl.getOriginalElement((PsiElement)scope);
            if (originalElement != null) {
                scope = originalElement;
            }
        } else {
            Logger.getInstance(JSResolveUtil.class).error("scope must be valid");
        }
        TIntObjectHashMap defsMap = (TIntObjectHashMap)((CachedValue)ourCachedDefsCache.get(CACHED_DEFS_KEY, (UserDataHolder)scope, null)).getValue();
        Object defs = defsMap.get(name.hashCode());
        if (defs instanceof JSElement) {
            Set<JSElement> set = Collections.singleton((JSElement)defs);
            if (set == null) {
                JSResolveUtil.$$$reportNull$$$0(59);
            }
            return set;
        }
        if (defs instanceof JSElement[]) {
            List<JSElement> list = Arrays.asList((JSElement[])defs);
            if (list == null) {
                JSResolveUtil.$$$reportNull$$$0(60);
            }
            return list;
        }
        List<JSElement> list = Collections.emptyList();
        if (list == null) {
            JSResolveUtil.$$$reportNull$$$0(61);
        }
        return list;
    }

    @Nullable
    public static PsiElement getLocalVariableRef(@Nullable JSFunction function, JSReferenceExpression expr) {
        return expr.getQualifier() == null ? JSResolveUtil.getLocalVariableRef(function, expr.getReferenceName()) : null;
    }

    @Nullable
    public static PsiElement getLocalVariableRef(@Nullable JSFunction function, @Nullable String referencedName) {
        if (referencedName != null) {
            SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(referencedName, true, new ResolveResultSink(null, referencedName));
            while (function != null) {
                boolean val = function.processDeclarations(processor, ResolveState.initial(), (PsiElement)function.getParameterList(), (PsiElement)function);
                if (!val) {
                    return processor.getResult();
                }
                if ((function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)function, JSFunction.class)) != null) continue;
                break;
            }
        }
        return null;
    }

    public static JSSourceElement[] getSourceElements(PsiElement owner) {
        if (owner instanceof JSStubElementImpl) {
            return (JSSourceElement[])((JSStubElementImpl)owner).getStubOrPsiChildren(JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS, (PsiElement[])JSSourceElement.EMPTY_ARRAY);
        }
        if (owner instanceof JSFile) {
            return ((JSFile)owner).getStatements();
        }
        return JSSourceElement.EMPTY_ARRAY;
    }

    public static PsiElement[] getStubbedChildren(@Nullable PsiElement owner) {
        return JSResolveUtil.getStubbedChildren(owner, JSExtendedLanguagesTokenSetProvider.OUR_STUBBED_FILTER);
    }

    public static PsiElement[] getStubbedChildren(@Nullable PsiElement owner, @NotNull TokenSet filter) {
        if (filter == null) {
            JSResolveUtil.$$$reportNull$$$0(62);
        }
        if (owner instanceof JSStubElementImpl) {
            JSStubElementImpl element = (JSStubElementImpl)owner;
            StubElement stub = element.getStub();
            if (stub != null) {
                return stub.getChildrenByType(filter, PsiElement.EMPTY_ARRAY);
            }
            return JSResolveUtil.getChildrenFromTokenSet(element.getNode(), filter);
        }
        if (owner instanceof JSFile) {
            JSFile file = (JSFile)owner;
            StubElement stub = ((JSFileImpl)file).getStub();
            if (stub != null) {
                return stub.getChildrenByType(filter, PsiElement.EMPTY_ARRAY);
            }
            return JSResolveUtil.getChildrenFromTokenSet((ASTNode)file.getNode(), filter);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    private static PsiElement[] getChildrenFromTokenSet(ASTNode astNode, TokenSet filter) {
        ASTNode[] astNodes = astNode.getChildren(filter);
        PsiElement[] result = new PsiElement[astNodes.length];
        for (int i = 0; i < astNodes.length; ++i) {
            result[i] = astNodes[i].getPsi();
        }
        return result;
    }

    @Contract(value="null -> false")
    public static boolean isConstructorFunction(@Nullable PsiElement element) {
        return element instanceof JSFunction && ((JSFunction)element).isConstructor();
    }

    @Nullable
    public static JSPsiElementBase getExportedElement(@NotNull JSFile file) {
        Collection<JSPsiElementBase> elements;
        if (file == null) {
            JSResolveUtil.$$$reportNull$$$0(63);
        }
        String qName = "module.exports";
        JSType innerType = file.getExportsInnerAlias();
        if (innerType instanceof JSNamedType && ((JSNamedType)innerType).isStaticOrInstance() == JSContext.STATIC) {
            qName = JSTypeUtils.getQualifiedNameMatchingType(innerType, false);
        } else if (innerType instanceof JSReferenceType) {
            qName = ((JSReferenceType)innerType).getReferencedName();
        }
        if (qName != null && (elements = JSClassResolver.getInstance().findElementsByQNameIncludingImplicit(qName, GlobalSearchScope.fileScope((PsiFile)file))).size() == 1) {
            return elements.iterator().next();
        }
        return null;
    }

    public static boolean isEventListenerCall(JSCallExpression e) {
        String methodName;
        JSExpression methodExpression = e.getMethodExpression();
        return methodExpression instanceof JSReferenceExpression && ("addEventListener".equals(methodName = ((JSReferenceExpression)methodExpression).getReferenceName()) || "removeEventListener".equals(methodName));
    }

    @NotNull
    public static Collection<PsiElement> getResolvedElements(@NotNull PsiReference ref) {
        if (ref == null) {
            JSResolveUtil.$$$reportNull$$$0(64);
        }
        if (ref instanceof PsiPolyVariantReference) {
            ResolveResult[] results = ((PsiPolyVariantReference)ref).multiResolve(false);
            SmartList elements = new SmartList();
            for (ResolveResult result : results) {
                if (!result.isValidResult()) continue;
                elements.add((Object)result.getElement());
            }
            SmartList smartList = elements;
            if (smartList == null) {
                JSResolveUtil.$$$reportNull$$$0(65);
            }
            return smartList;
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)ref.resolve());
        if (list == null) {
            JSResolveUtil.$$$reportNull$$$0(66);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 39: 
            case 40: 
            case 41: 
            case 48: 
            case 49: 
            case 50: 
            case 59: 
            case 60: 
            case 61: 
            case 65: 
            case 66: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 39: 
            case 40: 
            case 41: 
            case 48: 
            case 49: 
            case 50: 
            case 59: 
            case 60: 
            case 61: 
            case 65: 
            case 66: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 32: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 39: 
            case 40: 
            case 41: 
            case 48: 
            case 49: 
            case 50: 
            case 59: 
            case 60: 
            case 61: 
            case 65: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSResolveUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedJsFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: 
            case 29: 
            case 31: 
            case 35: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 11: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 16: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forcedPackageName";
                break;
            }
            case 22: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 23: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
            case 26: 
            case 44: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 28: 
            case 30: 
            case 38: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainOccurrence";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_scope";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSResolveUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortTypeName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findOverridingFunctionsByNamespaces";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaScriptSymbolsResolveScope";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNamespaceForQualifier";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "findNamedElementsInScope";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processInjectedFileForTag";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getShortenedType";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 39: 
            case 40: 
            case 41: 
            case 48: 
            case 49: 
            case 50: 
            case 59: 
            case 60: 
            case 61: 
            case 65: 
            case 66: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getXmlBackedClass";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isResolveStrict";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasUseStrictPragma";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "shortReferenceIsAmbiguousOrUnequal";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isFromPredefinedFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getResolveScope";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getContext";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isObjectClass";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processHierarchy";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "stableResolveOrder";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findFileLocalElement";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleFromPackage";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTopReferenceExpression";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isSameReference";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findParent";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findParentClass";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getParameterFromSetAccessor";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcessTopLevelGlobalContext";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcessImports";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "walkOverStructure";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "processParametersForUsedArgument";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findParameterForUsedArgument";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getPackageNameFromPlace";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "tryProcessXmlFileImplicitElements";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "tryProcessAllElementsInInjectedContext";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isExprInStrictTypeContext";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getJavaScriptSymbolsResolveScope";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "iterateType";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isOutOfScopeDefaultExport";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "findNamedElementsInScope";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getStubbedChildren";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getExportedElement";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 39: 
            case 40: 
            case 41: 
            case 48: 
            case 49: 
            case 50: 
            case 59: 
            case 60: 
            case 61: 
            case 65: 
            case 66: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class MyNamespaceProcessor
    implements JSTypeEvaluateManager.NamespaceProcessor {
        private final Set<JSPsiElementBase> myFunctions;
        private final LinkedList<String> myDescendants = new LinkedList();
        private final Set<String> myProcessed = new THashSet();
        protected JSPsiElementBase function;
        private final boolean myFindAll;

        public MyNamespaceProcessor(Set<JSPsiElementBase> functions, boolean findAll) {
            this.myFunctions = functions;
            this.myFindAll = findAll;
        }

        @Override
        public boolean process(String serializedType, VirtualFile file) {
            JSType type = JSTypeUtils.createType(serializedType, JSTypeSource.EMPTY);
            if (type instanceof JSNamedType && ((JSNamedType)type).getTypeContext() == JSTypeContext.STATIC) {
                return true;
            }
            String qName = JSTypeUtils.getTypeMatchingNamespace(serializedType);
            JSPsiElementBase context = this.myFunctions.iterator().next();
            if (!this.myFindAll && this.myProcessed.contains(qName)) {
                return true;
            }
            if (this.myProcessed.add(qName)) {
                this.myDescendants.add(qName);
            }
            Collection<JSPsiElementBase> elements = null;
            GlobalSearchScope scope = GlobalSearchScope.fileScope((Project)context.getProject(), (VirtualFile)file);
            boolean result = false;
            Iterator<JSPsiElementBase> functionIterator = this.myFunctions.iterator();
            while (functionIterator.hasNext()) {
                Collection<JSPsiElementBase> elementsToProcess;
                this.function = functionIterator.next();
                if (JSSymbolUtil.isConstructorSymbol(this.function)) {
                    if (elements == null) {
                        elements = JSClassResolver.getInstance().findElementsByQNameIncludingImplicit(qName, scope);
                    }
                    elementsToProcess = elements;
                } else {
                    String descendantName = this.function.getName();
                    elementsToProcess = new ArrayList<JSPsiElementBase>();
                    if (descendantName != null) {
                        String memberName = qName + "." + descendantName;
                        Collection<JSPsiElementBase> members = JSClassResolver.getInstance().findElementsByQNameIncludingImplicit(memberName, scope);
                        elementsToProcess.addAll(members);
                    }
                }
                boolean skipImplicitElements = false;
                for (JSPsiElementBase elementToProcess : elementsToProcess) {
                    if (elementToProcess instanceof JSImplicitElement) continue;
                    skipImplicitElements = true;
                    break;
                }
                boolean b = true;
                for (JSPsiElementBase elementToProcess : elementsToProcess) {
                    if (skipImplicitElements && elementToProcess instanceof JSImplicitElement) continue;
                    b &= this.doProcess((PsiElement)elementToProcess);
                }
                if (!b) {
                    functionIterator.remove();
                }
                result |= b;
            }
            return result;
        }

        protected abstract boolean doProcess(PsiElement var1);

        public void processDescendantsOf(String qName, PsiElement context) {
            ProgressManager.checkCanceled();
            boolean b = JSTypeEvaluateManager.iterateSubclasses(context, qName, this);
            while (b && !this.myDescendants.isEmpty()) {
                ProgressManager.checkCanceled();
                b = JSTypeEvaluateManager.iterateSubclasses(context, this.myDescendants.removeFirst(), this);
            }
        }
    }

    public static class VisitAllTypesProcessor
    extends ResolveProcessor {
        private final Processor<JSClass> myProcessor;
        private final boolean myVisitInterfaces;

        public VisitAllTypesProcessor(Processor<JSClass> processor, boolean visitInterfaces) {
            super((String)null);
            this.myProcessor = processor;
            this.setLocalResolve(true);
            this.setTypeContext(true);
            this.setToProcessHierarchy(true);
            this.setToProcessMembers(false);
            this.myVisitInterfaces = visitInterfaces;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                VisitAllTypesProcessor.$$$reportNull$$$0(0);
            }
            if (state == null) {
                VisitAllTypesProcessor.$$$reportNull$$$0(1);
            }
            if (element instanceof JSClass) {
                JSClass clazz = (JSClass)element;
                if (!this.myProcessor.process((Object)clazz)) {
                    return false;
                }
                if (this.myVisitInterfaces) {
                    for (JSClass im : clazz.getImplementedInterfaces()) {
                        if (im.processDeclarations((PsiScopeProcessor)this, state, (PsiElement)im, (PsiElement)im)) continue;
                        return false;
                    }
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "state";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$VisitAllTypesProcessor";
            objectArray[2] = "execute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class RelevantDefsUserDataCache
    extends UserDataCache<CachedValue<TIntObjectHashMap<Object>>, JSElement, Object> {
        protected CachedValue<TIntObjectHashMap<Object>> compute(JSElement jsElement, Object o) {
            return CachedValuesManager.getManager((Project)jsElement.getProject()).createCachedValue(() -> {
                TIntObjectHashMap relevantDefs = new TIntObjectHashMap();
                MyJSElementVisitor elementVisitor = new MyJSElementVisitor(jsElement, (TIntObjectHashMap<Object>)relevantDefs);
                elementVisitor.startVisiting(jsElement);
                return new CachedValueProvider.Result((Object)relevantDefs, new Object[]{jsElement});
            }, false);
        }

        private static class MyJSElementVisitor
        extends JSRecursiveWalkingElementVisitor {
            private Set<JSFile> visitedIncludes;
            private final TIntObjectHashMap<Object> myRelevantDefs;
            private final JSElement myBase;
            private JSElement context;
            private final boolean isTypeScript;
            private final boolean isActionScript;

            public MyJSElementVisitor(JSElement base, TIntObjectHashMap<Object> relevantDefs) {
                this.myRelevantDefs = relevantDefs;
                this.myBase = base;
                this.context = base;
                this.isTypeScript = DialectDetector.isTypeScript((PsiElement)base);
                this.isActionScript = DialectDetector.isActionScript((PsiElement)base);
            }

            private void startVisiting(JSElement jsElement) {
                TypeScriptObjectType body;
                PsiElement first = null;
                PsiElement[] arrayElementsToScan = null;
                if (jsElement instanceof JSFunction) {
                    Object object = body = this.isTypeScript ? JSResolveUtil.getSourceElements((PsiElement)jsElement) : ((JSFunction)jsElement).getBody();
                    if (((JSSourceElement[])body).length > 0 && body[0] instanceof JSBlockStatement) {
                        ASTNode node = body[0].getNode().getFirstChildNode();
                        first = node != null ? node.getPsi() : null;
                    }
                } else if (this.isTypeScript && jsElement instanceof TypeScriptInterface) {
                    body = ((TypeScriptInterface)jsElement).getBody();
                    if (body != null) {
                        arrayElementsToScan = new PsiElement[]{body};
                    }
                } else if (jsElement instanceof JSClass || jsElement instanceof JSPackageStatement || jsElement instanceof TypeScriptModule) {
                    arrayElementsToScan = JSResolveUtil.getSourceElements((PsiElement)jsElement);
                } else if (jsElement instanceof TypeScriptVariable) {
                    PsiElement[] typeElement = ((TypeScriptVariable)jsElement).getTypeElement();
                    if (typeElement instanceof TypeScriptObjectType) {
                        arrayElementsToScan = new PsiElement[]{typeElement};
                    }
                } else if (jsElement instanceof JSVariable) {
                    arrayElementsToScan = PsiElement.EMPTY_ARRAY;
                } else if (jsElement instanceof JSObjectLiteralExpression) {
                    arrayElementsToScan = ((JSObjectLiteralExpression)jsElement).getProperties();
                } else if (jsElement instanceof JSFile && (this.isActionScript || this.isTypeScript)) {
                    arrayElementsToScan = JSResolveUtil.getSourceElements((PsiElement)jsElement);
                } else if (jsElement instanceof JSVarStatement) {
                    arrayElementsToScan = this.isActionScript || this.isTypeScript ? ((JSVarStatement)jsElement).getStubSafeVariables() : ((JSVarStatement)jsElement).getVariables();
                } else {
                    first = jsElement.getFirstChild();
                }
                if (arrayElementsToScan != null) {
                    for (PsiElement elt : arrayElementsToScan) {
                        elt.accept((PsiElementVisitor)this);
                    }
                } else {
                    for (PsiElement e = first; e != null; e = e.getNextSibling()) {
                        if (!(e instanceof JSSourceElement) && !(e instanceof JSVariable) && !(e instanceof JSProperty) && !(e instanceof JSDestructuringContainer) && !(e instanceof PsiComment)) continue;
                        e.accept((PsiElementVisitor)this);
                    }
                }
            }

            public void visitJSDefinitionExpression(JSDefinitionExpression node) {
            }

            public void visitJSExpressionStatement(JSExpressionStatement node) {
                JSExpression expression = node.getExpression();
                if (expression instanceof JSLiteralExpression && (JSResolveUtil.SINGLE_QUOTED_USE_STRICT.equals(expression.getText()) || JSResolveUtil.QUOTED_USE_STRICT.equals(expression.getText()))) {
                    this.addRelevantDef((JSElement)new ImplicitJSVariableImpl(JSResolveUtil.USE_STRICT, (JSType)null, (PsiElement)node));
                }
                if (expression != null) {
                    this.visitJSExpression(expression);
                }
            }

            public void visitJSVariable(JSVariable node) {
                if (node.hasBlockScope()) {
                    return;
                }
                if (node instanceof ActionScriptVariableImpl && ((ActionScriptVariableImpl)node).hasQualifiedName()) {
                    return;
                }
                this.processUseDirectiveInAttrList((JSAttributeListOwner)node);
                this.addRelevantDef((JSElement)node);
            }

            private void processUseDirectiveInAttrList(JSAttributeListOwner node) {
                JSAttributeList attributeList = node.getAttributeList();
                if (attributeList != null) {
                    PsiElement elt;
                    JSAttributeListStub stub = (JSAttributeListStub)attributeList.getStub();
                    if (stub != null) {
                        StubElement useNamespaceDirectiveInStub = stub.findChildStubByType(JSStubElementTypes.USE_NAMESPACE_DIRECTIVE);
                        elt = useNamespaceDirectiveInStub != null ? useNamespaceDirectiveInStub.getPsi() : null;
                    } else {
                        ASTNode useNs = attributeList.getNode().findChildByType(JSStubElementTypes.USE_NAMESPACE_DIRECTIVE);
                        PsiElement psiElement = elt = useNs != null ? useNs.getPsi() : null;
                    }
                    if (elt != null) {
                        elt.accept((PsiElementVisitor)this);
                    }
                }
            }

            public void visitJSIncludeDirective(JSIncludeDirective includeDirective) {
                PsiFile _file = includeDirective.resolveFile();
                if (!(_file instanceof JSFile) || this.myBase.getContainingFile() == _file) {
                    return;
                }
                JSFile file = (JSFile)_file;
                if (this.visitedIncludes != null && this.visitedIncludes.contains(file)) {
                    return;
                }
                if (this.visitedIncludes == null) {
                    this.visitedIncludes = new THashSet();
                }
                this.visitedIncludes.add(file);
                JSElement prevContext = this.context;
                this.context = file;
                this.context.putUserData(contextKey, (Object)this.myBase);
                this.startVisiting((JSElement)file);
                this.context = prevContext;
            }

            public void visitJSVarStatement(JSVarStatement node) {
                JSVariable[] variables;
                for (JSVariable var : variables = this.isActionScript || this.isTypeScript ? node.getStubSafeVariables() : node.getVariables()) {
                    var.accept((PsiElementVisitor)this);
                }
            }

            public void visitES6ExportDefaultAssignment(ES6ExportDefaultAssignment node) {
                JSElement el = node.getStubSafeElement();
                if (el instanceof JSClass) {
                    this.visitJSClass((JSClass)el);
                }
            }

            public void visitTypeScriptExportAssignment(TypeScriptExportAssignment exportAssignment) {
            }

            public void visitJSParameter(JSParameter node) {
            }

            public void visitJSFunctionExpression(JSFunctionExpression node) {
            }

            public void visitJSProperty(JSProperty node) {
                this.addRelevantDef((JSElement)node);
            }

            public void visitJSObjectLiteralExpression(JSObjectLiteralExpression node) {
            }

            public void visitJSClass(JSClass aClass) {
                this.processUseDirectiveInAttrList((JSAttributeListOwner)aClass);
                this.addRelevantDef((JSElement)aClass);
            }

            public void visitJSPackageStatement(JSPackageStatement packageStatement) {
            }

            public void visitTypeScriptModule(TypeScriptModule module) {
                this.addRelevantDef((JSElement)module);
            }

            public void visitJSFunctionDeclaration(JSFunction node) {
                if (node instanceof ActionScriptFunctionImpl && ((ActionScriptFunctionImpl)node).hasQualifiedName()) {
                    return;
                }
                this.processUseDirectiveInAttrList((JSAttributeListOwner)node);
                this.addRelevantDef((JSElement)node);
                if (this.isTypeScript) {
                    for (JSParameter parameter : node.getParameterVariables()) {
                        if (!TypeScriptPsiUtil.isClassMember(parameter)) continue;
                        this.addRelevantDef((JSElement)parameter);
                    }
                }
            }

            public void visitJSNamespaceDeclaration(JSNamespaceDeclaration namespaceDeclaration) {
                this.addRelevantDef((JSElement)namespaceDeclaration);
            }

            public void visitJSImportStatement(JSImportStatement importStatement) {
            }

            public void visitTypeScriptImportStatement(TypeScriptImportStatement importStatement) {
                this.addRelevantDef((JSElement)importStatement);
            }

            public void visitTypeScriptObjectType(TypeScriptObjectType objectType) {
                for (TypeScriptTypeMember member : objectType.getTypeMembers()) {
                    if (!(member instanceof JSNamedElement)) continue;
                    this.addRelevantDef((JSElement)member);
                }
            }

            public void visitJSUseNamespaceDirective(JSUseNamespaceDirective useNamespaceDirective) {
                String namespaceToBeUsed = useNamespaceDirective.getNamespaceToBeUsed();
                if (namespaceToBeUsed != null) {
                    this.addNamedElement((JSElement)useNamespaceDirective, namespaceToBeUsed.hashCode());
                }
            }

            public void visitES6ImportDeclaration(ES6ImportDeclaration importDeclaration) {
                ES6ImportedBinding[] bindings;
                for (ES6ImportedBinding eS6ImportedBinding : bindings = importDeclaration.getImportedBindings()) {
                    this.addRelevantDef((JSElement)eS6ImportedBinding);
                }
                for (ES6ImportedBinding eS6ImportedBinding : importDeclaration.getImportSpecifiers()) {
                    ES6ImportSpecifierAlias alias = eS6ImportedBinding.getAlias();
                    if (alias != null) {
                        this.addRelevantDef((JSElement)alias);
                        continue;
                    }
                    this.addNamedElement((JSElement)eS6ImportedBinding, eS6ImportedBinding.getReferenceName().hashCode());
                }
            }

            public void visitES6ExportDeclaration(ES6ExportDeclaration exportDeclaration) {
                for (ES6ExportSpecifier specifier : exportDeclaration.getExportSpecifiers()) {
                    ES6ExportSpecifierAlias alias = specifier.getAlias();
                    if (alias != null) {
                        this.addRelevantDef((JSElement)alias);
                        continue;
                    }
                    this.addNamedElement((JSElement)specifier, specifier.getReferenceName().hashCode());
                }
                ES6ExportedDefaultBinding defaultBinding = exportDeclaration.getExportedDefaultBinding();
                if (defaultBinding != null) {
                    this.addRelevantDef((JSElement)defaultBinding);
                }
            }

            public void visitComment(PsiComment comment) {
                if (!JSDirectiveCommentUtil.isDirectiveCommentTokenType(comment)) {
                    return;
                }
                String text = comment.getText();
                int bodyStartIndex = JSDirectiveCommentUtil.getGlobalDirectiveBodyStartIndex(text);
                if (bodyStartIndex > 0 && bodyStartIndex <= text.length() - 2) {
                    text = text.substring(bodyStartIndex, text.length() - 2);
                    StringTokenizer t = new StringTokenizer(text, ",");
                    while (t.hasMoreElements()) {
                        String s = t.nextElement();
                        int i = s.indexOf(58);
                        boolean readOnly = false;
                        if (i != -1) {
                            readOnly = StringUtil.equalsIgnoreCase((CharSequence)"false", (CharSequence)s.substring(i + 1).trim());
                            s = s.substring(0, i);
                        }
                        if (!StringUtil.isJavaIdentifier((String)(s = s.trim()))) continue;
                        EnumSet<JSImplicitElement.Property> properties = EnumSet.of(JSImplicitElement.Property.MinorImportance);
                        if (readOnly) {
                            properties.add(JSImplicitElement.Property.Constant);
                        }
                        JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(s, (PsiElement)comment).setProperties(properties).setType(JSImplicitElement.Type.Variable);
                        this.addRelevantDef((JSElement)new JSImplicitElementImpl(builder));
                    }
                }
            }

            private void addRelevantDef(@NotNull JSElement node) {
                String name;
                if (node == null) {
                    MyJSElementVisitor.$$$reportNull$$$0(0);
                }
                if ((name = node.getName()) != null) {
                    int key = name.hashCode();
                    this.addNamedElement(node, key);
                }
            }

            private void addNamedElement(JSElement node, int key) {
                Object o = this.myRelevantDefs.get(key);
                if (o == null) {
                    this.myRelevantDefs.put(key, (Object)node);
                } else if (o instanceof JSElement) {
                    JSElement[] newO = new JSElement[]{(JSElement)o, node};
                    this.myRelevantDefs.put(key, (Object)newO);
                } else {
                    JSElement[] oldO = (JSElement[])o;
                    JSElement[] newO = new JSElement[oldO.length + 1];
                    System.arraycopy(oldO, 0, newO, 0, oldO.length);
                    newO[oldO.length] = node;
                    this.myRelevantDefs.put(key, (Object)newO);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$RelevantDefsUserDataCache$MyJSElementVisitor", "addRelevantDef"));
            }
        }
    }

    public static interface AllowFileLocalSymbols {
    }

    public static abstract class JSInjectedFilesVisitor
    implements PsiLanguageInjectionHost.InjectedPsiVisitor,
    XmlBackedJSClass.InjectedFileVisitor {
        public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
            if (injectedPsi == null) {
                JSInjectedFilesVisitor.$$$reportNull$$$0(0);
            }
            if (places == null) {
                JSInjectedFilesVisitor.$$$reportNull$$$0(1);
            }
            if (injectedPsi instanceof JSFile) {
                this.process((JSFile)injectedPsi);
            }
        }

        protected abstract void process(JSFile var1);

        public void visit(XmlTag rootTag, JSFile file) {
            this.process(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "injectedPsi";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "places";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$JSInjectedFilesVisitor";
            objectArray[2] = "visit";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class StructureResolveProcessor
    extends ResolveProcessor
    implements Processor<PsiNamedElement> {
        private static final ResolveProcessor.ProcessingOptions ourProcessingOptions = new StructureProcessingOptions();

        public StructureResolveProcessor(String name) {
            super(name);
            this.setLocalResolve(true);
            this.setSkipImplicitDeclarations(true);
            this.setProcessingOptions(ourProcessingOptions);
        }

        public boolean process(PsiNamedElement psiNamedElement) {
            PsiFile containingFile;
            PsiElement context;
            boolean b = true;
            if (psiNamedElement instanceof JSElement && (b = psiNamedElement.processDeclarations((PsiScopeProcessor)this, ResolveState.initial(), (PsiElement)psiNamedElement, (PsiElement)psiNamedElement)) && psiNamedElement instanceof JSFile && (context = psiNamedElement.getContext()) != null && (containingFile = context.getContainingFile()) instanceof XmlFile) {
                b = JSResolveUtil.processAllGlobalsInXmlFile(this, (XmlFile)containingFile, context);
            }
            return b;
        }

        public static class StructureProcessingOptions
        extends ResolveProcessor.ProcessingOptions {
            @Override
            public boolean toProcessFunctionArguments() {
                return false;
            }

            @Override
            public boolean toProcessFunctionBodyDeclarations(@Nullable PsiElement lastParent, @NotNull JSFunction fun) {
                if (fun == null) {
                    StructureProcessingOptions.$$$reportNull$$$0(0);
                }
                return lastParent != null;
            }

            @Override
            public boolean toProcessPackageContent(PsiElement lastParent, JSPackageStatementImpl packageStatement) {
                return lastParent != null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$StructureResolveProcessor$StructureProcessingOptions", "toProcessFunctionBodyDeclarations"));
            }
        }
    }

    public static enum GlobalSymbolsAcceptanceState {
        ACCEPT_ONLY_CLASSES,
        ACCEPT_NO_CLASSES,
        ACCEPT_NAMESPACE_DECLARATIONS,
        WHATEVER;

    }

    public static class GenericSignature {
        public final String genericType;
        public final String elementType;
        public static GenericSignature EMPTY = new GenericSignature(null, null);

        public GenericSignature(String _type, String _genericType) {
            this.elementType = _type;
            this.genericType = _genericType;
        }

        public static String build(String typeName, @Nullable GenericSignature genericSignature) {
            if (genericSignature == null) {
                return typeName;
            }
            return typeName + ".<" + genericSignature.genericType + ">";
        }
    }

    static enum AssignableTypeStatus {
        OK,
        LANG_IMPLICIT_COERCION,
        COMPILE_TIME_FAIL;

    }
}

