/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextElement;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JSEvaluationResultContext {
    public static final JSEvaluationResultContext EMPTY = new JSEvaluationResultContextImpl(Collections.emptyList(), false, null);

    @Nullable
    public JSApplyContextElement peekJSElementToApply();

    public boolean isJSElementsToApplyEmpty();

    public boolean isTypeGuessed();

    public Collection<JSApplyContextElement> getJSElementsToApply();

    public boolean isEquivalentTo(JSEvaluationResultContext var1);

    @Nullable
    public PsiElement getLocalScope();

    public static class JSEvaluationResultContextImpl
    implements JSEvaluationResultContext {
        private final List<JSApplyContextElement> myJSElementsToApply;
        private final boolean myTypeIsGuessed;
        @Nullable
        private final PsiElement myLocalScope;

        private JSEvaluationResultContextImpl(Collection<JSApplyContextElement> jsElementsToApply, boolean typeIsGuessed, @Nullable PsiElement localScope) {
            this.myJSElementsToApply = ContainerUtil.immutableList((Object[])jsElementsToApply.toArray(new JSApplyContextElement[jsElementsToApply.size()]));
            this.myTypeIsGuessed = typeIsGuessed;
            this.myLocalScope = localScope;
        }

        @NotNull
        public static JSEvaluationResultContext copyFrom(@Nullable JSEvaluationResultContext other) {
            if (other == null || other.isJSElementsToApplyEmpty() && !other.isTypeGuessed() && other.getLocalScope() == null) {
                JSEvaluationResultContext jSEvaluationResultContext = EMPTY;
                if (jSEvaluationResultContext == null) {
                    JSEvaluationResultContextImpl.$$$reportNull$$$0(0);
                }
                return jSEvaluationResultContext;
            }
            JSEvaluationResultContextImpl jSEvaluationResultContextImpl = new JSEvaluationResultContextImpl(other.getJSElementsToApply(), other.isTypeGuessed(), other.getLocalScope());
            if (jSEvaluationResultContextImpl == null) {
                JSEvaluationResultContextImpl.$$$reportNull$$$0(1);
            }
            return jSEvaluationResultContextImpl;
        }

        @Override
        @Nullable
        public JSApplyContextElement peekJSElementToApply() {
            return this.myJSElementsToApply.get(this.myJSElementsToApply.size() - 1);
        }

        @Override
        public boolean isJSElementsToApplyEmpty() {
            return this.myJSElementsToApply.isEmpty();
        }

        @Override
        public boolean isTypeGuessed() {
            return this.myTypeIsGuessed;
        }

        @Override
        public Collection<JSApplyContextElement> getJSElementsToApply() {
            return this.myJSElementsToApply;
        }

        @Override
        @Nullable
        public PsiElement getLocalScope() {
            return this.myLocalScope;
        }

        @Override
        public boolean isEquivalentTo(@NotNull JSEvaluationResultContext other) {
            if (other == null) {
                JSEvaluationResultContextImpl.$$$reportNull$$$0(2);
            }
            return JSEvaluationResultContextImpl.areEvaluationContextsEquivalent(this, other);
        }

        public static boolean areEvaluationContextsEquivalent(@NotNull JSEvaluationResultContext obj1, @NotNull JSEvaluationResultContext obj2) {
            if (obj1 == null) {
                JSEvaluationResultContextImpl.$$$reportNull$$$0(3);
            }
            if (obj2 == null) {
                JSEvaluationResultContextImpl.$$$reportNull$$$0(4);
            }
            return obj1.isTypeGuessed() == obj2.isTypeGuessed() && obj1.getJSElementsToApply().equals(obj2.getJSElementsToApply()) && obj1.getLocalScope() == obj2.getLocalScope();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSEvaluationResultContext$JSEvaluationResultContextImpl";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj1";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copyFrom";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSEvaluationResultContext$JSEvaluationResultContextImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isEquivalentTo";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "areEvaluationContextsEquivalent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

