/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSGenericsIndex;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDocReference
extends JSTextReference {
    private final boolean myMethodRef;

    protected JSDocReference(@NotNull JSReferenceSet set, @NotNull String s, @NotNull TextRange rangeInElement, boolean methodRef) {
        if (set == null) {
            JSDocReference.$$$reportNull$$$0(0);
        }
        if (s == null) {
            JSDocReference.$$$reportNull$$$0(1);
        }
        if (rangeInElement == null) {
            JSDocReference.$$$reportNull$$$0(2);
        }
        super(set, s, rangeInElement);
        this.myMethodRef = methodRef;
    }

    @Override
    @NotNull
    protected ResolveResult[] doResolve() {
        String name;
        if ("int".equals(this.myCanonicalText) || "uint".equals(this.myCanonicalText) || ("Null".equals(this.myCanonicalText) || "null".equals(this.myCanonicalText) || "Undefined".equals(this.myCanonicalText)) && this.getElement() instanceof JSDocTagValue) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new JSResolveResult(this.mySet.getElement())};
            if (resolveResultArray == null) {
                JSDocReference.$$$reportNull$$$0(3);
            }
            return resolveResultArray;
        }
        if (this.mySet.getElement() instanceof JSDocTagValue && this.myRangeInElement.getStartOffset() == 0 && this.mySet.getReferences().length == 1 && "property".equals(name = ((JSDocTag)this.mySet.getElement().getParent()).getName())) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new JSResolveResult(this.mySet.getElement())};
            if (resolveResultArray == null) {
                JSDocReference.$$$reportNull$$$0(4);
            }
            return resolveResultArray;
        }
        ResolveResult[] resolveResultArray = this.doResolve(this.getNameForSymbolResolve());
        if (resolveResultArray == null) {
            JSDocReference.$$$reportNull$$$0(5);
        }
        return resolveResultArray;
    }

    private String getNameForSymbolResolve() {
        PsiElement elt = this.getElement();
        if ((elt instanceof JSDocTagValue || elt instanceof JSDocComment) && this.mySet.getReferences().length == 1 && this.mySet.getReferences()[this.mySet.getReferences().length - 1] == this && !this.myMethodRef) {
            return JSDocumentationUtils.doCapitalizeCommentTypeIfNeeded(this.myCanonicalText);
        }
        return this.myCanonicalText;
    }

    @Override
    @NotNull
    public JSQualifiedName getQualifiedName() {
        JSQualifiedName name;
        if (this.mySet.getReferences().length == 1 && this.myRangeInElement.getStartOffset() > 0 && (name = this.buildQualifiedNameForRelativeLink()) != null) {
            JSQualifiedName jSQualifiedName = name;
            if (jSQualifiedName == null) {
                JSDocReference.$$$reportNull$$$0(6);
            }
            return jSQualifiedName;
        }
        JSQualifiedName jSQualifiedName = super.getQualifiedName();
        if (jSQualifiedName == null) {
            JSDocReference.$$$reportNull$$$0(7);
        }
        return jSQualifiedName;
    }

    @Nullable
    private JSQualifiedName buildQualifiedNameForRelativeLink() {
        JSExpression expression;
        PsiElement elt = this.findNearestClass();
        if (this.myMethodRef && elt instanceof JSExpressionStatement && (expression = ((JSExpressionStatement)elt).getExpression()) instanceof JSAssignmentExpression) {
            JSExpression jsExpression = ((JSAssignmentExpression)expression).getLOperand();
            if (jsExpression instanceof JSDefinitionExpression) {
                jsExpression = ((JSDefinitionExpression)jsExpression).getExpression();
            }
            if (jsExpression instanceof JSReferenceExpression) {
                String qualifier;
                JSExpression rOperand = ((JSAssignmentExpression)expression).getROperand();
                boolean stripQualifier = true;
                if (rOperand instanceof JSFunction && ((JSFunction)rOperand).isConstructor()) {
                    stripQualifier = false;
                }
                if (stripQualifier) {
                    jsExpression = ((JSReferenceExpression)jsExpression).getQualifier();
                }
                if (jsExpression != null && (qualifier = JSContextResolver.getQualifierOfExprAsString((JSElement)jsExpression)) != null) {
                    ArrayList<String> contextNames = new ArrayList<String>(3);
                    BaseJSSymbolProcessor.addIndexListFromQName(qualifier, contextNames);
                    return this.qNameFromNames(contextNames);
                }
            }
        }
        return null;
    }

    @Override
    public void processLocalVariants(PsiFile psiFile, SinkResolveProcessor<?> processor, PsiElement context) {
        JSDocComment docComment = (JSDocComment)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), JSDocComment.class);
        if (docComment != null) {
            List currentParameters = docComment.getGenericParameters();
            if (!currentParameters.isEmpty()) {
                JSDocReference.processGenericParameters(currentParameters, docComment, processor);
            } else {
                List parameters;
                JSDocComment definitionComment;
                JSQualifiedName namespace;
                PsiElement element2 = JSDocumentationUtils.findAttachedElementFromComment((PsiComment)docComment);
                if (element2 instanceof JSQualifiedNamedElement && (namespace = ((JSQualifiedNamedElement)element2).getNamespace()) != null && (definitionComment = JSGenericsIndex.findGenericParametersComment(namespace.getQualifiedName(), GlobalSearchScope.fileScope((PsiFile)psiFile))) != null && !(parameters = definitionComment.getGenericParameters()).isEmpty()) {
                    JSDocReference.processGenericParameters(parameters, definitionComment, processor);
                }
            }
        }
        if (this.myMethodRef && docComment != null) {
            PsiElement next = JSDocumentationUtils.findAttachedElementFromComment((PsiComment)docComment);
            if (next instanceof JSProperty) {
                JSResolveUtil.treeWalkUp(processor, this.mySet.getElement(), this.mySet.getElement(), next);
            }
        } else {
            this.doProcessLocalVariants(psiFile, processor, context, (Condition<PsiElement>)((Condition)element -> true));
        }
    }

    private static void processGenericParameters(@NotNull List<String> parameters, @NotNull JSDocComment comment, @NotNull SinkResolveProcessor<?> processor) {
        if (parameters == null) {
            JSDocReference.$$$reportNull$$$0(8);
        }
        if (comment == null) {
            JSDocReference.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            JSDocReference.$$$reportNull$$$0(10);
        }
        for (String parameter : parameters) {
            processor.execute((PsiElement)new JSImplicitElementImpl(parameter, (PsiElement)comment), ResolveState.initial());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocReference";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocReference";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolve";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processGenericParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

