/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.psi.impl.JSReferenceSetElement;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReferenceSet {
    protected String myReferenceText;
    protected int myOffset;
    protected PsiReference[] myReferences;
    @NotNull
    final PsiElement element;
    private final boolean isSoft;
    final boolean onlyFqns;
    protected boolean myOnlyDefaultPackage;
    @Nullable
    Collection<String> myBaseClassFqns;
    @Nullable
    LocalQuickFixProvider myLocalQuickFixProvider;

    public JSReferenceSet(@NotNull PsiElement element, String text, int offset, boolean soft) {
        if (element == null) {
            JSReferenceSet.$$$reportNull$$$0(0);
        }
        this(element, text, offset, soft, false);
    }

    public JSReferenceSet(@NotNull PsiElement element, String text, int offset, boolean soft, boolean _onlyFqns) {
        if (element == null) {
            JSReferenceSet.$$$reportNull$$$0(1);
        }
        this.element = element;
        this.isSoft = soft;
        this.myReferenceText = text;
        this.myOffset = offset;
        this.myReferences = this.reparse(text, offset);
        this.onlyFqns = _onlyFqns;
    }

    public JSReferenceSet(@NotNull PsiElement element, boolean soft) {
        if (element == null) {
            JSReferenceSet.$$$reportNull$$$0(2);
        }
        this.element = element;
        this.isSoft = soft;
        this.onlyFqns = false;
    }

    public JSReferenceSet(@NotNull PsiElement element) {
        if (element == null) {
            JSReferenceSet.$$$reportNull$$$0(3);
        }
        this(element, true);
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.element;
        if (psiElement == null) {
            JSReferenceSet.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    public void setBaseClassFqns(@NotNull Collection<String> baseClassFqns) {
        if (baseClassFqns == null) {
            JSReferenceSet.$$$reportNull$$$0(5);
        }
        this.myBaseClassFqns = new ArrayList<String>(baseClassFqns);
    }

    public String[] getBaseClassFqns() {
        return this.myBaseClassFqns == null ? ArrayUtil.EMPTY_STRING_ARRAY : ArrayUtil.toStringArray(this.myBaseClassFqns);
    }

    public PsiReference[] getReferences() {
        return this.myReferences;
    }

    public void update(String text, int offset) {
        if (this.myReferences != null && this.myReferenceText != null && this.myReferenceText.equals(text) && this.myOffset == offset) {
            return;
        }
        this.myReferenceText = text;
        this.myOffset = offset;
        this.myReferences = StringUtil.startsWithChar((CharSequence)text, (char)'\"') || StringUtil.startsWithChar((CharSequence)text, (char)'\'') ? this.reparse(JSStringUtil.unquoteAndUnescapeString(text), offset + 1) : PsiReference.EMPTY_ARRAY;
    }

    protected PsiReference[] reparse(String value, int offset) {
        ArrayList<JSReferenceSetElement> refs = new ArrayList<JSReferenceSetElement>(1);
        int lastPos = 0;
        int dotPos = this.findSeparatorPosition(value, lastPos);
        while (dotPos != -1) {
            String s = value.substring(lastPos, dotPos).trim();
            if (s.length() > 0) {
                refs.add(this.createTextReference(s, offset + lastPos));
            }
            lastPos = dotPos + 1;
            dotPos = this.findSeparatorPosition(value, lastPos);
        }
        int end = value.length();
        String substring = value.substring(lastPos, end);
        String s = substring.trim();
        if (s.length() > 0) {
            int index;
            for (index = 0; index < substring.length() && Character.isWhitespace(substring.charAt(index)); ++index) {
            }
            refs.add(this.createTextReference(s, offset + lastPos + index));
        }
        return refs.size() > 0 ? refs.toArray(new PsiReference[refs.size()]) : PsiReference.EMPTY_ARRAY;
    }

    protected JSReferenceSetElement createTextReference(String s, int offset) {
        return new JSTextReference(this, s, offset);
    }

    protected int findSeparatorPosition(String s, int fromIndex) {
        if (StringUtil.isQuotedString((String)s)) {
            return -1;
        }
        return s.indexOf(46, fromIndex);
    }

    public boolean isSoft() {
        return this.isSoft;
    }

    public void setLocalQuickFixProvider(@Nullable LocalQuickFixProvider localQuickFixProvider) {
        this.myLocalQuickFixProvider = localQuickFixProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSReferenceSet";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClassFqns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSReferenceSet";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setBaseClassFqns";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

