/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.stubs.JSVariableStub;
import com.intellij.lang.javascript.psi.stubs.JSVariableStubBase;
import com.intellij.lang.javascript.psi.types.JSDestructuringTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Segment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptVariableImpl
extends JSVariableImpl<JSVariableStub<JSVariable>, JSVariable>
implements TypeScriptVariable {
    public TypeScriptVariableImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptVariableImpl(JSVariableStub<JSVariable> stub, JSStubElementType<JSVariableStub<JSVariable>, JSVariable> signature) {
        super(stub, signature);
    }

    protected JSType doGetDeclarationTypeStubSafe() {
        return TypeScriptPsiUtil.getTypeFromDeclaration(this);
    }

    @Override
    @Nullable
    protected final JSType doGetType() {
        JSType type = this.doGetDeclarationTypeStubSafe();
        if (type != null) {
            return type;
        }
        if (this.hasInitializer()) {
            PsiElement parent = this.getParent();
            if (JSDestructuringUtil.isDestructuring(parent)) {
                return new JSDestructuringTypeImpl((Segment)this.getTextRange(), JSTypeSourceFactory.createTypeSource((PsiElement)this, true));
            }
            JSExpression initializer = this.getInitializer();
            if (initializer != null) {
                if (initializer instanceof JSLiteralExpression) {
                    JSType typeFromConstant = JSTypeEvaluator.getTypeFromConstant(initializer);
                    if (this.isConst() && typeFromConstant != null) {
                        return typeFromConstant;
                    }
                    JSType possibleType = JSTypeUtils.getApparentType(typeFromConstant);
                    if (possibleType != null) {
                        return possibleType;
                    }
                }
                return new JSTypeofTypeImpl(initializer, JSTypeSourceFactory.createTypeSource((PsiElement)this, true));
            }
        }
        return null;
    }

    @Override
    protected final JSType doGetStubType(JSVariableStub<JSVariable> stub) {
        String typeString = stub.getTypeString();
        if (typeString == null) {
            return this.doGetDeclarationTypeStubSafe();
        }
        return TypeScriptVariableImpl.getTypeFromStubString(this, stub, typeString);
    }

    @Nullable
    public static JSType getTypeFromStubString(@NotNull JSVariable variable, @NotNull JSVariableStubBase<?> stub, @NotNull String typeString) {
        if (variable == null) {
            TypeScriptVariableImpl.$$$reportNull$$$0(0);
        }
        if (stub == null) {
            TypeScriptVariableImpl.$$$reportNull$$$0(1);
        }
        if (typeString == null) {
            TypeScriptVariableImpl.$$$reportNull$$$0(2);
        }
        return JSTypeUtils.parseSerializedType(typeString, JSTypeSourceFactory.createTypeSource((PsiElement)variable, stub.isTypeStrict()));
    }

    @Override
    public boolean isLocal() {
        return PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)this, JSFunction.class) != null;
    }

    public TypeScriptType getTypeElement() {
        return TypeScriptPsiUtil.getStubOrPsiTypeElement(this);
    }

    @Override
    @Nullable
    protected String doGetName() {
        boolean computed;
        JSVariableStub stub = (JSVariableStub)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        String name = TypeScriptPsiUtil.getNameFromIdentifier(this.findNameIdentifier());
        if (name != null) {
            return name;
        }
        ASTNode nameNode = JSPsiImplUtils.getComputedNameOfVariable(this.getNode(), false);
        boolean bl = computed = nameNode != null;
        if (nameNode == null) {
            nameNode = JSPsiImplUtils.findFallbackNameIdentifierOfVariable(this.getNode().getFirstChildNode());
        }
        return TypeScriptVariableImpl.getResultNameFromNameNode(nameNode, computed);
    }

    @Override
    protected boolean useLocalSearchScope(@Nullable PsiElement declarationScope) {
        return super.useLocalSearchScope(declarationScope) && !(declarationScope instanceof TypeScriptModule);
    }

    @Override
    @NotNull
    protected JSAttributeList.AccessType calcAccessType() {
        JSAttributeList attributeList = this.getAttributeList();
        JSAttributeList.AccessType accessType = attributeList != null ? attributeList.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL;
        if (accessType == null) {
            TypeScriptVariableImpl.$$$reportNull$$$0(3);
        }
        return accessType;
    }

    @Override
    @Deprecated
    @Nullable
    public String getTypeString() {
        JSType type = this.getType();
        return type == null ? null : type.getTypeText(JSType.TypeTextFormat.SERIALIZED);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeString";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptVariableImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptVariableImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "calcAccessType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromStubString";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

