/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.diagramm;

import com.intellij.diagram.DiagramEdgeBase;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramRelationshipInfoAdapter;
import com.intellij.diagram.presentation.DiagramLineType;
import com.intellij.lang.javascript.modules.diagramm.JSStructuralDiagramItem;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStructuralUiEdge
extends DiagramEdgeBase<JSStructuralDiagramItem> {
    private final List<Pair<String, String>> myLinks;
    private Color myColor;
    private String myProviderName;

    public JSStructuralUiEdge(@NotNull DiagramNode<JSStructuralDiagramItem> source, @NotNull DiagramNode<JSStructuralDiagramItem> target) {
        if (source == null) {
            JSStructuralUiEdge.$$$reportNull$$$0(0);
        }
        if (target == null) {
            JSStructuralUiEdge.$$$reportNull$$$0(1);
        }
        super(source, target, (DiagramRelationshipInfo)new DiagramRelationshipInfoAdapter("", DiagramLineType.SOLID){

            public Shape getStartArrow() {
                return STANDARD;
            }

            public Shape getEndArrow() {
                return NONE;
            }
        });
        this.myLinks = new ArrayList<Pair<String, String>>();
    }

    public void links(String source, String target) {
        this.myLinks.add((Pair<String, String>)Pair.create((Object)source, (Object)target));
    }

    @Nullable
    public String getTooltip() {
        if (this.myLinks.isEmpty()) {
            return null;
        }
        List parts = this.myLinks.stream().map(l -> ((String)l.getFirst()).equals(l.getSecond()) ? (String)l.getFirst() : (String)l.getFirst() + "->" + (String)l.getSecond()).collect(Collectors.toList());
        return XmlStringUtil.wrapInHtml((CharSequence)(StringUtil.join(parts, (String)"<br/>") + (this.myProviderName != null ? " (" + this.myProviderName + ")" : "")));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JSStructuralUiEdge edge = (JSStructuralUiEdge)((Object)o);
        return !(this.myLinks != null ? !this.myLinks.equals(edge.myLinks) : edge.myLinks != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myLinks != null ? this.myLinks.hashCode() : 0);
        return result;
    }

    public void setColor(Color color) {
        this.myColor = color;
    }

    public Color getColor() {
        return this.myColor;
    }

    public void setProviderName(String providerName) {
        this.myProviderName = providerName;
    }

    public boolean isLinks(@NotNull String source, @NotNull String target) {
        if (source == null) {
            JSStructuralUiEdge.$$$reportNull$$$0(2);
        }
        if (target == null) {
            JSStructuralUiEdge.$$$reportNull$$$0(3);
        }
        return this.myLinks.contains(Pair.create((Object)source, (Object)target));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/modules/diagramm/JSStructuralUiEdge";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isLinks";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

