/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSXHarmonyLanguageDialect;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.modules.ImportCommonJSModuleFix;
import com.intellij.lang.javascript.modules.ImportJSModuleBaseFix;
import com.intellij.lang.javascript.modules.JSLiteralExpressionReferenceInfo;
import com.intellij.lang.javascript.modules.JSModuleReferenceExpressionInfo;
import com.intellij.lang.javascript.modules.JsModulesSuggester;
import com.intellij.lang.javascript.modules.LocalReferenceResolver;
import com.intellij.lang.javascript.modules.ModuleReferenceInfo;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSBaseModulesDependenciesElementVisitor
extends JSElementVisitor {
    private static final Key<Set<VirtualFile>> ourPredefinedLibrariesKey = Key.create((String)"NodeJs.Predefined.Libraies");
    private static final Key<Set<String>> ourDefines = Key.create((String)"NodeJs.Defined.Variables");
    protected final LocalInspectionToolSession mySession;
    private final ProblemsHolder myHolder;
    private final boolean myOnTheFly;

    public JSBaseModulesDependenciesElementVisitor(LocalInspectionToolSession session, ProblemsHolder holder, boolean onTheFly) {
        this.mySession = session;
        this.myHolder = holder;
        this.myOnTheFly = onTheFly;
    }

    public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
        if (node == null) {
            JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(0);
        }
        if (!DialectDetector.isJavaScript((PsiElement)node.getContainingFile()) || !JSBaseModulesDependenciesElementVisitor.checkContext(node)) {
            return;
        }
        JSExpression qualifier = node.getQualifier();
        if (qualifier != null) {
            return;
        }
        ProblemHighlightType unresolvedReferenceHighlightType = JSBaseModulesDependenciesElementVisitor.getUnresolvedReferenceHighlightType(node);
        if (!ProblemHighlightType.LIKE_UNKNOWN_SYMBOL.equals((Object)unresolvedReferenceHighlightType)) {
            return;
        }
        if (JSChangeUtil.isWellKnownPredefined(StringUtil.notNullize((String)node.getText()))) {
            return;
        }
        JSModuleReferenceExpressionInfo moduleReferenceInfo = new JSModuleReferenceExpressionInfo(node);
        if (moduleReferenceInfo.getContextName() == null) {
            return;
        }
        if (JSChangeUtil.isWellKnownPredefined(StringUtil.notNullize((String)moduleReferenceInfo.getParentName()))) {
            return;
        }
        JsModulesSuggester modulesSuggester = this.createSuggester((PsiElement)node, moduleReferenceInfo);
        if (modulesSuggester == null) {
            return;
        }
        ResolveResult[] resolveResults = node.multiResolve(false);
        this.processResolvedElements((PsiElement)node, moduleReferenceInfo, modulesSuggester, resolveResults);
    }

    private static boolean checkContext(JSReferenceExpression node) {
        JSEmbeddedContent embeddedContent = (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)node, JSEmbeddedContent.class);
        if (embeddedContent != null) {
            PsiElement parent = embeddedContent.getParent();
            return parent.getNode().getElementType() != XmlElementType.XML_ATTRIBUTE_VALUE;
        }
        return true;
    }

    public void visitJSLiteralExpression(JSLiteralExpression node) {
        if (!(node instanceof JSXmlLiteralExpressionImpl) || !DialectDetector.isJSX((PsiElement)node.getContainingFile())) {
            return;
        }
        String name = node.getName();
        if (!StringUtil.isCapitalized((String)name)) {
            return;
        }
        JSXmlLiteralExpressionImpl xmlLiteralExpression = (JSXmlLiteralExpressionImpl)node;
        boolean isResolved = JSXHarmonyLanguageDialect.areReferencesResolvedOrEmpty(xmlLiteralExpression);
        if (isResolved) {
            return;
        }
        JSLiteralExpressionReferenceInfo moduleReferenceInfo = new JSLiteralExpressionReferenceInfo(xmlLiteralExpression);
        JsModulesSuggester modulesSuggester = this.createSuggester((PsiElement)node, moduleReferenceInfo);
        if (modulesSuggester == null) {
            return;
        }
        this.processResolvedElements((PsiElement)node, moduleReferenceInfo, modulesSuggester, ResolveResult.EMPTY_ARRAY);
    }

    private void processResolvedElements(@NotNull PsiElement node, @NotNull ModuleReferenceInfo moduleReferenceInfo, @NotNull JsModulesSuggester modulesSuggester, @NotNull ResolveResult[] resolveResults) {
        if (node == null) {
            JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(1);
        }
        if (moduleReferenceInfo == null) {
            JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(2);
        }
        if (modulesSuggester == null) {
            JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(3);
        }
        if (resolveResults == null) {
            JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(4);
        }
        if (!JSBaseModulesDependenciesElementVisitor.shouldAddFixes(node, resolveResults, modulesSuggester)) {
            return;
        }
        String inspectionText = this.getInspectionText();
        MultiMap<PsiElement, LocalQuickFix> fixes = modulesSuggester.findFixes(resolveResults);
        if (fixes.isEmpty()) {
            return;
        }
        boolean isFirst = true;
        for (Map.Entry entry : fixes.entrySet()) {
            Collection<LocalQuickFix> list = (Collection<LocalQuickFix>)entry.getValue();
            if ((list = JSBaseModulesDependenciesElementVisitor.sortAndFilter(list, moduleReferenceInfo)).isEmpty()) {
                return;
            }
            if (isFirst) {
                if (!this.checkDefines(this.mySession, list)) {
                    return;
                }
                isFirst = false;
            }
            PsiElement currentElement = (PsiElement)entry.getKey();
            ProblemHighlightType highlightType = JSBaseModulesDependenciesElementVisitor.getProblemHighlightType(currentElement);
            PsiReference reference = currentElement.getReference();
            if (reference == null) continue;
            this.myHolder.registerProblemForReference(reference, highlightType, inspectionText, list.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    private static ProblemHighlightType getProblemHighlightType(PsiElement element) {
        if (element instanceof JSReferenceExpression) {
            ResolveResult[] results = ((JSReferenceExpression)element).multiResolve(false);
            return results.length == 1 && !results[0].isValidResult() ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        }
        return ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
    }

    protected abstract String getInspectionText();

    @Nullable
    protected abstract JsModulesSuggester createSuggester(@NotNull PsiElement var1, @NotNull ModuleReferenceInfo var2);

    @NotNull
    public static Collection<LocalQuickFix> sortAndFilter(@NotNull Collection<LocalQuickFix> fixes, ModuleReferenceInfo moduleReferenceInfo) {
        if (fixes == null) {
            JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(5);
        }
        ArrayList<LocalQuickFix> sublist = new ArrayList<LocalQuickFix>();
        for (LocalQuickFix fix : fixes) {
            String path;
            if (!(fix instanceof ImportCommonJSModuleFix) || !(path = ((ImportCommonJSModuleFix)fix).getPath()).equals(moduleReferenceInfo.getContextName()) && !path.startsWith(moduleReferenceInfo.getContextName() + "/")) continue;
            sublist.add(fix);
        }
        if (!sublist.isEmpty()) {
            ArrayList<LocalQuickFix> arrayList = sublist;
            if (arrayList == null) {
                JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(6);
            }
            return arrayList;
        }
        Collection<LocalQuickFix> collection = fixes;
        if (collection == null) {
            JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(7);
        }
        return collection;
    }

    private static ProblemHighlightType getUnresolvedReferenceHighlightType(JSReferenceExpression node) {
        if (node.getQualifier() == null && node.getParent() instanceof JSDefinitionExpression && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
            return ProblemHighlightType.ERROR;
        }
        return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
    }

    private static boolean shouldAddFixes(@NotNull PsiElement refExpression, @NotNull ResolveResult[] resolveResults, @NotNull JsModulesSuggester modulesSuggester) {
        PsiFile file;
        if (refExpression == null) {
            JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(8);
        }
        if (resolveResults == null) {
            JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(9);
        }
        if (modulesSuggester == null) {
            JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(10);
        }
        if (new LocalReferenceResolver(file = refExpression.getContainingFile()).checkResolveResults(resolveResults)) {
            return false;
        }
        if (resolveResults.length == 0) {
            return true;
        }
        for (ResolveResult result : resolveResults) {
            if (result instanceof JSResolveResult && ((JSResolveResult)result).getES6Import() != null) {
                return false;
            }
            if (!modulesSuggester.isResolvedGlobally(result)) continue;
            return false;
        }
        return true;
    }

    private boolean checkDefines(@NotNull LocalInspectionToolSession session, @NotNull Collection<LocalQuickFix> fixes) {
        String varName;
        if (session == null) {
            JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(11);
        }
        if (fixes == null) {
            JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(12);
        }
        if (this.myOnTheFly) {
            return true;
        }
        if (fixes.isEmpty()) {
            return false;
        }
        Set data = (Set)session.getUserData(ourDefines);
        ImportJSModuleBaseFix item = (ImportJSModuleBaseFix)ContainerUtil.getFirstItem(fixes);
        String string = varName = item == null ? null : item.getVarName();
        if (data != null && data.contains(varName)) {
            return false;
        }
        data = data == null ? new HashSet() : data;
        data.add(varName);
        session.putUserData(ourDefines, (Object)data);
        return true;
    }

    @NotNull
    public static Set<VirtualFile> cacheAndGetPredefinedLibraries(Project project, LocalInspectionToolSession session) {
        Set libraryFiles = (Set)session.getUserData(ourPredefinedLibrariesKey);
        if (libraryFiles != null) {
            Set set = libraryFiles;
            if (set == null) {
                JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(13);
            }
            return set;
        }
        libraryFiles = ContainerUtil.newHashSet(JSLibraryManager.getInstance(project).getRequiredLibraryFiles());
        PsiFile psiFile = session.getFile();
        VirtualFile file = psiFile.getVirtualFile();
        if (file != null) {
            JSLibraryMappings libraryMappings = JSLibraryMappings.getInstance(psiFile.getProject());
            Set result = libraryFiles;
            libraryMappings.forEachLibraryInScopeForFile(file, model -> model.collectFilesWithGlobalDefinitions((Collection)result));
        }
        session.putUserData(ourPredefinedLibrariesKey, (Object)libraryFiles);
        Set set = libraryFiles;
        if (set == null) {
            JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(14);
        }
        return set;
    }

    public static boolean isForBrowser(@NotNull Project project, @NotNull VirtualFile vf) {
        if (project == null) {
            JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(15);
        }
        if (vf == null) {
            JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(16);
        }
        JSLibraryMappings mappings = JSLibraryMappings.getInstance(project);
        return mappings.isLibraryInScopeFor(vf, "HTML");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleReferenceInfo";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesSuggester";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 6: 
            case 7: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/JSBaseModulesDependenciesElementVisitor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpression";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/JSBaseModulesDependenciesElementVisitor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "sortAndFilter";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "cacheAndGetPredefinedLibraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitJSReferenceExpression";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processResolvedElements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sortAndFilter";
                break;
            }
            case 6: 
            case 7: 
            case 13: 
            case 14: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddFixes";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkDefines";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isForBrowser";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

