/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.macro;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.macro.JSMacroUtil;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class JSSuggestVariableNameMacro
extends Macro {
    public String getName() {
        return "jsSuggestVariableName";
    }

    public String getPresentableName() {
        return JSBundle.message((String)"macro.js.suggest.variable.name", (Object[])new Object[0]);
    }

    @NotNull
    public String getDefaultValue() {
        if ("o" == null) {
            JSSuggestVariableNameMacro.$$$reportNull$$$0(0);
        }
        return "o";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        String[] names;
        if (params == null) {
            JSSuggestVariableNameMacro.$$$reportNull$$$0(1);
        }
        if ((names = JSSuggestVariableNameMacro.getNames(context)) == null || names.length == 0) {
            return null;
        }
        return new TextResult(names[0]);
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        String[] names;
        if (params == null) {
            JSSuggestVariableNameMacro.$$$reportNull$$$0(2);
        }
        if ((names = JSSuggestVariableNameMacro.getNames(context)) == null || names.length < 2) {
            return null;
        }
        LookupElement[] items = new LookupElement[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            items[i] = LookupElementBuilder.create((String)name);
        }
        return items;
    }

    private static String[] getNames(ExpressionContext context) {
        String type;
        PsiElement var;
        PsiElement element = JSMacroUtil.getElementFromContext(context);
        if (element != null && element.getNode() != null && element.getNode().getElementType() == JSTokenTypes.IDENTIFIER && (var = element.getParent().getParent()) instanceof JSVariable && !StringUtil.isEmpty((String)(type = ((JSVariable)var).getTypeString()))) {
            if ((type = StringUtil.getShortName((String)type)).length() > 2 && type.charAt(0) == 'I' && Character.isUpperCase(type.charAt(1)) && !Character.isUpperCase(type.charAt(2))) {
                type = type.substring(1);
            }
            JSNamedElement[] usedNames = JSMacroUtil.getNamedElementsVisibleAt(context, false);
            ArrayList<String> names = new ArrayList<String>();
            if ("int".equals(type)) {
                names.add(JSSuggestVariableNameMacro.makeNameUnique("i", usedNames));
            } else {
                for (String name : NameUtil.getSuggestionsByName((String)type, (String)"", (String)"", (boolean)false, (boolean)false, (boolean)false)) {
                    if (name.equals(type)) continue;
                    names.add(JSSuggestVariableNameMacro.makeNameUnique(name, usedNames));
                }
            }
            return ArrayUtil.toStringArray(names);
        }
        return new String[]{JSSuggestVariableNameMacro.makeNameUnique("obj", JSMacroUtil.getNamedElementsVisibleAt(context))};
    }

    private static String makeNameUnique(String name, JSNamedElement[] namedElements) {
        String uniqueName = name;
        boolean needToChangeName = false;
        for (JSNamedElement namedElement : namedElements) {
            if (!name.equals(namedElement.getName())) continue;
            needToChangeName = true;
            break;
        }
        if (needToChangeName) {
            int i = 1;
            block1: while (true) {
                uniqueName = name + i;
                for (JSNamedElement namedElement : namedElements) {
                    if (!uniqueName.equals(namedElement.getName())) {
                        continue;
                    }
                    ++i;
                    continue block1;
                }
                break;
            }
        }
        return uniqueName;
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return JSMacroUtil.isJSLikeContext(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/macro/JSSuggestVariableNameMacro";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/macro/JSSuggestVariableNameMacro";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calculateResult";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calculateLookupItems";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

