/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.intellij.lang.javascript.linter.jshint.JSHintOption;
import com.intellij.lang.javascript.linter.jshint.JSHintOptionGroup;
import com.intellij.lang.javascript.linter.jshint.JSHintTreeNode;
import com.intellij.lang.javascript.linter.jshint.JSHintUtil;
import com.intellij.lang.javascript.linter.option.OptionEnumType;
import com.intellij.lang.javascript.linter.option.OptionEnumVariant;
import com.intellij.lang.javascript.linter.option.OptionTypes;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.Gray;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintTreeCellRenderer
extends CheckboxTree.CheckboxTreeCellRenderer {
    private static final Object LINK_MARKER = new Object();
    private JSHintTreeNode myCurrentNode;

    public JSHintTreeCellRenderer() {
        super(false);
    }

    public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JSHintTreeNode node = (JSHintTreeNode)((Object)ObjectUtils.tryCast((Object)value, JSHintTreeNode.class));
        if (node != null) {
            this.doCustomizeRenderer(node, selected);
        }
    }

    private void doCustomizeRenderer(JSHintTreeNode node, boolean selected) {
        this.myCurrentNode = node;
        Color background = selected ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeTextBackground();
        UIUtil.changeBackGround((Component)((Object)this), (Color)background);
        Color foreground = selected ? UIUtil.getTreeSelectionForeground() : UIUtil.getTreeTextForeground();
        JSHintOption option = node.getUserDataAsOption();
        JSHintOptionGroup optionGroup = node.getUserDataAsOptionGroup();
        int style = option != null ? 0 : 1;
        ColoredTreeCellRenderer textRenderer = this.getTextRenderer();
        textRenderer.setEnabled(node.isEnabled());
        if (optionGroup != null) {
            textRenderer.append(optionGroup.getTitle(), new SimpleTextAttributes(null, foreground, null, 1));
        } else {
            if (option == null) {
                throw new NullPointerException();
            }
            if (node.isEditLinkNeeded()) {
                this.myCheckbox.setVisible(false);
            }
            JSHintTreeCellRenderer.appendShortDescription(option, foreground, (SimpleColoredComponent)textRenderer);
            String optionValue = JSHintTreeCellRenderer.formatOptionValue(option, node.getValue());
            if (optionValue != null) {
                textRenderer.append(": " + optionValue, new SimpleTextAttributes(background, foreground, null, style));
            }
            JSHintTreeCellRenderer.addEditHyperlinkIfNeeded((SimpleColoredComponent)textRenderer, node);
            JSHintTreeCellRenderer.addOptionKey((SimpleColoredComponent)textRenderer, option);
        }
        this.setForeground(foreground);
    }

    private static void addOptionKey(@NotNull SimpleColoredComponent textRenderer, @NotNull JSHintOption option) {
        String keyAlias;
        if (textRenderer == null) {
            JSHintTreeCellRenderer.$$$reportNull$$$0(0);
        }
        if (option == null) {
            JSHintTreeCellRenderer.$$$reportNull$$$0(1);
        }
        String keys = (keyAlias = option.getKeyAlias()) != null ? option.getKey() + " (" + keyAlias + ")" : option.getKey();
        textRenderer.append("   " + keys, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
    }

    private static void addEditHyperlinkIfNeeded(@NotNull SimpleColoredComponent textRenderer, @NotNull JSHintTreeNode node) {
        if (textRenderer == null) {
            JSHintTreeCellRenderer.$$$reportNull$$$0(2);
        }
        if (node == null) {
            JSHintTreeCellRenderer.$$$reportNull$$$0(3);
        }
        if (node.isEditLinkNeeded()) {
            textRenderer.append("  ", new SimpleTextAttributes(null, null, null, 0));
            int style = 0;
            if (node.isMouseInside()) {
                style |= 0x10;
            }
            textRenderer.append("Set", new SimpleTextAttributes(null, PlatformColors.BLUE, null, style), LINK_MARKER);
        }
    }

    @Nullable
    private static String formatOptionValue(@NotNull JSHintOption option, @Nullable Object value) {
        if (option == null) {
            JSHintTreeCellRenderer.$$$reportNull$$$0(4);
        }
        if (OptionTypes.isEnumOption(option)) {
            OptionEnumVariant variant = OptionEnumType.findVariantByValueOrFail(option, value);
            return variant.getValueAsJsonStr();
        }
        if (OptionTypes.isIntegerOption(option)) {
            Integer intValue = JSHintUtil.castToInteger(value);
            if (intValue != null) {
                return String.valueOf(intValue);
            }
            return "any";
        }
        return null;
    }

    private static void appendShortDescription(@NotNull JSHintOption option, Color foreground, SimpleColoredComponent textRenderer) {
        if (option == null) {
            JSHintTreeCellRenderer.$$$reportNull$$$0(5);
        }
        for (JSHintOption.Fragment fragment : option.getShortDescriptionFragments()) {
            String text = fragment.getText();
            Gray background = null;
            Color localForeground = foreground;
            int style = 0;
            if (fragment.isCode()) {
                style |= 0x100;
                background = Gray._230;
                localForeground = Gray._10;
                text = " " + text + " ";
            }
            textRenderer.append(text, new SimpleTextAttributes((Color)background, localForeground, null, style));
        }
    }

    public boolean isPointInsideEditLink(@NotNull JSHintTreeNode node, @NotNull Point pointRelativeToRow) {
        if (node == null) {
            JSHintTreeCellRenderer.$$$reportNull$$$0(6);
        }
        if (pointRelativeToRow == null) {
            JSHintTreeCellRenderer.$$$reportNull$$$0(7);
        }
        ColoredTreeCellRenderer coloredComponent = this.getTextRenderer();
        if (this.myCurrentNode != node) {
            coloredComponent.clear();
            this.doCustomizeRenderer(node, false);
        }
        return coloredComponent.getFragmentTagAt(pointRelativeToRow.x) == LINK_MARKER;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRenderer";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointRelativeToRow";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/JSHintTreeCellRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addOptionKey";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addEditHyperlinkIfNeeded";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "formatOptionValue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "appendShortDescription";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isPointInsideEditLink";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

