/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.google.common.collect.ImmutableMap;
import com.intellij.lang.javascript.linter.jshint.JSHintOption;
import com.intellij.lang.javascript.linter.jshint.JSHintUtil;
import com.intellij.lang.javascript.linter.option.OptionEnumType;
import com.intellij.lang.javascript.linter.option.OptionEnumVariant;
import com.intellij.lang.javascript.linter.option.OptionTypes;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintOptionsState {
    private final Map<String, Object> myValueByOptionMap;

    private JSHintOptionsState(@NotNull Map<String, Object> valueByOptionMap) {
        if (valueByOptionMap == null) {
            JSHintOptionsState.$$$reportNull$$$0(0);
        }
        this.myValueByOptionMap = ImmutableMap.copyOf(valueByOptionMap);
    }

    @NotNull
    public Set<String> getOptionKeys() {
        Set<String> set = this.myValueByOptionMap.keySet();
        if (set == null) {
            JSHintOptionsState.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public Map<String, Object> getValueByOptionMap() {
        Map<String, Object> map = this.myValueByOptionMap;
        if (map == null) {
            JSHintOptionsState.$$$reportNull$$$0(2);
        }
        return map;
    }

    @Nullable
    public Object getValue(@NotNull String optionKey) {
        JSHintOption option;
        Object value;
        if (optionKey == null) {
            JSHintOptionsState.$$$reportNull$$$0(3);
        }
        if ((value = this.myValueByOptionMap.get(optionKey)) == null && (option = JSHintOption.findByName(optionKey)) != null) {
            return option.getDefaultValue();
        }
        return value;
    }

    @Nullable
    public Object getValue(@NotNull JSHintOption option) {
        if (option == null) {
            JSHintOptionsState.$$$reportNull$$$0(4);
        }
        return this.getValue(option.getKey());
    }

    @NotNull
    public OptionEnumVariant getEnumVariant(@NotNull JSHintOption option) {
        if (option == null) {
            JSHintOptionsState.$$$reportNull$$$0(5);
        }
        Object value = this.getValue(option);
        OptionEnumVariant optionEnumVariant = OptionEnumType.findVariantByValueOrFail(option, value);
        if (optionEnumVariant == null) {
            JSHintOptionsState.$$$reportNull$$$0(6);
        }
        return optionEnumVariant;
    }

    public boolean getBoolean(@NotNull JSHintOption option) {
        if (option == null) {
            JSHintOptionsState.$$$reportNull$$$0(7);
        }
        if (!OptionTypes.isBooleanOption(option)) {
            throw new RuntimeException("Option " + option + " has " + option.getType() + " type, but boolean type was expected.");
        }
        Object obj = this.getValue(option);
        if (obj == null) {
            throw new RuntimeException("Boolean type shouldn't be null");
        }
        return (Boolean)obj;
    }

    @Nullable
    public String getString(@NotNull JSHintOption option) {
        if (option == null) {
            JSHintOptionsState.$$$reportNull$$$0(8);
        }
        if (!OptionTypes.isStringOption(option)) {
            throw new RuntimeException("Option " + option + " has " + option.getType() + " type, but string type was expected.");
        }
        Object obj = this.myValueByOptionMap.get(option.getKey());
        return JSHintUtil.castToString(obj);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSHintOptionsState that = (JSHintOptionsState)o;
        for (JSHintOption option : JSHintOption.values()) {
            Object thatValue;
            Object thisValue = this.getValue(option);
            if (ComparatorUtil.equalsNullable((Object)thisValue, (Object)(thatValue = that.getValue(option)))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.myValueByOptionMap.hashCode();
    }

    public String toString() {
        return this.myValueByOptionMap.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueByOptionMap";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/jshint/JSHintOptionsState";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionKey";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/JSHintOptionsState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionKeys";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueByOptionMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnumVariant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getEnumVariant";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBoolean";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder {
        private final Map<String, Object> myValueByOptionMap = new HashMap();

        public Builder put(@NotNull JSHintOption option, @Nullable Object value) {
            if (option == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.put(option.getKey(), value);
            return this;
        }

        public Builder put(@NotNull String key, @Nullable Object value) {
            if (key == null) {
                Builder.$$$reportNull$$$0(1);
            }
            String newKey = key;
            JSHintOption option = JSHintOption.findByName(key);
            if (option != null) {
                newKey = option.getKey();
            }
            if (value == null) {
                this.myValueByOptionMap.remove(newKey);
            } else {
                this.myValueByOptionMap.put(newKey, value);
            }
            return this;
        }

        @NotNull
        public JSHintOptionsState build() {
            JSHintOptionsState jSHintOptionsState = new JSHintOptionsState(this.myValueByOptionMap);
            if (jSHintOptionsState == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return jSHintOptionsState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "option";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/jshint/JSHintOptionsState$Builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/JSHintOptionsState$Builder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "put";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

