/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.gjslint;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.linter.FilesMirror;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterAnnotationsBuilder;
import com.intellij.lang.javascript.linter.JSLinterConfigurable;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterExternalAnnotator;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSLinterStandardFixes;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.JSLinterWithInspectionExternalAnnotator;
import com.intellij.lang.javascript.linter.gjslint.GjsLintConfigFileChangeTracker;
import com.intellij.lang.javascript.linter.gjslint.GjsLintConfigurable;
import com.intellij.lang.javascript.linter.gjslint.GjsLintConfiguration;
import com.intellij.lang.javascript.linter.gjslint.GjsLintInspection;
import com.intellij.lang.javascript.linter.gjslint.GjsLintState;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GjsLintExternalAnnotator
extends JSLinterExternalAnnotator<GjsLintState> {
    private static final Logger LOG = Logger.getInstance(GjsLintExternalAnnotator.class);
    private static final GjsLintExternalAnnotator INSTANCE_FOR_BATCH_INSPECTION = new GjsLintExternalAnnotator(false);
    private static final Pattern ERROR_PATTERN = Pattern.compile("^Line (\\d+), E:\\d+: (.*)$");
    private static final String CODE_TEMP_FILE_MAP_KEY_NAME = "CODE_TEMP_FILE_MAP_KEY";
    private static final String CONFIG_TEMP_FILE_MAP_KEY_NAME = "CONFIG_TEMP_FILE_MAP_KEY";
    private final FilesMirror myCodeFilesMirror = new FilesMirror("CODE_TEMP_FILE_MAP_KEY", "intellij-js-closure-linter");
    private final FilesMirror myConfigFilesMirror = new FilesMirror("CONFIG_TEMP_FILE_MAP_KEY", "intellij-js-closure-linter");

    public GjsLintExternalAnnotator() {
        this(true);
    }

    public GjsLintExternalAnnotator(boolean onTheFly) {
        super(onTheFly);
    }

    @NotNull
    public static GjsLintExternalAnnotator getInstanceForBatchInspection() {
        GjsLintExternalAnnotator gjsLintExternalAnnotator = INSTANCE_FOR_BATCH_INSPECTION;
        if (gjsLintExternalAnnotator == null) {
            GjsLintExternalAnnotator.$$$reportNull$$$0(0);
        }
        return gjsLintExternalAnnotator;
    }

    @Override
    @NotNull
    protected JSLinterConfigurable<GjsLintState> createSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            GjsLintExternalAnnotator.$$$reportNull$$$0(1);
        }
        GjsLintConfigurable gjsLintConfigurable = new GjsLintConfigurable(project, true);
        if (gjsLintConfigurable == null) {
            GjsLintExternalAnnotator.$$$reportNull$$$0(2);
        }
        return gjsLintConfigurable;
    }

    @Override
    protected Class<? extends JSLinterConfiguration<GjsLintState>> getConfigurationClass() {
        return GjsLintConfiguration.class;
    }

    @Override
    protected Class<? extends JSLinterInspection> getInspectionClass() {
        return GjsLintInspection.class;
    }

    @Override
    protected boolean acceptPsiFile(@NotNull PsiFile file) {
        if (file == null) {
            GjsLintExternalAnnotator.$$$reportNull$$$0(3);
        }
        return file instanceof JSFile && JSUtils.isJavaScriptFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public JSLinterAnnotationResult<GjsLintState> annotate(@NotNull JSLinterInput<GjsLintState> collectedInfo) {
        JSLinterAnnotationResult<GjsLintState> jSLinterAnnotationResult;
        GjsLintState state;
        String exeFilePath;
        if (collectedInfo == null) {
            GjsLintExternalAnnotator.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmpty((String)(exeFilePath = (state = collectedInfo.getState()).getLinterExePath()))) {
            return JSLinterAnnotationResult.create(collectedInfo, new JSLinterFileLevelAnnotation("Closure Linter executable file is not specified"), null);
        }
        File exeFile = new File(exeFilePath);
        if (!(exeFile.isFile() && exeFile.isAbsolute() && exeFile.canExecute())) {
            return JSLinterAnnotationResult.create(collectedInfo, new JSLinterFileLevelAnnotation("Closure Linter executable file is not found"), null);
        }
        String configFilePath = state.getConfigFilePath();
        if (StringUtil.isEmpty((String)configFilePath)) {
            return JSLinterAnnotationResult.create(collectedInfo, new JSLinterFileLevelAnnotation("Configuration file for Closure Linter is not specified"), null);
        }
        File configFile = new File(configFilePath);
        if (!configFile.isFile() || !configFile.isAbsolute()) {
            return JSLinterAnnotationResult.create(collectedInfo, new JSLinterFileLevelAnnotation("Configuration file for Closure Linter is not found"), null);
        }
        VirtualFile codeVirtualFile = collectedInfo.getPsiFile().getVirtualFile();
        if (codeVirtualFile == null || !codeVirtualFile.isValid()) {
            return null;
        }
        VirtualFile configVirtualFile = VfsUtil.findFileByIoFile((File)configFile, (boolean)false);
        if (configVirtualFile == null || !configVirtualFile.isValid()) {
            return null;
        }
        File actualCodeFile = this.myCodeFilesMirror.getOrCreateFileWithActualContent(collectedInfo.getProject(), codeVirtualFile, collectedInfo.getFileContent());
        if (actualCodeFile == null) {
            return null;
        }
        File actualConfigFile = this.myConfigFilesMirror.getOrCreateFileWithActualContent(collectedInfo.getProject(), configVirtualFile, null);
        if (actualConfigFile == null) {
            return null;
        }
        GjsLintConfigFileChangeTracker.startTracking();
        long startTimeNano = System.nanoTime();
        try {
            jSLinterAnnotationResult = GjsLintExternalAnnotator.startProcess(collectedInfo, exeFile, configVirtualFile, actualConfigFile, codeVirtualFile, actualCodeFile);
        }
        catch (Throwable throwable) {
            long durationNano = System.nanoTime() - startTimeNano;
            if (durationNano > TimeUnit.MILLISECONDS.toNanos(500L)) {
                LOG.info("[Closure Linter] Taken time " + String.format("%d ms", TimeUnit.NANOSECONDS.toMillis(durationNano)));
            }
            throw throwable;
        }
        long durationNano = System.nanoTime() - startTimeNano;
        if (durationNano > TimeUnit.MILLISECONDS.toNanos(500L)) {
            LOG.info("[Closure Linter] Taken time " + String.format("%d ms", TimeUnit.NANOSECONDS.toMillis(durationNano)));
        }
        return jSLinterAnnotationResult;
    }

    @Nullable
    private static JSLinterAnnotationResult<GjsLintState> startProcess(@NotNull JSLinterInput<GjsLintState> collectedInfo, @NotNull File exeFile, @NotNull VirtualFile configVirtualFile, @NotNull File configFile, @NotNull VirtualFile codeVirtualFile, @NotNull File codeFile) {
        KillableColoredProcessHandler processHandler;
        File workingDir;
        if (collectedInfo == null) {
            GjsLintExternalAnnotator.$$$reportNull$$$0(5);
        }
        if (exeFile == null) {
            GjsLintExternalAnnotator.$$$reportNull$$$0(6);
        }
        if (configVirtualFile == null) {
            GjsLintExternalAnnotator.$$$reportNull$$$0(7);
        }
        if (configFile == null) {
            GjsLintExternalAnnotator.$$$reportNull$$$0(8);
        }
        if (codeVirtualFile == null) {
            GjsLintExternalAnnotator.$$$reportNull$$$0(9);
        }
        if (codeFile == null) {
            GjsLintExternalAnnotator.$$$reportNull$$$0(10);
        }
        if ((workingDir = codeFile.getParentFile()) == null) {
            return null;
        }
        GeneralCommandLine commandLine = GjsLintExternalAnnotator.createCommandLine(workingDir, exeFile, configVirtualFile, configFile, codeVirtualFile, codeFile);
        String runError = null;
        final ProcessOutput output = new ProcessOutput();
        try {
            processHandler = new KillableColoredProcessHandler(commandLine, true);
        }
        catch (ExecutionException e) {
            runError = "Can not start gjslint process: " + e.getMessage();
            processHandler = null;
        }
        final ArrayList errors = ContainerUtil.newArrayList();
        final Ref runErrorRef = Ref.create(runError);
        if (runErrorRef.isNull() && processHandler != null) {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (event == null) {
                        return;
                    }
                    String text = event.getText().trim();
                    if (outputType == ProcessOutputTypes.STDOUT) {
                        output.appendStdout(text);
                        JSLinterError error = GjsLintExternalAnnotator.toError(text);
                        if (error != null) {
                            errors.add(error);
                        }
                    } else if (outputType == ProcessOutputTypes.STDERR) {
                        output.appendStderr(text);
                        String prefix = "gflags.UnrecognizedFlagError: ";
                        if (text.startsWith(prefix) && runErrorRef.isNull()) {
                            String unrecognizedFlag = text.substring(prefix.length());
                            String fix = GjsLintExternalAnnotator.findPossibleFixedFlag(unrecognizedFlag);
                            StringBuilder message = new StringBuilder("Closure Linter: ").append(unrecognizedFlag);
                            if (fix != null) {
                                message.append(". Try '").append(fix).append("'");
                            }
                            runErrorRef.set((Object)message.toString());
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/lang/javascript/linter/gjslint/GjsLintExternalAnnotator$1";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            processHandler.startNotify();
            processHandler.waitFor();
        }
        if ((runError = (String)runErrorRef.get()) != null) {
            IntentionAction detailsAction = processHandler == null ? null : JSLinterUtil.createDetailsAction(collectedInfo.getProject(), configVirtualFile, commandLine, output, null);
            return JSLinterAnnotationResult.create(collectedInfo, new JSLinterFileLevelAnnotation(null, runError, HighlightSeverity.ERROR, new JSLinterStandardFixes().setDetailsAction(detailsAction)), configVirtualFile);
        }
        return JSLinterAnnotationResult.createLinterResult(collectedInfo, errors, configVirtualFile);
    }

    @Nullable
    private static String findPossibleFixedFlag(@NotNull String message) {
        if (message == null) {
            GjsLintExternalAnnotator.$$$reportNull$$$0(11);
        }
        String prefix = "Unknown command line flag '";
        String suffix = "'";
        if (message.startsWith(prefix) && message.endsWith(suffix)) {
            String unrecognizedFlag = message.substring(prefix.length(), message.length() - suffix.length());
            int ind = (unrecognizedFlag = unrecognizedFlag.trim()).indexOf(" ");
            if (ind > 0) {
                String first = unrecognizedFlag.substring(0, ind).trim();
                String second = unrecognizedFlag.substring(ind + 1).trim();
                return first + "=" + second;
            }
        }
        return null;
    }

    @Nullable
    private static JSLinterError toError(@NotNull String text) {
        Matcher matcher;
        if (text == null) {
            GjsLintExternalAnnotator.$$$reportNull$$$0(12);
        }
        if ((matcher = ERROR_PATTERN.matcher(text)).find() && matcher.groupCount() == 2) {
            int line;
            String lineStr = matcher.group(1);
            try {
                line = Integer.parseInt(lineStr);
            }
            catch (NumberFormatException ignored) {
                LOG.warn("Can't parse line number in '" + lineStr + "'");
                return null;
            }
            String message = matcher.group(2);
            return new JSLinterError(line, 0, message, null);
        }
        return null;
    }

    @NotNull
    public static GeneralCommandLine createCommandLine(@NotNull File workingDir, @NotNull File gjslintExeFile, @NotNull VirtualFile configVirtualFile, @NotNull File configFile, @NotNull VirtualFile codeVirtualFile, @NotNull File codeFile) {
        if (workingDir == null) {
            GjsLintExternalAnnotator.$$$reportNull$$$0(13);
        }
        if (gjslintExeFile == null) {
            GjsLintExternalAnnotator.$$$reportNull$$$0(14);
        }
        if (configVirtualFile == null) {
            GjsLintExternalAnnotator.$$$reportNull$$$0(15);
        }
        if (configFile == null) {
            GjsLintExternalAnnotator.$$$reportNull$$$0(16);
        }
        if (codeVirtualFile == null) {
            GjsLintExternalAnnotator.$$$reportNull$$$0(17);
        }
        if (codeFile == null) {
            GjsLintExternalAnnotator.$$$reportNull$$$0(18);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        commandLine.setCharset(CharsetToolkit.UTF8_CHARSET);
        commandLine.setWorkDirectory(workingDir);
        commandLine.setExePath(gjslintExeFile.getAbsolutePath());
        commandLine.addParameter("--flagfile");
        commandLine.addParameters(new String[]{configFile.getAbsolutePath()});
        commandLine.addParameter("--recurse=no");
        commandLine.addParameter(codeFile.getAbsolutePath());
        boolean passRealFilePath = GjsLintConfigFileChangeTracker.checkPassRealPath(configVirtualFile);
        if (passRealFilePath) {
            String configRealPath = FileUtil.toSystemDependentName((String)codeVirtualFile.getPath());
            commandLine.addParameter("--realFilePath=" + configRealPath);
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            GjsLintExternalAnnotator.$$$reportNull$$$0(19);
        }
        return generalCommandLine;
    }

    @Override
    public void apply(@NotNull PsiFile file, @Nullable JSLinterAnnotationResult<GjsLintState> annotationResult, @NotNull AnnotationHolder holder) {
        if (file == null) {
            GjsLintExternalAnnotator.$$$reportNull$$$0(20);
        }
        if (holder == null) {
            GjsLintExternalAnnotator.$$$reportNull$$$0(21);
        }
        if (annotationResult == null) {
            return;
        }
        HighlightDisplayKey inspectionKey = GjsLintInspection.getHighlightDisplayKey();
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return;
        }
        GjsLintConfigurable configurable = new GjsLintConfigurable(file.getProject(), true);
        new JSLinterAnnotationsBuilder<GjsLintState>(file, annotationResult, holder, inspectionKey, configurable, "Closure Linter: ", this.getInspectionClass(), JSLinterStandardFixes.DEFAULT).setHighlightingGranularity(JSLinterWithInspectionExternalAnnotator.HighlightingGranularity.line).apply();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/gjslint/GjsLintExternalAnnotator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectedInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exeFile";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configVirtualFile";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeVirtualFile";
                break;
            }
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gjslintExeFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceForBatchInspection";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/gjslint/GjsLintExternalAnnotator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettingsConfigurable";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createSettingsConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "acceptPsiFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "startProcess";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findPossibleFixedFlag";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "toError";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

