/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.standardjs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.util.JsonUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardJSUtil {
    public static final String PACKAGE_NAME = "standard";
    public static final String CONFIG_SECTION_NAME = "standard";
    public static final List<String> ESLINT_CONFIGURATION_NAMES = ContainerUtil.list((Object[])new String[]{"standard", "eslint-config-standard"});
    public static final Logger LOG = Logger.getInstance(StandardJSUtil.class);
    public static final int MIN_VERSION = 7;

    private StandardJSUtil() {
    }

    @Nullable
    public static NodePackage findEslintPackage(@NotNull NodePackage standardPackage) {
        if (standardPackage == null) {
            StandardJSUtil.$$$reportNull$$$0(0);
        }
        return StandardJSUtil.findDependentPackage(standardPackage, "eslint");
    }

    @Nullable
    private static NodePackage findDependentPackage(@NotNull NodePackage nodePackage, @NotNull String name) {
        VirtualFile file;
        if (nodePackage == null) {
            StandardJSUtil.$$$reportNull$$$0(1);
        }
        if (name == null) {
            StandardJSUtil.$$$reportNull$$$0(2);
        }
        if ((file = LocalFileSystem.getInstance().findFileByIoFile(new File(nodePackage.getSystemDependentPath()))) == null) {
            return null;
        }
        ArrayList infos = ContainerUtil.newArrayList();
        VirtualFile nestedNodeModulesDir = file.findChild("node_modules");
        if (nestedNodeModulesDir != null) {
            NodeModuleSearchUtil.findModuleWithNameInDirectory(infos, nestedNodeModulesDir, ModuleType.CORE_MODULE, name);
        }
        NodeModuleSearchUtil.findModuleWithNameInDirectory(infos, file.getParent(), ModuleType.CORE_MODULE, name);
        CompletionModuleInfo item = (CompletionModuleInfo)ContainerUtil.getFirstItem((List)infos);
        return item != null && item.getAbsolutePath() != null ? new NodePackage(item.getAbsolutePath()) : null;
    }

    @Nullable
    @Contract(value="_, null -> null")
    public static ConfigData getPackageJsonConfigData(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        if (project == null) {
            StandardJSUtil.$$$reportNull$$$0(3);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        if (virtualFile == null) {
            return null;
        }
        return (ConfigData)ReadAction.compute(() -> {
            PsiFile psiFile = psiManager.findFile(virtualFile);
            if (psiFile == null) {
                return null;
            }
            return (ConfigData)CachedValuesManager.getCachedValue((PsiElement)psiFile, () -> {
                try {
                    String text = VfsUtilCore.loadText((VirtualFile)virtualFile);
                    return CachedValueProvider.Result.create((Object)StandardJSUtil.parseSectionData(text), (Object[])new Object[]{virtualFile});
                }
                catch (Exception e) {
                    LOG.info(String.format("Could not read config data from file [%s]", virtualFile.getCanonicalPath()), (Throwable)e);
                    return CachedValueProvider.Result.create(null, (Object[])new Object[]{virtualFile});
                }
            });
        });
    }

    @Nullable
    private static ConfigData parseSectionData(@Nullable String text) throws Exception {
        JsonObject jsonObject = JsonUtil.tryParseJsonObject((String)text);
        if (jsonObject == null) {
            return null;
        }
        JsonObject sectionObject = JsonUtil.getChildAsObject((JsonObject)jsonObject, (String)"standard");
        if (sectionObject == null) {
            return null;
        }
        List<String> plugins = StandardJSUtil.getChildAsSingleStringOrList(sectionObject, "plugins", "plugin");
        List<String> globals = StandardJSUtil.getChildAsSingleStringOrList(sectionObject, "globals", "global");
        List<String> ignored = StandardJSUtil.getChildAsSingleStringOrList(sectionObject, "ignore");
        String parser = JsonUtil.getChildAsString((JsonObject)sectionObject, (String)"parser");
        List<String> environment = StandardJSUtil.getEnvironment(sectionObject);
        return new ConfigData(plugins, ignored, globals, environment, parser);
    }

    @NotNull
    private static List<String> getEnvironment(@NotNull JsonObject sectionObject) {
        JsonElement child;
        JsonObject object;
        if (sectionObject == null) {
            StandardJSUtil.$$$reportNull$$$0(4);
        }
        List<String> list = (object = JsonUtil.getAsObject((JsonElement)(child = JsonUtil.findChild((JsonObject)sectionObject, (String[])new String[]{"env", "envs"})))) != null ? JsonUtil.keys((JsonObject)object) : StandardJSUtil.getAsSingleStringOrList(child);
        if (list == null) {
            StandardJSUtil.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private static List<String> getChildAsSingleStringOrList(@NotNull JsonObject obj, String ... names) {
        JsonElement child;
        if (obj == null) {
            StandardJSUtil.$$$reportNull$$$0(6);
        }
        List<String> list = (child = JsonUtil.findChild((JsonObject)obj, (String[])names)) == null ? ContainerUtil.emptyList() : StandardJSUtil.getAsSingleStringOrList(child);
        if (list == null) {
            StandardJSUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private static List<String> getAsSingleStringOrList(@Nullable JsonElement element) {
        if (element == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                StandardJSUtil.$$$reportNull$$$0(8);
            }
            return list;
        }
        String string = JsonUtil.getString((JsonElement)element);
        List list = string != null ? ContainerUtil.list((Object[])new String[]{string}) : JsonUtil.getAsStringList((JsonElement)element);
        if (list == null) {
            StandardJSUtil.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "standardPackage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePackage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sectionObject";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironment";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAsSingleStringOrList";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsSingleStringOrList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findEslintPackage";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findDependentPackage";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPackageJsonConfigData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getEnvironment";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChildAsSingleStringOrList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ConfigData {
        public final List<String> plugins;
        public final List<String> ignored;
        public final List<String> globals;
        public final List<String> env;
        public final String parser;

        public ConfigData(@NotNull List<String> plugins, @NotNull List<String> ignored, @NotNull List<String> globals, @NotNull List<String> env, String parser) {
            if (plugins == null) {
                ConfigData.$$$reportNull$$$0(0);
            }
            if (ignored == null) {
                ConfigData.$$$reportNull$$$0(1);
            }
            if (globals == null) {
                ConfigData.$$$reportNull$$$0(2);
            }
            if (env == null) {
                ConfigData.$$$reportNull$$$0(3);
            }
            this.plugins = plugins;
            this.ignored = ignored;
            this.globals = globals;
            this.env = env;
            this.parser = parser;
        }

        public String toString() {
            return "ConfigData{plugins=" + this.plugins + ", ignored=" + this.ignored + ", globals=" + this.globals + ", env=" + this.env + ", parser='" + this.parser + '\'' + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "plugins";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ignored";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "globals";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "env";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSUtil$ConfigData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

