/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.library.JSPredefinedLibraryProvider;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCorePredefinedLibrariesProvider
extends JSPredefinedLibraryProvider {
    private static final Logger LOG = Logger.getInstance(JSCorePredefinedLibrariesProvider.class);
    private static final String ON = "On";
    public static final String LIB_HTML = "HTML";
    public static final String LIB_NASHORN = "Nashorn";
    public static final String ECMASCRIPT_JS = "EcmaScript.js";
    public static final String ECMASCRIPT5_JS = "lib.es5.d.ts";
    public static final String BROWSER_D_TS = "browser.d.ts";
    private static final String[][] ourPredefinedLibraries = new String[][]{{"HTML", "On", "lib.dom.d.ts", "lib.dom.iterable.d.ts", "lib.scripthost.d.ts", "lib.webworker.d.ts", "browser.d.ts", "xpath.d.ts", "websql.d.ts"}};
    private static final String[] ES5_LIB_FILES = new String[]{"lib.es5.d.ts"};
    private static final String[] ES6_LIB_FILES = new String[]{"lib.esnext.d.ts", "lib.es2017.d.ts", "lib.esnext.asynciterable.d.ts", "lib.es2015.symbol.d.ts", "lib.es2015.iterable.d.ts", "lib.es2016.d.ts", "lib.es2017.object.d.ts", "lib.es2017.sharedmemory.d.ts", "lib.es2017.string.d.ts", "lib.es2017.intl.d.ts", "lib.es2015.symbol.wellknown.d.ts", "lib.es2015.d.ts", "lib.es2016.array.include.d.ts", "lib.es2015.core.d.ts", "lib.es2015.collection.d.ts", "lib.es2015.generator.d.ts", "lib.es2015.promise.d.ts", "lib.es2015.proxy.d.ts", "lib.es2015.reflect.d.ts", "lib.es5.d.ts"};
    private static final String[] ourJavaScriptLibraries = new String[]{"lib.d.ts"};
    private static final String[] ourJSXLibraries = new String[]{"react.d.ts"};
    private static final AtomicNotNullLazyValue<Set<VirtualFile>> ourJSXPredefLibFiles = JSCorePredefinedLibrariesProvider.newAtomicNotNullLazyValue(ourJSXLibraries);
    private static final AtomicNotNullLazyValue<Set<VirtualFile>> ourJSCorePredefLibFiles = JSCorePredefinedLibrariesProvider.newAtomicNotNullLazyValue(ourJavaScriptLibraries);
    private static final AtomicNotNullLazyValue<Set<VirtualFile>> ourJSPredefLibFiles = new AtomicNotNullLazyValue<Set<VirtualFile>>(){

        @NotNull
        protected Set<VirtualFile> compute() {
            HashSet result = new HashSet();
            for (String[] stringArray : ourPredefinedLibraries) {
                assert (stringArray.length >= 3);
                result.addAll(JSCorePredefinedLibrariesProvider.getFiles(stringArray));
            }
            for (String[] stringArray : ourJavaScriptLibraries) {
                result.add(JSCorePredefinedLibrariesProvider.getPredefinedLibFile((String)stringArray));
            }
            for (String[] stringArray : ES5_LIB_FILES) {
                result.add(JSCorePredefinedLibrariesProvider.getPredefinedLibFile((String)stringArray));
            }
            for (String[] stringArray : ES6_LIB_FILES) {
                result.add(JSCorePredefinedLibrariesProvider.getPredefinedLibFile((String)stringArray));
            }
            HashSet hashSet = result;
            if (hashSet == null) {
                1.$$$reportNull$$$0(0);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider$1", "compute"));
        }
    };
    private static final AtomicNotNullLazyValue<Set<VirtualFile>> ourAllJSPredefLibFiles = new AtomicNotNullLazyValue<Set<VirtualFile>>(){

        @NotNull
        protected Set<VirtualFile> compute() {
            HashSet result = new HashSet(JSCorePredefinedLibrariesProvider.getJavaScriptPredefinedLibraryFiles());
            for (String[] libDef : ourPredefinedLibraries) {
                assert (libDef.length >= 3);
                result.addAll(JSCorePredefinedLibrariesProvider.getFiles(libDef));
            }
            result.addAll(JSCorePredefinedLibrariesProvider.toVirtualFileSet(ES5_LIB_FILES));
            result.addAll(JSCorePredefinedLibrariesProvider.toVirtualFileSet(ES6_LIB_FILES));
            result.addAll(JSCorePredefinedLibrariesProvider.toVirtualFileSet(ourJSXLibraries));
            result.add(JSCorePredefinedLibrariesProvider.findFileByURL("lib.es6.d.ts"));
            HashSet hashSet = result;
            if (hashSet == null) {
                2.$$$reportNull$$$0(0);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider$2", "compute"));
        }
    };
    private static final Map<String, Ref<VirtualFile>> ourLibFileCache = ContainerUtil.newConcurrentMap();

    @Override
    @NotNull
    public ScriptingLibraryModel[] getPredefinedLibraries(@NotNull Project project) {
        if (project == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(0);
        }
        ArrayList<ScriptingLibraryModel> predefinedLibraries = new ArrayList<ScriptingLibraryModel>();
        for (String[] libDef : ourPredefinedLibraries) {
            assert (libDef.length >= 3);
            String libName = libDef[0];
            String defaultFlag = libDef[1];
            Set<VirtualFile> libFiles = JSCorePredefinedLibrariesProvider.getFiles(libDef);
            predefinedLibraries.add(ScriptingLibraryModel.createPredefinedLibrary((String)libName, (VirtualFile[])VfsUtilCore.toVirtualFileArray(libFiles), (boolean)ON.equals(defaultFlag)));
        }
        ScriptingLibraryModel[] scriptingLibraryModelArray = predefinedLibraries.toArray(new ScriptingLibraryModel[predefinedLibraries.size()]);
        if (scriptingLibraryModelArray == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(1);
        }
        return scriptingLibraryModelArray;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getRequiredLibraryFilesToIndex() {
        HashSet libFiles = new HashSet();
        libFiles.addAll(JSCorePredefinedLibrariesProvider.getJSXPredefinedLibraryFiles());
        HashSet hashSet = libFiles;
        if (hashSet == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getRequiredLibraryFilesForResolve(@NotNull Project project) {
        if (project == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(3);
        }
        HashSet files = new HashSet();
        JSLanguageLevel level = JSRootConfiguration.getInstance(project).getLanguageLevel();
        if (level.isES6Compatible()) {
            JSCorePredefinedLibrariesProvider.addFiles((Set<VirtualFile>)files, ES6_LIB_FILES);
        } else if (level.isES5Compatible()) {
            JSCorePredefinedLibrariesProvider.addFiles((Set<VirtualFile>)files, ES5_LIB_FILES);
        } else {
            files.addAll(JSCorePredefinedLibrariesProvider.getJavaScriptCorePredefinedLibraryFiles());
        }
        HashSet hashSet = files;
        if (hashSet == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public Map<String, String> getPredefinedLibraryRenamingMap() {
        Map<String, String> map = Collections.emptyMap();
        if (map == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(5);
        }
        return map;
    }

    @NotNull
    public static Set<VirtualFile> getJSXPredefinedLibraryFiles() {
        Set set = (Set)ourJSXPredefLibFiles.getValue();
        if (set == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    public static Set<VirtualFile> getJavaScriptCorePredefinedLibraryFiles() {
        Set set = (Set)ourJSCorePredefLibFiles.getValue();
        if (set == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    public static Set<VirtualFile> getJavaScriptPredefinedLibraryFiles() {
        Set set = (Set)ourJSPredefLibFiles.getValue();
        if (set == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    public static Set<VirtualFile> getAllJSPredefinedLibraryFiles() {
        Set set = (Set)ourAllJSPredefLibFiles.getValue();
        if (set == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(9);
        }
        return set;
    }

    @NotNull
    private static Set<VirtualFile> getFiles(String[] libDef) {
        assert (libDef.length >= 3);
        HashSet libFiles = new HashSet();
        for (int i = 2; i < libDef.length; ++i) {
            VirtualFile file = JSCorePredefinedLibrariesProvider.getPredefinedLibFile(libDef[i]);
            if (file == null) continue;
            libFiles.add(file);
        }
        HashSet hashSet = libFiles;
        if (hashSet == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    @Nullable
    private static VirtualFile getPredefinedLibFile(@NotNull String libFileName) {
        Ref<VirtualFile> fileRef;
        if (libFileName == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(11);
        }
        if ((fileRef = JSCorePredefinedLibrariesProvider.getCachedFileRef(libFileName)) != null) {
            return (VirtualFile)fileRef.get();
        }
        VirtualFile file = JSCorePredefinedLibrariesProvider.findFileByURL(libFileName);
        return JSCorePredefinedLibrariesProvider.cacheFile(libFileName, file);
    }

    @Nullable
    private static VirtualFile findFileByURL(@NotNull String libFileName) {
        if (libFileName == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(12);
        }
        URL libFileUrl = null;
        File ioFile = new File(TypeScriptUtil.getTypeScriptCompilerFolderFile(), "external" + File.separator + libFileName);
        try {
            libFileUrl = ioFile.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (libFileUrl == null) {
            LOG.error("Cannot find " + libFileName + ", the installation is possibly broken.");
            return null;
        }
        VirtualFile file = VfsUtil.findFileByURL((URL)libFileUrl);
        if (file != null && file.isValid()) {
            return file;
        }
        LOG.warn("Cannot find virtual file " + libFileName + " by url " + libFileUrl.toExternalForm());
        return null;
    }

    @Nullable
    private static Ref<VirtualFile> getCachedFileRef(@NotNull String fileName) {
        Ref<VirtualFile> ref;
        VirtualFile file;
        if (fileName == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(13);
        }
        VirtualFile virtualFile = file = (ref = ourLibFileCache.get(fileName)) != null ? (VirtualFile)ref.get() : null;
        if (file != null && !file.isValid()) {
            ourLibFileCache.remove(fileName);
            ref = null;
        }
        return ref;
    }

    @Contract(value="_, null -> null")
    @Nullable
    private static VirtualFile cacheFile(@NotNull String libFileName, @Nullable VirtualFile file) {
        if (libFileName == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(14);
        }
        return JSLibraryUtil.cacheFile(libFileName, file, ourLibFileCache);
    }

    @NotNull
    private static Set<VirtualFile> toVirtualFileSet(@NotNull String[] predefinedFileNames) {
        if (predefinedFileNames == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(15);
        }
        java.util.HashSet files = ContainerUtil.newHashSet((int)predefinedFileNames.length);
        JSCorePredefinedLibrariesProvider.addFiles(files, predefinedFileNames);
        java.util.HashSet hashSet = files;
        if (hashSet == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(16);
        }
        return hashSet;
    }

    private static void addFiles(@NotNull Set<VirtualFile> files, @NotNull String[] predefinedFileNames) {
        if (files == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(17);
        }
        if (predefinedFileNames == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(18);
        }
        for (String predefinedFileName : predefinedFileNames) {
            VirtualFile file = JSCorePredefinedLibrariesProvider.getPredefinedLibFile(predefinedFileName);
            if (file == null) continue;
            files.add(file);
        }
    }

    @NotNull
    private static AtomicNotNullLazyValue<Set<VirtualFile>> newAtomicNotNullLazyValue(final @NotNull String[] predefinedFileNames) {
        if (predefinedFileNames == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(19);
        }
        AtomicNotNullLazyValue<Set<VirtualFile>> atomicNotNullLazyValue = new AtomicNotNullLazyValue<Set<VirtualFile>>(){

            @NotNull
            protected Set<VirtualFile> compute() {
                Set set = JSCorePredefinedLibrariesProvider.toVirtualFileSet(predefinedFileNames);
                if (set == null) {
                    3.$$$reportNull$$$0(0);
                }
                return set;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider$3", "compute"));
            }
        };
        if (atomicNotNullLazyValue == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(20);
        }
        return atomicNotNullLazyValue;
    }

    public static boolean isECMAScriptLibraryFileName(String fileName) {
        return ECMASCRIPT_JS.equals(fileName) || ArrayUtil.contains((String)fileName, (String[])ES5_LIB_FILES) || ArrayUtil.contains((String)fileName, (String[])ES6_LIB_FILES);
    }

    public static boolean isWebLibraryFileName(String fileName) {
        return ArrayUtil.indexOf((Object[])ourPredefinedLibraries[0], (Object)fileName) >= 2;
    }

    public static boolean isLibraryElement(@Nullable PsiElement element) {
        VirtualFile file;
        PsiFile psiFile = element != null ? element.getContainingFile() : null;
        psiFile = psiFile != null ? psiFile.getOriginalFile() : null;
        VirtualFile virtualFile = file = psiFile != null ? psiFile.getVirtualFile() : null;
        if (file == null) {
            file = (VirtualFile)IndexingDataKeys.VIRTUAL_FILE.get((UserDataHolder)psiFile);
        }
        if (file == null && psiFile != null) {
            file = psiFile.getViewProvider().getVirtualFile();
        }
        if (file instanceof LightVirtualFile) {
            file = ((LightVirtualFile)file).getOriginalFile();
        }
        return file != null && JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles().contains(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libFileName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 15: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedFileNames";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLibraries";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredLibraryFilesToIndex";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredLibraryFilesForResolve";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLibraryRenamingMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSXPredefinedLibraryFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaScriptCorePredefinedLibraryFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaScriptPredefinedLibraryFiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllJSPredefinedLibraryFiles";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "toVirtualFileSet";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "newAtomicNotNullLazyValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedLibraries";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 20: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredLibraryFilesForResolve";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedLibFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findFileByURL";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCachedFileRef";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "cacheFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "toVirtualFileSet";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addFiles";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "newAtomicNotNullLazyValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

