/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.modules.ES6ImportAction;
import com.intellij.lang.javascript.modules.ES6ModulesSuggester;
import com.intellij.lang.javascript.modules.JSBaseModulesDependenciesElementVisitor;
import com.intellij.lang.javascript.modules.JSSimpleModuleReferenceInfo;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.imports.JSXNamespaceProvider;
import com.intellij.lang.typescript.intentions.TypeScriptAddImportStatementFix;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.CheckBox;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSXNamespaceValidationInspection
extends JSInspection
implements JSXNamespaceProvider {
    public static final String SHORT_NAME = JSXNamespaceValidationInspection.calcShortNameFromClass(JSXNamespaceValidationInspection.class);
    private static final Key<Boolean> VALIDATED_FLAG = Key.create((String)"JSX.Inspection.Namespace.Validation");
    public boolean importPopup = false;
    public String requiredNamespace = "React";

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, final LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSLiteralExpression(JSLiteralExpression node) {
                if (!DialectDetector.isJSX((PsiElement)node)) {
                    return;
                }
                if (!(node instanceof JSXmlLiteralExpressionImpl)) {
                    return;
                }
                if (Boolean.TRUE.equals(session.getUserData(VALIDATED_FLAG))) {
                    return;
                }
                String namespace = JSXNamespaceValidationInspection.this.getNamespace((PsiElement)node);
                if (StringUtil.isEmpty((String)namespace)) {
                    return;
                }
                JSExecutionScope scope = (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)node, JSExecutionScope.class);
                if (scope == null) {
                    return;
                }
                final Ref hasElement = Ref.create((Object)Boolean.FALSE);
                JSStubBasedPsiTreeUtil.processDeclarationsInScope((PsiElement)scope, new JSResolveProcessorBase(namespace){

                    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                        if (element == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (state == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        hasElement.set((Object)Boolean.TRUE);
                        return false;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "element";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "state";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/lang/javascript/inspections/JSXNamespaceValidationInspection$1$1";
                        objectArray[2] = "execute";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }, true);
                if (((Boolean)hasElement.get()).booleanValue()) {
                    return;
                }
                JSXNamespaceValidationInspection.this.registerProblem(holder, session, node, namespace);
            }
        };
        if (jSElementVisitor == null) {
            JSXNamespaceValidationInspection.$$$reportNull$$$0(0);
        }
        return jSElementVisitor;
    }

    @Override
    @Nullable
    public String getNamespace(@NotNull PsiElement context) {
        if (context == null) {
            JSXNamespaceValidationInspection.$$$reportNull$$$0(1);
        }
        if (DialectDetector.isTypeScript(context)) {
            TypeScriptConfig config2 = TypeScriptConfigUtil.getConfigForPsiFile(context.getContainingFile());
            if (config2 == null) {
                return this.requiredNamespace;
            }
            String factory = config2.jsxFactory();
            if (factory != null) {
                int qualifierSeparator = factory.indexOf(".");
                return qualifierSeparator > 0 ? factory.substring(0, qualifierSeparator) : factory;
            }
            String namespace = config2.getRawCompilerOption("reactNamespace");
            if (!StringUtil.isEmpty((String)namespace)) {
                return namespace;
            }
        }
        return this.requiredNamespace;
    }

    private void registerProblem(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session, @NotNull JSLiteralExpression context, @NotNull String namespace) {
        if (holder == null) {
            JSXNamespaceValidationInspection.$$$reportNull$$$0(2);
        }
        if (session == null) {
            JSXNamespaceValidationInspection.$$$reportNull$$$0(3);
        }
        if (context == null) {
            JSXNamespaceValidationInspection.$$$reportNull$$$0(4);
        }
        if (namespace == null) {
            JSXNamespaceValidationInspection.$$$reportNull$$$0(5);
        }
        session.putUserData(VALIDATED_FLAG, (Object)Boolean.TRUE);
        PsiReference reference = context.getReference();
        if (reference != null) {
            List<LocalQuickFix> fixes = this.getFixes(holder, session, context, namespace);
            holder.registerProblemForReference(reference, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, JSBundle.message((String)"jsx.missing.namespace.inspection.text", (Object[])new Object[]{namespace}), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    private List<LocalQuickFix> getFixes(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session, @NotNull JSLiteralExpression context, final @NotNull String namespace) {
        if (holder == null) {
            JSXNamespaceValidationInspection.$$$reportNull$$$0(6);
        }
        if (session == null) {
            JSXNamespaceValidationInspection.$$$reportNull$$$0(7);
        }
        if (context == null) {
            JSXNamespaceValidationInspection.$$$reportNull$$$0(8);
        }
        if (namespace == null) {
            JSXNamespaceValidationInspection.$$$reportNull$$$0(9);
        }
        ArrayList result = ContainerUtil.newArrayList();
        if (DialectDetector.isTypeScript((PsiElement)context)) {
            ASTNode nameNode = context.getNode().findChildByType(JSTokenTypes.XML_TAG_NAME);
            if (nameNode != null) {
                ES6ImportAction.ImportElementFilter filter = new ES6ImportAction.ImportElementFilter(){

                    @Override
                    @NotNull
                    public List<JSElement> filterByContext(@NotNull PsiElement context, @NotNull List<JSElement> result) {
                        if (context == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (result == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        List<JSElement> list = result;
                        if (list == null) {
                            2.$$$reportNull$$$0(2);
                        }
                        return list;
                    }

                    @Override
                    public boolean isValidContext(@NotNull PsiElement context) {
                        if (context == null) {
                            2.$$$reportNull$$$0(3);
                        }
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 2: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 2: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "context";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "result";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSXNamespaceValidationInspection$2";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSXNamespaceValidationInspection$2";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "filterByContext";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "filterByContext";
                                break;
                            }
                            case 2: {
                                break;
                            }
                            case 3: {
                                objectArray = objectArray;
                                objectArray[2] = "isValidContext";
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 2: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
                result.add(new TypeScriptAddImportStatementFix(namespace, nameNode.getPsi(), this.importPopup, filter){

                    @Override
                    @Nls
                    @NotNull
                    public String getText() {
                        String string = JSBundle.message((String)"tsx.missing.name.quick.fix.name", (Object[])new Object[]{"'" + namespace + "'"});
                        if (string == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSXNamespaceValidationInspection$3", "getText"));
                    }
                });
            }
        } else {
            JSSimpleModuleReferenceInfo info = new JSSimpleModuleReferenceInfo(namespace, this.importPopup);
            Set<VirtualFile> files = JSBaseModulesDependenciesElementVisitor.cacheAndGetPredefinedLibraries(context.getProject(), session);
            ES6ModulesSuggester suggester = new ES6ModulesSuggester(session, files, info, (PsiElement)context);
            MultiMap<PsiElement, LocalQuickFix> fixes = suggester.findFixes(ResolveResult.EMPTY_ARRAY);
            result.addAll(fixes.values());
        }
        return result;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        final JBTextField namespace = new JBTextField(this.requiredNamespace);
        namespace.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                JSXNamespaceValidationInspection.this.requiredNamespace = namespace.getText();
            }
        });
        CheckBox importPopup = new CheckBox("", (InspectionProfileEntry)this, "importPopup");
        FormBuilder builder = FormBuilder.createFormBuilder();
        builder.addLabeledComponent("Import popup:", (JComponent)importPopup);
        builder.addLabeledComponent("Namespace:", (JComponent)namespace);
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)builder.getPanel(), "North");
        return wrapper;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSXNamespaceValidationInspection";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSXNamespaceValidationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNamespace";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFixes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

