/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.annotations.NotNull;

public class JSLastCommaInObjectLiteralInspection
extends JSInspection {
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.last.comma.in.object.literal.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            JSLastCommaInObjectLiteralInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSObjectLiteralExpression(JSObjectLiteralExpression node) {
                if (DialectDetector.isTypeScript((PsiElement)node) || DialectDetector.isES6((PsiElement)node)) {
                    return;
                }
                PsiElement child = JSLastCommaInObjectLiteralInspection.findErrorNode(node);
                if (child != null) {
                    holder.registerProblem(child, JSBundle.message((String)"javascript.validation.message.unneeded.comma", (Object[])new Object[0]), new LocalQuickFix[]{JSFixFactory.getInstance().removeASTNodeFix("javascript.validation.message.remove.unneeded.comma.fix", child.getNode())});
                }
            }
        };
        if (jSElementVisitor == null) {
            JSLastCommaInObjectLiteralInspection.$$$reportNull$$$0(1);
        }
        return jSElementVisitor;
    }

    public static PsiElement findErrorNode(JSObjectLiteralExpression node) {
        ASTNode childNode;
        PsiElement child;
        PsiElement lastChild = node.getLastChild();
        PsiElement psiElement = child = lastChild != null ? lastChild.getPrevSibling() : null;
        while (child instanceof PsiWhiteSpace || child instanceof PsiComment) {
            child = child.getPrevSibling();
        }
        if (child != null && (childNode = child.getNode()) != null && childNode.getElementType() == JSTokenTypes.COMMA) {
            return child;
        }
        return null;
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            JSLastCommaInObjectLiteralInspection.$$$reportNull$$$0(2);
        }
        return highlightDisplayLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/inspections/JSLastCommaInObjectLiteralInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

