/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.javascript.JavaScriptReferenceContributor;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSJQueryEfficiencyInspection
extends JSInspection {
    private static final boolean JQUERY_ENABLED = true;
    public boolean myAllowAttributeAndPseudoSelectors = true;

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.jquery.efficiency.inspection.message", (Object[])new Object[0]);
        if (string == null) {
            JSJQueryEfficiencyInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JSBundle.message((String)"js.jquery.efficiency.inspection.allow.attribute.and.pseudo.selectors", (Object[])new Object[0]), (InspectionProfileEntry)this, "myAllowAttributeAndPseudoSelectors");
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSCallExpression(JSCallExpression node) {
                JSExpression[] arguments;
                String name;
                JSReferenceExpression refExpr;
                JSExpression methodExpression = node.getMethodExpression();
                if (methodExpression instanceof JSReferenceExpression && (refExpr = (JSReferenceExpression)methodExpression).getQualifier() == null && ("jQuery".equals(name = refExpr.getReferencedName()) || "$".equals(name)) && (arguments = node.getArguments()).length == 1) {
                    JSExpression selector = arguments[0];
                    JSLiteralExpression firstLiteral = null;
                    JSExpression leftmostLiteral = selector;
                    while (leftmostLiteral instanceof JSBinaryExpression) {
                        leftmostLiteral = ((JSBinaryExpression)leftmostLiteral).getLOperand();
                    }
                    if (leftmostLiteral instanceof JSLiteralExpression) {
                        firstLiteral = (JSLiteralExpression)leftmostLiteral;
                    }
                    if (firstLiteral != null && firstLiteral.isQuotedLiteral()) {
                        JSElement scope;
                        JSExpression[] occurrences;
                        JSStatement statement;
                        int firstSpacePos;
                        String selectorText = firstLiteral.getText();
                        if (JavaScriptReferenceContributor.isRawHtmlJQuery(selectorText)) {
                            return;
                        }
                        if (PsiTreeUtil.findChildOfType((PsiElement)firstLiteral, OuterLanguageElement.class) != null) {
                            return;
                        }
                        if (selectorText.startsWith("#", 1) && (firstSpacePos = StringUtil.indexOfAny((String)selectorText, (String)" +~>")) >= 0 && StringUtil.containsAlphaCharacters((String)selectorText.substring(firstSpacePos)) && !selectorText.contains(",")) {
                            holder.registerProblem((PsiElement)selector, JSBundle.message((String)"js.jquery.efficiency.inspection.message", (Object[])new Object[0]), new LocalQuickFix[]{new PrefaceWithIdSelector(selector.getTextOffset() + firstSpacePos, selector.getText().substring(firstSpacePos), selectorText.charAt(0))});
                        }
                        if (!JSJQueryEfficiencyInspection.this.myAllowAttributeAndPseudoSelectors) {
                            if (selectorText.contains("[")) {
                                holder.registerProblem((PsiElement)node, JSBundle.message((String)"js.jquery.efficiency.inspection.attribute.used.message", (Object[])new Object[0]), new LocalQuickFix[0]);
                            }
                            if (selectorText.contains(":")) {
                                holder.registerProblem((PsiElement)node, JSBundle.message((String)"js.jquery.efficiency.inspection.pseudoselector.used.message", (Object[])new Object[0]), new LocalQuickFix[0]);
                            }
                        }
                        if ((statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)node, JSStatement.class, (boolean)false)) != null && !(statement.getParent() instanceof JSIfStatement) && (occurrences = JSUtils.findExpressionOccurrences(scope = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{JSExecutionScope.class, JSBlockStatement.class}), (Pair<JSExpression, TextRange>)Pair.create((Object)node, (Object)null), false)).length > 1) {
                            holder.registerProblem((PsiElement)node, JSBundle.message((String)"js.jquery.efficiency.inspection.duplicated.selector", (Object[])new Object[0]), new LocalQuickFix[0]);
                        }
                    }
                }
                super.visitJSCallExpression(node);
            }
        };
        if (jSElementVisitor == null) {
            JSJQueryEfficiencyInspection.$$$reportNull$$$0(1);
        }
        return jSElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/inspections/JSJQueryEfficiencyInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class PrefaceWithIdSelector
    implements LocalQuickFix {
        private int mySpacePos;
        private String mySelectorAfterSpace;
        private char myQuote;

        PrefaceWithIdSelector(int spacePos, String selectorAfterSpace, char quote) {
            this.mySpacePos = spacePos;
            this.mySelectorAfterSpace = selectorAfterSpace;
            this.myQuote = quote;
        }

        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"js.jquery.efficiency.inspection.preface.with.id.selector", (Object[])new Object[0]);
            if (string == null) {
                PrefaceWithIdSelector.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                PrefaceWithIdSelector.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                PrefaceWithIdSelector.$$$reportNull$$$0(2);
            }
            PsiFile file = descriptor2.getPsiElement().getContainingFile();
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            if (document != null) {
                StringBuilder replacementString = new StringBuilder();
                replacementString.append(this.myQuote);
                replacementString.append(").find(");
                replacementString.append(this.myQuote);
                replacementString.append(this.mySelectorAfterSpace.trim());
                document.replaceString(this.mySpacePos, this.mySpacePos + this.mySelectorAfterSpace.length(), (CharSequence)replacementString);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSJQueryEfficiencyInspection$PrefaceWithIdSelector";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSJQueryEfficiencyInspection$PrefaceWithIdSelector";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

