/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIgnoredPromiseFromCallInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSCallExpression(@NotNull JSCallExpression node) {
                DialectOptionHolder optionHolder;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((optionHolder = DialectDetector.dialectOfElement((PsiElement)node)) == null || optionHolder.isECMA4) {
                    return;
                }
                if (!JSIgnoredPromiseFromCallInspection.isExpressionStatement(node)) {
                    return;
                }
                if (JSIgnoredPromiseFromCallInspection.returnsPromiseType((JSExpression)node)) {
                    JSReferenceExpression referenceExpression = JSIgnoredPromiseFromCallInspection.getReferenceOrNull(node);
                    if (referenceExpression == null) {
                        return;
                    }
                    PsiElement referenceNameElement = referenceExpression.getReferenceNameElement();
                    if (referenceNameElement == null) {
                        return;
                    }
                    String referenceName = referenceExpression.getReferenceName();
                    if ("then".equals(referenceName) || "catch".equals(referenceName) || "finally".equals(referenceName)) {
                        return;
                    }
                    holder.registerProblem(referenceNameElement, JSBundle.message((String)"js.inspection.promise.ignored.problem.descriptor", (Object[])new Object[]{referenceName}), new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSIgnoredPromiseFromCallInspection$1", "visitJSCallExpression"));
            }
        };
        if (jSElementVisitor == null) {
            JSIgnoredPromiseFromCallInspection.$$$reportNull$$$0(0);
        }
        return jSElementVisitor;
    }

    private static boolean returnsPromiseType(@NotNull JSExpression expression) {
        JSTypeEvaluationResult resolveResult;
        if (expression == null) {
            JSIgnoredPromiseFromCallInspection.$$$reportNull$$$0(1);
        }
        List types = (resolveResult = JSTypeEvaluator.getExpressionType(expression)) != null ? ContainerUtil.map(resolveResult.getResults(), e -> e.getType()) : ContainerUtil.emptyList();
        return !types.isEmpty() && ContainerUtil.and((Iterable)types, element -> JSTypeUtils.isPromiseType(element) || JSIgnoredPromiseFromCallInspection.implementsPromiseLike(element));
    }

    private static boolean implementsPromiseLike(@Nullable JSType expressionType) {
        Collection<? extends PsiElement> resolvedTypes = TypeScriptTypeParser.resolveElementsByType(expressionType);
        return !resolvedTypes.isEmpty() && ContainerUtil.and(resolvedTypes, typeResolveResult -> JSIgnoredPromiseFromCallInspection.implementsPromiseLike(typeResolveResult instanceof JSClass ? (JSClass)typeResolveResult : null));
    }

    private static boolean implementsPromiseLike(@Nullable JSClass resolvedClass) {
        if (resolvedClass == null) {
            return false;
        }
        Ref implementationFound = new Ref((Object)false);
        JSClassUtils.processClassesInHierarchy(resolvedClass, true, (aClass, substitutor, fromImplements) -> {
            if ("PromiseLike".equals(aClass.getName())) {
                implementationFound.set((Object)true);
                return false;
            }
            return true;
        });
        return (Boolean)implementationFound.get();
    }

    @Nullable
    private static JSReferenceExpression getReferenceOrNull(@NotNull JSCallExpression node) {
        JSExpression methodExpression;
        if (node == null) {
            JSIgnoredPromiseFromCallInspection.$$$reportNull$$$0(2);
        }
        return (methodExpression = node.getMethodExpression()) != null && methodExpression instanceof JSReferenceExpression ? (JSReferenceExpression)methodExpression : null;
    }

    private static boolean isExpressionStatement(@NotNull JSCallExpression call) {
        if (call == null) {
            JSIgnoredPromiseFromCallInspection.$$$reportNull$$$0(3);
        }
        return JSUtils.getParentSkipParentheses((PsiElement)call) instanceof JSExpressionStatement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSIgnoredPromiseFromCallInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSIgnoredPromiseFromCallInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "returnsPromiseType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceOrNull";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isExpressionStatement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

