/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationProcessor;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.OrderedSet;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSClosureCompilerSyntaxInspection
extends JSInspection {
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.closure.compiler.syntax.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(1);
        }
        return highlightDisplayLevel;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSDocComment(JSDocComment docComment) {
                if (!DialectDetector.isJavaScript((PsiElement)docComment)) {
                    return;
                }
                PsiElement errorElement = JSDocumentationUtils.findAttachedElementFromComment((PsiComment)docComment);
                THashSet commentInterfaces = new THashSet();
                boolean hasImplements = false;
                boolean hasExtends = false;
                for (JSDocTag tag : docComment.getTags()) {
                    JSDocumentationUtils.DocTag docTag = JSDocumentationUtils.getDocTag(tag.getText());
                    if (docTag == null) continue;
                    if (docTag.type == JSDocumentationProcessor.MetaDocType.IMPLEMENTS) {
                        hasImplements = true;
                        JSDocTagValue tagValue = tag.getValue();
                        if (tagValue == null) continue;
                        JSType type = JSTypeUtils.createType(docTag.matchName, JSTypeSource.EMPTY);
                        if (type instanceof JSGenericTypeImpl) {
                            type = ((JSGenericTypeImpl)type).getType();
                        }
                        if (type instanceof JSTypeImpl && JSSymbolUtil.isInterface(type.getTypeText(JSType.TypeTextFormat.SIMPLE), (PsiElement)docComment)) {
                            commentInterfaces.add(docTag.matchName);
                            continue;
                        }
                        holder.registerProblem((PsiElement)tagValue, JSBundle.message((String)"js.closure.compiler.syntax.implements.not.interface", (Object[])new Object[]{docTag.matchName}), new LocalQuickFix[0]);
                        continue;
                    }
                    if (docTag.type == JSDocumentationProcessor.MetaDocType.EXTENDS) {
                        hasExtends = true;
                        continue;
                    }
                    this.checkTypeInDocTag(tag, docTag);
                }
                final String className = docComment.findNameOfClassAppliedTo();
                if (className != null && (hasImplements || hasExtends)) {
                    OrderedSet implementedInterfaces = new OrderedSet();
                    OrderedSet classesInHierarchy = new OrderedSet();
                    classesInHierarchy.add((Object)className);
                    final PsiElement elementToHighlight = errorElement != null ? errorElement : docComment;
                    JSTypeEvaluateManager.iterateTypeHierarchy((PsiElement)docComment, Collections.singleton(className), false, new JSTypeEvaluateManager.NamespaceProcessor((Set)commentInterfaces, docComment, implementedInterfaces, classesInHierarchy){
                        final /* synthetic */ Set val$commentInterfaces;
                        final /* synthetic */ JSDocComment val$docComment;
                        final /* synthetic */ OrderedSet val$implementedInterfaces;
                        final /* synthetic */ OrderedSet val$classesInHierarchy;
                        {
                            this.val$commentInterfaces = set;
                            this.val$docComment = jSDocComment;
                            this.val$implementedInterfaces = orderedSet;
                            this.val$classesInHierarchy = orderedSet2;
                        }

                        @Override
                        public boolean process(String serializedType, VirtualFile file) {
                            String qName = JSTypeUtils.getTypeMatchingNamespace(serializedType);
                            if (className.equals(qName)) {
                                holder.registerProblem(elementToHighlight, JSBundle.message((String)"js.closure.compiler.syntax.cyclic.inheritance", (Object[])new Object[]{className}), new LocalQuickFix[0]);
                            } else if (this.val$commentInterfaces.contains(qName) || JSSymbolUtil.isInterface(qName, (PsiElement)this.val$docComment)) {
                                this.val$implementedInterfaces.add((Object)qName);
                            } else {
                                this.val$classesInHierarchy.add((Object)qName);
                            }
                            return true;
                        }
                    });
                    if (JSSymbolUtil.isInterface(className, (PsiElement)docComment)) {
                        return;
                    }
                    GlobalSearchScope scope = JSResolveUtil.getResolveScope(elementToHighlight);
                    Function classMembersCollector = name -> JSClassResolver.getInstance().findNamespaceMembers((String)name, scope);
                    JSClosureCompilerSyntaxInspection.processUnimplementedMethods(className, elementToHighlight, (Set)implementedInterfaces, (Set)classesInHierarchy, classMembersCollector, t -> t, holder);
                }
            }

            private void checkTypeInDocTag(@NotNull JSDocTag psiTag, JSDocumentationUtils.DocTag tag) {
                if (psiTag == null) {
                    1.$$$reportNull$$$0(0);
                }
                String type = tag.type == JSDocumentationProcessor.MetaDocType.TYPE || tag.type == JSDocumentationProcessor.MetaDocType.ENUM || tag.type == JSDocumentationProcessor.MetaDocType.TYPEDEF || tag.type == JSDocumentationProcessor.MetaDocType.EXTENDS || tag.type == JSDocumentationProcessor.MetaDocType.IMPLEMENTS || tag.type == JSDocumentationProcessor.MetaDocType.RETURN || tag.type == JSDocumentationProcessor.MetaDocType.THIS || tag.type == JSDocumentationProcessor.MetaDocType.LENDS || tag.type == JSDocumentationProcessor.MetaDocType.MIXIN || tag.type == JSDocumentationProcessor.MetaDocType.MIXES || tag.type == JSDocumentationProcessor.MetaDocType.THROWS ? tag.matchName : (tag.type == JSDocumentationProcessor.MetaDocType.PARAMETER || tag.type == JSDocumentationProcessor.MetaDocType.PROPERTY ? tag.matchValue : null);
                JSDocTagValue value = psiTag.getValue();
                if (value != null && type != null) {
                    if (type.trim().isEmpty()) {
                        holder.registerProblem((PsiElement)value, JSBundle.message((String)"js.closure.compiler.syntax.empty.type", (Object[])new Object[0]), new LocalQuickFix[0]);
                    } else {
                        boolean parsedCorrectly;
                        boolean bl = parsedCorrectly = (tag.type == JSDocumentationProcessor.MetaDocType.PARAMETER ? new JSTypeParser(type, JSTypeSource.EMPTY).parseParameterType() : new JSTypeParser(type, JSTypeSource.EMPTY).parse()) != null;
                        if (!parsedCorrectly) {
                            holder.registerProblem((PsiElement)value, JSBundle.message((String)"js.closure.compiler.syntax.invalid.type", (Object[])new Object[0]), new LocalQuickFix[0]);
                        }
                    }
                }
            }

            public void visitJSNewExpression(JSNewExpression node) {
                super.visitJSNewExpression(node);
                if (!DialectDetector.isJavaScript((PsiElement)node)) {
                    return;
                }
                JSExpression expression = node.getMethodExpression();
                if (expression instanceof JSReferenceExpression) {
                    JSDocComment docComment;
                    JSElementBase classOrInterface = (JSElementBase)ObjectUtils.tryCast((Object)((JSReferenceExpression)expression).resolve(), JSElementBase.class);
                    if (classOrInterface == null) {
                        return;
                    }
                    if (classOrInterface.isClassOrInterface() == JSElementBase.ClassOrInterface.INTERFACE) {
                        holder.registerProblem((PsiElement)expression, JSBundle.message((String)"javascript.interface.can.not.be.instantiated.message", (Object[])new Object[0]), new LocalQuickFix[0]);
                    } else if (classOrInterface.isClassOrInterface() == JSElementBase.ClassOrInterface.CLASS && (docComment = JSClosureCompilerSyntaxInspection.findDocComment((JSElement)classOrInterface)) != null && docComment.hasAbstractTag()) {
                        holder.registerProblem((PsiElement)expression, JSBundle.message((String)"javascript.abstract.class.can.not.be.instantiated.message", (Object[])new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }

            public void visitJSParameterList(JSParameterList node) {
                if (!DialectDetector.isJavaScript((PsiElement)node)) {
                    return;
                }
                boolean foundRest = false;
                for (JSParameterListElement parameter : node.getParameters()) {
                    if (parameter.getTypeDecorator().isRest() && !parameter.isRest()) {
                        foundRest = true;
                        continue;
                    }
                    if (!foundRest) continue;
                    holder.registerProblem((PsiElement)parameter, JSBundle.message((String)"javascript.validation.message.parameter.is.not.allowed.after.rest.parameter", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }

            public void visitJSClass(JSClass aClass) {
                if (!DialectDetector.isJavaScript((PsiElement)aClass)) {
                    return;
                }
                JSDocComment docComment = JSClosureCompilerSyntaxInspection.findDocComment((JSElement)aClass);
                if (docComment != null && docComment.hasAbstractTag()) {
                    return;
                }
                OrderedSet superClasses = new OrderedSet();
                JSClassUtils.processClassesInHierarchy(aClass, false, (arg_0, arg_1, arg_2) -> 1.lambda$visitJSClass$2((Set)superClasses, arg_0, arg_1, arg_2));
                JSClosureCompilerSyntaxInspection.processUnimplementedMethods(aClass, (PsiElement)aClass, Collections.emptySet(), (Set)superClasses, superClass -> Arrays.asList(superClass.getFunctions()), JSClass::getName, holder);
            }

            private static /* synthetic */ boolean lambda$visitJSClass$2(Set superClasses, JSClass superClass, JSTypeSubstitutor substitutor, boolean __) {
                superClasses.add(superClass);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiTag", "com/intellij/lang/javascript/inspections/JSClosureCompilerSyntaxInspection$1", "checkTypeInDocTag"));
            }
        };
        if (jSElementVisitor == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(2);
        }
        return jSElementVisitor;
    }

    private static <T> void processUnimplementedMethods(@NotNull T sourceClass, @NotNull PsiElement errorElement, @NotNull Set<T> implementedInterfaces, @NotNull Set<T> classesInHierarchy, @NotNull Function<T, Collection<JSPsiElementBase>> getClassMethods, @NotNull Function<T, String> getName, @NotNull ProblemsHolder holder) {
        JSSourceElement parent;
        if (sourceClass == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(3);
        }
        if (errorElement == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(4);
        }
        if (implementedInterfaces == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(5);
        }
        if (classesInHierarchy == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(6);
        }
        if (getClassMethods == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(7);
        }
        if (getName == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(8);
        }
        if (holder == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(9);
        }
        THashMap methodsToImplement = new THashMap();
        ArrayList<String> implementedMethods = new ArrayList<String>(3);
        for (T superClass : classesInHierarchy) {
            for (JSPsiElementBase member : (Collection)getClassMethods.fun(superClass)) {
                if (member.getJSContext() == JSContext.STATIC) continue;
                JSDocComment docComment = JSClosureCompilerSyntaxInspection.findDocComment((JSElement)member);
                if (docComment != null && docComment.hasAbstractTag() && !sourceClass.equals(superClass)) {
                    methodsToImplement.putIfAbsent(member.getName(), new MethodToImplement(member, true, (String)getName.fun(superClass)));
                    continue;
                }
                implementedMethods.add(member.getName());
            }
        }
        for (Object implementedInterface : implementedInterfaces) {
            for (JSPsiElementBase member : (Collection)getClassMethods.fun(implementedInterface)) {
                if (member.getJSContext() != JSContext.INSTANCE) continue;
                methodsToImplement.putIfAbsent(member.getName(), new MethodToImplement(member, false, (String)getName.fun(implementedInterface)));
            }
        }
        ArrayList notImplemented = new ArrayList(3);
        for (Map.Entry entry : methodsToImplement.entrySet()) {
            String methodToImplement = (String)entry.getKey();
            if (implementedMethods.contains(methodToImplement)) continue;
            notImplemented.add(entry.getValue());
        }
        if (!notImplemented.isEmpty() && (parent = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)errorElement, JSSourceElement.class, (boolean)false)) != null) {
            THashMap tHashMap = new THashMap(notImplemented.size());
            for (int i = 0; i < notImplemented.size(); ++i) {
                PsiElement nameIdentifier;
                LocalQuickFix[] fix;
                LocalQuickFix[] localQuickFixArray;
                MethodToImplement toImplement = (MethodToImplement)notImplemented.get(i);
                String notImplementedName = toImplement.member.getName();
                tHashMap.put(notImplementedName, toImplement.buildParameterList());
                String key = toImplement.isAbstractMethod ? "javascript.validation.message.abstract.method.not.implemented" : "javascript.validation.message.interface.method.not.implemented";
                String message = JSBundle.message((String)key, (Object[])new Object[]{notImplementedName, toImplement.baseClassName});
                if (i == notImplemented.size() - 1) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = JSFixFactory.getInstance().implementJSDocMethodsFix((String)getName.fun(sourceClass), (Map<String, String>)tHashMap);
                } else {
                    localQuickFixArray = fix = LocalQuickFix.EMPTY_ARRAY;
                }
                if (errorElement instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)errorElement).getNameIdentifier()) != null) {
                    errorElement = nameIdentifier;
                }
                holder.registerProblem(errorElement, message, fix);
            }
        }
    }

    @Nullable
    private static JSDocComment findDocComment(@NotNull JSElement member) {
        if (member == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(10);
        }
        return JSStubBasedPsiTreeUtil.findDocComment((PsiElement)member);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSClosureCompilerSyntaxInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementedInterfaces";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesInHierarchy";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getClassMethods";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSClosureCompilerSyntaxInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processUnimplementedMethods";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findDocComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MethodToImplement {
        final JSPsiElementBase member;
        final boolean isAbstractMethod;
        final String baseClassName;

        public MethodToImplement(JSPsiElementBase member, boolean isAbstractMethod, String baseClassName) {
            this.member = member;
            this.isAbstractMethod = isAbstractMethod;
            this.baseClassName = baseClassName;
        }

        String buildParameterList() {
            JSFunctionItem function = JSPsiImplUtils.getPossibleFunctionItem((PsiElement)this.member);
            StringBuilder builder = new StringBuilder("(");
            if (function != null) {
                builder.append(Arrays.stream(function.getParameters()).map(p -> p.getName()).reduce((p1, p2) -> p1 + ", " + p2).orElse(""));
            }
            builder.append(")");
            return builder.toString();
        }
    }
}

