/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.index.JSCustomIndexer;
import com.intellij.lang.javascript.index.JSImplicitElementsIndex;
import com.intellij.lang.javascript.index.JSIndexContentBuilder;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.util.Key;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.indexing.FileContent;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIndexContent {
    public static final String REQUIRE_DATA_MAIN_KEY = "js.require.data.main";
    private static final Key<JSIndexContent> ourJSIndexContent = Key.create((String)"js.index.content");
    @NotNull
    public final Map<String, Collection<JSImplicitElementsIndex.JSElementProxy>> myImplicitElements;
    @NotNull
    public final Map<String, String> myCustomSingleEntries;
    @NotNull
    private final Map<Key, Object> myAdditionalData;

    public JSIndexContent(@NotNull JSIndexContentBuilder builder) {
        if (builder == null) {
            JSIndexContent.$$$reportNull$$$0(0);
        }
        this.myImplicitElements = builder.myImplicitElements;
        this.myCustomSingleEntries = builder.myCustomSingleEntries;
        this.myAdditionalData = builder.myAdditionalData;
    }

    @NotNull
    public Map<String, Collection<JSImplicitElementsIndex.JSElementProxy>> getImplicitElements() {
        Map<String, Collection<JSImplicitElementsIndex.JSElementProxy>> map = this.myImplicitElements;
        if (map == null) {
            JSIndexContent.$$$reportNull$$$0(1);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static JSIndexContent indexFile(FileContent content) {
        JSIndexContent indexContent = (JSIndexContent)content.getUserData(ourJSIndexContent);
        if (indexContent != null) {
            JSIndexContent jSIndexContent = indexContent;
            if (jSIndexContent != null) return jSIndexContent;
            JSIndexContent.$$$reportNull$$$0(2);
            return jSIndexContent;
        }
        FileContent fileContent = content;
        // MONITORENTER : fileContent
        indexContent = (JSIndexContent)content.getUserData(ourJSIndexContent);
        if (indexContent != null) {
            JSIndexContent jSIndexContent = indexContent;
            // MONITOREXIT : fileContent
            if (jSIndexContent != null) return jSIndexContent;
            JSIndexContent.$$$reportNull$$$0(3);
            return jSIndexContent;
        }
        indexContent = JSIndexContent.get(JSIndexContent.getPsiFileForIndexing(content));
        content.putUserData(ourJSIndexContent, (Object)indexContent);
        JSIndexContent jSIndexContent = indexContent;
        // MONITOREXIT : fileContent
        if (jSIndexContent != null) return jSIndexContent;
        JSIndexContent.$$$reportNull$$$0(4);
        return jSIndexContent;
    }

    @NotNull
    private static PsiFile getPsiFileForIndexing(FileContent content) {
        PsiFile psiFile = content.getPsiFile();
        if (psiFile == null) {
            JSIndexContent.$$$reportNull$$$0(5);
        }
        return psiFile;
    }

    @NotNull
    private static JSIndexContent createFromFile(@NotNull PsiFile file) {
        if (file == null) {
            JSIndexContent.$$$reportNull$$$0(6);
        }
        JSIndexContentBuilder indexBuilder = new JSIndexContentBuilder();
        JSCustomIndexer indexer = JSDialectSpecificHandlersFactory.forElement((PsiElement)file).createCustomIndexer(file, indexBuilder);
        JSIndexContent.acceptChildren(file, (PsiElementVisitor)indexer);
        if (file instanceof JSFile) {
            indexer.processJsFile((JSFile)file);
        }
        JSIndexContent jSIndexContent = new JSIndexContent(indexBuilder);
        if (jSIndexContent == null) {
            JSIndexContent.$$$reportNull$$$0(7);
        }
        return jSIndexContent;
    }

    public static void acceptChildren(PsiFile file, PsiElementVisitor visitor) {
        if (file instanceof JSFile) {
            return;
        }
        if (file instanceof XmlFile) {
            file.acceptChildren(visitor);
            return;
        }
        FileViewProvider provider = file.getViewProvider();
        if (!JSImplicitElementsIndex.Holder.containFileType(file.getFileType())) {
            PsiFile psiFile = provider.getPsi((Language)HTMLLanguage.INSTANCE);
            if (psiFile != null) {
                psiFile.acceptChildren(visitor);
            }
            return;
        }
        for (PsiFile psiFile : provider.getAllFiles()) {
            psiFile.acceptChildren(visitor);
        }
    }

    @Nullable
    public <T> T getAdditionalData(@NotNull Key<T> key) {
        if (key == null) {
            JSIndexContent.$$$reportNull$$$0(8);
        }
        return (T)key.get(this.myAdditionalData);
    }

    @NotNull
    public static JSIndexContent get(@NotNull PsiFile file) {
        if (file == null) {
            JSIndexContent.$$$reportNull$$$0(9);
        }
        JSIndexContent jSIndexContent = (JSIndexContent)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            if (file == null) {
                JSIndexContent.$$$reportNull$$$0(11);
            }
            return new CachedValueProvider.Result((Object)JSIndexContent.createFromFile(file), new Object[]{file});
        });
        if (jSIndexContent == null) {
            JSIndexContent.$$$reportNull$$$0(10);
        }
        return jSIndexContent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/JSIndexContent";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/JSIndexContent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitElements";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "indexFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFileForIndexing";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFromFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalData";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$get$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

