/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.lang.javascript.psi.types.JSApplyCallType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFileCachedDataEvaluator
extends JSElementVisitor {
    @NotNull
    protected final JSFileCachedData myCachedData;
    private final Stack<Boolean> mySkipChildren;
    private boolean mySkipCurrentElementChildren;

    public JSFileCachedDataEvaluator(@NotNull JSFileCachedData outCachedData) {
        if (outCachedData == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(0);
        }
        this.mySkipChildren = ContainerUtil.newStack();
        this.myCachedData = outCachedData;
    }

    public void setSkipChildren() {
        this.mySkipCurrentElementChildren = true;
    }

    public boolean isSkipChildren() {
        return !this.mySkipChildren.isEmpty() && (Boolean)this.mySkipChildren.peek() != false;
    }

    public void startElement(@NotNull PsiElement element) {
        if (element == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(1);
        }
        this.mySkipCurrentElementChildren = this.isSkipChildren();
        if (!this.mySkipCurrentElementChildren) {
            element.accept((PsiElementVisitor)this);
        }
        this.mySkipChildren.push((Object)this.mySkipCurrentElementChildren);
    }

    public void finishElement(@NotNull PsiElement element) {
        if (element == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(2);
        }
        this.mySkipCurrentElementChildren = (Boolean)this.mySkipChildren.pop();
    }

    public void visitJSCallExpression(JSCallExpression node) {
        JSType type;
        JSExpression moduleInitializer;
        if (node.isRequireCall()) {
            this.myCachedData.applyModuleStatus(JSFileCachedDataEvaluator.getStatusForCommonJSMarker((JSExpression)node));
        } else if (JSAmdPsiUtil.isDefineCall(node) && (moduleInitializer = JSAmdPsiUtil.getModuleInitializer(node)) instanceof JSFunctionExpression && (type = JSSymbolUtil.evaluateModuleInnerAlias((JSFunction)((JSFunctionExpression)moduleInitializer), "exports")) != null) {
            this.myCachedData.setExportsInnerAlias(type);
        }
    }

    public void visitJSAssignmentExpression(JSAssignmentExpression node) {
        JSExpression lOperand = node.getLOperand();
        if (lOperand instanceof JSDefinitionExpression) {
            lOperand = ((JSDefinitionExpression)lOperand).getExpression();
        }
        if (lOperand instanceof JSReferenceExpression) {
            JSExpression qualifier;
            if (JSSymbolUtil.isExportReference((JSReferenceExpression)lOperand)) {
                JSType type;
                this.myCachedData.applyModuleStatus(JSFileCachedDataEvaluator.getStatusForCommonJSMarker((JSExpression)node));
                JSExpression rOperand = node.getROperand();
                if (rOperand != null && (type = this.getExportsInnerAliasType(rOperand)) != null) {
                    this.myCachedData.setExportsInnerAlias(type);
                }
            }
            if ((qualifier = ((JSReferenceExpression)lOperand).getQualifier()) instanceof JSReferenceExpression && JSSymbolUtil.isExportReference((JSReferenceExpression)qualifier)) {
                this.myCachedData.applyModuleStatus(JSFileCachedDataEvaluator.getStatusForCommonJSMarker((JSExpression)node));
            }
        }
    }

    @NotNull
    private static JSFile.ModuleStatus getStatusForCommonJSMarker(JSExpression element) {
        JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSStatement.class);
        JSFile.ModuleStatus moduleStatus = statement != null && statement.getParent() instanceof PsiFile ? JSFile.ModuleStatus.COMMONJS : JSFile.ModuleStatus.MAYBE_COMMONJS;
        if (moduleStatus == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(3);
        }
        return moduleStatus;
    }

    @Nullable
    private JSType getExportsInnerAliasType(@NotNull JSExpression expression) {
        if (expression == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(4);
        }
        for (FrameworkIndexingHandler indexingHandler : FrameworkIndexingHandler.getExtensions((PsiElement)expression)) {
            JSType type = indexingHandler.getExportsInnerAliasType(expression);
            if (type == null) continue;
            return type;
        }
        return JSFileCachedDataEvaluator.getTypeForExportedElement(expression, this.myCachedData);
    }

    public static JSType getTypeForExportedElement(@NotNull JSExpression expression) {
        if (expression == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(5);
        }
        return JSFileCachedDataEvaluator.getTypeForExportedElement(expression, null);
    }

    @Nullable
    private static JSType getTypeForExportedElement(@NotNull JSExpression expression, @Nullable JSFileCachedData fileCachedDataForExportsInnerAlias) {
        JSRequireCallExpressionType reexportType;
        JSNamespaceEvaluationResult result;
        JSType methodExpressionType;
        JSExpression methodExpression;
        if (expression == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(6);
        }
        if (expression instanceof JSDefinitionExpression) {
            expression = ((JSDefinitionExpression)expression).getExpression();
        }
        if (expression == null) {
            return null;
        }
        JSType nsType = null;
        JSCallExpression requireCall = null;
        if (expression instanceof JSAssignmentExpression) {
            JSType rType;
            JSExpression lOperand = ((JSAssignmentExpression)expression).getLOperand();
            JSExpression rOperand = ((JSAssignmentExpression)expression).getROperand();
            JSType lType = lOperand != null ? JSFileCachedDataEvaluator.getTypeForExportedElement(lOperand, fileCachedDataForExportsInnerAlias) : null;
            JSType jSType = rType = rOperand != null ? JSFileCachedDataEvaluator.getTypeForExportedElement(rOperand, fileCachedDataForExportsInnerAlias) : null;
            if (lType == null) {
                return rType;
            }
            if (rType == null) {
                return lType;
            }
            return JSCompositeTypeImpl.getCommonType(lType, rType, null, false);
        }
        if (expression instanceof JSReferenceExpression) {
            JSElement refExprValue;
            JSType type;
            JSNamespaceEvaluationResult namespace = JSSymbolUtil.evaluateNamespaceLocallyAsIs(expression);
            JSType jSType = type = namespace != null ? namespace.toType((PsiElement)expression) : null;
            if (type instanceof JSNamedType) {
                nsType = type;
            }
            if ((refExprValue = JSSymbolUtil.calcRefExprValue((JSReferenceExpression)expression)) instanceof JSCallExpression && ((JSCallExpression)refExprValue).isRequireCall()) {
                requireCall = (JSCallExpression)refExprValue;
            }
            if (fileCachedDataForExportsInnerAlias != null && refExprValue instanceof JSExpression && JSFileCachedDataEvaluator.referencesImport((JSExpression)refExprValue, fileCachedDataForExportsInnerAlias)) {
                fileCachedDataForExportsInnerAlias.setReferencesImportInDefaultExport();
            }
        } else if (expression instanceof JSFunctionExpression) {
            JSType type = JSSymbolUtil.evaluateReturnedTypeLocally((JSFunction)((JSFunctionExpression)expression));
            if (type instanceof JSNamedType) {
                return new JSFunctionTypeImpl(JSTypeSource.EMPTY, Collections.emptyList(), type);
            }
        } else if (expression instanceof JSCallExpression && ((JSCallExpression)expression).isRequireCall()) {
            requireCall = (JSCallExpression)expression;
        } else if (expression instanceof JSCallExpression && !(expression instanceof JSNewExpression) && (methodExpression = ((JSCallExpression)expression).getMethodExpression()) != null && (methodExpressionType = JSFileCachedDataEvaluator.getTypeForExportedElement(methodExpression, fileCachedDataForExportsInnerAlias)) != null) {
            return new JSApplyCallType(methodExpressionType, JSTypeSource.EMPTY);
        }
        if (nsType == null && requireCall == null && (result = JSSymbolUtil.evaluateNamespaceLocally(expression)) != null) {
            nsType = result.toType((PsiElement)expression);
        }
        if (requireCall == null) {
            return nsType;
        }
        String path = CommonJSUtil.getRequireCallModulePath(requireCall);
        JSRequireCallExpressionType jSRequireCallExpressionType = reexportType = path != null ? new JSRequireCallExpressionType(path, JSTypeSource.EMPTY) : null;
        return reexportType == null ? nsType : (nsType == null ? reexportType : JSCompositeTypeImpl.getCommonType(nsType, reexportType, null, false));
    }

    private static boolean referencesImport(@NotNull JSExpression expression, @NotNull JSFileCachedData cachedData) {
        if (expression == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(7);
        }
        if (cachedData == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(8);
        }
        final Ref referencesImport = Ref.create((Object)Boolean.FALSE);
        expression.accept((PsiElementVisitor)new JSRecursiveWalkingElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                JSExpression initializer;
                JSElement localResolve;
                String referenceName = node.getReferenceName();
                if (node.getQualifier() == null && referenceName != null && (localResolve = JSSymbolUtil.resolveLocallyIncludingDefinitions(referenceName, (JSElement)node)) instanceof JSInitializerOwner && (initializer = ((JSInitializerOwner)localResolve).getInitializer()) instanceof JSCallExpression && ((JSCallExpression)initializer).isRequireCall()) {
                    referencesImport.set((Object)Boolean.TRUE);
                    this.stopWalking();
                }
                super.visitJSReferenceExpression(node);
            }

            public void visitJSCallExpression(JSCallExpression node) {
                if (node.isRequireCall()) {
                    referencesImport.set((Object)Boolean.TRUE);
                    this.stopWalking();
                }
                super.visitJSCallExpression(node);
            }

            public boolean visitAsFunction(JSFunction function) {
                return true;
            }
        });
        if (((Boolean)referencesImport.get()).booleanValue()) {
            cachedData.setReferencesImportInDefaultExport();
        }
        return (Boolean)referencesImport.get();
    }

    public void visitES6ImportDeclaration(ES6ImportDeclaration importDeclaration) {
        this.myCachedData.applyModuleStatus(JSFile.ModuleStatus.ES6);
        this.myCachedData.setHasES6Syntax();
        this.setSkipChildren();
    }

    public void visitES6ExportDefaultAssignment(ES6ExportDefaultAssignment node) {
        this.myCachedData.applyModuleStatus(JSFile.ModuleStatus.ES6);
        this.myCachedData.setHasES6Syntax();
        this.setSkipChildren();
    }

    public void visitES6ExportDeclaration(ES6ExportDeclaration exportDeclaration) {
        this.myCachedData.applyModuleStatus(JSFile.ModuleStatus.ES6);
        this.myCachedData.setHasES6Syntax();
        this.setSkipChildren();
    }

    public void visitJSVariable(JSVariable node) {
        this.checkIfExportStatement((JSAttributeListOwner)node);
    }

    public void visitJSClass(JSClass aClass) {
        this.checkIfExportStatement((JSAttributeListOwner)aClass);
        this.setSkipChildren();
    }

    public void visitJSFunctionDeclaration(JSFunction node) {
        this.checkIfExportStatement((JSAttributeListOwner)node);
        this.setSkipChildren();
    }

    private void checkIfExportStatement(@NotNull JSAttributeListOwner node) {
        JSAttributeList attributeList;
        if (node == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(9);
        }
        if ((attributeList = node.getAttributeList()) != null && attributeList.getNode().findChildByType(JSTokenTypes.EXPORT_KEYWORD) != null) {
            this.myCachedData.applyModuleStatus(JSFile.ModuleStatus.ES6);
            this.myCachedData.setHasES6Syntax();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outCachedData";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/JSFileCachedDataEvaluator";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedData";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/JSFileCachedDataEvaluator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusForCommonJSMarker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "startElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "finishElement";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getExportsInnerAliasType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTypeForExportedElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "referencesImport";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkIfExportStatement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

