/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRecursiveCallLineMarkerProvider
extends LineMarkerProviderDescriptor {
    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            JSRecursiveCallLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    @Nullable
    public String getName() {
        return "Recursive call";
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            JSRecursiveCallLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            JSRecursiveCallLineMarkerProvider.$$$reportNull$$$0(2);
        }
        THashSet visited = ContainerUtil.newTroveSet();
        for (PsiElement element : elements) {
            PsiElement identifier;
            JSFunction containingFunction;
            ProgressManager.checkCanceled();
            if (!(element instanceof JSReferenceExpression)) continue;
            JSReferenceExpression referenceExpression = (JSReferenceExpression)element;
            JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSStatement.class, (boolean)true, (Class[])new Class[]{JSSourceElement.class});
            if (statement == null || visited.contains(statement) || (containingFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)statement, JSFunction.class)) == null) continue;
            if (JSRecursiveCallLineMarkerProvider.isInCallExpression(referenceExpression) && JSRecursiveCallLineMarkerProvider.isRecursiveCall(referenceExpression, containingFunction)) {
                visited.add(statement);
                identifier = referenceExpression.getReferenceNameElement();
                if (identifier == null) continue;
                result.add(new RecursiveMethodCallMarkerInfo(identifier));
                continue;
            }
            if (!containingFunction.isGetProperty() && !containingFunction.isSetProperty() || !JSRecursiveCallLineMarkerProvider.isRecursivePropertyCall(referenceExpression, containingFunction)) continue;
            visited.add(statement);
            identifier = referenceExpression.getReferenceNameElement();
            if (identifier == null) continue;
            result.add(new RecursiveMethodCallMarkerInfo(identifier));
        }
    }

    private static boolean isRecursivePropertyCall(@NotNull JSReferenceExpression expression, @NotNull JSFunction function) {
        ReadWriteAccessDetector.Access accessType;
        if (expression == null) {
            JSRecursiveCallLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (function == null) {
            JSRecursiveCallLineMarkerProvider.$$$reportNull$$$0(4);
        }
        return ((accessType = JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)expression)) == ReadWriteAccessDetector.Access.ReadWrite || function.isGetProperty() && accessType == ReadWriteAccessDetector.Access.Read || function.isSetProperty() && accessType == ReadWriteAccessDetector.Access.Write) && JSRecursiveCallLineMarkerProvider.isRecursiveCall(expression, function);
    }

    private static boolean isInCallExpression(@NotNull JSReferenceExpression referenceExpression) {
        PsiElement parent;
        if (referenceExpression == null) {
            JSRecursiveCallLineMarkerProvider.$$$reportNull$$$0(5);
        }
        return (parent = referenceExpression.getParent()) instanceof JSCallExpression && ((JSCallExpression)parent).getMethodExpression() == referenceExpression;
    }

    private static boolean isRecursiveCall(@NotNull JSReferenceExpression ref, @NotNull JSFunction parentFunction) {
        String name;
        if (ref == null) {
            JSRecursiveCallLineMarkerProvider.$$$reportNull$$$0(6);
        }
        if (parentFunction == null) {
            JSRecursiveCallLineMarkerProvider.$$$reportNull$$$0(7);
        }
        if ((name = ref.getReferenceName()) == null) {
            return false;
        }
        if (!name.equals(parentFunction.getName())) {
            return false;
        }
        return JSRecursiveCallLineMarkerProvider.isClassOrLiteralMethodRecursiveCall(ref, parentFunction) || JSRecursiveCallLineMarkerProvider.isGlobalFunctionRecursiveCall(ref, parentFunction);
    }

    private static boolean isClassOrLiteralMethodRecursiveCall(@NotNull JSReferenceExpression referenceExpression, @NotNull JSFunction parentFunction) {
        PsiElement parent;
        if (referenceExpression == null) {
            JSRecursiveCallLineMarkerProvider.$$$reportNull$$$0(8);
        }
        if (parentFunction == null) {
            JSRecursiveCallLineMarkerProvider.$$$reportNull$$$0(9);
        }
        if ((parent = JSResolveUtil.findParent((PsiElement)parentFunction)) instanceof JSClass || parent instanceof JSObjectLiteralExpression || parent instanceof JSProperty) {
            return referenceExpression.getQualifier() instanceof JSThisExpression;
        }
        return false;
    }

    private static boolean isGlobalFunctionRecursiveCall(@NotNull JSReferenceExpression referenceExpression, @NotNull JSFunction parentFunction) {
        if (referenceExpression == null) {
            JSRecursiveCallLineMarkerProvider.$$$reportNull$$$0(10);
        }
        if (parentFunction == null) {
            JSRecursiveCallLineMarkerProvider.$$$reportNull$$$0(11);
        }
        if (referenceExpression.getQualifier() != null) {
            return false;
        }
        return JSRecursiveCallLineMarkerProvider.checkResolvedEqual(referenceExpression, parentFunction);
    }

    private static boolean checkResolvedEqual(@NotNull JSReferenceExpression referenceExpression, @NotNull JSFunction parentFunction) {
        if (referenceExpression == null) {
            JSRecursiveCallLineMarkerProvider.$$$reportNull$$$0(12);
        }
        if (parentFunction == null) {
            JSRecursiveCallLineMarkerProvider.$$$reportNull$$$0(13);
        }
        ResolveResult[] results = referenceExpression.multiResolve(false);
        PsiElement resolve = JSResolveResult.resolve(results);
        PsiElement expectedElement = JSRecursiveCallLineMarkerProvider.getExpectedElement(parentFunction);
        return resolve != null && resolve.isEquivalentTo(expectedElement);
    }

    @NotNull
    private static PsiElement getExpectedElement(@NotNull JSFunction parentFunction) {
        if (parentFunction == null) {
            JSRecursiveCallLineMarkerProvider.$$$reportNull$$$0(14);
        }
        if (parentFunction instanceof JSFunctionExpression) {
            PsiElement parent = parentFunction.getParent();
            Object object = parent instanceof JSVariable ? parent : parentFunction;
            if (object == null) {
                JSRecursiveCallLineMarkerProvider.$$$reportNull$$$0(15);
            }
            return object;
        }
        JSFunction jSFunction = parentFunction;
        if (jSFunction == null) {
            JSRecursiveCallLineMarkerProvider.$$$reportNull$$$0(16);
        }
        return jSFunction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentFunction";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/highlighting/JSRecursiveCallLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/highlighting/JSRecursiveCallLineMarkerProvider";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isRecursivePropertyCall";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isInCallExpression";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isRecursiveCall";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isClassOrLiteralMethodRecursiveCall";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isGlobalFunctionRecursiveCall";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkResolvedEqual";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedElement";
                break;
            }
            case 15: 
            case 16: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RecursiveMethodCallMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        private RecursiveMethodCallMarkerInfo(@NotNull PsiElement identifier) {
            if (identifier == null) {
                RecursiveMethodCallMarkerInfo.$$$reportNull$$$0(0);
            }
            super(identifier, identifier.getTextRange(), AllIcons.Gutter.RecursiveMethod, 11, FunctionUtil.constant((Object)"Recursive call"), null, GutterIconRenderer.Alignment.RIGHT);
        }

        public GutterIconRenderer createGutterRenderer() {
            if (this.myIcon == null) {
                return null;
            }
            return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

                public AnAction getClickAction() {
                    return null;
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/lang/javascript/highlighting/JSRecursiveCallLineMarkerProvider$RecursiveMethodCallMarkerInfo", "<init>"));
        }
    }
}

