/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.highlighting.BraceMatcherTerminationAspect;
import com.intellij.lang.BracePair;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSBraceMatcher
implements PairedBraceMatcher,
BraceMatcherTerminationAspect {
    private static final BracePair[] PAIRS = new BracePair[]{new BracePair(JSTokenTypes.LPAR, JSTokenTypes.RPAR, false), new BracePair(JSTokenTypes.LBRACKET, JSTokenTypes.RBRACKET, false), new BracePair(JSTokenTypes.LBRACE, JSTokenTypes.RBRACE, true)};

    @NotNull
    public BracePair[] getPairs() {
        if (PAIRS == null) {
            JSBraceMatcher.$$$reportNull$$$0(0);
        }
        return PAIRS;
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType tokenType) {
        if (lbraceType == null) {
            JSBraceMatcher.$$$reportNull$$$0(1);
        }
        return JSTokenTypes.WHITE_SPACE == tokenType || JSTokenTypes.COMMENTS.contains(tokenType) || tokenType == JSTokenTypes.SEMICOLON || tokenType == JSTokenTypes.COMMA || tokenType == JSTokenTypes.RPAR || tokenType == JSTokenTypes.RBRACKET || tokenType == JSTokenTypes.RBRACE || tokenType == JSTokenTypes.STRING_TEMPLATE_PART || tokenType == JSTokenTypes.BACKQUOTE || tokenType == JSTokenTypes.GT && lbraceType == JSTokenTypes.LBRACE || null == tokenType;
    }

    public int getCodeConstructStart(PsiFile file, int openingBraceOffset) {
        PsiElement element = file.findElementAt(openingBraceOffset);
        if (element == null || element instanceof PsiFile) {
            return openingBraceOffset;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof JSBlockStatement) {
            parent = parent.getParent();
        }
        return parent.getTextRange().getStartOffset();
    }

    public boolean shouldStopMatch(boolean forward, @NotNull IElementType braceType, @NotNull HighlighterIterator iterator) {
        if (braceType == null) {
            JSBraceMatcher.$$$reportNull$$$0(2);
        }
        if (iterator == null) {
            JSBraceMatcher.$$$reportNull$$$0(3);
        }
        IElementType currType = iterator.getTokenType();
        if (forward && currType == JSTokenTypes.RPAR && braceType != JSTokenTypes.LPAR) {
            int retreatCount = 0;
            iterator.retreat();
            ++retreatCount;
            currType = iterator.getTokenType();
            if (currType == JSTokenTypes.WHITE_SPACE) {
                iterator.retreat();
                ++retreatCount;
                currType = iterator.getTokenType();
            }
            for (int i = retreatCount; i > 0; --i) {
                iterator.advance();
            }
            if (currType == braceType) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/highlighting/JSBraceMatcher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lbraceType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "braceType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPairs";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/highlighting/JSBraceMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isPairedBracesAllowedBeforeType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "shouldStopMatch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

