/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.BackspaceHandler;
import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class JSBackspaceHandler
extends BackspaceHandlerDelegate {
    private int myOffsetMatchingBrace;

    public void beforeCharDeleted(char c, PsiFile file, Editor editor) {
        this.myOffsetMatchingBrace = -1;
        if ((c == '(' || c == '[' || c == '{') && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            int offset = editor.getCaretModel().getOffset() - 1;
            this.myOffsetMatchingBrace = JSBackspaceHandler.findMatch(c, file, editor, offset);
        }
    }

    private static int findMatch(char c, PsiFile file, Editor editor, int offset) {
        if (offset == editor.getDocument().getTextLength() - 1) {
            return -1;
        }
        if (!file.getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE)) {
            return -1;
        }
        JSElement element = (JSElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, JSElement.class, (boolean)false);
        if (element == null) {
            return -1;
        }
        PsiElement wrapper = JSBackspaceHandler.getTopLevelParent((PsiElement)element);
        if (wrapper instanceof JSEmbeddedContent) {
            return -1;
        }
        TextRange tr = file.getTextRange();
        if (wrapper != null) {
            tr = wrapper.getTextRange();
        }
        String chars = editor.getDocument().getText();
        return JSBackspaceHandler.countBraces(c, BackspaceHandler.getRightChar((char)c), chars, tr, offset);
    }

    private static int countBraces(char left, char right, String text, TextRange tr, int offset) {
        int balance = 0;
        boolean stuffInTheMiddle = false;
        int rightBrace = -1;
        int start = tr.getStartOffset();
        int end = Math.min(text.length(), tr.getEndOffset());
        for (int i = start; i < end; ++i) {
            char c = text.charAt(i);
            if (left == c) {
                ++balance;
                continue;
            }
            if (right == c) {
                if (balance > 0) {
                    --balance;
                }
                if (i <= offset || stuffInTheMiddle || rightBrace != -1) continue;
                rightBrace = i;
                continue;
            }
            if (i <= offset || stuffInTheMiddle || rightBrace != -1 || c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f') continue;
            stuffInTheMiddle = true;
        }
        return balance == 0 ? rightBrace : -1;
    }

    private static PsiElement getTopLevelParent(@NotNull PsiElement element) {
        if (element == null) {
            JSBackspaceHandler.$$$reportNull$$$0(0);
        }
        for (PsiElement current = element; current != null && !(current instanceof PsiFile); current = current.getParent()) {
            if (JSExtendedLanguagesTokenSetProvider.EMBEDDED_CONTENTS.contains(current.getNode().getElementType())) {
                return current;
            }
            if (!(current instanceof JSFunction)) continue;
            if (current.getParent() == null) {
                return current;
            }
            PsiElement next = JSBackspaceHandler.getTopLevelParent(current.getParent());
            if (next == null) {
                return current;
            }
            return next;
        }
        return null;
    }

    public boolean charDeleted(char c, PsiFile file, Editor editor) {
        if (this.myOffsetMatchingBrace >= 0) {
            editor.getDocument().deleteString(this.myOffsetMatchingBrace - 1, this.myOffsetMatchingBrace);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/highlighting/JSBackspaceHandler", "getTopLevelParent"));
    }
}

