/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hierarchy.method;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.lang.javascript.hierarchy.method.JSMethodHierarchyTreeStructure;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import javax.swing.Icon;

public final class JSMethodHierarchyNodeDescriptor
extends HierarchyNodeDescriptor {
    private Icon myRawIcon;
    private Icon myStateIcon;
    private JSMethodHierarchyTreeStructure myTreeStructure;

    public JSMethodHierarchyNodeDescriptor(Project project, HierarchyNodeDescriptor parentDescriptor, JSClass aClass, boolean isBase, JSMethodHierarchyTreeStructure treeStructure) {
        super(project, (NodeDescriptor)parentDescriptor, (PsiElement)aClass, isBase);
        this.myTreeStructure = treeStructure;
    }

    public final void setTreeStructure(JSMethodHierarchyTreeStructure treeStructure) {
        this.myTreeStructure = treeStructure;
    }

    public final JSClass getJSClass() {
        return (JSClass)this.getPsiElement();
    }

    public final PsiElement getTargetElement() {
        JSClass aClass = this.getJSClass();
        if (aClass == null || !aClass.isValid()) {
            return null;
        }
        JSFunction method = JSInheritanceUtil.findMethodInClass(this.myTreeStructure.getBaseMethod(), aClass, false);
        if (method != null) {
            return method;
        }
        return aClass;
    }

    public final boolean update() {
        int flags = 1;
        if (this.isMarkReadOnly()) {
            flags |= 2;
        }
        boolean changes = super.update();
        JSClass jsClass = this.getJSClass();
        if (jsClass == null) {
            String invalidPrefix = IdeBundle.message((String)"node.hierarchy.invalid", (Object[])new Object[0]);
            if (!this.myHighlightedText.getText().startsWith(invalidPrefix)) {
                this.myHighlightedText.getBeginning().addText(invalidPrefix, HierarchyNodeDescriptor.getInvalidPrefixAttributes());
            }
            return true;
        }
        Icon newRawIcon = jsClass.getIcon(flags);
        Icon newStateIcon = this.calculateState(jsClass);
        if (newRawIcon != this.myRawIcon || newStateIcon != this.myStateIcon) {
            LayeredIcon icon;
            changes = true;
            this.myRawIcon = newRawIcon;
            this.myStateIcon = newStateIcon;
            Icon newIcon = this.myRawIcon;
            if (this.myIsBase) {
                icon = new LayeredIcon(2);
                icon.setIcon(newIcon, 0);
                icon.setIcon(AllIcons.Hierarchy.Base, 1, -AllIcons.Hierarchy.Base.getIconWidth() / 2, 0);
                newIcon = icon;
            }
            if (this.myStateIcon != null) {
                icon = new RowIcon(2);
                icon.setIcon(this.myStateIcon, 0);
                icon.setIcon(newIcon, 1);
                newIcon = icon;
            }
            this.setIcon(newIcon);
        }
        CompositeAppearance oldText = this.myHighlightedText;
        this.myHighlightedText = new CompositeAppearance();
        TextAttributes classNameAttributes = null;
        if (this.myColor != null) {
            classNameAttributes = new TextAttributes(this.myColor, null, null, null, 0);
        }
        this.myHighlightedText.getEnding().addText(jsClass.getName(), classNameAttributes);
        this.myHighlightedText.getEnding().addText(" (" + StringUtil.getPackageName((String)jsClass.getQualifiedName()) + ")", HierarchyNodeDescriptor.getPackageNameAttributes());
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText)) {
            changes = true;
        }
        return changes;
    }

    private Icon calculateState(JSClass jsClass) {
        boolean hasBaseImplementation;
        if (jsClass.isInterface()) {
            return null;
        }
        JSFunction method = JSInheritanceUtil.findMethodInClass(this.myTreeStructure.getBaseMethod(), jsClass, false);
        if (method != null) {
            return AllIcons.Hierarchy.MethodDefined;
        }
        JSFunction baseClassMethod = JSInheritanceUtil.findMethodInClass(this.myTreeStructure.getBaseMethod(), jsClass, true);
        boolean bl = hasBaseImplementation = baseClassMethod != null;
        if (hasBaseImplementation) {
            return AllIcons.Hierarchy.MethodNotDefined;
        }
        return AllIcons.Hierarchy.ShouldDefineMethod;
    }
}

