/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.generation.BaseJSGenerateHandler;
import com.intellij.lang.javascript.generation.JSNamedElementNode;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.JSConstructorChecker;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMethodsFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaScriptGenerateConstructorHandler
extends BaseJSGenerateHandler {
    @Override
    protected String getTitleKey() {
        return "generate.constructor.fields.chooser.title";
    }

    @Override
    protected BaseCreateMethodsFix createFix(final JSClass jsClass) {
        return new BaseCreateMethodsFix<JSVariable>(jsClass){

            @Override
            public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                JSCodeStyleSettings codeStyleSettings = (JSCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(JSCodeStyleSettings.class);
                this.evalAnchor(editor, file);
                String functionText = JSClassUtils.createConstructorSignatureForClass(jsClass, true) + "(";
                String initialization = "";
                boolean first = true;
                String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)file);
                Set<JSVariable> toProcess = this.getElementsToProcess();
                Iterator<JSVariable> variableIterator = toProcess.iterator();
                boolean hadSuperClassConstructorInitializationBefore = false;
                while (variableIterator.hasNext()) {
                    boolean mangle;
                    JSVariable var = variableIterator.next();
                    if (!first) {
                        functionText = functionText + ", ";
                    }
                    first = false;
                    String name = var.getName();
                    if (name == null) continue;
                    String parameterName = JSRefactoringUtil.transformVarNameToAccessorName(name, codeStyleSettings);
                    boolean bl = mangle = !JSRefactoringUtil.isValidIdentifier(parameterName, project);
                    if (mangle) {
                        parameterName = JavaScriptGenerateConstructorHandler.mangleParameterName(parameterName);
                    }
                    String insertedOwnName = JSSymbolUtil.handleSpecialPropertyNames(name, JSCodeStyleSettings.getQuoteChar((PsiElement)file));
                    boolean hasBracket = insertedOwnName.startsWith("[");
                    String typeString = BaseCreateMethodsFix.getProcessedType(var.getType(), jsClass, (PsiElement)var);
                    functionText = functionText + parameterName + (typeString != null ? ":" + typeString : "");
                    if (JSResolveUtil.findParent((PsiElement)var) == jsClass) {
                        if (hadSuperClassConstructorInitializationBefore) {
                            initialization = initialization + ")" + semicolon + "\n";
                            hadSuperClassConstructorInitializationBefore = false;
                        }
                        if (parameterName.equals(name)) {
                            initialization = initialization + (mangle ? (hasBracket ? "this" : "this[") : "this.");
                        } else {
                            String qualifier = JSClassUtils.getDefaultFieldQualifier((PsiElement)jsClass, true);
                            if (qualifier != null) {
                                initialization = initialization + (mangle ? qualifier.substring(0, qualifier.length() - 1) + (hasBracket ? "" : "[") : qualifier);
                            }
                        }
                        initialization = initialization + insertedOwnName + (mangle && !hasBracket ? "]" : "") + " = " + parameterName + semicolon + "\n";
                        continue;
                    }
                    initialization = hadSuperClassConstructorInitializationBefore ? initialization + ", " : initialization + "super(";
                    initialization = initialization + parameterName;
                    hadSuperClassConstructorInitializationBefore = true;
                }
                if (hadSuperClassConstructorInitializationBefore) {
                    initialization = initialization + ")" + semicolon + "\n";
                }
                functionText = functionText + ") {\n";
                functionText = functionText + initialization;
                functionText = functionText + "}";
                this.doAddOneMethod(project, functionText, this.anchor);
            }

            @Override
            public Set<JSVariable> getElementsToProcess() {
                LinkedHashSet<JSVariable> vars = new LinkedHashSet<JSVariable>();
                JSFunction nontrivialSuperClassConstructor = JSConstructorChecker.getNontrivialSuperClassConstructor(jsClass);
                if (nontrivialSuperClassConstructor != null) {
                    ContainerUtil.addAll(vars, (Object[])nontrivialSuperClassConstructor.getParameterVariables());
                }
                vars.addAll(super.getElementsToProcess());
                return vars;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/generation/JavaScriptGenerateConstructorHandler$1", "invoke"));
            }
        };
    }

    private static String mangleParameterName(String name) {
        StringBuilder builder = new StringBuilder();
        if (name.startsWith("[") && name.endsWith("]")) {
            name = name.substring(1, name.length() - 1);
        }
        for (int i = 0; i < name.length(); ++i) {
            char iChar = name.charAt(i);
            if (i == 0 && !Character.isJavaIdentifierStart(iChar) || i != 0 && !Character.isJavaIdentifierPart(iChar)) {
                builder.append('_');
                continue;
            }
            if (i == 0 && Character.isUpperCase(iChar)) {
                iChar = Character.toLowerCase(iChar);
            }
            builder.append(iChar);
        }
        return builder.toString();
    }

    @Override
    protected void collectCandidates(JSClass clazz, Collection<JSNamedElementNode> candidates) {
        JavaScriptGenerateConstructorHandler.collectJSVariables(clazz, candidates, false, false, true, true, false);
    }

    @Override
    protected boolean canHaveEmptySelectedElements() {
        return true;
    }
}

