/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameFileFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.validation.fixes.ChangeLanguageLevelFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import icons.JavaScriptLanguageIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSXLanguageLevelAnnotator
implements Annotator {
    private static final String JSX_SWITCH_DISABLED = "jsx.switch.disabled";

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        JSFile file;
        if (element == null) {
            JSXLanguageLevelAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            JSXLanguageLevelAnnotator.$$$reportNull$$$0(1);
        }
        if ((file = (JSFile)ObjectUtils.tryCast((Object)element, JSFile.class)) == null) {
            return;
        }
        Project project = file.getProject();
        DialectOptionHolder optionHolder = DialectDetector.dialectOfElement((PsiElement)file);
        if (optionHolder == null || optionHolder.isJSX) {
            return;
        }
        if (PropertiesComponent.getInstance((Project)project).getBoolean(JSX_SWITCH_DISABLED)) {
            return;
        }
        if (JSXLanguageLevelAnnotator.isJsxFile(file)) {
            if (optionHolder.isTypeScript) {
                VirtualFile virtualFile = file.getVirtualFile();
                if (virtualFile != null && virtualFile.isInLocalFileSystem()) {
                    JSXLanguageLevelAnnotator.addTypeScriptNotification(holder, file);
                }
            } else {
                JSXLanguageLevelAnnotator.addJavaScriptNotification(holder, file);
            }
        }
    }

    private static void addJavaScriptNotification(@NotNull AnnotationHolder holder, @NotNull JSFile file) {
        if (holder == null) {
            JSXLanguageLevelAnnotator.$$$reportNull$$$0(2);
        }
        if (file == null) {
            JSXLanguageLevelAnnotator.$$$reportNull$$$0(3);
        }
        Annotation annotation = holder.createWarningAnnotation((PsiElement)file, JSBundle.message((String)"js.switch.to.jsx.inspection.name", (Object[])new Object[0]));
        annotation.setFileLevelAnnotation(true);
        annotation.setGutterIconRenderer((GutterIconRenderer)new JsxGutterIconRenderer());
        annotation.registerFix((IntentionAction)new ChangeLanguageLevelFix(JSLanguageLevel.JSX){

            @Override
            @NotNull
            public String getText() {
                if ("Switch" == null) {
                    1.$$$reportNull$$$0(0);
                }
                return "Switch";
            }

            @Override
            public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.invoke(project, editor, file);
                DaemonCodeAnalyzer.getInstance((Project)project).restart();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/JSXLanguageLevelAnnotator$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/JSXLanguageLevelAnnotator$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        annotation.registerFix(JSXLanguageLevelAnnotator.createDismissIntention());
    }

    private static void addTypeScriptNotification(@NotNull AnnotationHolder holder, @NotNull JSFile file) {
        if (holder == null) {
            JSXLanguageLevelAnnotator.$$$reportNull$$$0(4);
        }
        if (file == null) {
            JSXLanguageLevelAnnotator.$$$reportNull$$$0(5);
        }
        Annotation annotation = holder.createWarningAnnotation((PsiElement)file, JSBundle.message((String)"ts.switch.to.jsx.inspection.name", (Object[])new Object[0]));
        annotation.setFileLevelAnnotation(true);
        annotation.setGutterIconRenderer((GutterIconRenderer)new JsxGutterIconRenderer());
        annotation.registerFix((IntentionAction)new RenameFileFix(file.getName() + "x"));
        annotation.registerFix(JSXLanguageLevelAnnotator.createDismissIntention());
    }

    @NotNull
    private static IntentionAction createDismissIntention() {
        IntentionAction intentionAction = new IntentionAction(){

            @NotNull
            public String getText() {
                if ("Dismiss" == null) {
                    2.$$$reportNull$$$0(0);
                }
                return "Dismiss";
            }

            @NotNull
            public String getFamilyName() {
                String string = JSBundle.message((String)"javascript.change.language.level.family", (Object[])new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                if (project == null) {
                    2.$$$reportNull$$$0(2);
                }
                return true;
            }

            public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                if (project == null) {
                    2.$$$reportNull$$$0(3);
                }
                PropertiesComponent.getInstance((Project)project).setValue(JSXLanguageLevelAnnotator.JSX_SWITCH_DISABLED, "true");
                DaemonCodeAnalyzer.getInstance((Project)project).restart();
            }

            public boolean startInWriteAction() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/JSXLanguageLevelAnnotator$2";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/JSXLanguageLevelAnnotator$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isAvailable";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (intentionAction == null) {
            JSXLanguageLevelAnnotator.$$$reportNull$$$0(6);
        }
        return intentionAction;
    }

    private static boolean isJsxFile(@NotNull JSFile file) {
        if (file == null) {
            JSXLanguageLevelAnnotator.$$$reportNull$$$0(7);
        }
        final Ref jsxRef = Ref.create((Object)false);
        new JSRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                if (Boolean.TRUE.equals(jsxRef.get())) {
                    return;
                }
                super.visitElement(element);
                if (element instanceof LeafPsiElement && element.getNode().getElementType() == JSTokenTypes.LT) {
                    PsiElement next;
                    PsiElement startNext = PsiTreeUtil.nextLeaf((PsiElement)element);
                    PsiElement psiElement = next = startNext != null ? PsiTreeUtil.nextLeaf((PsiElement)startNext) : null;
                    if (JSXLanguageLevelAnnotator.isCloseTagExpression(startNext, next)) {
                        jsxRef.set((Object)true);
                        return;
                    }
                    PsiElement prev = PsiTreeUtil.prevLeaf((PsiElement)element);
                    PsiElement psiElement2 = prev = prev instanceof PsiWhiteSpace ? PsiTreeUtil.prevLeaf((PsiElement)prev) : prev;
                    if (JSXLanguageLevelAnnotator.isOpenTagExpression(next, prev)) {
                        jsxRef.set((Object)true);
                    }
                }
            }
        }.visitFile((PsiFile)file);
        return (Boolean)jsxRef.get();
    }

    private static boolean isOpenTagExpression(@Nullable PsiElement next, @Nullable PsiElement prev) {
        return (next == null || next.getNode().getElementType() != JSTokenTypes.LT) && prev instanceof PsiErrorElement && JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]).equals(((PsiErrorElement)prev).getErrorDescription());
    }

    private static boolean isCloseTagExpression(@Nullable PsiElement startNext, @Nullable PsiElement next) {
        if (startNext == null || next == null) {
            return false;
        }
        if (startNext instanceof PsiErrorElement && next.getNode().getElementType() == JSTokenTypes.REGEXP_LITERAL && JSXLanguageLevelAnnotator.isNodeTextLikeCloseTag(next)) {
            return true;
        }
        return next instanceof PsiErrorElement && startNext.getNode().getElementType() == JSTokenTypes.REGEXP_LITERAL && JSXLanguageLevelAnnotator.isNodeTextLikeCloseTag(startNext);
    }

    private static boolean isNodeTextLikeCloseTag(@NotNull PsiElement next) {
        String text;
        if (next == null) {
            JSXLanguageLevelAnnotator.$$$reportNull$$$0(8);
        }
        return (text = next.getText()).startsWith("/") && text.contains(">");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/JSXLanguageLevelAnnotator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/JSXLanguageLevelAnnotator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDismissIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addJavaScriptNotification";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addTypeScriptNotification";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isJsxFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isNodeTextLikeCloseTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JsxGutterIconRenderer
    extends GutterIconRenderer
    implements DumbAware {
        private JsxGutterIconRenderer() {
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = JavaScriptLanguageIcons.Logos.Jsx_16;
            if (icon == null) {
                JsxGutterIconRenderer.$$$reportNull$$$0(0);
            }
            return icon;
        }

        public boolean equals(Object obj) {
            return obj instanceof JsxGutterIconRenderer;
        }

        public int hashCode() {
            return System.identityHashCode(JavaScriptLanguageIcons.Logos.Jsx_16);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/JSXLanguageLevelAnnotator$JsxGutterIconRenderer", "getIcon"));
        }
    }
}

