/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.mozilla;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.lang.javascript.documentation.JSDocumentationProvider;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.library.JSExternalDocumentationProvider;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MdnExtDocProvider
extends JSExternalDocumentationProvider {
    private static final Logger LOG = Logger.getInstance(MdnExtDocProvider.class);

    public MdnExtDocProvider(String docUrl) {
        super(docUrl);
    }

    @Nullable
    public String fetchExternalDocumentation(Project project, PsiElement element, List<String> docUrls) {
        PsiComment comment = (PsiComment)ApplicationManager.getApplication().runReadAction(() -> JSDocumentationUtils.findDocComment(element));
        if (comment != null) {
            return null;
        }
        String url = docUrls.get(0);
        File targetDir = new File(JSUtils.getConfigJavaScriptDirPath(), "mdn");
        File targetFile = new File(targetDir, JSLibraryUtil.makeUniqueFileName(url, false));
        try {
            if (!targetFile.exists()) {
                DownloadUtil.downloadAtomically((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator(), (String)(url + "?raw&summary"), (File)targetFile);
            }
            String content = FileUtil.loadFile((File)targetFile);
            Ref result = new Ref();
            ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
                if (!element.isValid()) {
                    return;
                }
                SmartPsiElementPointer originalElement = (SmartPsiElementPointer)element.getUserData(DocumentationManager.ORIGINAL_ELEMENT_KEY);
                String doc = new JSDocumentationProvider().generateDoc(element, originalElement != null ? originalElement.getElement() : null);
                result.set((Object)doc);
            });
            return (result.isNull() ? "" : (String)result.get()) + MdnExtDocProvider.decorate(MdnExtDocProvider.fixLinks(content), url);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    private static String decorate(String mdnDoc, String url) {
        return "<p>" + mdnDoc + "<p>By <a href='" + url + "$history'>Mozilla Contributors</a>, <a href='http://creativecommons.org/licenses/by-sa/2.5/'>CC BY-SA 2.5</a>";
    }

    private static String fixLinks(String s) {
        return s.replaceAll("href=\"/", "href=\"https://developer.mozilla.org/");
    }
}

