/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.extjs;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSTypedefIndex;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.validation.HighlightSeverityHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtXTypeReference
implements PsiReference,
HighlightSeverityHolder,
EmptyResolveMessageProvider {
    public static final String EXT_XTYPE_PROPERTY = "xtype";
    private static final char EXT_XTYPE_TYPEDEF_MARK = '@';
    @NotNull
    private final JSLiteralExpression myStringLiteral;

    public ExtXTypeReference(@NotNull JSLiteralExpression stringLiteral) {
        if (stringLiteral == null) {
            ExtXTypeReference.$$$reportNull$$$0(0);
        }
        this.myStringLiteral = stringLiteral;
    }

    public PsiElement getElement() {
        return this.myStringLiteral;
    }

    public TextRange getRangeInElement() {
        return ElementManipulators.getValueTextRange((PsiElement)this.myStringLiteral);
    }

    @Nullable
    public PsiElement resolve() {
        String typeName = StringUtil.unquoteString((String)this.myStringLiteral.getText());
        JSType type = JSTypeEvaluateManager.getTypedefValue((PsiElement)this.myStringLiteral, typeName);
        JSTypeSource source = type != null ? type.getSource() : null;
        return source != null && source.getSourceElement() != null && source.getSourceElement().isValid() ? source.getSourceElement() : null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = StringUtil.unquoteString((String)this.myStringLiteral.getText());
        if (string == null) {
            ExtXTypeReference.$$$reportNull$$$0(1);
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            ExtXTypeReference.$$$reportNull$$$0(2);
        }
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.resolve() == element;
    }

    @NotNull
    public Object[] getVariants() {
        ArrayList<String> xtypes = new ArrayList<String>();
        Collection keys = StubIndex.getInstance().getAllKeys(JSTypedefIndex.KEY, this.myStringLiteral.getProject());
        GlobalSearchScope scope = JSResolveUtil.getResolveScope((PsiElement)this.myStringLiteral);
        block0: for (String key : keys) {
            for (JSElement element : StubIndex.getElements(JSTypedefIndex.KEY, (Object)key, (Project)this.myStringLiteral.getProject(), (GlobalSearchScope)scope, JSElement.class)) {
                assert (element instanceof JSImplicitElementProvider);
                JSElementIndexingData data = ((JSImplicitElementProvider)element).getIndexingData();
                assert (data != null);
                Collection typedefs = data.getTypedefs();
                assert (typedefs != null && !typedefs.isEmpty());
                for (Pair typedef : typedefs) {
                    if (!StringUtil.equals((CharSequence)key, (CharSequence)((CharSequence)typedef.first)) || typedef.second == null || !ExtXTypeReference.isExtXType((String)typedef.second)) continue;
                    xtypes.add(key);
                    continue block0;
                }
            }
        }
        Object[] objectArray = xtypes.toArray();
        if (objectArray == null) {
            ExtXTypeReference.$$$reportNull$$$0(3);
        }
        return objectArray;
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    @NotNull
    public HighlightSeverity getUnresolvedReferenceSeverity() {
        HighlightSeverity highlightSeverity = HighlightSeverity.WARNING;
        if (highlightSeverity == null) {
            ExtXTypeReference.$$$reportNull$$$0(4);
        }
        return highlightSeverity;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = JSBundle.message((String)"js.frameworks.sencha.xtype.not.found", (Object[])new Object[]{StringUtil.unquoteString((String)this.myStringLiteral.getText())});
        if (string == null) {
            ExtXTypeReference.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static boolean isExtXType(@NotNull String typeValue) {
        int nonDigit;
        if (typeValue == null) {
            ExtXTypeReference.$$$reportNull$$$0(6);
        }
        for (nonDigit = 0; typeValue.length() > nonDigit && Character.isDigit(typeValue.charAt(nonDigit)); ++nonDigit) {
        }
        return typeValue.length() > nonDigit && typeValue.charAt(nonDigit) == '@';
    }

    static String markExtXType(@NotNull String typeValue) {
        if (typeValue == null) {
            ExtXTypeReference.$$$reportNull$$$0(7);
        }
        return '@' + typeValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringLiteral";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/extjs/ExtXTypeReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/extjs/ExtXTypeReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedReferenceSeverity";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isExtXType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "markExtXType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

