/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter.blocks;

import com.intellij.embedding.EmbeddingElementType;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSBlockContext;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSSpacingProcessor;
import com.intellij.lang.javascript.formatter.blocks.JSSpacingStrategy;
import com.intellij.lang.javascript.formatter.blocks.SubBlockVisitor;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.lang.javascript.formatter.blocks.alignment.CompositeAlignmentFactory;
import com.intellij.lang.javascript.formatter.blocks.alignment.ES6ImportAlignmentFactory;
import com.intellij.lang.javascript.formatter.blocks.alignment.JSBinaryOperatorAlignmentFactory;
import com.intellij.lang.javascript.formatter.blocks.alignment.JSDefaultParameterValueAlignmentFactory;
import com.intellij.lang.javascript.formatter.blocks.alignment.JSPropertyAlignmentFactory;
import com.intellij.lang.javascript.formatter.blocks.alignment.JSVarStatementAlignmentFactory;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.types.JSClassElementTypeBase;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.lang.javascript.types.JSPropertyElementType;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.webcore.formatter.SpacingStrategy;
import com.intellij.webcore.formatter.chainedMethods.CallChainBlockBuilder;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSBlock
extends AbstractBlock {
    @NotNull
    protected final ASTNode myNode;
    @NotNull
    protected final JSCodeStyleSettings myDialectSettings;
    private CommonCodeStyleSettings myCommonSettings;
    @Nullable
    private Alignment myAlignment;
    @Nullable
    private final Indent myIndent;
    @Nullable
    private final Wrap myWrap;
    protected final ASTNodeBasedAlignmentFactory mySharedAlignmentFactory;
    private final SpacingStrategy mySpacingStrategy;
    protected final JSBlockContext myBlockContext;
    private Wrap myChildWrap;

    public JSBlock(@NotNull ASTNode node, @Nullable Alignment alignment, @Nullable Indent indent, @Nullable Wrap wrap, @NotNull CodeStyleSettings topSettings) {
        if (node == null) {
            JSBlock.$$$reportNull$$$0(0);
        }
        if (topSettings == null) {
            JSBlock.$$$reportNull$$$0(1);
        }
        this(node, alignment, indent, wrap, null, JSBlockContext.createDefault(topSettings));
    }

    public JSBlock(@NotNull ASTNode node, @Nullable Alignment alignment, @Nullable Indent indent, @Nullable Wrap wrap, @Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory, @NotNull JSBlockContext jsBlockContext) {
        if (node == null) {
            JSBlock.$$$reportNull$$$0(2);
        }
        if (jsBlockContext == null) {
            JSBlock.$$$reportNull$$$0(3);
        }
        super(node, wrap, alignment);
        this.myAlignment = alignment;
        this.myIndent = indent;
        this.myNode = node;
        this.myWrap = wrap;
        this.myBlockContext = jsBlockContext;
        this.myDialectSettings = jsBlockContext.getDialectSettings();
        this.myCommonSettings = jsBlockContext.getCommonSettings();
        this.mySharedAlignmentFactory = this.getSharedAlignmentFactory(sharedAlignmentFactory, this.myDialectSettings);
        this.mySpacingStrategy = new JSSpacingStrategy(this.myDialectSettings, jsBlockContext.getCommonSettings(), this::calculateSpacing);
    }

    protected Spacing calculateSpacing(ASTNode child1, ASTNode child2) {
        return new JSSpacingProcessor(this.myNode, child1, child2, this.myBlockContext.getTopSettings(), this.myBlockContext.getDialect(), this.myDialectSettings).calcSpacing();
    }

    public boolean processInjections() {
        return !this.isBuildIndentsOnly();
    }

    @NotNull
    public ASTNode getNode() {
        ASTNode aSTNode = this.myNode;
        if (aSTNode == null) {
            JSBlock.$$$reportNull$$$0(4);
        }
        return aSTNode;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myNode.getTextRange();
        if (textRange == null) {
            JSBlock.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    protected List<Block> buildChildren() {
        List<Block> subBlocks = this.buildChainBlocks();
        if (subBlocks != null) {
            return subBlocks;
        }
        SubBlockVisitor visitor = this.createSubBlockVisitor();
        visitor.visit(this.myNode);
        return visitor.getBlocks();
    }

    protected SubBlockVisitor createSubBlockVisitor() {
        return new SubBlockVisitor(this, this.mySharedAlignmentFactory, this.myBlockContext);
    }

    @Nullable
    private List<Block> buildChainBlocks() {
        if (this.isChainedCallsFormattingSupported() && (this.myNode.getElementType() == JSElementTypes.CALL_EXPRESSION || JSElementTypes.NEW_EXPRESSIONS.contains(this.myNode.getElementType()))) {
            CommonCodeStyleSettings commonJsSettings = this.myCommonSettings;
            JSCodeStyleSettings jsSettings = this.myDialectSettings;
            CallChainBlockBuilder builder = new CallChainBlockBuilder(this.myNode, this.mySpacingStrategy, jsSettings.INDENT_CHAINED_CALLS ? Indent.Type.CONTINUATION : Indent.Type.NONE, commonJsSettings.METHOD_CALL_CHAIN_WRAP, commonJsSettings.CALL_PARAMETERS_WRAP, commonJsSettings.PREFER_PARAMETERS_WRAP, commonJsSettings.ALIGN_MULTILINE_CHAINED_METHODS, commonJsSettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS, jsSettings.CHAINED_CALL_DOT_ON_NEW_LINE, jsSettings.USE_CHAINED_CALLS_GROUP_INDENTS){

                protected boolean shouldFlatten(@NotNull IElementType elementType) {
                    if (elementType == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return elementType == JSElementTypes.REFERENCE_EXPRESSION || elementType == JSElementTypes.CALL_EXPRESSION;
                }

                protected boolean isLeftParen(@NotNull IElementType elementType) {
                    if (elementType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return elementType == JSTokenTypes.LPAR;
                }

                protected boolean isRightParen(@NotNull IElementType elementType) {
                    if (elementType == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return elementType == JSTokenTypes.RPAR;
                }

                protected boolean isDot(@NotNull IElementType elementType) {
                    if (elementType == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return elementType == JSTokenTypes.DOT;
                }

                protected boolean isIdentifier(@NotNull IElementType elementType) {
                    if (elementType == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return JSKeywordSets.IDENTIFIER_NAMES.contains(elementType);
                }

                protected boolean isEndOfLineComment(@NotNull IElementType elementType) {
                    if (elementType == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return elementType == JSTokenTypes.END_OF_LINE_COMMENT;
                }

                protected Block createSubBlock(@NotNull ASTNode node, @NotNull Indent indent) {
                    if (node == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    if (indent == null) {
                        1.$$$reportNull$$$0(7);
                    }
                    return JSBlock.this.myBlockContext.createBlock(node, null, null, indent, JSBlock.this.mySharedAlignmentFactory, null);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "elementType";
                            break;
                        }
                        case 6: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "node";
                            break;
                        }
                        case 7: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indent";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/lang/javascript/formatter/blocks/JSBlock$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "shouldFlatten";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isLeftParen";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isRightParen";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isDot";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isIdentifier";
                            break;
                        }
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isEndOfLineComment";
                            break;
                        }
                        case 6: 
                        case 7: {
                            objectArray = objectArray2;
                            objectArray2[2] = "createSubBlock";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            return builder.buildBlocks();
        }
        return null;
    }

    protected boolean isChainedCallsFormattingSupported() {
        return false;
    }

    protected ASTNodeBasedAlignmentFactory getSharedAlignmentFactory(@Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory, @NotNull JSCodeStyleSettings jsCodeStyleSettings) {
        if (jsCodeStyleSettings == null) {
            JSBlock.$$$reportNull$$$0(6);
        }
        CommonCodeStyleSettings jsCommonSettings = this.myCommonSettings;
        IElementType nodeType = this.myNode.getElementType();
        if (nodeType == JSElementTypes.OBJECT_LITERAL_EXPRESSION || nodeType == JSElementTypes.ARRAY_LITERAL_EXPRESSION) {
            JSPropertyAlignmentFactory propertyAlignmentFactory = new JSPropertyAlignmentFactory(jsCodeStyleSettings, this.myAlignment);
            this.myAlignment = null;
            return propertyAlignmentFactory;
        }
        if (JSStubElementTypes.DESTRUCTURING_OBJECT == nodeType) {
            JSPropertyAlignmentFactory propertyAlignmentFactory = new JSPropertyAlignmentFactory(jsCodeStyleSettings, this.myAlignment);
            JSVarStatementAlignmentFactory statementAlignmentFactory = new JSVarStatementAlignmentFactory(jsCodeStyleSettings);
            CompositeAlignmentFactory alignmentFactory = new CompositeAlignmentFactory(propertyAlignmentFactory, statementAlignmentFactory);
            this.myAlignment = null;
            return alignmentFactory;
        }
        if (JSElementTypes.PARAMETER_LISTS.contains(nodeType)) {
            return new JSDefaultParameterValueAlignmentFactory(jsCodeStyleSettings);
        }
        if (nodeType instanceof JSFileElementType || JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(nodeType) || JSExtendedLanguagesTokenSetProvider.EMBEDDED_CONTENTS.contains(nodeType)) {
            return new CompositeAlignmentFactory(new JSVarStatementAlignmentFactory(jsCodeStyleSettings), new ES6ImportAlignmentFactory(jsCodeStyleSettings));
        }
        if (nodeType == JSElementTypes.BINARY_EXPRESSION) {
            return JSBinaryOperatorAlignmentFactory.getInstance(this.myNode, sharedAlignmentFactory, jsCommonSettings);
        }
        return sharedAlignmentFactory;
    }

    @Nullable
    public Wrap getWrap() {
        return this.myWrap;
    }

    @Nullable
    public Indent getIndent() {
        return this.myIndent;
    }

    @Nullable
    public Alignment getAlignment() {
        return this.myAlignment;
    }

    @Nullable
    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            JSBlock.$$$reportNull$$$0(7);
        }
        return this.mySpacingStrategy.getSpacing(child1, child2);
    }

    @Nullable
    public Wrap createChildWrap(@NotNull ASTNode node) {
        if (node == null) {
            JSBlock.$$$reportNull$$$0(8);
        }
        IElementType nodeType = node.getElementType();
        Wrap currentWrap = this.getCurrentWrap(4);
        if (this.checkShouldWrapEveryItem(nodeType)) {
            return currentWrap;
        }
        return null;
    }

    protected boolean checkShouldWrapEveryItem(IElementType nodeType) {
        CommonCodeStyleSettings commonSettings = this.myBlockContext.getCommonSettings();
        return JSBlock.shouldWrapEveryItem(nodeType, JSElementTypes.BINARY_EXPRESSION, commonSettings.BINARY_OPERATION_WRAP) || JSBlock.shouldWrapEveryItem(nodeType, JSElementTypes.ARRAY_LITERAL_EXPRESSION, commonSettings.ARRAY_INITIALIZER_WRAP) || JSBlock.shouldWrapEveryItem(nodeType, JSElementTypes.PARAMETER_LISTS, commonSettings.METHOD_PARAMETERS_WRAP) || JSBlock.shouldWrapEveryItem(nodeType, JSElementTypes.FOR_STATEMENT, commonSettings.FOR_STATEMENT_WRAP) || JSBlock.shouldWrapEveryItem(nodeType, JSElementTypes.CONDITIONAL_EXPRESSION, commonSettings.TERNARY_OPERATION_WRAP) || JSBlock.shouldWrapEveryItem(nodeType, JSStubElementTypes.OBJECT_LITERAL_EXPRESSION, this.myDialectSettings.OBJECT_LITERAL_WRAP) || JSBlock.shouldWrapEveryItem(nodeType, (IElementType)ES6ElementTypes.IMPORT_DECLARATION, this.myDialectSettings.IMPORTS_WRAP) || JSBlock.shouldWrapEveryItem(nodeType, (IElementType)ES6ElementTypes.EXPORT_DECLARATION, this.myDialectSettings.IMPORTS_WRAP) || JSBlock.shouldWrapEveryItem(nodeType, JSStubElementTypes.VAR_STATEMENT, this.myDialectSettings.VAR_DECLARATION_WRAP) || JSBlock.shouldWrapEveryItem(nodeType, JSElementTypes.EXTENDS_IMPLEMENTS_LISTS, commonSettings.EXTENDS_LIST_WRAP);
    }

    private static boolean shouldWrapEveryItem(IElementType nodeType, TokenSet expectedTypes, int wrapType) {
        return expectedTypes.contains(nodeType) && (wrapType & 4) != 0;
    }

    protected static boolean shouldWrapEveryItem(IElementType nodeType, IElementType expectedType, int wrapType) {
        return nodeType == expectedType && (wrapType & 4) != 0;
    }

    protected Wrap getCurrentWrap(int type) {
        Wrap blockWrap = this.getChildWrap();
        if (blockWrap != null) {
            return blockWrap;
        }
        return Wrap.createWrap((int)type, (boolean)true);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes attributes;
        int i;
        Block prevBlock;
        Indent indent = null;
        IElementType blockElementType = this.myNode.getElementType();
        ASTNode parent = this.myNode.getTreeParent();
        IElementType parentElementType = parent != null ? parent.getElementType() : null;
        CommonCodeStyleSettings jsSettings = this.myCommonSettings;
        List subBlocks = this.getSubBlocks();
        JSBlock prevJSBlock = null;
        if (newChildIndex > 0 && newChildIndex <= subBlocks.size() && (prevBlock = (Block)subBlocks.get(newChildIndex - 1)) instanceof JSBlock) {
            prevJSBlock = (JSBlock)prevBlock;
        }
        if (blockElementType == JSTokenTypes.DOC_COMMENT) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getSpaceIndent((int)1), null);
            if (childAttributes == null) {
                JSBlock.$$$reportNull$$$0(9);
            }
            return childAttributes;
        }
        if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(blockElementType)) {
            indent = parentElementType == JSElementTypes.FUNCTION_DECLARATION ? (jsSettings.METHOD_BRACE_STYLE == 3 ? Indent.getNoneIndent() : Indent.getNormalIndent()) : (jsSettings.BRACE_STYLE == 3 ? Indent.getNoneIndent() : Indent.getNormalIndent());
        } else if (blockElementType instanceof JSClassElementTypeBase || blockElementType == JSElementTypes.OBJECT_LITERAL_EXPRESSION || blockElementType == TypeScriptElementTypes.OBJECT_TYPE || blockElementType == JSElementTypes.TYPESCRIPT_ENUM || blockElementType == JSElementTypes.TYPESCRIPT_MODULE) {
            indent = Indent.getNormalIndent();
        } else if (blockElementType == JSElementTypes.SWITCH_STATEMENT) {
            indent = this.calculateIndentInSwitch(prevJSBlock);
        } else if (blockElementType instanceof JSFileElementType || blockElementType instanceof EmbeddingElementType || this.myNode.getPsi() instanceof JSFile) {
            indent = Indent.getNoneIndent();
        } else if (blockElementType == JSElementTypes.IF_STATEMENT) {
            indent = Indent.getContinuationIndent();
        } else if (JSElementTypes.VAR_STATEMENTS.contains(blockElementType)) {
            if (parentElementType == JSStubElementTypes.TYPESCRIPT_ENUM) {
                indent = Indent.getNoneIndent();
            } else if (!JSBlock.isStatementDocCommentBlock(prevJSBlock)) {
                indent = Indent.getContinuationIndent();
            }
        } else if (JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS.contains(blockElementType) || JSElementTypes.FUNCTION_EXPRESSIONS.contains(blockElementType) || JSStubElementTypes.ATTRIBUTE_LISTS.contains(blockElementType)) {
            indent = Indent.getNoneIndent();
        } else if (blockElementType == JSElementTypes.CALL_EXPRESSION && !this.myDialectSettings.INDENT_CHAINED_CALLS) {
            indent = Indent.getNoneIndent();
        }
        Alignment alignment = null;
        for (i = 0; i < newChildIndex && i != subBlocks.size(); ++i) {
            IElementType childType;
            Block subBlock = (Block)subBlocks.get(i);
            Alignment childAlignment = subBlock.getAlignment();
            if (childAlignment == null) continue;
            IElementType iElementType = childType = subBlock instanceof JSBlock ? ((JSBlock)subBlock).getNode().getElementType() : null;
            if (blockElementType == JSElementTypes.ARRAY_LITERAL_EXPRESSION && childType == JSTokenTypes.LBRACKET || blockElementType == JSElementTypes.OBJECT_LITERAL_EXPRESSION && childType == JSTokenTypes.LBRACE || childType == JSTokenTypes.END_OF_LINE_COMMENT) break;
            alignment = childAlignment;
            break;
        }
        if (blockElementType instanceof JSPropertyElementType) {
            indent = Indent.getNoneIndent();
        }
        if (blockElementType == JSElementTypes.FOR_STATEMENT || blockElementType == JSElementTypes.FOR_IN_STATEMENT) {
            for (i = 0; i < newChildIndex; ++i) {
                if (((JSBlock)((Object)subBlocks.get(i))).getNode().getElementType() != JSTokenTypes.RPAR) continue;
                alignment = null;
                break;
            }
        }
        if ((attributes = this.getImportExportDeclarationChildAttributes(newChildIndex, subBlocks, blockElementType, prevJSBlock)) != null) {
            ChildAttributes childAttributes = attributes;
            if (childAttributes == null) {
                JSBlock.$$$reportNull$$$0(10);
            }
            return childAttributes;
        }
        if (JSElementTypes.FUNCTION_EXPRESSIONS.contains(blockElementType) && prevJSBlock != null && JSTokenTypes.ARROWS.contains(prevJSBlock.getNode().getElementType())) {
            indent = Indent.getContinuationIndent();
        }
        ChildAttributes childAttributes = new ChildAttributes(indent, alignment);
        if (childAttributes == null) {
            JSBlock.$$$reportNull$$$0(11);
        }
        return childAttributes;
    }

    protected ChildAttributes getImportExportDeclarationChildAttributes(int newChildIndex, List<Block> subBlocks, @NotNull IElementType blockElementType, @Nullable JSBlock prevJSBlock) {
        if (blockElementType == null) {
            JSBlock.$$$reportNull$$$0(12);
        }
        if ((blockElementType == ES6ElementTypes.IMPORT_DECLARATION || blockElementType == ES6ElementTypes.EXPORT_DECLARATION) && prevJSBlock != null) {
            ASTNode prevNode = prevJSBlock.getNode();
            IElementType prevType = prevNode.getElementType();
            JSBlock siblingBlock = prevJSBlock;
            IElementType siblingElementType = prevType;
            if (prevType == JSTokenTypes.COMMA) {
                Block block;
                int prevPrevIndex = newChildIndex - 2;
                if (prevPrevIndex >= 0 && (block = subBlocks.get(prevPrevIndex)) instanceof JSBlock) {
                    siblingBlock = (JSBlock)block;
                    siblingElementType = siblingBlock.getNode().getElementType();
                }
                if (siblingElementType == ES6ElementTypes.IMPORT_SPECIFIER || siblingElementType == ES6ElementTypes.EXPORT_SPECIFIER) {
                    return new ChildAttributes(siblingBlock.myIndent, siblingBlock.myAlignment);
                }
            }
        }
        return null;
    }

    private static boolean isStatementDocCommentBlock(@Nullable JSBlock block) {
        ASTNode parent;
        ASTNode node;
        return block != null && (node = block.getNode()).getElementType() == JSElementTypes.DOC_COMMENT && (parent = node.getTreeParent()) != null && parent.getFirstChildNode() == node;
    }

    public boolean isIncomplete() {
        return JSBlock.isIncomplete(this.myNode);
    }

    private static boolean isIncomplete(ASTNode node) {
        ASTNode lastChild;
        node.getPsi().getFirstChild();
        for (lastChild = node.getLastChildNode(); lastChild != null && lastChild.getPsi() instanceof PsiWhiteSpace; lastChild = lastChild.getTreePrev()) {
        }
        if (lastChild == null) {
            return false;
        }
        if (lastChild.getPsi() instanceof PsiErrorElement) {
            return true;
        }
        return JSBlock.isIncomplete(lastChild);
    }

    public boolean isLeaf() {
        if (this.myNode.getElementType() == JSTokenTypes.DOC_COMMENT) {
            return false;
        }
        return this.myNode.getFirstChildNode() == null;
    }

    private Indent calculateIndentInSwitch(JSBlock prevBlock) {
        ASTNode caseChild;
        CommonCodeStyleSettings jsSettings = this.myCommonSettings;
        boolean indentCase = jsSettings.INDENT_CASE_FROM_SWITCH;
        Indent defaultIndent = indentCase ? Indent.getNormalIndent() : Indent.getNoneIndent();
        Indent indentFromCase = indentCase ? this.getIndentWithNormal(Indent.Type.NORMAL) : Indent.getNormalIndent();
        ASTNode prevNode = prevBlock.getNode();
        if (prevNode.getPsi() instanceof PsiWhiteSpace) {
            prevNode = prevNode.getTreePrev();
        }
        if (prevNode == null) {
            return defaultIndent;
        }
        if (JSExtendedLanguagesTokenSetProvider.CASE_CLAUSES.contains(prevNode.getElementType()) ? (caseChild = prevNode.getLastChildNode()) != null && (caseChild.getElementType() == JSElementTypes.BREAK_STATEMENT || caseChild.getElementType() == JSElementTypes.RETURN_STATEMENT) : prevNode.getElementType() == JSTokenTypes.LBRACE) {
            return defaultIndent;
        }
        return indentFromCase;
    }

    @NotNull
    private Indent getIndentWithNormal(Indent.Type indentType) {
        CommonCodeStyleSettings jsSettings = this.myCommonSettings;
        CommonCodeStyleSettings.IndentOptions indentOptions = jsSettings.getIndentOptions();
        assert (indentOptions != null);
        int extraIndent = indentType == Indent.Type.CONTINUATION ? indentOptions.CONTINUATION_INDENT_SIZE : indentOptions.INDENT_SIZE;
        Indent indent = Indent.getSpaceIndent((int)(indentOptions.INDENT_SIZE + extraIndent));
        if (indent == null) {
            JSBlock.$$$reportNull$$$0(13);
        }
        return indent;
    }

    public Wrap getChildWrap() {
        return this.myChildWrap;
    }

    public void setChildWrap(Wrap childWrap) {
        this.myChildWrap = childWrap;
    }

    public SpacingStrategy getSpacingStrategy() {
        return this.mySpacingStrategy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsBlockContext";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/formatter/blocks/JSBlock";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsCodeStyleSettings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockElementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/formatter/blocks/JSBlock";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentWithNormal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSharedAlignmentFactory";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createChildWrap";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getImportExportDeclarationChildAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

