/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.NamedFoldingDescriptor;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.folding.JSCodeFoldingSettings;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.types.JSClassElementTypeBase;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public abstract class JavaScriptFoldingBuilderBase
extends CustomFoldingBuilder {
    private static final int IMPORT_OFFSET = "import ".length();
    private static final String SOURCE_MAPS_PREFIX = "//# sourceMappingURL=data:application/json;base64,";
    private static final TokenSet COMMENTS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.END_OF_LINE_COMMENT});
    private static final TokenSet IMPORTS = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.IMPORT_DECLARATION, JSStubElementTypes.IMPORT_STATEMENT});
    private static final Pattern DOC_COMMENT_CONTENT = Pattern.compile("^\\s*/?\\**(\\s*)(.*?)\\s*\\**/?$");
    private static final Pattern DOC_TYPE_COMMENT = Pattern.compile("\\s*@type\\s+(?:([\\p{L}_\\$][\\p{LD}_\\$-]*(?:[\\.#~:/][\\p{L}_\\$][\\p{LD}_\\$-]*)*#?)|\\{(.+)}) ");

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (descriptors == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(0);
        }
        if (root == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(1);
        }
        if (document == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(2);
        }
        this.appendDescriptors(root.getNode(), document, descriptors);
    }

    protected ASTNode appendDescriptors(ASTNode node, Document document, List<FoldingDescriptor> descriptors) {
        IElementType type = node.getElementType();
        if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(type) || type == JSStubElementTypes.OBJECT_LITERAL_EXPRESSION || type == JSElementTypes.ARRAY_LITERAL_EXPRESSION || type == JSElementTypes.XML_LITERAL_EXPRESSION || type == TypeScriptElementTypes.OBJECT_TYPE) {
            TextRange textRange = node.getTextRange();
            if (!(textRange.getEndOffset() > document.getTextLength() || document.getLineNumber(textRange.getStartOffset()) == document.getLineNumber(textRange.getEndOffset()) || JavaScriptFoldingBuilderBase.tryFoldOneLineFunction(node, document, descriptors) || JavaScriptFoldingBuilderBase.isModulePatternChild(node) || JavaScriptFoldingBuilderBase.blockStatementIsEntireSwitchClause(document, node))) {
                this.addDescriptorForNode(node, descriptors);
            }
        } else if (type == JSElementTypes.SWITCH_STATEMENT) {
            TextRange textRange;
            ASTNode lBrace = node.findChildByType(JSTokenTypes.LBRACE);
            ASTNode rBrace = node.findChildByType(JSTokenTypes.RBRACE);
            if (lBrace != null && rBrace != null && (textRange = new TextRange(lBrace.getStartOffset(), rBrace.getStartOffset() + 1)).getEndOffset() < document.getTextLength() && document.getLineNumber(textRange.getStartOffset()) != document.getLineNumber(textRange.getEndOffset())) {
                this.addDescriptorForRange(node, descriptors, textRange);
            }
        } else if (type == JSElementTypes.CASE_CLAUSE) {
            ASTNode bodyStart;
            ASTNode caseKeyword = node.findChildByType(JSTokenTypes.CASE_KEYWORD);
            ASTNode keyword = caseKeyword != null ? caseKeyword : node.findChildByType(JSTokenTypes.DEFAULT_KEYWORD);
            ASTNode labelEnd = node.findChildByType(JSTokenTypes.COLON, keyword);
            if (labelEnd != null && (bodyStart = labelEnd.getTreeNext()) != null) {
                this.addDescriptorForRange(node, descriptors, new TextRange(bodyStart.getStartOffset(), node.getTextRange().getEndOffset()));
            }
        } else if (type == JSTokenTypes.DOC_COMMENT || type == JSTokenTypes.C_STYLE_COMMENT) {
            this.addDescriptorForNode(node, descriptors);
        } else {
            ASTNode lbrace;
            if (type == JSTokenTypes.END_OF_LINE_COMMENT) {
                return this.collapseConsequentNodesOfSpecifiedType(node, descriptors, COMMENTS);
            }
            if (this.isImportNode(type)) {
                return this.collapseImport(document, node, descriptors);
            }
            if ((type instanceof JSClassElementTypeBase || type == JSStubElementTypes.PACKAGE_STATEMENT || type == JSStubElementTypes.TYPESCRIPT_ENUM || type == JSStubElementTypes.TYPESCRIPT_MODULE) && (lbrace = node.findChildByType(JSTokenTypes.LBRACE)) != null) {
                this.addDescriptorForRange(node, descriptors, new TextRange(lbrace.getStartOffset(), node.getTextRange().getEndOffset()));
            }
        }
        if (type instanceof JSFileElementType) {
            node.getPsi().getFirstChild();
        }
        ASTNode child = node.getFirstChildNode();
        while (child != null) {
            IElementType iElementType = child.getElementType();
            if (iElementType == JSElementTypes.BINARY_EXPRESSION || iElementType == JSElementTypes.COMMA_EXPRESSION) {
                JSBinaryExpression expression = (JSBinaryExpression)child.getPsi();
                JSExpression lOperand = expression.getLOperand();
                while (JSSymbolUtil.binaryOpTypeToAvoidRecursions(expression.getOperationSign()) && lOperand instanceof JSBinaryExpression) {
                    ASTNode rOperandNode;
                    JSExpression rOperand = expression.getROperand();
                    ASTNode aSTNode = rOperandNode = rOperand != null ? rOperand.getNode() : null;
                    if (rOperandNode != null) {
                        this.appendDescriptors(rOperandNode, document, descriptors);
                    }
                    expression = (JSBinaryExpression)lOperand;
                    lOperand = expression.getLOperand();
                }
                this.appendDescriptors(expression.getNode(), document, descriptors);
                child = child.getTreeNext();
                continue;
            }
            child = this.appendDescriptors(child, document, descriptors).getTreeNext();
        }
        return node;
    }

    private static boolean tryFoldOneLineFunction(@NotNull ASTNode node, @NotNull Document document, @NotNull List<FoldingDescriptor> descriptors) {
        String functionLeftText;
        int leftStart;
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(3);
        }
        if (document == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(4);
        }
        if (descriptors == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(5);
        }
        if (!JSCodeFoldingSettings.getInstance().isCollapseOneLineFunctions()) {
            return false;
        }
        if (!JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(node.getElementType()) || node.getTreeParent() == null || !JavaScriptFoldingBuilderBase.isFunction(node.getTreeParent().getElementType())) {
            return false;
        }
        JSFunction function = (JSFunction)ObjectUtils.tryCast((Object)node.getTreeParent().getPsi(), JSFunction.class);
        if (function == null) {
            return false;
        }
        JSBlockStatement body = (JSBlockStatement)ObjectUtils.tryCast((Object)JSChangeUtil.getFunctionBody(function), JSBlockStatement.class);
        if (body == null || body.getStatements().length > 1) {
            return false;
        }
        ASTNode left = body.getNode().findChildByType(JSTokenTypes.LBRACE);
        ASTNode right = body.getNode().findChildByType(JSTokenTypes.RBRACE);
        if (left == null || right == null) {
            return false;
        }
        boolean showAsAnonymous = function instanceof JSFunctionExpression && !JSPsiImplUtils.isArrowFunction(function);
        TextRange functionRange = function.getTextRange();
        if (showAsAnonymous) {
            leftStart = functionRange.getStartOffset();
            functionLeftText = JavaScriptFoldingBuilderBase.getFunctionLeftText(function);
        } else {
            PsiElement nonSpaceBeforeLeft = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)body);
            leftStart = nonSpaceBeforeLeft != null ? nonSpaceBeforeLeft.getTextRange().getEndOffset() : left.getTextRange().getStartOffset();
            functionLeftText = " { ";
        }
        int rightEnd = functionRange.getEndOffset();
        if (body.getStatements().length == 0) {
            if (!JavaScriptFoldingBuilderBase.linesAreClose(document, left.getTextRange().getEndOffset(), right.getTextRange().getStartOffset(), 2)) {
                return false;
            }
            FoldingGroup group = FoldingGroup.newGroup((String)"empty-one-liner");
            String text = StringUtil.trimTrailing((String)functionLeftText) + "}";
            descriptors.add((FoldingDescriptor)new NamedFoldingDescriptor((PsiElement)function, leftStart, rightEnd, group, text));
            return true;
        }
        JSStatement statement = body.getStatements()[0];
        if (statement == null) {
            return false;
        }
        TextRange stRange = statement.getTextRange();
        if (!JavaScriptFoldingBuilderBase.linesAreClose(document, stRange.getStartOffset(), stRange.getEndOffset(), 0)) {
            return false;
        }
        if (!JavaScriptFoldingBuilderBase.linesAreClose(document, left.getTextRange().getEndOffset(), stRange.getStartOffset(), 1) || !JavaScriptFoldingBuilderBase.linesAreClose(document, stRange.getEndOffset(), right.getTextRange().getEndOffset(), 1)) {
            return false;
        }
        int leftEnd = stRange.getStartOffset();
        int rightStart = stRange.getEndOffset();
        if (leftEnd <= leftStart + 1 || rightEnd <= rightStart + 1) {
            return false;
        }
        FoldingGroup group = FoldingGroup.newGroup((String)"one-liner");
        descriptors.add((FoldingDescriptor)new NamedFoldingDescriptor(left, leftStart, leftEnd, group, functionLeftText));
        descriptors.add((FoldingDescriptor)new NamedFoldingDescriptor(right, rightStart, rightEnd, group, " }"));
        return true;
    }

    private static String getFunctionLeftText(@NotNull JSFunction function) {
        String parameters;
        String name;
        if (function == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(6);
        }
        int length = function.getParameters().length;
        String string = name = function instanceof JSFunctionExpression ? null : function.getName();
        if (length > 0) {
            boolean wrap = length != 1 || !StringUtil.isEmptyOrSpaces((String)name);
            parameters = Arrays.stream(function.getParameters()).map(p -> p.getName()).collect(Collectors.joining(", ", wrap ? "(" : "", wrap ? ")" : ""));
        } else {
            parameters = "()";
        }
        JSAttributeList attributes = function.getAttributeList();
        String attributesText = attributes == null ? null : StringUtil.notNullize((String)attributes.getText()) + " ";
        return Stream.of(attributesText, function.isGetProperty() ? "get " : (function.isSetProperty() ? "set " : ""), function.isGenerator() ? "*" : "", name, parameters, name == null ? " => {" : " {").filter(m -> !StringUtil.isEmptyOrSpaces((String)m)).collect(Collectors.joining("", "", " "));
    }

    private static boolean linesAreClose(@NotNull Document document, int off1, int off2, int maxDiff) {
        int ln2;
        int ln1;
        if (document == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(7);
        }
        return Math.abs((ln1 = document.getLineNumber(off1)) - (ln2 = document.getLineNumber(off2))) <= maxDiff;
    }

    private static boolean blockStatementIsEntireSwitchClause(Document document, ASTNode node) {
        ASTNode parent = node.getTreeParent();
        return node.getElementType() == JSElementTypes.BLOCK_STATEMENT && parent.getElementType() == JSElementTypes.CASE_CLAUSE && document.getLineNumber(node.getStartOffset()) == document.getLineNumber(parent.getStartOffset());
    }

    private static boolean isModulePatternChild(ASTNode node) {
        PsiElement parent = node.getTreeParent().getPsi();
        if (parent instanceof JSFunctionExpression && (parent = parent.getParent()) instanceof JSParenthesizedExpression) {
            PsiElement currentParent = parent;
            if ((parent = parent.getParent()) instanceof JSCallExpression && ((JSCallExpression)parent).getMethodExpression() == currentParent && JavaScriptFoldingBuilderBase.isModulePattern(PsiTreeUtil.getParentOfType((PsiElement)parent, JSStatement.class))) {
                return true;
            }
        }
        return false;
    }

    private static boolean isModulePattern(PsiElement element) {
        PsiElement sibling;
        if (element == null || !(element.getParent() instanceof JSFile)) {
            return false;
        }
        for (sibling = element.getNextSibling(); sibling != null && !(sibling instanceof JSElement); sibling = sibling.getNextSibling()) {
        }
        if (sibling != null) {
            return false;
        }
        for (sibling = element.getPrevSibling(); sibling != null && !(sibling instanceof JSElement); sibling = sibling.getPrevSibling()) {
        }
        return sibling == null;
    }

    private void addDescriptorForRange(ASTNode node, List<FoldingDescriptor> descriptors, TextRange range) {
        if (range.getLength() > 1) {
            FoldingDescriptor descriptor2 = new FoldingDescriptor(node, range);
            descriptor2.setCanBeRemovedWhenCollapsed(this.isImportNode(node.getElementType()));
            descriptors.add(descriptor2);
        }
    }

    private void addDescriptorForNode(ASTNode node, List<FoldingDescriptor> descriptors) {
        TextRange range = node.getTextRange();
        this.addDescriptorForRange(node, descriptors, range);
    }

    private ASTNode collapseImport(Document document, @NotNull ASTNode node, @NotNull List<FoldingDescriptor> descriptors) {
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(8);
        }
        if (descriptors == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(9);
        }
        int sizeBeforeCollapse = descriptors.size();
        ASTNode nodeResult = this.collapseConsequentNodesOfSpecifiedType(node, descriptors, this.getImportTokenTypes());
        if (descriptors.size() != sizeBeforeCollapse) {
            return nodeResult;
        }
        if (this.isMultiline(document, node)) {
            TextRange nodeRange = node.getTextRange();
            this.addDescriptorForRange(node, descriptors, new TextRange(nodeRange.getStartOffset() + IMPORT_OFFSET, nodeRange.getEndOffset()));
        }
        return node;
    }

    protected TokenSet getImportTokenTypes() {
        return IMPORTS;
    }

    private boolean isMultiline(Document document, ASTNode node) {
        if (!this.isMultilineNodeType(node)) {
            return false;
        }
        TextRange nodeRange = node.getTextRange();
        int startNumber = document.getLineNumber(nodeRange.getStartOffset());
        int endNumber = document.getLineNumber(nodeRange.getEndOffset());
        return endNumber - startNumber > 0;
    }

    protected boolean isMultilineNodeType(ASTNode node) {
        return ES6ElementTypes.IMPORT_DECLARATION == node.getElementType();
    }

    @NotNull
    private ASTNode collapseConsequentNodesOfSpecifiedType(@NotNull ASTNode startNode, @NotNull List<FoldingDescriptor> descriptors, @NotNull TokenSet tokens) {
        String text;
        if (startNode == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(10);
        }
        if (descriptors == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(11);
        }
        if (tokens == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(12);
        }
        PsiElement endElement = startNode.getPsi();
        PsiElement current = endElement.getNextSibling();
        boolean stopAtFirstNontrivialLine = startNode.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT;
        boolean containsCustomRegionMarker = JavaScriptFoldingBuilderBase.isCustomRegionElement((PsiElement)endElement);
        while (!(!(current instanceof PsiWhiteSpace) || stopAtFirstNontrivialLine && (text = current.getText()).startsWith("\n") && text.indexOf(10, 1) > 0)) {
            if ((current = current.getNextSibling()) == null || !tokens.contains(current.getNode().getElementType())) continue;
            endElement = current;
            containsCustomRegionMarker |= JavaScriptFoldingBuilderBase.isCustomRegionElement((PsiElement)endElement);
            current = current.getNextSibling();
        }
        boolean sourceMaps = JavaScriptFoldingBuilderBase.isSourceMapsComment(startNode);
        if (startNode.getPsi() != endElement || sourceMaps) {
            int adjustmentOffset = 0;
            if (this.isImportNode(startNode.getElementType())) {
                adjustmentOffset = IMPORT_OFFSET;
            } else if (sourceMaps) {
                adjustmentOffset = SOURCE_MAPS_PREFIX.length();
            }
            TextRange rangeToFold = new TextRange(startNode.getStartOffset() + adjustmentOffset, endElement.getNode().getStartOffset() + endElement.getTextLength());
            if (!containsCustomRegionMarker) {
                this.addDescriptorForRange(startNode, descriptors, rangeToFold);
            }
            ASTNode aSTNode = endElement.getNode();
            if (aSTNode == null) {
                JavaScriptFoldingBuilderBase.$$$reportNull$$$0(13);
            }
            return aSTNode;
        }
        ASTNode aSTNode = startNode;
        if (aSTNode == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(14);
        }
        return aSTNode;
    }

    private boolean isImportNode(IElementType type) {
        return this.getImportTokenTypes().contains(type);
    }

    private static boolean isSourceMapsComment(@NotNull ASTNode element) {
        if (element == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(15);
        }
        return element.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT && StringUtil.startsWith((CharSequence)element.getChars(), (CharSequence)SOURCE_MAPS_PREFIX);
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        IElementType type;
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(16);
        }
        if (range == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(17);
        }
        if ((type = node.getElementType()) == JSTokenTypes.DOC_COMMENT) {
            String text = node.getText();
            StringTokenizer tokenizer = new StringTokenizer(text, "\n\r");
            String firstLine = "";
            boolean firstToken = true;
            while (tokenizer.hasMoreTokens()) {
                String content;
                String candidate = tokenizer.nextToken();
                Matcher matcher = DOC_COMMENT_CONTENT.matcher(candidate);
                if (matcher.matches() && !StringUtil.isEmpty((String)(content = matcher.group(2)))) {
                    firstLine = matcher.group(1) + content + " ";
                    break;
                }
                firstToken = false;
            }
            if (firstToken) {
                Matcher matcher = DOC_TYPE_COMMENT.matcher(firstLine);
                if (matcher.matches()) {
                    String typeString = matcher.group(1);
                    if (StringUtil.isEmpty((String)typeString)) {
                        typeString = matcher.group(2);
                    }
                    if (!StringUtil.isEmpty((String)typeString)) {
                        return "/*" + typeString + "*/";
                    }
                }
                return "/**...*/";
            }
            return "/**" + firstLine + "...*/";
        }
        if (type == JSTokenTypes.C_STYLE_COMMENT) {
            return "/*...*/";
        }
        if (type == JSTokenTypes.END_OF_LINE_COMMENT) {
            return JavaScriptFoldingBuilderBase.isSourceMapsComment(node) ? "..." : "//...";
        }
        if (this.isImportNode(type)) {
            return "...";
        }
        if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(type) || type instanceof JSClassElementTypeBase || type == JSElementTypes.SWITCH_STATEMENT || type == JSStubElementTypes.PACKAGE_STATEMENT) {
            return this.getBlockPlaceholderText();
        }
        if (type == JSStubElementTypes.OBJECT_LITERAL_EXPRESSION) {
            JSObjectLiteralExpression objectLiteralExpression = (JSObjectLiteralExpression)node.getPsi(JSObjectLiteralExpression.class);
            if (objectLiteralExpression != null) {
                return this.getObjectPlaceholderText(objectLiteralExpression);
            }
            return this.getBlockPlaceholderText();
        }
        if (type == JSElementTypes.ARRAY_LITERAL_EXPRESSION) {
            return "[...]";
        }
        if (type == JSElementTypes.XML_LITERAL_EXPRESSION) {
            ASTNode child = XmlChildRole.START_TAG_NAME_FINDER.findChild(node);
            return "<" + (child != null ? child.getText() : "xml") + "/>";
        }
        return null;
    }

    protected String getBlockPlaceholderText() {
        return "{...}";
    }

    protected String getObjectPlaceholderText(@NotNull JSObjectLiteralExpression node) {
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(18);
        }
        JSProperty[] properties = node.getProperties();
        JSProperty candidate = null;
        for (JSProperty property : properties) {
            String name = property.getName();
            boolean isId = "id".equals(name) || "name".equals(name);
            JSExpression value = property.getValue();
            if ((!(value instanceof JSReferenceExpression) || !JSSymbolUtil.isAccurateReferenceExpression((JSReferenceExpression)value)) && (!(value instanceof JSLiteralExpression) || !isId && !((JSLiteralExpression)value).isQuotedLiteral())) continue;
            if (candidate == null || isId) {
                candidate = property;
            }
            if (isId) break;
        }
        if (candidate != null) {
            return this.getFoldedTestByProperty(candidate);
        }
        return this.getBlockPlaceholderText();
    }

    @NotNull
    protected String getFoldedTestByProperty(JSProperty candidate) {
        String string = "{\"" + candidate.getName() + "\": " + candidate.getValue().getText() + "...}";
        if (string == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(19);
        }
        return string;
    }

    protected abstract JSCodeFoldingSettings getCodeFoldingSettings();

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        IElementType grandType;
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(20);
        }
        JSCodeFoldingSettings jsCodeFoldingSettings = this.getCodeFoldingSettings();
        ASTNode parentNode = node.getTreeParent();
        IElementType parentType = parentNode != null ? parentNode.getElementType() : null;
        IElementType iElementType = grandType = parentNode != null && parentNode.getTreeParent() != null ? parentNode.getTreeParent().getElementType() : null;
        if (parentType instanceof JSFileElementType && node.getTreePrev() == null && node.getPsi() instanceof PsiComment) {
            return jsCodeFoldingSettings.isCollapseFileHeaders();
        }
        IElementType nodeType = node.getElementType();
        if (nodeType == JSStubElementTypes.IMPORT_STATEMENT || nodeType == ES6ElementTypes.IMPORT_DECLARATION) {
            return jsCodeFoldingSettings.isCollapseImports();
        }
        if (JavaScriptFoldingBuilderBase.isFunction(nodeType)) {
            return jsCodeFoldingSettings.isCollapseOneLineFunctions();
        }
        if ((JSTokenTypes.RBRACE.equals(nodeType) || JSTokenTypes.LBRACE.equals(nodeType)) && JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(parentType) && JavaScriptFoldingBuilderBase.isFunction(grandType)) {
            return jsCodeFoldingSettings.isCollapseOneLineFunctions();
        }
        if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(nodeType) && JavaScriptFoldingBuilderBase.isFunction(parentType)) {
            return jsCodeFoldingSettings.isCollapseMethods();
        }
        if (nodeType == JSTokenTypes.DOC_COMMENT) {
            return jsCodeFoldingSettings.isCollapseDocComments();
        }
        if (JavaScriptFoldingBuilderBase.isSourceMapsComment(node)) {
            return true;
        }
        if (nodeType == JSStubElementTypes.OBJECT_LITERAL_EXPRESSION) {
            return jsCodeFoldingSettings.isCollapseObjectLiterals();
        }
        if (nodeType == JSElementTypes.ARRAY_LITERAL_EXPRESSION) {
            return jsCodeFoldingSettings.isCollapseArrayLiterals();
        }
        if (nodeType == JSElementTypes.XML_LITERAL_EXPRESSION) {
            return jsCodeFoldingSettings.isCollapseXmlLiterals();
        }
        return false;
    }

    private static boolean isFunction(IElementType type) {
        return JSElementTypes.FUNCTION_DECLARATIONS.contains(type) || JSElementTypes.FUNCTION_EXPRESSIONS.contains(type) || JSStubElementTypes.TYPESCRIPT_FUNCTION.equals((Object)type) || JSStubElementTypes.TYPESCRIPT_FUNCTION_EXPRESSION.equals((Object)type);
    }

    protected boolean isCustomFoldingCandidate(@NotNull ASTNode node) {
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(21);
        }
        return node.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT || node.getPsi() instanceof PsiComment && !node.getText().contains("\n");
    }

    protected boolean isCustomFoldingRoot(@NotNull ASTNode node) {
        IElementType nodeType;
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(22);
        }
        return (nodeType = node.getElementType()) == JSStubElementTypes.FILE || JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(nodeType) || JSExtendedLanguagesTokenSetProvider.EMBEDDED_CONTENTS.contains(nodeType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 8: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startNode";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokens";
                break;
            }
            case 13: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/folding/JavaScriptFoldingBuilderBase";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/folding/JavaScriptFoldingBuilderBase";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collapseConsequentNodesOfSpecifiedType";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldedTestByProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildLanguageFoldRegions";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tryFoldOneLineFunction";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionLeftText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "linesAreClose";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collapseImport";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collapseConsequentNodesOfSpecifiedType";
                break;
            }
            case 13: 
            case 14: 
            case 19: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isSourceMapsComment";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagePlaceholderText";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getObjectPlaceholderText";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isRegionCollapsedByDefault";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isCustomFoldingCandidate";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isCustomFoldingRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

