/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.findUsages;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JSReadWriteAccessDetector
extends ReadWriteAccessDetector {
    public static final JSReadWriteAccessDetector ourInstance = new JSReadWriteAccessDetector();

    public boolean isReadWriteAccessible(@NotNull PsiElement element) {
        if (element == null) {
            JSReadWriteAccessDetector.$$$reportNull$$$0(0);
        }
        return element instanceof JSVariable || element instanceof JSFunction && (((JSFunction)element).isGetProperty() || ((JSFunction)element).isSetProperty()) || element instanceof JSDefinitionExpression;
    }

    public boolean isDeclarationWriteAccess(@NotNull PsiElement element) {
        if (element == null) {
            JSReadWriteAccessDetector.$$$reportNull$$$0(1);
        }
        if (element instanceof JSVariable) {
            JSVariable var = (JSVariable)element;
            if (var.getInitializer() != null) {
                return true;
            }
            PsiElement parent = var.getParent();
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof JSForInStatement && ((JSForInStatement)grandParent).getDeclarationStatement() == parent) {
                return true;
            }
        } else if (element instanceof JSDefinitionExpression) {
            return true;
        }
        return false;
    }

    @NotNull
    public ReadWriteAccessDetector.Access getReferenceAccess(@NotNull PsiElement referencedElement, @NotNull PsiReference reference) {
        if (referencedElement == null) {
            JSReadWriteAccessDetector.$$$reportNull$$$0(2);
        }
        if (reference == null) {
            JSReadWriteAccessDetector.$$$reportNull$$$0(3);
        }
        ReadWriteAccessDetector.Access access = this.getExpressionAccess(reference.getElement());
        if (access == null) {
            JSReadWriteAccessDetector.$$$reportNull$$$0(4);
        }
        return access;
    }

    @NotNull
    public ReadWriteAccessDetector.Access getExpressionAccess(@NotNull PsiElement _expression) {
        PsiElement expression;
        if (_expression == null) {
            JSReadWriteAccessDetector.$$$reportNull$$$0(5);
        }
        if ((expression = _expression.getParent()) != null && this.isDeclarationWriteAccess(expression) && JSResolveUtil.isSelfReference(_expression)) {
            ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Write;
            if (access == null) {
                JSReadWriteAccessDetector.$$$reportNull$$$0(6);
            }
            return access;
        }
        if (_expression instanceof JSDefinitionExpression) {
            expression = _expression;
        }
        if (expression instanceof JSDefinitionExpression) {
            PsiElement grandParent = expression.getParent();
            if (grandParent instanceof JSAssignmentExpression && ((JSAssignmentExpression)grandParent).getOperationSign() == JSTokenTypes.EQ) {
                ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Write;
                if (access == null) {
                    JSReadWriteAccessDetector.$$$reportNull$$$0(7);
                }
                return access;
            }
            ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.ReadWrite;
            if (access == null) {
                JSReadWriteAccessDetector.$$$reportNull$$$0(8);
            }
            return access;
        }
        if (expression instanceof JSPrefixExpression) {
            if (JSReadWriteAccessDetector.isIncrementOrDecrement(((JSPrefixExpression)expression).getOperationSign())) {
                ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.ReadWrite;
                if (access == null) {
                    JSReadWriteAccessDetector.$$$reportNull$$$0(9);
                }
                return access;
            }
        } else if (expression instanceof JSPostfixExpression && JSReadWriteAccessDetector.isIncrementOrDecrement(((JSPostfixExpression)expression).getOperationSign())) {
            ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.ReadWrite;
            if (access == null) {
                JSReadWriteAccessDetector.$$$reportNull$$$0(10);
            }
            return access;
        }
        ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Read;
        if (access == null) {
            JSReadWriteAccessDetector.$$$reportNull$$$0(11);
        }
        return access;
    }

    private static boolean isIncrementOrDecrement(IElementType sign) {
        return sign == JSTokenTypes.PLUSPLUS || sign == JSTokenTypes.MINUSMINUS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/findUsages/JSReadWriteAccessDetector";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/findUsages/JSReadWriteAccessDetector";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceAccess";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionAccess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isReadWriteAccessible";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDeclarationWriteAccess";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceAccess";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionAccess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

