/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editor;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.psi.PsiElement;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSBreadcrumbsProvider
implements BreadcrumbsProvider {
    public Language[] getLanguages() {
        return new Language[]{JavascriptLanguage.INSTANCE, JavaScriptSupportLoader.TYPESCRIPT};
    }

    public boolean acceptElement(@NotNull PsiElement element) {
        JSQualifiedNamedElement assignedTo;
        if (element == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(0);
        }
        if (!(element instanceof JSQualifiedNamedElement)) {
            return false;
        }
        return !(element instanceof JSExpression) || (assignedTo = JSPsiImplUtils.getInitializedElement((JSExpression)element)) == null;
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement element) {
        JSExpression expression;
        String referenceName;
        JSExpression methodExpression;
        PsiElement callExpr;
        PsiElement parent;
        if (element == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof JSFunctionExpression && ((JSFunctionExpression)element).getName() == null && (parent = element.getParent()) instanceof JSArgumentList && (callExpr = parent.getParent()) instanceof JSCallExpression && (methodExpression = ((JSCallExpression)callExpr).getMethodExpression()) instanceof JSReferenceExpression && (referenceName = ((JSReferenceExpression)methodExpression).getReferenceName()) != null) {
            String string = JSBundle.message((String)"js.breadcrumbs.callback.for", (Object[])new Object[]{referenceName});
            if (string == null) {
                JSBreadcrumbsProvider.$$$reportNull$$$0(2);
            }
            return string;
        }
        StringBuilder builder = new StringBuilder();
        String name = null;
        if (!(!(element instanceof JSDefinitionExpression) || (expression = ((JSDefinitionExpression)element).getExpression()) instanceof JSReferenceExpression && ((JSReferenceExpression)expression).getQualifier() instanceof JSThisExpression)) {
            name = ((JSDefinitionExpression)element).getQualifiedName();
        }
        if (name == null) {
            name = ((JSQualifiedNamedElement)element).getName();
        }
        if (name == null) {
            name = "<anonymous>";
        }
        if (name.startsWith("[Symbol.") || name.indexOf(46) == -1) {
            name = JSSymbolUtil.handleSpecialPropertyNames(name, '\"');
        }
        builder.append(name);
        if (element instanceof JSFunction || element instanceof JSInitializerOwner && ((JSInitializerOwner)element).getInitializer() instanceof JSFunction) {
            builder.append("()");
        }
        String string = builder.toString();
        if (string == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public Icon getElementIcon(@NotNull PsiElement element) {
        if (element == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Nullable
    public String getElementTooltip(@NotNull PsiElement element) {
        if (element == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(5);
        }
        return null;
    }

    @Nullable
    public PsiElement getParent(@NotNull PsiElement element) {
        JSQualifiedNamedElement initializedElement;
        if (element == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(6);
        }
        if (element instanceof JSExpression && (initializedElement = JSPsiImplUtils.getInitializedElement((JSExpression)element)) instanceof JSDefinitionExpression) {
            return initializedElement;
        }
        return element.getParent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/editor/JSBreadcrumbsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/editor/JSBreadcrumbsProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getElementInfo";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementIcon";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementTooltip";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

