/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSDocElementType;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.editor.JSEditorOptions;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class JavaScriptTypedHandler
extends TypedHandlerDelegate {
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, Project project, Editor editor, PsiFile file) {
        PsiElement at;
        int offset;
        if (!JavaScriptTypedHandler.charOfInterest(charTyped)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (file instanceof XmlFile) {
            if (!JavaScriptSupportLoader.isFlexMxmFile(file)) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            offset = editor.getCaretModel().getOffset();
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiFile injectedPsi = InjectedLanguageUtil.findInjectedPsiNoCommit((PsiFile)file, (int)offset);
            if (injectedPsi == null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            editor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)editor, (PsiFile)file, (int)offset);
            file = injectedPsi;
        }
        if (!(file instanceof JSFile)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        offset = editor.getCaretModel().getOffset();
        if (JavaScriptTypedHandler.isNotApplicableByLexer(charTyped, editor, offset)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (file.getContext() == null) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        }
        AutoPopupController autoPopupController = AutoPopupController.getInstance((Project)project);
        if (charTyped == '.') {
            PsiElement element;
            PsiElement at2 = file.findElementAt(offset - 1);
            PsiElement psiElement = element = at2 != null ? PsiTreeUtil.getNonStrictParentOfType((PsiElement)at2, (Class[])new Class[]{PsiComment.class, JSLiteralExpression.class}) : null;
            if (element == null) {
                autoPopupController.autoPopupMemberLookup(editor, null);
            }
            return TypedHandlerDelegate.Result.STOP;
        }
        if (charTyped == ' ' || charTyped == ',') {
            at = file.findElementAt(offset);
            if (at != null && at.getParent() instanceof JSArgumentList) {
                autoPopupController.autoPopupParameterInfo(editor, null);
                return TypedHandlerDelegate.Result.STOP;
            }
            if (charTyped == ',') {
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        if ((at = file.findElementAt(offset)) != null) {
            if (PsiTreeUtil.getNonStrictParentOfType((PsiElement)at, (Class[])new Class[]{PsiComment.class, JSLiteralExpression.class, JSConditionalExpression.class}) != null || at.getParent() instanceof JSSwitchStatement) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            if (at instanceof PsiWhiteSpace) {
                at = PsiTreeUtil.prevLeaf((PsiElement)at);
            }
            if (at == null || PsiTreeUtil.getNonStrictParentOfType((PsiElement)at, (Class[])new Class[]{JSConditionalExpression.class}) != null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
        }
        if (charTyped == '<') {
            Document document = editor.getDocument();
            if (offset > 0 && offset <= document.getTextLength() && document.getCharsSequence().charAt(offset - 1) != '.') {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
        }
        autoPopupController.autoPopupMemberLookup(editor, null);
        return TypedHandlerDelegate.Result.STOP;
    }

    private static boolean isNotApplicableByLexer(char charTyped, Editor editor, int offset) {
        if (charTyped == ' ') {
            Document document = editor.getDocument();
            CharSequence charSequence = document.getCharsSequence();
            if (offset > 3 && offset <= document.getTextLength() && (charSequence.charAt(offset - 1) != 'w' || charSequence.charAt(offset - 2) != 'e' || charSequence.charAt(offset - 3) != 'n') && charSequence.charAt(offset - 1) != ':' && charSequence.charAt(offset - 1) != ',') {
                return true;
            }
        }
        if (offset == 0) {
            return true;
        }
        HighlighterIterator iterator = JavaScriptTypedHandler.createHighlighterIterator(editor, offset - 1);
        IElementType tokenType = iterator.getTokenType();
        return JSTokenTypes.COMMENTS.contains(tokenType) || tokenType instanceof JSDocElementType || StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(tokenType) || JSTokenTypes.STRING_LITERALS.contains(tokenType);
    }

    private static boolean charOfInterest(char charTyped) {
        return charTyped == '<' || charTyped == ' ' || charTyped == ',' || charTyped == '.';
    }

    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project, Editor editor, PsiFile file, FileType fileType) {
        PsiElement at;
        int offset;
        if (c == '}' && JavaScriptSupportLoader.isFlexMxmFile(file)) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            offset = editor.getCaretModel().getOffset();
            at = file.findElementAt(offset);
            PsiElement value = PsiTreeUtil.getNonStrictParentOfType((PsiElement)at, (Class[])new Class[]{XmlAttributeValue.class, XmlText.class});
            if (value != null && editor.getDocument().getCharsSequence().charAt(offset) == '}') {
                editor.getCaretModel().moveToOffset(offset + 1);
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        if (c == '.') {
            offset = editor.getCaretModel().getOffset();
            Object object = offset < editor.getDocument().getTextLength() ? file.findElementAt(offset) : (at = offset > 0 ? file.findElementAt(offset - 1) : null);
            if (at != null && at.getParent().getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE) && !JavaScriptTypedHandler.isNotApplicableByLexer(c, editor, offset)) {
                AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, null);
            }
        }
        return super.beforeCharTyped(c, project, editor, file, fileType);
    }

    public TypedHandlerDelegate.Result charTyped(char c, Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        int startOffset;
        HighlighterIterator iterator;
        IElementType tokenType;
        PsiElement at;
        int offset;
        if (editor == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(1);
        }
        if (c == '{' && JavaScriptSupportLoader.isFlexMxmFile(file)) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            offset = editor.getCaretModel().getOffset();
            at = file.findElementAt(offset);
            PsiElement value = PsiTreeUtil.getParentOfType((PsiElement)at, (Class[])new Class[]{XmlAttributeValue.class, XmlText.class});
            if (value != null) {
                String s = StringUtil.stripQuotesAroundValue((String)value.getText());
                int lbraceCount = 0;
                int rbraceCount = 0;
                for (int i = 0; i < s.length(); ++i) {
                    char ch = s.charAt(i);
                    if (ch == '{') {
                        ++lbraceCount;
                        continue;
                    }
                    if (ch != '}') continue;
                    ++rbraceCount;
                }
                if (lbraceCount == rbraceCount + 1) {
                    editor.getDocument().insertString(offset, (CharSequence)"}");
                    return TypedHandlerDelegate.Result.STOP;
                }
            }
        }
        if (!JavaScriptTypedHandler.isJSDialectAtCaret(editor, file)) {
            return super.charTyped(c, project, editor, file);
        }
        if (c == ',' || c == ':' || c == '.' && JavaScriptTypedHandler.isIndentChainedCalls(project)) {
            PsiElement parent;
            offset = editor.getCaretModel().getOffset();
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            at = file.findElementAt(offset - 1);
            PsiElement psiElement = parent = at != null ? at.getParent() : null;
            if (parent != null) {
                int indentPos = -1;
                IElementType parentType = parent.getNode().getElementType();
                if (JSElementTypes.VAR_STATEMENTS.contains(parentType) || parentType == JSElementTypes.REFERENCE_EXPRESSION) {
                    indentPos = at.getTextOffset() - 1;
                } else if (JSExtendedLanguagesTokenSetProvider.CASE_CLAUSES.contains(parentType)) {
                    indentPos = parent.getTextOffset() - 1;
                }
                if (indentPos >= 0 && JavaScriptTypedHandler.isAfterLineStart(indentPos, editor.getDocument())) {
                    CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, indentPos);
                    return TypedHandlerDelegate.Result.STOP;
                }
            }
        } else if (c == '$' && JSEditorOptions.getInstance().START_STRING_INTERPOLATION_ON_TYPING && (tokenType = (iterator = JavaScriptTypedHandler.createHighlighterIterator(editor, (startOffset = editor.getCaretModel().getOffset()) - 1)).getTokenType()) == JSTokenTypes.STRING_TEMPLATE_PART) {
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"{}");
            editor.getCaretModel().moveCaretRelatively(-1, 0, false, false, true);
            return TypedHandlerDelegate.Result.STOP;
        }
        return super.charTyped(c, project, editor, file);
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeSelectionRemoved(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(3);
        }
        if (file == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(4);
        }
        if (c == '$' && JSEditorOptions.getInstance().START_STRING_INTERPOLATION_ON_TYPING && editor.getSelectionModel().hasSelection()) {
            int startOffset = editor.getSelectionModel().getSelectionStart();
            int endOffset = editor.getSelectionModel().getSelectionEnd();
            boolean caretBefore = editor.getCaretModel().getOffset() <= startOffset;
            HighlighterIterator iterator = JavaScriptTypedHandler.createHighlighterIterator(editor, startOffset);
            if (iterator.getTokenType() == JSTokenTypes.STRING_TEMPLATE_PART && iterator.getEnd() >= endOffset) {
                String insertedText = "${" + editor.getSelectionModel().getSelectedText() + "}";
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)insertedText);
                if (caretBefore) {
                    editor.getCaretModel().moveCaretRelatively(-insertedText.length(), 0, false, false, true);
                }
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    JavaScriptTypedHandler.$$$reportNull$$$0(5);
                }
                return result;
            }
        }
        TypedHandlerDelegate.Result result = super.beforeSelectionRemoved(c, project, editor, file);
        if (result == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(6);
        }
        return result;
    }

    @NotNull
    private static HighlighterIterator createHighlighterIterator(@NotNull Editor editor, int offset) {
        if (editor == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(7);
        }
        HighlighterIterator highlighterIterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (highlighterIterator == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(8);
        }
        return highlighterIterator;
    }

    private static boolean isJSDialectAtCaret(@NotNull Editor editor, @NotNull PsiFile file) {
        int offset;
        PsiElement at;
        if (editor == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(9);
        }
        if (file == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(10);
        }
        if ((at = file.findElementAt((offset = editor.getCaretModel().getOffset()) - 1)) == null) {
            return false;
        }
        Language language = PsiUtilCore.findLanguageFromElement((PsiElement)at);
        return language == JavascriptLanguage.INSTANCE || language instanceof JSLanguageDialect;
    }

    private static boolean isIndentChainedCalls(@NotNull Project project) {
        if (project == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(11);
        }
        JSCodeStyleSettings settings = (JSCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(JSCodeStyleSettings.class);
        return settings.INDENT_CHAINED_CALLS;
    }

    private static boolean isAfterLineStart(int indentPos, @NotNull Document document) {
        if (document == null) {
            JavaScriptTypedHandler.$$$reportNull$$$0(12);
        }
        int firstNonSpace = CharArrayUtil.shiftBackward((CharSequence)document.getCharsSequence(), (int)indentPos, (String)" \t");
        return document.getCharsSequence().charAt(firstNonSpace) == '\n';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/editing/JavaScriptTypedHandler";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/editing/JavaScriptTypedHandler";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeSelectionRemoved";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlighterIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "beforeSelectionRemoved";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighterIterator";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isJSDialectAtCaret";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isIndentChainedCalls";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAfterLineStart";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

